/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.neo4j.v4x;

import java.lang.reflect.Method;
import java.util.concurrent.CompletionStage;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.plugin.neo4j.v4x.Neo4jPluginConfig;
import org.apache.skywalking.apm.plugin.neo4j.v4x.Neo4jPluginConstants;
import org.apache.skywalking.apm.plugin.neo4j.v4x.SessionRequiredInfo;
import org.apache.skywalking.apm.plugin.neo4j.v4x.util.CypherUtils;
import org.neo4j.driver.Query;

public class SessionRunInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ((CompletionStage)ret).thenApply(resultCursor -> {
            Query query = (Query)allArguments[0];
            SessionRequiredInfo requiredInfo = (SessionRequiredInfo)objInst.getSkyWalkingDynamicField();
            if (query == null || requiredInfo == null || requiredInfo.getSpan() == null) {
                return resultCursor;
            }
            AbstractSpan span = requiredInfo.getSpan();
            span.setOperationName("Neo4j/Session/" + method.getName());
            Tags.DB_STATEMENT.set(span, CypherUtils.limitBodySize(query.text()));
            if (Neo4jPluginConfig.Plugin.Neo4j.TRACE_CYPHER_PARAMETERS) {
                Neo4jPluginConstants.CYPHER_PARAMETERS_TAG.set(span, CypherUtils.limitParametersSize(query.parameters().toString()));
            }
            span.asyncFinish();
            return resultCursor;
        });
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        SessionRequiredInfo requiredInfo = (SessionRequiredInfo)objInst.getSkyWalkingDynamicField();
        if (requiredInfo != null) {
            requiredInfo.getSpan().log(t);
        }
    }
}

