/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance;

import java.util.Objects;
import org.apache.skywalking.apm.agent.core.plugin.AbstractClassEnhancePluginDefine;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.ConstructorInterceptPoint;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.InstanceMethodsInterceptPoint;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.StaticMethodsInterceptPoint;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.v2.ConstructorInterceptV2Point;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.v2.InstanceMethodsInterceptV2Point;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.v2.StaticMethodsInterceptV2Point;
import org.apache.skywalking.apm.dependencies.net.bytebuddy.utility.RandomString;

public class DelegateNamingResolver {
    private static final String PREFIX = "delegate$";
    private final String fieldNamePrefix;

    public DelegateNamingResolver(String className, AbstractClassEnhancePluginDefine pluginDefine) {
        this.fieldNamePrefix = "$sw$delegate$" + RandomString.hashOf(className.hashCode()) + "$" + RandomString.hashOf(pluginDefine.hashCode()) + "$";
    }

    public String resolve(ConstructorInterceptPoint interceptPoint) {
        Objects.requireNonNull(interceptPoint, "interceptPoint cannot be null");
        return this.fieldNamePrefix + RandomString.hashOf(interceptPoint.computeHashCode());
    }

    public String resolve(ConstructorInterceptV2Point interceptPoint) {
        Objects.requireNonNull(interceptPoint, "interceptPoint cannot be null");
        return this.fieldNamePrefix + RandomString.hashOf(interceptPoint.computeHashCode());
    }

    public String resolve(InstanceMethodsInterceptPoint interceptPoint) {
        Objects.requireNonNull(interceptPoint, "interceptPoint cannot be null");
        return this.fieldNamePrefix + RandomString.hashOf(interceptPoint.computeHashCode());
    }

    public String resolve(InstanceMethodsInterceptV2Point interceptPoint) {
        Objects.requireNonNull(interceptPoint, "interceptPoint cannot be null");
        return this.fieldNamePrefix + RandomString.hashOf(interceptPoint.computeHashCode());
    }

    public String resolve(StaticMethodsInterceptPoint interceptPoint) {
        Objects.requireNonNull(interceptPoint, "interceptPoint cannot be null");
        return this.fieldNamePrefix + RandomString.hashOf(interceptPoint.computeHashCode());
    }

    public String resolve(StaticMethodsInterceptV2Point interceptPoint) {
        Objects.requireNonNull(interceptPoint, "interceptPoint cannot be null");
        return this.fieldNamePrefix + RandomString.hashOf(interceptPoint.computeHashCode());
    }
}

