/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.elasticsearch.v6;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.common.transport.TransportAddress;

public class TransportAddressCache {
    private List<TransportAddress> transportAddresses = new ArrayList<TransportAddress>();
    private String transportAddressesStr = "";

    public synchronized void addDiscoveryNode(TransportAddress ... transportAddress) {
        this.transportAddresses.addAll(Arrays.asList(transportAddress));
        this.transportAddressesStr = this.format();
    }

    public synchronized void removeDiscoveryNode(TransportAddress transportAddress) {
        ArrayList<TransportAddress> nodesBuilder = new ArrayList<TransportAddress>();
        for (TransportAddress otherNode : this.transportAddresses) {
            if (otherNode.getAddress().equals(transportAddress.getAddress())) continue;
            nodesBuilder.add(otherNode);
        }
        this.transportAddresses = nodesBuilder;
        this.transportAddressesStr = this.format();
    }

    private String format() {
        return String.join((CharSequence)",", this.transportAddresses.stream().map(x -> String.format("%s:%s", x.getAddress(), x.getPort())).collect(Collectors.toList()));
    }

    public String transportAddress() {
        return this.transportAddressesStr;
    }
}

