/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.locator;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.common.rest.locator.MicroservicePaths;
import org.apache.servicecomb.common.rest.locator.OperationGroup;
import org.apache.servicecomb.common.rest.locator.OperationLocator;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.foundation.common.utils.ClassLoaderScopeContext;

public class ServicePathManager {
    private static final String REST_PATH_MANAGER = "RestServicePathManager";
    protected MicroserviceMeta microserviceMeta;
    protected MicroservicePaths swaggerPaths = new MicroservicePaths();
    protected MicroservicePaths producerPaths;

    public static ServicePathManager getServicePathManager(MicroserviceMeta microserviceMeta) {
        return (ServicePathManager)microserviceMeta.getExtData(REST_PATH_MANAGER);
    }

    public ServicePathManager(MicroserviceMeta microserviceMeta) {
        this.microserviceMeta = microserviceMeta;
        for (SchemaMeta schemaMeta : microserviceMeta.getSchemaMetas().values()) {
            this.addSchema(schemaMeta);
        }
        this.sortPath();
        microserviceMeta.putExtData(REST_PATH_MANAGER, (Object)this);
    }

    private void addSchema(SchemaMeta schemaMeta) {
        for (OperationMeta operationMeta : schemaMeta.getOperations().values()) {
            RestOperationMeta restOperationMeta = new RestOperationMeta();
            restOperationMeta.init(operationMeta);
            operationMeta.putExtData("swaggerRestOperation", (Object)restOperationMeta);
            this.addResource(restOperationMeta);
        }
    }

    public OperationLocator consumerLocateOperation(String path, String httpMethod) {
        String standPath = OperationLocator.getStandardPath(path);
        OperationLocator locator = new OperationLocator();
        locator.locate(this.microserviceMeta.getMicroserviceName(), standPath, httpMethod, this.swaggerPaths);
        return locator;
    }

    public OperationLocator producerLocateOperation(String path, String httpMethod) {
        String standPath = OperationLocator.getStandardPath(path);
        OperationLocator locator = new OperationLocator();
        locator.locate(this.microserviceMeta.getMicroserviceName(), standPath, httpMethod, this.producerPaths);
        return locator;
    }

    public void addResource(RestOperationMeta swaggerRestOperation) {
        this.swaggerPaths.addResource(swaggerRestOperation);
    }

    public void sortPath() {
        this.swaggerPaths.sortPath();
    }

    public void buildProducerPaths() {
        String urlPrefix = ClassLoaderScopeContext.getClassLoaderScopeProperty((String)"urlPrefix");
        if (StringUtils.isEmpty((CharSequence)urlPrefix)) {
            this.producerPaths = this.swaggerPaths;
            this.producerPaths.printPaths();
            return;
        }
        this.producerPaths = new MicroservicePaths();
        for (OperationGroup operationGroup : this.swaggerPaths.getStaticPathOperationMap().values()) {
            this.addProducerPaths(urlPrefix, operationGroup.values());
        }
        this.addProducerPaths(urlPrefix, this.swaggerPaths.getDynamicPathOperationList());
        this.producerPaths.printPaths();
    }

    private void addProducerPaths(String urlPrefix, Collection<RestOperationMeta> restOperationMetas) {
        Iterator<RestOperationMeta> iterator = restOperationMetas.iterator();
        while (iterator.hasNext()) {
            RestOperationMeta swaggerRestOperation;
            RestOperationMeta producerRestOperation = swaggerRestOperation = iterator.next();
            if (!swaggerRestOperation.getAbsolutePath().startsWith(urlPrefix)) {
                producerRestOperation = new RestOperationMeta();
                producerRestOperation.init(swaggerRestOperation.getOperationMeta());
                producerRestOperation.setAbsolutePath(urlPrefix + swaggerRestOperation.getAbsolutePath());
            }
            this.producerPaths.addResource(producerRestOperation);
        }
    }
}

