/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.publish;

import io.micrometer.core.instrument.Statistic;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.foundation.metrics.publish.MeasurementNode;
import org.apache.servicecomb.metrics.core.publish.model.invocation.OperationPerf;
import org.apache.servicecomb.metrics.core.publish.model.invocation.OperationPerfGroup;
import org.apache.servicecomb.metrics.core.publish.model.invocation.OperationPerfGroups;
import org.apache.servicecomb.metrics.core.publish.model.invocation.PerfInfo;

public final class PublishUtils {
    private PublishUtils() {
    }

    public static PerfInfo createPerfInfo(MeasurementNode stageNode) {
        PerfInfo perfInfo = new PerfInfo();
        perfInfo.setTotalRequests(stageNode.findChild(Statistic.COUNT.name()).summary());
        perfInfo.setMsTotalTime(stageNode.findChild(Statistic.TOTAL_TIME.name()).summary() * 1000.0);
        perfInfo.setMsMaxLatency(stageNode.findChild(Statistic.MAX.name()).summary() * 1000.0);
        return perfInfo;
    }

    public static OperationPerf createOperationPerf(String operation, MeasurementNode statusNode) {
        OperationPerf operationPerf = new OperationPerf();
        operationPerf.setOperation(operation);
        MeasurementNode stageNode = statusNode.findChild("stage");
        stageNode.getChildren().values().forEach(mNode -> {
            PerfInfo perfInfo = PublishUtils.createPerfInfo(mNode);
            operationPerf.getStages().put(mNode.getName(), perfInfo);
        });
        MeasurementNode latencyNode = statusNode.findChild("distribution");
        if (latencyNode != null && latencyNode.getMeasurements() != null) {
            operationPerf.setLatencyDistribution((Integer[])latencyNode.getMeasurements().stream().map(m -> (int)m.getValue()).toArray(Integer[]::new));
        }
        return operationPerf;
    }

    public static void addOperationPerfGroups(OperationPerfGroups operationPerfGroups, String transport, String operation, MeasurementNode statusNode) {
        Map statusMap = operationPerfGroups.getGroups().computeIfAbsent(transport, tn -> new HashMap());
        OperationPerfGroup group = statusMap.computeIfAbsent(statusNode.getName(), status -> new OperationPerfGroup(transport, (String)status));
        OperationPerf operationPerf = PublishUtils.createOperationPerf(operation, statusNode);
        group.addOperationPerf(operationPerf);
    }
}

