/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.sse;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufProcessor;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.reactivex.netty.protocol.http.sse.ServerSentEvent;

@ChannelHandler.Sharable
public class ServerSentEventEncoder
extends MessageToByteEncoder<ServerSentEvent> {
    private static final byte[] EVENT_PREFIX_BYTES = "event: ".getBytes();
    private static final byte[] NEW_LINE_AS_BYTES = "\n".getBytes();
    private static final byte[] ID_PREFIX_AS_BYTES = "id: ".getBytes();
    private static final byte[] DATA_PREFIX_AS_BYTES = "data: ".getBytes();
    private final boolean splitSseData;

    public ServerSentEventEncoder() {
        this(false);
    }

    public ServerSentEventEncoder(boolean splitSseData) {
        this.splitSseData = splitSseData;
    }

    protected void encode(ChannelHandlerContext ctx, ServerSentEvent serverSentEvent, ByteBuf out) throws Exception {
        if (serverSentEvent.hasEventType()) {
            out.writeBytes(EVENT_PREFIX_BYTES);
            out.writeBytes(serverSentEvent.getEventType());
            out.writeBytes(NEW_LINE_AS_BYTES);
        }
        if (serverSentEvent.hasEventId()) {
            out.writeBytes(ID_PREFIX_AS_BYTES);
            out.writeBytes(serverSentEvent.getEventId());
            out.writeBytes(NEW_LINE_AS_BYTES);
        }
        ByteBuf content = serverSentEvent.content();
        if (this.splitSseData) {
            while (content.isReadable()) {
                int readerIndexAtStart = content.readerIndex();
                int newLineIndex = content.forEachByte(new ByteBufProcessor(){

                    public boolean process(byte value) throws Exception {
                        return (char)value != '\n';
                    }
                });
                if (-1 == newLineIndex) {
                    out.writeBytes(DATA_PREFIX_AS_BYTES);
                    out.writeBytes(content);
                    out.writeBytes(NEW_LINE_AS_BYTES);
                    continue;
                }
                out.writeBytes(DATA_PREFIX_AS_BYTES);
                out.writeBytes(content, newLineIndex - readerIndexAtStart);
                content.readerIndex(content.readerIndex() + 1);
                out.writeBytes(NEW_LINE_AS_BYTES);
            }
        } else {
            out.writeBytes(DATA_PREFIX_AS_BYTES);
            out.writeBytes(content);
            out.writeBytes(NEW_LINE_AS_BYTES);
        }
    }
}

