/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.authentication.consumer;

import java.util.Optional;
import org.apache.servicecomb.authentication.consumer.RSAConsumerTokenManager;
import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;

public class ConsumerAuthHandler
implements Handler {
    private RSAConsumerTokenManager athenticationTokenManager = new RSAConsumerTokenManager();

    public void handle(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        Optional<String> token = Optional.ofNullable(this.athenticationTokenManager.getToken());
        if (!token.isPresent()) {
            asyncResp.consumerFail((Throwable)new IllegalStateException("rejected by consumer authentication handler"));
            return;
        }
        invocation.addContext("x-cse-auth-rsatoken", token.get());
        invocation.next(asyncResp);
    }

    public void setAuthenticationTokenManager(RSAConsumerTokenManager authenticationTokenManager) {
        this.athenticationTokenManager = authenticationTokenManager;
    }
}

