/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.cache;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.netflix.hystrix.contrib.javanica.cache.annotation.CacheKey;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Set;

public class CacheInvocationParameter {
    private final Class<?> rawType;
    private final Object value;
    private final CacheKey cacheKeyAnnotation;
    private final Set<Annotation> annotations;
    private final int position;

    public CacheInvocationParameter(Class<?> rawType, Object value, Annotation[] annotations, int position) {
        this.rawType = rawType;
        this.value = value;
        this.annotations = ImmutableSet.builder().addAll(Arrays.asList(annotations)).build();
        this.position = position;
        this.cacheKeyAnnotation = (CacheKey)this.cacheKeyAnnotation();
    }

    public Set<Annotation> getAnnotations() {
        return this.annotations;
    }

    public CacheKey getCacheKeyAnnotation() {
        return this.cacheKeyAnnotation;
    }

    public boolean hasCacheKeyAnnotation() {
        return this.cacheKeyAnnotation != null;
    }

    public Class<?> getRawType() {
        return this.rawType;
    }

    public Object getValue() {
        return this.value;
    }

    public int getPosition() {
        return this.position;
    }

    private Annotation cacheKeyAnnotation() {
        return (Annotation)Iterables.tryFind(this.annotations, (Predicate)new Predicate<Annotation>(){

            public boolean apply(Annotation input) {
                return input.annotationType().equals(CacheKey.class);
            }
        }).orNull();
    }
}

