/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.rocketmq.eventbridge.adapter.persistence.apidestination.mybatis.mapper;

import java.util.List;
import org.apache.ibatis.annotations.Param;
import org.apache.rocketmq.eventbridge.adapter.persistence.apidestination.mybatis.dataobject.ApiDestinationDO;
import org.apache.rocketmq.eventbridge.domain.model.apidestination.ApiDestinationDTO;

public interface EventApiDestinationMapper {
    /**
     * This method was generated by MyBatis Generator. This method corresponds to the database table
     * event_api_destination
     *
     * @mbggenerated
     */
    int deleteByPrimaryKey(Integer id);

    /**
     * This method was generated by MyBatis Generator. This method corresponds to the database table
     * event_api_destination
     *
     * @mbggenerated
     */
    int insert(ApiDestinationDTO record);

    /**
     * This method was generated by MyBatis Generator. This method corresponds to the database table
     * event_api_destination
     *
     * @mbggenerated
     */
    int insertSelective(ApiDestinationDO record);

    /**
     * This method was generated by MyBatis Generator. This method corresponds to the database table
     * event_api_destination
     *
     * @mbggenerated
     */
    ApiDestinationDO selectByPrimaryKey(Integer id);

    /**
     * This method was generated by MyBatis Generator. This method corresponds to the database table
     * event_api_destination
     *
     * @mbggenerated
     */
    List<ApiDestinationDO> listApiDestinations(@Param("accountId") String accountId, @Param("name") String name,
                                               @Param("connectionName") String connectionName, @Param("nextToken") int nextToken, @Param("maxResults") int maxResults);

    /**
     * Select by account and name
     *
     * @param accountId
     * @param name
     * @return
     */
    ApiDestinationDO selectByAccountIdAndName(@Param("accountId") String accountId, @Param("name") String name);

    /**
     * This method was generated by MyBatis Generator. This method corresponds to the database table
     * event_api_destination
     *
     * @mbggenerated
     */
    int updateByPrimaryKeySelective(ApiDestinationDO record);

    /**
     * This method was generated by MyBatis Generator. This method corresponds to the database table
     * event_api_destination
     *
     * @mbggenerated
     */
    int updateByNameAndAccountId(ApiDestinationDO record);

    /**
     * This method was generated by MyBatis Generator. This method corresponds to the database table
     * event_api_destination
     *
     * @mbggenerated
     */
    int updateByPrimaryKeyWithBLOBs(ApiDestinationDO record);

    /**
     * This method was generated by MyBatis Generator. This method corresponds to the database table
     * event_api_destination
     *
     * @mbggenerated
     */
    int updateByPrimaryKey(ApiDestinationDO record);

    /**
     * delete event_api_destination
     *
     * @param accountId
     * @param name
     * @return
     */
    int deleteByAccountIdAndName(@Param("accountId") String accountId, @Param("name") String name);

    /**
     * @param accountId
     * @return
     */
    int getApiDestinationCount(@Param("accountId") String accountId);

    int getApiDestinationByAccountIdAndNameCount(@Param("accountId") String accountId, @Param("name") String name, @Param("connectionName") String connectionName);

    List<ApiDestinationDO> queryApiDestinationByConnectionName(@Param("accountId") String accountId,
        @Param("connectionName") String connectionName);
}