/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.project.ui;

import java.awt.Image;
import java.util.concurrent.Callable;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.queries.AccessibilityQuery;
import org.netbeans.api.queries.VisibilityQuery;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public final class PackageDisplayUtils {
    private static final boolean TRUNCATE_PACKAGE_NAMES = Boolean.getBoolean("org.netbeans.spi.java.project.support.ui.packageView.TRUNCATE_PACKAGE_NAMES");
    public static final String PACKAGE = "org/netbeans/spi/java/project/support/ui/package.gif";
    private static final String PACKAGE_EMPTY = "org/netbeans/spi/java/project/support/ui/packageEmpty.gif";
    private static final String PACKAGE_PRIVATE = "org/netbeans/spi/java/project/support/ui/packagePrivate.gif";
    private static final String PACKAGE_PUBLIC = "org/netbeans/spi/java/project/support/ui/packagePublic.gif";

    private PackageDisplayUtils() {
    }

    public static String getDisplayLabel(String pkgname) {
        return PackageDisplayUtils.computePackageName(pkgname, TRUNCATE_PACKAGE_NAMES);
    }

    public static String getToolTip(FileObject pkg, String pkgname) {
        String pkglabel = PackageDisplayUtils.computePackageName(pkgname, false);
        Boolean b = AccessibilityQuery.isPubliclyAccessible(pkg);
        if (b != null) {
            if (b.booleanValue()) {
                return NbBundle.getMessage(PackageDisplayUtils.class, "LBL_public_package", pkglabel);
            }
            return NbBundle.getMessage(PackageDisplayUtils.class, "LBL_private_package", pkglabel);
        }
        return NbBundle.getMessage(PackageDisplayUtils.class, "LBL_package", pkglabel);
    }

    private static String computePackageName(String pkgname, boolean truncate) {
        if (pkgname.length() == 0) {
            return NbBundle.getMessage(PackageDisplayUtils.class, "LBL_DefaultPackage");
        }
        if (truncate) {
            return pkgname.replaceFirst("^([^.])[^.]+\\.", "$1.").replaceAll("([^.]{3})[^.]+\\.", "$1.");
        }
        return pkgname;
    }

    public static Image getIcon(@NonNull FileObject pkg, boolean empty) {
        return PackageDisplayUtils.getIcon(pkg, empty, () -> AccessibilityQuery.isPubliclyAccessible2(pkg).getAccessibility());
    }

    public static Image getIcon(@NonNull FileObject pkg, boolean empty, @NonNull Callable<AccessibilityQuery.Accessibility> accessibilityProvider) {
        AccessibilityQuery.Accessibility a;
        if (empty) {
            return ImageUtilities.loadImage(PACKAGE_EMPTY);
        }
        try {
            a = pkg.isValid() ? accessibilityProvider.call() : AccessibilityQuery.Accessibility.UNKNOWN;
        }
        catch (Exception e) {
            a = AccessibilityQuery.Accessibility.UNKNOWN;
        }
        switch (a) {
            case EXPORTED: {
                return ImageUtilities.loadImage(PACKAGE_PUBLIC);
            }
            case PRIVATE: {
                return ImageUtilities.loadImage(PACKAGE_PRIVATE);
            }
            case UNKNOWN: {
                return ImageUtilities.loadImage(PACKAGE);
            }
        }
        throw new IllegalStateException(String.valueOf((Object)a));
    }

    public static boolean isEmpty(FileObject fo) {
        return PackageDisplayUtils.isEmpty(fo, true);
    }

    public static boolean isEmpty(FileObject fo, boolean recurse) {
        FileObject[] kids = fo.getChildren();
        for (int i = 0; i < kids.length; ++i) {
            if (!kids[i].isFolder() && VisibilityQuery.getDefault().isVisible(kids[i])) {
                return false;
            }
            if (!recurse || !VisibilityQuery.getDefault().isVisible(kids[i]) || PackageDisplayUtils.isEmpty(kids[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isSignificant(FileObject pkg) throws IllegalArgumentException {
        if (!pkg.isFolder()) {
            throw new IllegalArgumentException("Not a folder");
        }
        if (!VisibilityQuery.getDefault().isVisible(pkg)) {
            return false;
        }
        FileObject[] kids = pkg.getChildren();
        boolean subpackages = false;
        for (int i = 0; i < kids.length; ++i) {
            if (!VisibilityQuery.getDefault().isVisible(kids[i])) continue;
            if (kids[i].isData()) {
                return true;
            }
            subpackages = true;
        }
        return !subpackages;
    }
}

