/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.perf;

import org.netbeans.modules.java.hints.perf.Tiny;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFixUtilities;
import org.openide.util.NbBundle;

public class NoBooleanConstructor {
    public static ErrorDescription hintBoolean(HintContext ctx) {
        switch (ctx.getInfo().getSourceVersion()) {
            case RELEASE_0: 
            case RELEASE_1: 
            case RELEASE_2: 
            case RELEASE_3: {
                return NoBooleanConstructor.hint(ctx, "($b ? Boolean.TRUE : Boolean.FALSE)", "FIX_NoBooleanConstructorBoolean");
            }
            case RELEASE_4: {
                return NoBooleanConstructor.hint(ctx, "java.lang.Boolean.valueOf($b)", "FIX_NoBooleanConstructorBoolean");
            }
        }
        return NoBooleanConstructor.hint(ctx, "$b", "FIX_NoBooleanConstructorBoolean");
    }

    public static ErrorDescription hintString(HintContext ctx) {
        return NoBooleanConstructor.hint(ctx, "java.lang.Boolean.valueOf($str)", "FIX_NoBooleanConstructorString");
    }

    private static ErrorDescription hint(HintContext ctx, String fix, String fixKey) {
        String fixDisplayName = NbBundle.getMessage(Tiny.class, fixKey);
        Fix f = JavaFixUtilities.rewriteFix(ctx, fixDisplayName, ctx.getPath(), fix);
        String displayName = NbBundle.getMessage(Tiny.class, "ERR_NoBooleanConstructor");
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), displayName, f);
    }
}

