/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.awt.EventQueue;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.JEditorPane;
import jpt.sun.source.tree.MethodTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.Modifier;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.codegen.EqualsHashCodeGenerator;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MissingHashCode {
    public static List<ErrorDescription> run(HintContext ctx) {
        CompilationInfo compilationInfo = ctx.getInfo();
        TreePath treePath = ctx.getPath();
        Element clazz = compilationInfo.getTrees().getElement(treePath);
        if (clazz == null || !clazz.getKind().isClass()) {
            return null;
        }
        ExecutableElement[] ret = EqualsHashCodeGenerator.overridesHashCodeAndEquals(compilationInfo, clazz, new EqualsHashCodeGenerator.Cancel(){

            @Override
            public boolean isCanceled() {
                return false;
            }
        });
        ExecutableElement warningToElement = null;
        String addHint = null;
        if (ret[0] == null && ret[1] != null) {
            addHint = "MSG_GenEquals";
            warningToElement = ret[1];
        }
        if (ret[1] == null && ret[0] != null) {
            addHint = "MSG_GenHashCode";
            warningToElement = ret[0];
        }
        if (addHint != null) {
            assert (warningToElement != null);
            TreePath warningTo = compilationInfo.getTrees().getPath(warningToElement);
            if (warningTo == null || warningTo.getLeaf().getKind() != Tree.Kind.METHOD) {
                return null;
            }
            List<FixImpl> fixes = Collections.singletonList(new FixImpl(addHint, TreePathHandle.create(clazz, compilationInfo), compilationInfo.getFileObject()));
            int[] span = compilationInfo.getTreeUtilities().findNameSpan((MethodTree)warningTo.getLeaf());
            if (span != null) {
                ErrorDescription ed = ErrorDescriptionFactory.forName(ctx, warningTo, NbBundle.getMessage(MissingHashCode.class, addHint), fixes.toArray(new Fix[0]));
                return Collections.singletonList(ed);
            }
        }
        return null;
    }

    public String getId() {
        return this.getClass().getName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(MissingHashCode.class, "MSG_MissingHashCode");
    }

    public String getDescription() {
        return NbBundle.getMessage(MissingHashCode.class, "HINT_MissingHashCode");
    }

    private static final class FixImpl
    implements Fix,
    Runnable,
    Task<WorkingCopy> {
        private TreePathHandle handle;
        private FileObject file;
        private String msg;
        private boolean fieldFound;

        public FixImpl(String type, TreePathHandle handle, FileObject file) {
            this.handle = handle;
            this.file = file;
            this.msg = type;
        }

        @Override
        public String getText() {
            return NbBundle.getMessage(MissingHashCode.class, this.msg);
        }

        @Override
        public ChangeInfo implement() throws IOException {
            ModificationResult result = JavaSource.forFileObject(this.file).runModificationTask(this);
            if (this.fieldFound) {
                EventQueue.invokeLater(this);
            } else {
                result.commit();
            }
            return null;
        }

        @Override
        public void run() {
            try {
                EditorCookie cook = DataObject.find(this.file).getLookup().lookup(EditorCookie.class);
                JEditorPane[] arr = cook.getOpenedPanes();
                if (arr == null) {
                    return;
                }
                EqualsHashCodeGenerator.invokeEqualsHashCode(this.handle, arr[0]);
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace(ex);
            }
        }

        @Override
        public void run(WorkingCopy wc) throws Exception {
            wc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            for (Element element : this.handle.resolveElement(wc).getEnclosedElements()) {
                if (element.getKind() != ElementKind.FIELD || element.getModifiers().contains((Object)Modifier.STATIC)) continue;
                this.fieldFound = true;
                return;
            }
            EqualsHashCodeGenerator.generateEqualsAndHashCode(wc, this.handle.resolve(wc));
        }

        public String toString() {
            return "Fix";
        }
    }
}

