/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.imports;

import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.java.editor.imports.ComputeImports;
import org.netbeans.modules.java.editor.imports.ImportClassPanel;
import org.netbeans.modules.java.editor.overridden.PopupUtil;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class FastImportAction
extends BaseAction {
    public static final String NAME = "fast-import";

    public FastImportAction() {
        super(NAME);
    }

    @Override
    public void actionPerformed(ActionEvent evt, final JTextComponent target) {
        try {
            final Rectangle carretRectangle = target.modelToView(target.getCaretPosition());
            final Font font = target.getFont();
            final Point where = new Point(carretRectangle.x, carretRectangle.y + carretRectangle.height);
            SwingUtilities.convertPointToScreen(where, target);
            final int position = target.getCaretPosition();
            final String ident = Utilities.getIdentifier(Utilities.getDocument(target), position);
            FileObject file = this.getFile(target.getDocument());
            if (ident == null || file == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            final JavaSource js = JavaSource.forFileObject(file);
            if (js == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            final AtomicBoolean cancel = new AtomicBoolean();
            final Task<CompilationController> task = new Task<CompilationController>(){

                @Override
                public void run(CompilationController parameter) throws IOException {
                    parameter.toPhase(JavaSource.Phase.RESOLVED);
                    if (cancel.get()) {
                        return;
                    }
                    final JavaSource javaSource = parameter.getJavaSource();
                    ComputeImports.Pair<Map<String, List<Element>>, Map<String, List<Element>>> result = new ComputeImports(parameter).computeCandidates(Collections.singleton(ident));
                    List candidates = (List)((Map)result.a).get(ident);
                    if (candidates == null) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    final List<TypeElement> priviledged = ElementFilter.typesIn(candidates);
                    if (priviledged == null) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    final ArrayList<TypeElement> denied = new ArrayList<TypeElement>(ElementFilter.typesIn((Iterable)((Map)result.b).get(ident)));
                    denied.removeAll(priviledged);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ImportClassPanel panel = new ImportClassPanel(priviledged, denied, font, javaSource, position, target);
                            PopupUtil.showPopup(panel, "", where.x, where.y, true, carretRectangle.height);
                        }
                    });
                }
            };
            ProgressUtils.runOffEventDispatchThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        js.runUserActionTask(task, true);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace(ex);
                    }
                }
            }, NbBundle.getMessage(FastImportAction.class, "LBL_Fast_Import"), cancel, false);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace(ex);
        }
    }

    private FileObject getFile(Document doc) {
        DataObject od = (DataObject)doc.getProperty("stream");
        if (od == null) {
            return null;
        }
        return od.getPrimaryFile();
    }
}

