/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen;

import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.swing.text.JTextComponent;
import jpt.sun.source.tree.AnnotationTree;
import jpt.sun.source.tree.BlockTree;
import jpt.sun.source.tree.ClassTree;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.IdentifierTree;
import jpt.sun.source.tree.MemberSelectTree;
import jpt.sun.source.tree.MethodTree;
import jpt.sun.source.tree.ModifiersTree;
import jpt.sun.source.tree.Scope;
import jpt.sun.source.tree.StatementTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.tree.VariableTree;
import jpt.sun.source.util.SourcePositions;
import jpt.sun.source.util.TreePath;
import jpt.sun.source.util.Trees;
import jpt30.lang.model.SourceVersion;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.element.VariableElement;
import jpt30.lang.model.type.ArrayType;
import jpt30.lang.model.type.DeclaredType;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import jpt30.lang.model.type.WildcardType;
import jpt30.lang.model.util.ElementFilter;
import jpt30.lang.model.util.Types;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.java.editor.codegen.ConstructorGenerator;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.editor.codegen.ui.ElementNode;
import org.netbeans.modules.java.editor.codegen.ui.EqualsHashCodePanel;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;

public class EqualsHashCodeGenerator
implements CodeGenerator {
    private static final String ERROR = "<error>";
    private final JTextComponent component;
    final ElementNode.Description description;
    final boolean generateEquals;
    final boolean generateHashCode;
    static int randomNumber = -1;
    private static final Map<Acceptor, String> NOT_EQUALS_PATTERNS = new LinkedHashMap<Acceptor, String>();
    private static final Map<Acceptor, String> EQUALS_PATTERNS;
    private static final Map<Acceptor, String> HASH_CODE_PATTERNS;

    private EqualsHashCodeGenerator(JTextComponent component, ElementNode.Description description, boolean generateEquals, boolean generateHashCode) {
        this.component = component;
        this.description = description;
        this.generateEquals = generateEquals;
        this.generateHashCode = generateHashCode;
    }

    @Override
    public String getDisplayName() {
        if (this.generateEquals && this.generateHashCode) {
            return NbBundle.getMessage(EqualsHashCodeGenerator.class, "LBL_equals_and_hashcode");
        }
        if (!this.generateEquals) {
            return NbBundle.getMessage(EqualsHashCodeGenerator.class, "LBL_hashcode");
        }
        return NbBundle.getMessage(EqualsHashCodeGenerator.class, "LBL_equals");
    }

    static EqualsHashCodeGenerator createEqualsHashCodeGenerator(JTextComponent component, CompilationController cc, Element el) throws IOException {
        if (el.getKind() != ElementKind.CLASS) {
            return null;
        }
        if (el.getSimpleName() == null || el.getSimpleName().length() == 0) {
            return null;
        }
        TypeElement typeElement = (TypeElement)el;
        ExecutableElement[] equalsHashCode = EqualsHashCodeGenerator.overridesHashCodeAndEquals(cc, typeElement, null);
        ArrayList<ElementNode.Description> descriptions = new ArrayList<ElementNode.Description>();
        for (VariableElement variableElement : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
            if (ERROR.contentEquals(variableElement.getSimpleName()) || variableElement.getModifiers().contains((Object)Modifier.STATIC)) continue;
            descriptions.add(ElementNode.Description.create(cc, variableElement, null, true, EqualsHashCodeGenerator.isUsed(cc, variableElement, equalsHashCode)));
        }
        if (descriptions.isEmpty() || equalsHashCode[0] != null && equalsHashCode[1] != null) {
            return null;
        }
        return new EqualsHashCodeGenerator(component, ElementNode.Description.create(cc, typeElement, descriptions, false, false), equalsHashCode[0] == null, equalsHashCode[1] == null);
    }

    private static boolean isUsed(CompilationInfo cc, VariableElement field, ExecutableElement ... methods) {
        for (ExecutableElement e : methods) {
            if (e == null) continue;
            Trees tree = cc.getTrees();
            TreePath path = tree.getPath(e);
            class Used
            extends ErrorAwareTreePathScanner<Void, VariableElement> {
                boolean found;

                Used() {
                }

                @Override
                public Void visitIdentifier(IdentifierTree id, VariableElement what) {
                    if (id.getName().equals(what.getSimpleName())) {
                        this.found = true;
                    }
                    return (Void)super.visitIdentifier(id, what);
                }

                @Override
                public Void visitMemberSelect(MemberSelectTree sel, VariableElement what) {
                    if (sel.getIdentifier().equals(what.getSimpleName())) {
                        this.found = true;
                    }
                    return (Void)super.visitMemberSelect(sel, what);
                }
            }
            Used used = new Used();
            used.scan(path, field);
            if (!used.found) continue;
            return true;
        }
        return false;
    }

    public static ExecutableElement[] overridesHashCodeAndEquals(CompilationInfo compilationInfo, Element type, Cancel stop) {
        ExecutableElement[] ret = new ExecutableElement[2];
        TypeElement el = compilationInfo.getElements().getTypeElement("java.lang.Object");
        if (el == null) {
            return ret;
        }
        if (type == null || type.getKind() != ElementKind.CLASS) {
            return ret;
        }
        TypeMirror objAsType = el.asType();
        if (objAsType == null || objAsType.getKind() != TypeKind.DECLARED) {
            return ret;
        }
        ExecutableElement hashCode = null;
        ExecutableElement equals = null;
        for (ExecutableElement method : ElementFilter.methodsIn(el.getEnclosedElements())) {
            if (stop != null && stop.isCanceled()) {
                return ret;
            }
            if (method.getSimpleName().contentEquals("equals") && method.getParameters().size() == 1 && !method.getModifiers().contains((Object)Modifier.STATIC) && compilationInfo.getTypes().isSameType(objAsType, method.getParameters().get(0).asType())) {
                assert (equals == null);
                equals = method;
            }
            if (!method.getSimpleName().contentEquals("hashCode") || !method.getParameters().isEmpty() || method.getModifiers().contains((Object)Modifier.STATIC)) continue;
            assert (hashCode == null);
            hashCode = method;
        }
        if (hashCode == null || equals == null) {
            return ret;
        }
        TypeElement clazz = (TypeElement)type;
        for (Element element : type.getEnclosedElements()) {
            if (stop != null && stop.isCanceled()) {
                return ret;
            }
            if (element.getKind() != ElementKind.METHOD) continue;
            ExecutableElement method = (ExecutableElement)element;
            if (compilationInfo.getElements().overrides(method, hashCode, clazz)) {
                ret[1] = method;
            }
            if (!compilationInfo.getElements().overrides(method, equals, clazz)) continue;
            ret[0] = method;
        }
        return ret;
    }

    public static void invokeEqualsHashCode(final TreePathHandle handle, final JTextComponent component) {
        JavaSource js = JavaSource.forDocument(component.getDocument());
        if (js != null) {
            class FillIn
            implements Task<CompilationController> {
                EqualsHashCodeGenerator gen;

                FillIn() {
                }

                @Override
                public void run(CompilationController cc) throws Exception {
                    cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    Element e = handle.resolveElement(cc);
                    this.gen = EqualsHashCodeGenerator.createEqualsHashCodeGenerator(component, cc, e);
                }

                public void invoke() {
                    if (this.gen != null) {
                        this.gen.invoke();
                    }
                }
            }
            FillIn fillIn = new FillIn();
            try {
                js.runUserActionTask(fillIn, true);
                fillIn.invoke();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace(ex);
            }
        }
    }

    @Override
    public void invoke() {
        JavaSource js;
        final int caretOffset = this.component.getCaretPosition();
        final EqualsHashCodePanel panel = new EqualsHashCodePanel(this.description, this.generateEquals, this.generateHashCode);
        String title = NbBundle.getMessage(ConstructorGenerator.class, "LBL_generate_equals_and_hashcode");
        if (!this.generateEquals) {
            title = NbBundle.getMessage(ConstructorGenerator.class, "LBL_generate_hashcode");
        } else if (!this.generateHashCode) {
            title = NbBundle.getMessage(ConstructorGenerator.class, "LBL_generate_equals");
        }
        final DialogDescriptor dialogDescriptor = GeneratorUtils.createDialogDescriptor(panel, title);
        panel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                List<ElementHandle<? extends Element>> vars = panel.getEqualsVariables();
                if (vars == null || vars.isEmpty()) {
                    vars = panel.getHashCodeVariables();
                }
                dialogDescriptor.setValid(vars != null && !vars.isEmpty());
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == dialogDescriptor.getDefaultValue() && (js = JavaSource.forDocument(this.component.getDocument())) != null) {
            try {
                ModificationResult mr = js.runModificationTask(new Task<WorkingCopy>(){

                    @Override
                    public void run(WorkingCopy copy) throws IOException {
                        copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        Element e = EqualsHashCodeGenerator.this.description.getElementHandle().resolve(copy);
                        TreePath path = e != null ? copy.getTrees().getPath(e) : copy.getTreeUtilities().pathFor(caretOffset);
                        path = copy.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, path);
                        if (path == null) {
                            String message = NbBundle.getMessage(EqualsHashCodeGenerator.class, "ERR_CannotFindOriginalClass");
                            Utilities.setStatusBoldText(EqualsHashCodeGenerator.this.component, message);
                        } else {
                            ArrayList<VariableElement> equalsElements = new ArrayList<VariableElement>();
                            if (EqualsHashCodeGenerator.this.generateEquals) {
                                for (ElementHandle<? extends Element> elementHandle : panel.getEqualsVariables()) {
                                    equalsElements.add((VariableElement)elementHandle.resolve(copy));
                                }
                            }
                            ArrayList<VariableElement> hashCodeElements = new ArrayList<VariableElement>();
                            if (EqualsHashCodeGenerator.this.generateHashCode) {
                                for (ElementHandle<? extends Element> elementHandle : panel.getHashCodeVariables()) {
                                    hashCodeElements.add((VariableElement)elementHandle.resolve(copy));
                                }
                            }
                            EqualsHashCodeGenerator.generateEqualsAndHashCode(copy, path, EqualsHashCodeGenerator.this.generateEquals ? equalsElements : null, EqualsHashCodeGenerator.this.generateHashCode ? hashCodeElements : null, caretOffset);
                        }
                    }
                });
                GeneratorUtils.guardedCommit(this.component, mr);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace(ex);
            }
        }
    }

    public static void generateEqualsAndHashCode(WorkingCopy wc, TreePath path) {
        ExecutableElement[] arr = EqualsHashCodeGenerator.overridesHashCodeAndEquals(wc, wc.getTrees().getElement(path), null);
        Set e = arr[0] == null ? Collections.emptySet() : null;
        Set h = arr[1] == null ? Collections.emptySet() : null;
        EqualsHashCodeGenerator.generateEqualsAndHashCode(wc, path, e, h, -1);
    }

    public static void generateEqualsAndHashCode(WorkingCopy wc, TreePath path, Iterable<? extends VariableElement> equalsFields, Iterable<? extends VariableElement> hashCodeFields, int offset) {
        assert (TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getLeaf().getKind()));
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        if (te != null) {
            ClassTree nue = (ClassTree)path.getLeaf();
            Scope scope = wc.getTrees().getScope(path);
            ArrayList<MethodTree> members = new ArrayList<MethodTree>();
            if (hashCodeFields != null) {
                members.add(EqualsHashCodeGenerator.createHashCodeMethod(wc, hashCodeFields, scope));
            }
            if (equalsFields != null) {
                DeclaredType dt = (DeclaredType)te.asType();
                if (!dt.getTypeArguments().isEmpty()) {
                    WildcardType wt = wc.getTypes().getWildcardType(null, null);
                    TypeMirror[] typeArgs = new TypeMirror[dt.getTypeArguments().size()];
                    for (int i = 0; i < typeArgs.length; ++i) {
                        typeArgs[i] = wt;
                    }
                    dt = dt.getEnclosingType().getKind() == TypeKind.DECLARED ? wc.getTypes().getDeclaredType((DeclaredType)dt.getEnclosingType(), te, typeArgs) : wc.getTypes().getDeclaredType(te, typeArgs);
                }
                members.add(EqualsHashCodeGenerator.createEqualsMethod(wc, equalsFields, dt, scope));
            }
            wc.rewrite(nue, GeneratorUtils.insertClassMembers(wc, nue, members, offset));
        }
    }

    private static MethodTree createEqualsMethod(WorkingCopy wc, Iterable<? extends VariableElement> equalsFields, DeclaredType type, Scope scope) {
        ExpressionTree condition;
        TypeMirror tm;
        VariableElement ve;
        TreeMaker make = wc.getTreeMaker();
        EnumSet<Modifier> mods = EnumSet.of(Modifier.PUBLIC);
        TypeElement objElement = wc.getElements().getTypeElement("java.lang.Object");
        List<VariableTree> params = Collections.singletonList(make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), "obj", objElement != null ? make.Type(objElement.asType()) : make.Identifier("Object"), null));
        ArrayList<StatementTree> statements = new ArrayList<StatementTree>();
        statements.add(make.If(make.Binary(Tree.Kind.EQUAL_TO, make.Identifier("this"), make.Identifier("obj")), make.Return(make.Identifier("true")), null));
        statements.add(make.If(make.Binary(Tree.Kind.EQUAL_TO, make.Identifier("obj"), make.Identifier("null")), make.Return(make.Identifier("false")), null));
        statements.add(make.If(make.Binary(Tree.Kind.NOT_EQUAL_TO, make.MethodInvocation(Collections.emptyList(), make.Identifier("getClass"), Collections.emptyList()), make.MethodInvocation(Collections.emptyList(), make.MemberSelect((ExpressionTree)make.Identifier("obj"), "getClass"), Collections.emptyList())), make.Return(make.Identifier("false")), null));
        statements.add(make.Variable(make.Modifiers(EnumSet.of(Modifier.FINAL)), "other", make.Type(type), make.TypeCast(make.Type(type), make.Identifier("obj"))));
        ArrayList<VariableElement> primitives = new ArrayList<VariableElement>();
        ArrayList<VariableElement> strings = new ArrayList<VariableElement>();
        ArrayList<VariableElement> others = new ArrayList<VariableElement>();
        for (VariableElement variableElement : equalsFields) {
            TypeMirror tm2 = variableElement.asType();
            if (tm2 != null && tm2.getKind().isPrimitive()) {
                primitives.add(variableElement);
                continue;
            }
            if (tm2 != null && tm2.getKind() == TypeKind.DECLARED && ((TypeElement)((DeclaredType)tm2).asElement()).getQualifiedName().contentEquals("java.lang.String")) {
                strings.add(variableElement);
                continue;
            }
            others.add(variableElement);
        }
        boolean addReturnTrue = true;
        Iterator iterator = primitives.iterator();
        while (iterator.hasNext()) {
            ve = (VariableElement)iterator.next();
            tm = ve.asType();
            if (!iterator.hasNext() && strings.isEmpty() && others.isEmpty()) {
                condition = EqualsHashCodeGenerator.prepareExpression(wc, EQUALS_PATTERNS, tm, ve, scope);
                statements.add(make.Return(condition));
                addReturnTrue = false;
                continue;
            }
            condition = EqualsHashCodeGenerator.prepareExpression(wc, NOT_EQUALS_PATTERNS, tm, ve, scope);
            statements.add(make.If(condition, make.Return(make.Identifier("false")), null));
        }
        Iterator iterator2 = strings.iterator();
        while (iterator2.hasNext()) {
            ve = (VariableElement)iterator2.next();
            tm = ve.asType();
            if (!iterator2.hasNext() && others.isEmpty()) {
                condition = EqualsHashCodeGenerator.prepareExpression(wc, EQUALS_PATTERNS, tm, ve, scope);
                statements.add(make.Return(condition));
                addReturnTrue = false;
                continue;
            }
            condition = EqualsHashCodeGenerator.prepareExpression(wc, NOT_EQUALS_PATTERNS, tm, ve, scope);
            statements.add(make.If(condition, make.Return(make.Identifier("false")), null));
        }
        Iterator iterator3 = others.iterator();
        while (iterator3.hasNext()) {
            ve = (VariableElement)iterator3.next();
            tm = ve.asType();
            if (!iterator3.hasNext()) {
                condition = EqualsHashCodeGenerator.prepareExpression(wc, EQUALS_PATTERNS, tm, ve, scope);
                statements.add(make.Return(condition));
                addReturnTrue = false;
                continue;
            }
            condition = EqualsHashCodeGenerator.prepareExpression(wc, NOT_EQUALS_PATTERNS, tm, ve, scope);
            statements.add(make.If(condition, make.Return(make.Identifier("false")), null));
        }
        if (addReturnTrue) {
            statements.add(make.Return(make.Identifier("true")));
        }
        BlockTree blockTree = make.Block(statements, false);
        ModifiersTree modifiers = EqualsHashCodeGenerator.prepareModifiers(wc, mods, make);
        return make.Method(modifiers, (CharSequence)"equals", (Tree)make.PrimitiveType(TypeKind.BOOLEAN), Collections.emptyList(), params, Collections.emptyList(), blockTree, null);
    }

    private static MethodTree createHashCodeMethod(WorkingCopy wc, Iterable<? extends VariableElement> hashCodeFields, Scope scope) {
        TreeMaker make = wc.getTreeMaker();
        EnumSet<Modifier> mods = EnumSet.of(Modifier.PUBLIC);
        int startNumber = EqualsHashCodeGenerator.generatePrimeNumber(2, 10);
        int multiplyNumber = EqualsHashCodeGenerator.generatePrimeNumber(10, 100);
        ArrayList<StatementTree> statements = new ArrayList<StatementTree>();
        statements.add(make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), "hash", make.PrimitiveType(TypeKind.INT), make.Literal(startNumber)));
        for (VariableElement variableElement : hashCodeFields) {
            TypeMirror tm = variableElement.asType();
            ExpressionTree variableRead = EqualsHashCodeGenerator.prepareExpression(wc, HASH_CODE_PATTERNS, tm, variableElement, scope);
            statements.add(make.ExpressionStatement(make.Assignment(make.Identifier("hash"), make.Binary(Tree.Kind.PLUS, make.Binary(Tree.Kind.MULTIPLY, make.Literal(multiplyNumber), make.Identifier("hash")), variableRead))));
        }
        statements.add(make.Return(make.Identifier("hash")));
        BlockTree body = make.Block(statements, false);
        ModifiersTree modifiersTree = EqualsHashCodeGenerator.prepareModifiers(wc, mods, make);
        return make.Method(modifiersTree, (CharSequence)"hashCode", (Tree)make.PrimitiveType(TypeKind.INT), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), body, null);
    }

    private static boolean isPrimeNumber(int n) {
        int squareRoot = (int)Math.sqrt(n) + 1;
        if (n % 2 == 0) {
            return false;
        }
        for (int cntr = 3; cntr < squareRoot; ++cntr) {
            if (n % cntr != 0) continue;
            return false;
        }
        return true;
    }

    private static int generatePrimeNumber(int lowerLimit, int higherLimit) {
        if (randomNumber > 0) {
            return randomNumber;
        }
        Random r = new Random(System.currentTimeMillis());
        int proposed = r.nextInt(higherLimit - lowerLimit) + lowerLimit;
        while (!EqualsHashCodeGenerator.isPrimeNumber(proposed)) {
            ++proposed;
        }
        if (proposed > higherLimit) {
            --proposed;
            while (!EqualsHashCodeGenerator.isPrimeNumber(proposed)) {
                --proposed;
            }
        }
        return proposed;
    }

    private static ModifiersTree prepareModifiers(WorkingCopy wc, Set<Modifier> mods, TreeMaker make) {
        TypeElement override;
        LinkedList<AnnotationTree> annotations = new LinkedList<AnnotationTree>();
        if (GeneratorUtils.supportsOverride(wc) && (override = wc.getElements().getTypeElement("java.lang.Override")) != null) {
            annotations.add(wc.getTreeMaker().Annotation(wc.getTreeMaker().QualIdent(override), Collections.emptyList()));
        }
        ModifiersTree modifiers = make.Modifiers(mods, annotations);
        return modifiers;
    }

    private static KindOfType detectKind(CompilationInfo info, TypeMirror tm) {
        if (tm.getKind().isPrimitive()) {
            return KindOfType.valueOf(tm.getKind().name());
        }
        if (tm.getKind() == TypeKind.ARRAY) {
            return ((ArrayType)tm).getComponentType().getKind().isPrimitive() ? KindOfType.ARRAY_PRIMITIVE : KindOfType.ARRAY;
        }
        if (tm.getKind() == TypeKind.DECLARED) {
            Types t = info.getTypes();
            TypeElement en = info.getElements().getTypeElement("java.lang.Enum");
            if (en != null && t.isSubtype(tm, t.erasure(en.asType()))) {
                return KindOfType.ENUM;
            }
            if (((DeclaredType)tm).asElement().getKind().isClass() && ((TypeElement)((DeclaredType)tm).asElement()).getQualifiedName().contentEquals("java.lang.String")) {
                return KindOfType.STRING;
            }
        }
        return KindOfType.OTHER;
    }

    private static String choosePattern(CompilationInfo info, TypeMirror tm, Map<Acceptor, String> patterns) {
        for (Map.Entry<Acceptor, String> e : patterns.entrySet()) {
            if (!e.getKey().accept(info, tm)) continue;
            return e.getValue();
        }
        throw new IllegalStateException();
    }

    private static ExpressionTree prepareExpression(WorkingCopy wc, Map<Acceptor, String> patterns, TypeMirror tm, VariableElement ve, Scope scope) {
        String pattern = EqualsHashCodeGenerator.choosePattern(wc, tm, patterns);
        assert (pattern != null);
        String conditionText = MapFormat.format(pattern, Collections.singletonMap("VAR", ve.getSimpleName().toString()));
        ExpressionTree exp = wc.getTreeUtilities().parseExpression(conditionText, new SourcePositions[1]);
        exp = GeneratorUtilities.get(wc).importFQNs(exp);
        wc.getTreeUtilities().attributeTree(exp, scope);
        return exp;
    }

    static {
        NOT_EQUALS_PATTERNS.put(new SimpleAcceptor(KindOfType.BOOLEAN, KindOfType.BYTE, KindOfType.SHORT, KindOfType.INT, KindOfType.LONG, KindOfType.CHAR), "this.{VAR} != other.{VAR}");
        NOT_EQUALS_PATTERNS.put(new SimpleAcceptor(KindOfType.FLOAT), "java.lang.Float.floatToIntBits(this.{VAR}) != java.lang.Float.floatToIntBits(other.{VAR})");
        NOT_EQUALS_PATTERNS.put(new SimpleAcceptor(KindOfType.DOUBLE), "java.lang.Double.doubleToLongBits(this.{VAR}) != java.lang.Double.doubleToLongBits(other.{VAR})");
        NOT_EQUALS_PATTERNS.put(new SimpleAcceptor(KindOfType.ENUM), "this.{VAR} != other.{VAR}");
        NOT_EQUALS_PATTERNS.put(new SimpleAcceptor(KindOfType.ARRAY_PRIMITIVE), "! java.util.Arrays.equals(this.{VAR}, other.{VAR}");
        NOT_EQUALS_PATTERNS.put(new SimpleAcceptor(KindOfType.ARRAY), "! java.util.Arrays.deepEquals(this.{VAR}, other.{VAR}");
        NOT_EQUALS_PATTERNS.put(new MethodExistsAcceptor("java.util.Objects", "equals", SourceVersion.RELEASE_7), "! java.util.Objects.equals(this.{VAR}, other.{VAR})");
        NOT_EQUALS_PATTERNS.put(new SimpleAcceptor(KindOfType.STRING), "(this.{VAR} == null) ? (other.{VAR} != null) : !this.{VAR}.equals(other.{VAR})");
        NOT_EQUALS_PATTERNS.put(new SimpleAcceptor(KindOfType.OTHER), "this.{VAR} != other.{VAR} && (this.{VAR} == null || !this.{VAR}.equals(other.{VAR}))");
        EQUALS_PATTERNS = new LinkedHashMap<Acceptor, String>();
        EQUALS_PATTERNS.put(new SimpleAcceptor(KindOfType.BOOLEAN, KindOfType.BYTE, KindOfType.SHORT, KindOfType.INT, KindOfType.LONG, KindOfType.CHAR), "this.{VAR} == other.{VAR}");
        EQUALS_PATTERNS.put(new SimpleAcceptor(KindOfType.FLOAT), "java.lang.Float.floatToIntBits(this.{VAR}) == java.lang.Float.floatToIntBits(other.{VAR})");
        EQUALS_PATTERNS.put(new SimpleAcceptor(KindOfType.DOUBLE), "java.lang.Double.doubleToLongBits(this.{VAR}) == java.lang.Double.doubleToLongBits(other.{VAR})");
        EQUALS_PATTERNS.put(new SimpleAcceptor(KindOfType.ENUM), "this.{VAR} == other.{VAR}");
        EQUALS_PATTERNS.put(new SimpleAcceptor(KindOfType.ARRAY_PRIMITIVE), "java.util.Arrays.equals(this.{VAR}, other.{VAR}");
        EQUALS_PATTERNS.put(new SimpleAcceptor(KindOfType.ARRAY), "java.util.Arrays.deepEquals(this.{VAR}, other.{VAR}");
        EQUALS_PATTERNS.put(new MethodExistsAcceptor("java.util.Objects", "equals", SourceVersion.RELEASE_7), "java.util.Objects.equals(this.{VAR}, other.{VAR})");
        EQUALS_PATTERNS.put(new SimpleAcceptor(KindOfType.STRING), "(this.{VAR} == null) ? (other.{VAR} == null) : this.{VAR}.equals(other.{VAR})");
        EQUALS_PATTERNS.put(new SimpleAcceptor(KindOfType.OTHER), "this.{VAR} == other.{VAR} || (this.{VAR} != null && this.{VAR}.equals(other.{VAR}))");
        HASH_CODE_PATTERNS = new LinkedHashMap<Acceptor, String>();
        HASH_CODE_PATTERNS.put(new SimpleAcceptor(KindOfType.BYTE, KindOfType.SHORT, KindOfType.INT, KindOfType.CHAR), "this.{VAR}");
        HASH_CODE_PATTERNS.put(new SimpleAcceptor(KindOfType.LONG), "(int) (this.{VAR} ^ (this.{VAR} >>> 32))");
        HASH_CODE_PATTERNS.put(new SimpleAcceptor(KindOfType.FLOAT), "java.lang.Float.floatToIntBits(this.{VAR})");
        HASH_CODE_PATTERNS.put(new SimpleAcceptor(KindOfType.DOUBLE), "(int) (Double.doubleToLongBits(this.{VAR}) ^ (Double.doubleToLongBits(this.{VAR}) >>> 32))");
        HASH_CODE_PATTERNS.put(new SimpleAcceptor(KindOfType.BOOLEAN), "(this.{VAR} ? 1 : 0)");
        HASH_CODE_PATTERNS.put(new SimpleAcceptor(KindOfType.ARRAY_PRIMITIVE), "java.util.Arrays.hashCode(this.{VAR}");
        HASH_CODE_PATTERNS.put(new SimpleAcceptor(KindOfType.ARRAY), "java.util.Arrays.deepHashCode(this.{VAR}");
        HASH_CODE_PATTERNS.put(new MethodExistsAcceptor("java.util.Objects", "hashCode", SourceVersion.RELEASE_7), "java.util.Objects.hashCode(this.{VAR})");
        HASH_CODE_PATTERNS.put(new SimpleAcceptor(KindOfType.ENUM), "(this.{VAR} != null ? this.{VAR}.hashCode() : 0)");
        HASH_CODE_PATTERNS.put(new SimpleAcceptor(KindOfType.STRING), "(this.{VAR} != null ? this.{VAR}.hashCode() : 0)");
        HASH_CODE_PATTERNS.put(new SimpleAcceptor(KindOfType.OTHER), "(this.{VAR} != null ? this.{VAR}.hashCode() : 0)");
    }

    public static interface Cancel {
        public boolean isCanceled();
    }

    private static final class MethodExistsAcceptor
    implements Acceptor {
        private final String fqn;
        private final String methodName;
        private final SourceVersion minimalVersion;

        public MethodExistsAcceptor(String fqn, String methodName) {
            this(fqn, methodName, null);
        }

        public MethodExistsAcceptor(String fqn, String methodName, SourceVersion minimalVersion) {
            this.fqn = fqn;
            this.methodName = methodName;
            this.minimalVersion = minimalVersion;
        }

        @Override
        public boolean accept(CompilationInfo info, TypeMirror tm) {
            if (this.minimalVersion != null && this.minimalVersion.compareTo(info.getSourceVersion()) > 0) {
                return false;
            }
            TypeElement clazz = info.getElements().getTypeElement(this.fqn);
            if (clazz == null) {
                return false;
            }
            for (ExecutableElement m : ElementFilter.methodsIn(clazz.getEnclosedElements())) {
                if (!m.getSimpleName().contentEquals(this.methodName)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class SimpleAcceptor
    implements Acceptor {
        private final Set<KindOfType> kinds;

        public SimpleAcceptor(KindOfType kind) {
            this.kinds = EnumSet.of(kind);
        }

        public SimpleAcceptor(KindOfType kind, KindOfType ... moreKinds) {
            this.kinds = EnumSet.of(kind);
            this.kinds.addAll(Arrays.asList(moreKinds));
        }

        @Override
        public boolean accept(CompilationInfo info, TypeMirror tm) {
            return this.kinds.contains((Object)EqualsHashCodeGenerator.detectKind(info, tm));
        }
    }

    private static interface Acceptor {
        public boolean accept(CompilationInfo var1, TypeMirror var2);
    }

    private static enum KindOfType {
        BOOLEAN,
        BYTE,
        SHORT,
        INT,
        LONG,
        CHAR,
        FLOAT,
        DOUBLE,
        ENUM,
        ARRAY_PRIMITIVE,
        ARRAY,
        STRING,
        OTHER;

    }

    public static class Factory
    implements CodeGenerator.Factory {
        @Override
        public List<? extends CodeGenerator> create(Lookup context) {
            ArrayList<EqualsHashCodeGenerator> ret = new ArrayList<EqualsHashCodeGenerator>();
            JTextComponent component = context.lookup(JTextComponent.class);
            CompilationController controller = context.lookup(CompilationController.class);
            if (component == null || controller == null) {
                return ret;
            }
            TreePath path = context.lookup(TreePath.class);
            path = controller.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, path);
            if (path == null) {
                return ret;
            }
            try {
                EqualsHashCodeGenerator gen;
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                Element elem = controller.getTrees().getElement(path);
                if (elem != null && (gen = EqualsHashCodeGenerator.createEqualsHashCodeGenerator(component, controller, elem)) != null) {
                    ret.add(gen);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return ret;
        }
    }
}

