/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.service.authentication;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.LoginException;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.service.authentication.AuthTypes$;
import org.apache.kyuubi.service.authentication.AuthUtils$;
import org.apache.kyuubi.service.authentication.FEServiceProcessorFactory;
import org.apache.kyuubi.service.authentication.HadoopThriftAuthBridgeServer;
import org.apache.kyuubi.service.authentication.InternalSecurityAccessor$;
import org.apache.kyuubi.service.authentication.KyuubiAuthenticationFactory$;
import org.apache.kyuubi.service.authentication.KyuubiDelegationTokenManager;
import org.apache.kyuubi.service.authentication.KyuubiDelegationTokenManager$;
import org.apache.kyuubi.service.authentication.PlainSASLHelper$;
import org.apache.kyuubi.service.authentication.SaslQOP$;
import org.apache.kyuubi.service.authentication.TSetIpAddressProcessor$;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TCLIService;
import org.apache.kyuubi.shaded.thrift.TProcessorFactory;
import org.apache.kyuubi.shaded.thrift.transport.TSaslServerTransport;
import org.apache.kyuubi.shaded.thrift.transport.TTransportException;
import org.apache.kyuubi.shaded.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001B\f\u0019\u0001\rB\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tk\u0001\u0011\t\u0011)A\u0005m!)\u0011\b\u0001C\u0001u!9q\b\u0001b\u0001\n\u0003\u0001\u0005B\u00020\u0001A\u0003%\u0011\tC\u0004`\u0001\t\u0007I\u0011\u00011\t\r\u0005\u0004\u0001\u0015!\u00037\u0011\u001d\u0011\u0007A1A\u0005\u0002\u0001Daa\u0019\u0001!\u0002\u00131\u0004b\u00023\u0001\u0005\u0004%\t!\u001a\u0005\u0007S\u0002\u0001\u000b\u0011\u00024\t\u000f)\u0004!\u0019!C\u0005W\"1\u0001\u000f\u0001Q\u0001\n1DQ!\u001d\u0001\u0005\nIDq!a\u0002\u0001\t\u0003\tI\u0001C\u0004\u0002 \u0001!\t!!\t\t\u000f\u0005u\u0003\u0001\"\u0001\u0002`!9\u00111\r\u0001\u0005\u0002\u0005}s!CA31\u0005\u0005\t\u0012AA4\r!9\u0002$!A\t\u0002\u0005%\u0004BB\u001d\u0015\t\u0003\tY\u0007C\u0005\u0002nQ\t\n\u0011\"\u0001\u0002p\tY2*_;vE&\fU\u000f\u001e5f]RL7-\u0019;j_:4\u0015m\u0019;pefT!!\u0007\u000e\u0002\u001d\u0005,H\u000f[3oi&\u001c\u0017\r^5p]*\u00111\u0004H\u0001\bg\u0016\u0014h/[2f\u0015\tib$\u0001\u0004lsV,(-\u001b\u0006\u0003?\u0001\na!\u00199bG\",'\"A\u0011\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001!#\u0006\u0005\u0002&Q5\taEC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIcE\u0001\u0004B]f\u0014VM\u001a\t\u0003W1j\u0011\u0001H\u0005\u0003[q\u0011q\u0001T8hO&tw-\u0001\u0003d_:4\u0007C\u0001\u00194\u001b\u0005\t$B\u0001\u001a\u001d\u0003\u0019\u0019wN\u001c4jO&\u0011A'\r\u0002\u000b\u0017f,XOY5D_:4\u0017\u0001C5t'\u0016\u0014h/\u001a:\u0011\u0005\u0015:\u0014B\u0001\u001d'\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtDcA\u001e>}A\u0011A\bA\u0007\u00021!)af\u0001a\u0001_!9Qg\u0001I\u0001\u0002\u00041\u0014!C1vi\"$\u0016\u0010]3t+\u0005\t\u0005c\u0001\"K\u001b:\u00111\t\u0013\b\u0003\t\u001ek\u0011!\u0012\u0006\u0003\r\n\na\u0001\u0010:p_Rt\u0014\"A\u0014\n\u0005%3\u0013a\u00029bG.\fw-Z\u0005\u0003\u00172\u00131aU3r\u0015\tIe\u0005\u0005\u0002O7:\u0011q*\u0017\b\u0003!bs!!U,\u000f\u0005I3fBA*V\u001d\t!E+C\u0001\"\u0013\ty\u0002%\u0003\u0002\u001e=%\u00111\u0004H\u0005\u00033iI!A\u0017\r\u0002\u0013\u0005+H\u000f\u001b+za\u0016\u001c\u0018B\u0001/^\u0005!\tU\u000f\u001e5UsB,'B\u0001.\u0019\u0003)\tW\u000f\u001e5UsB,7\u000fI\u0001\rg\u0006\u001cH\u000eR5tC\ndW\rZ\u000b\u0002m\u0005i1/Y:m\t&\u001c\u0018M\u00197fI\u0002\nqb[3sE\u0016\u0014xn]#oC\ndW\rZ\u0001\u0011W\u0016\u0014(-\u001a:pg\u0016s\u0017M\u00197fI\u0002\na#\u001a4gK\u000e$\u0018N^3QY\u0006Lg.Q;uQRK\b/Z\u000b\u0002MB\u0019QeZ'\n\u0005!4#AB(qi&|g.A\ffM\u001a,7\r^5wKBc\u0017-\u001b8BkRDG+\u001f9fA\u0005\u0001\u0002.\u00193p_B\fU\u000f\u001e5TKJ4XM]\u000b\u0002YB\u0019QeZ7\u0011\u0005qr\u0017BA8\u0019\u0005qA\u0015\rZ8paRC'/\u001b4u\u0003V$\bN\u0011:jI\u001e,7+\u001a:wKJ\f\u0011\u0003[1e_>\u0004\u0018)\u001e;i'\u0016\u0014h/\u001a:!\u0003E9W\r^*bg2\u0004&o\u001c9feRLWm]\u000b\u0002gB!A/_>|\u001b\u0005)(B\u0001<x\u0003\u0011)H/\u001b7\u000b\u0003a\fAA[1wC&\u0011!0\u001e\u0002\u0004\u001b\u0006\u0004\bc\u0001?\u0002\u00029\u0011QP \t\u0003\t\u001aJ!a \u0014\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019!!\u0002\u0003\rM#(/\u001b8h\u0015\tyh%\u0001\u000bhKR$FK]1ogB|'\u000f\u001e$bGR|'/_\u000b\u0003\u0003\u0017\u0001B!!\u0004\u0002\u001c5\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"A\u0005ue\u0006t7\u000f]8si*!\u0011QCA\f\u0003\u0019!\bN]5gi*\u0019\u0011\u0011\u0004\u000f\u0002\rMD\u0017\rZ3e\u0013\u0011\ti\"a\u0004\u0003#Q#&/\u00198ta>\u0014HOR1di>\u0014\u00180\u0001\u000bhKR$\u0006K]8dKN\u001cxN\u001d$bGR|'/\u001f\u000b\u0005\u0003G\tY\u0003\u0005\u0003\u0002&\u0005\u001dRBAA\n\u0013\u0011\tI#a\u0005\u0003#Q\u0003&o\\2fgN|'OR1di>\u0014\u0018\u0010C\u0004\u0002.A\u0001\r!a\f\u0002\u0005\u0019,\u0007\u0003BA\u0019\u0003/rA!a\r\u0002R9!\u0011QGA'\u001d\u0011\t9$a\u0012\u000f\t\u0005e\u00121\t\b\u0005\u0003w\tyDD\u0002R\u0003{I1!!\u0007\u001d\u0013\u0011\t\t%a\u0006\u0002\t!Lg/Z\u0005\u00047\u0005\u0015#\u0002BA!\u0003/IA!!\u0013\u0002L\u0005\u0019!\u000f]2\u000b\u0007m\t)%\u0003\u0003\u0002\u0016\u0005=#\u0002BA%\u0003\u0017JA!a\u0015\u0002V\u0005YAk\u0011'J'\u0016\u0014h/[2f\u0015\u0011\t)\"a\u0014\n\t\u0005e\u00131\f\u0002\u0006\u0013\u001a\f7-\u001a\u0006\u0005\u0003'\n)&A\u0007hKR\u0014V-\\8uKV\u001bXM]\u000b\u0003\u0003C\u00022!J4|\u000319W\r^%q\u0003\u0012$'/Z:t\u0003mY\u00150^;cS\u0006+H\u000f[3oi&\u001c\u0017\r^5p]\u001a\u000b7\r^8ssB\u0011A\bF\n\u0003)\u0011\"\"!a\u001a\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\t\tHK\u00027\u0003gZ#!!\u001e\u0011\t\u0005]\u0014\u0011Q\u0007\u0003\u0003sRA!a\u001f\u0002~\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u007f2\u0013AC1o]>$\u0018\r^5p]&!\u00111QA=\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class KyuubiAuthenticationFactory
implements Logging {
    private final KyuubiConf conf;
    private final boolean isServer;
    private final Seq<Enumeration.Value> authTypes;
    private final boolean saslDisabled;
    private final boolean kerberosEnabled;
    private final Option<Enumeration.Value> effectivePlainAuthType;
    private final Option<HadoopThriftAuthBridgeServer> hadoopAuthServer;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    public static boolean $lessinit$greater$default$2() {
        return KyuubiAuthenticationFactory$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public Seq<Enumeration.Value> authTypes() {
        return this.authTypes;
    }

    public boolean saslDisabled() {
        return this.saslDisabled;
    }

    public boolean kerberosEnabled() {
        return this.kerberosEnabled;
    }

    public Option<Enumeration.Value> effectivePlainAuthType() {
        return this.effectivePlainAuthType;
    }

    private Option<HadoopThriftAuthBridgeServer> hadoopAuthServer() {
        return this.hadoopAuthServer;
    }

    private Map<String, String> getSaslProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        Enumeration.Value qop = SaslQOP$.MODULE$.withName(this.conf.get(KyuubiConf$.MODULE$.SASL_QOP()));
        props.put("javax.security.sasl.qop", qop.toString());
        props.put("javax.security.sasl.server.authentication", "true");
        return props;
    }

    public TTransportFactory getTTransportFactory() {
        if (this.saslDisabled()) {
            return new TTransportFactory();
        }
        TSaslServerTransport.Factory transportFactory = null;
        Option<HadoopThriftAuthBridgeServer> option = this.hadoopAuthServer();
        if (option instanceof Some) {
            Some some = (Some)option;
            HadoopThriftAuthBridgeServer server = (HadoopThriftAuthBridgeServer)some.value();
            transportFactory = this.liftedTree2$1(server);
        }
        Option<Enumeration.Value> option2 = this.effectivePlainAuthType();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            Enumeration.Value plainAuthType = (Enumeration.Value)some.value();
            transportFactory = (TSaslServerTransport.Factory)PlainSASLHelper$.MODULE$.getTransportFactory(plainAuthType.toString(), this.conf, (Option<TSaslServerTransport.Factory>)Option$.MODULE$.apply((Object)transportFactory), this.isServer);
        }
        Option<HadoopThriftAuthBridgeServer> option3 = this.hadoopAuthServer();
        if (option3 instanceof Some) {
            Some some = (Some)option3;
            HadoopThriftAuthBridgeServer server = (HadoopThriftAuthBridgeServer)some.value();
            return server.wrapTransportFactory((TTransportFactory)transportFactory);
        }
        return transportFactory;
    }

    public TProcessorFactory getTProcessorFactory(TCLIService.Iface fe) {
        Option<HadoopThriftAuthBridgeServer> option = this.hadoopAuthServer();
        if (option instanceof Some) {
            Some some = (Some)option;
            HadoopThriftAuthBridgeServer server = (HadoopThriftAuthBridgeServer)some.value();
            return new FEServiceProcessorFactory(server, fe);
        }
        return PlainSASLHelper$.MODULE$.getProcessFactory(fe);
    }

    public Option<String> getRemoteUser() {
        return this.hadoopAuthServer().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getRemoteUser()).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)TSetIpAddressProcessor$.MODULE$.getUserName()));
    }

    public Option<String> getIpAddress() {
        return this.hadoopAuthServer().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getRemoteAddress()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getHostAddress()).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)TSetIpAddressProcessor$.MODULE$.getUserIpAddress()));
    }

    private static final /* synthetic */ void liftedTree1$1(KyuubiDelegationTokenManager secretMgr$1) {
        try {
            secretMgr$1.startThreads();
        }
        catch (IOException e) {
            throw new TTransportException("Failed to start token manager", (Throwable)e);
        }
    }

    private final /* synthetic */ TSaslServerTransport.Factory liftedTree2$1(HadoopThriftAuthBridgeServer server$1) {
        TSaslServerTransport.Factory factory;
        try {
            factory = server$1.createSaslServerTransportFactory(this.getSaslProperties());
        }
        catch (TTransportException e) {
            throw new LoginException(e.getMessage());
        }
        return factory;
    }

    public KyuubiAuthenticationFactory(KyuubiConf conf, boolean isServer) {
        block2: {
            None$ none$;
            this.conf = conf;
            this.isServer = isServer;
            Logging.$init$(this);
            this.authTypes = (Seq)((TraversableLike)conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_METHOD())).map((Function1 & Serializable & scala.Serializable)s -> AuthTypes$.MODULE$.withName((String)s), Seq$.MODULE$.canBuildFrom());
            this.saslDisabled = AuthUtils$.MODULE$.saslDisabled(this.authTypes());
            this.kerberosEnabled = AuthUtils$.MODULE$.kerberosEnabled(this.authTypes());
            this.effectivePlainAuthType = AuthUtils$.MODULE$.effectivePlainAuthType(this.authTypes());
            if (this.kerberosEnabled()) {
                KyuubiDelegationTokenManager secretMgr = KyuubiDelegationTokenManager$.MODULE$.apply(conf);
                KyuubiAuthenticationFactory.liftedTree1$1(secretMgr);
                none$ = new Some((Object)new HadoopThriftAuthBridgeServer(secretMgr));
            } else {
                none$ = this.hadoopAuthServer = None$.MODULE$;
            }
            if (!BoxesRunTime.unboxToBoolean((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_SECURITY_ENABLED()))) break block2;
            InternalSecurityAccessor$.MODULE$.initialize(conf, isServer);
        }
    }
}

