/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;

public class OutputFile {
    private final PrintStream out;
    private final String filename;

    public OutputFile(String filename) throws IOException {
        File file = new File(filename);
        this.filename = file.getAbsolutePath();
        this.out = new PrintStream(file, "UTF-8");
    }

    @VisibleForTesting
    protected PrintStream getOut() {
        return this.out;
    }

    @VisibleForTesting
    protected String getFilename() {
        return this.filename;
    }

    @VisibleForTesting
    protected OutputFile(PrintStream out, String filename) {
        this.out = out;
        this.filename = filename;
    }

    boolean isActiveConverter() {
        return false;
    }

    void fetchStarted() {
    }

    void foundQuery(boolean foundQuery) {
    }

    void fetchFinished() {
    }

    public String toString() {
        return this.filename;
    }

    public void addLine(String command) {
        this.out.println(command);
    }

    public void println(String command) {
        this.out.println(command);
    }

    public void print(String command) {
        this.out.print(command);
    }

    public void close() throws IOException {
        this.out.close();
    }
}

