/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.sql.parser;

import java.nio.CharBuffer;
import scala.Option;
import scala.Predef$;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.util.matching.Regex;

public final class KyuubiParser$ {
    public static KyuubiParser$ MODULE$;
    private final Regex U16_CHAR_PATTERN;
    private final Regex U32_CHAR_PATTERN;
    private final Regex OCTAL_CHAR_PATTERN;
    private final Regex ESCAPED_CHAR_PATTERN;

    static {
        new KyuubiParser$();
    }

    public Regex U16_CHAR_PATTERN() {
        return this.U16_CHAR_PATTERN;
    }

    public Regex U32_CHAR_PATTERN() {
        return this.U32_CHAR_PATTERN;
    }

    public Regex OCTAL_CHAR_PATTERN() {
        return this.OCTAL_CHAR_PATTERN;
    }

    public Regex ESCAPED_CHAR_PATTERN() {
        return this.ESCAPED_CHAR_PATTERN;
    }

    public String unescapeSQLString(String b) {
        StringBuilder sb = new StringBuilder(b.length());
        if (b.startsWith("r") || b.startsWith("R")) {
            return b.substring(2, b.length() - 1);
        }
        CharBuffer charBuffer = CharBuffer.wrap(b, 1, b.length() - 1);
        while (charBuffer.remaining() > 0) {
            CharBuffer charBuffer2 = charBuffer;
            Option option = this.U16_CHAR_PATTERN().unapplySeq((CharSequence)charBuffer2);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                String cp = (String)((LinearSeqOptimized)option.get()).apply(0);
                sb.append((char)Integer.parseInt(cp, 16));
                charBuffer.position(charBuffer.position() + 6);
                continue;
            }
            Option option2 = this.U32_CHAR_PATTERN().unapplySeq((CharSequence)charBuffer2);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                StringBuilder stringBuilder;
                String cp = (String)((LinearSeqOptimized)option2.get()).apply(0);
                long codePoint = Long.parseLong(cp, 16);
                if (codePoint < 65536L) {
                    stringBuilder = sb.append((char)(codePoint & 0xFFFFL));
                } else {
                    long highSurrogate = (codePoint - 65536L) / 1024L + 55296L;
                    long lowSurrogate = (codePoint - 65536L) % 1024L + 56320L;
                    sb.append((char)highSurrogate);
                    stringBuilder = sb.append((char)lowSurrogate);
                }
                charBuffer.position(charBuffer.position() + 10);
                continue;
            }
            Option option3 = this.OCTAL_CHAR_PATTERN().unapplySeq((CharSequence)charBuffer2);
            if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(1) == 0) {
                String cp = (String)((LinearSeqOptimized)option3.get()).apply(0);
                sb.append((char)Integer.parseInt(cp, 8));
                charBuffer.position(charBuffer.position() + 4);
                continue;
            }
            Option option4 = this.ESCAPED_CHAR_PATTERN().unapplySeq((CharSequence)charBuffer2);
            if (!option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(1) == 0) {
                String c = (String)((LinearSeqOptimized)option4.get()).apply(0);
                KyuubiParser$.appendEscapedChar$1(c.charAt(0), sb);
                charBuffer.position(charBuffer.position() + 2);
                continue;
            }
            sb.append(charBuffer.get());
        }
        return sb.toString();
    }

    private static final void appendEscapedChar$1(char n, StringBuilder sb$1) {
        char c = n;
        switch (c) {
            case '0': {
                sb$1.append('\u0000');
                return;
            }
            case '\'': {
                sb$1.append('\'');
                return;
            }
            case '\"': {
                sb$1.append('\"');
                return;
            }
            case 'b': {
                sb$1.append('\b');
                return;
            }
            case 'n': {
                sb$1.append('\n');
                return;
            }
            case 'r': {
                sb$1.append('\r');
                return;
            }
            case 't': {
                sb$1.append('\t');
                return;
            }
            case 'Z': {
                sb$1.append('\u001a');
                return;
            }
            case '\\': {
                sb$1.append('\\');
                return;
            }
            case '%': {
                sb$1.append("\\%");
                return;
            }
            case '_': {
                sb$1.append("\\_");
                return;
            }
        }
        sb$1.append(n);
    }

    private KyuubiParser$() {
        MODULE$ = this;
        this.U16_CHAR_PATTERN = new StringOps(Predef$.MODULE$.augmentString("\\\\u([a-fA-F0-9]{4})(?s).*")).r();
        this.U32_CHAR_PATTERN = new StringOps(Predef$.MODULE$.augmentString("\\\\U([a-fA-F0-9]{8})(?s).*")).r();
        this.OCTAL_CHAR_PATTERN = new StringOps(Predef$.MODULE$.augmentString("\\\\([01][0-7]{2})(?s).*")).r();
        this.ESCAPED_CHAR_PATTERN = new StringOps(Predef$.MODULE$.augmentString("\\\\((?s).)(?s).*")).r();
    }
}

