/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.trino;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.trino.TrinoSqlEngine;
import org.apache.kyuubi.engine.trino.event.TrinoEngineEvent;
import org.apache.kyuubi.engine.trino.event.TrinoEngineEvent$;
import org.apache.kyuubi.engine.trino.event.TrinoEventHandlerRegister$;
import org.apache.kyuubi.events.EventBus$;
import org.apache.kyuubi.events.KyuubiEvent;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.RetryPolicies$;
import org.apache.kyuubi.util.SignalRegister$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class TrinoSqlEngine$
implements Logging,
scala.Serializable {
    public static TrinoSqlEngine$ MODULE$;
    private final CountDownLatch org$apache$kyuubi$engine$trino$TrinoSqlEngine$$countDownLatch;
    private final KyuubiConf kyuubiConf;
    private Option<TrinoSqlEngine> currentEngine;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    static {
        new TrinoSqlEngine$();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public CountDownLatch org$apache$kyuubi$engine$trino$TrinoSqlEngine$$countDownLatch() {
        return this.org$apache$kyuubi$engine$trino$TrinoSqlEngine$$countDownLatch;
    }

    public KyuubiConf kyuubiConf() {
        return this.kyuubiConf;
    }

    public Option<TrinoSqlEngine> currentEngine() {
        return this.currentEngine;
    }

    public void currentEngine_$eq(Option<TrinoSqlEngine> x$1) {
        this.currentEngine = x$1;
    }

    public void startEngine() {
        try {
            this.initLoggerEventHandler(this.kyuubiConf());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Failed to initialize Logger EventHandler: ").append(e.getMessage()).toString(), e);
            }
            throw throwable;
        }
        this.currentEngine_$eq((Option<TrinoSqlEngine>)new Some((Object)new TrinoSqlEngine()));
        this.currentEngine().foreach((Function1 & Serializable & scala.Serializable)engine -> {
            TrinoSqlEngine$.$anonfun$startEngine$2(engine);
            return BoxedUnit.UNIT;
        });
    }

    private void initLoggerEventHandler(KyuubiConf conf) {
        TrinoEventHandlerRegister$.MODULE$.registerEventLoggers(conf);
    }

    public void main(String[] args) {
        SignalRegister$.MODULE$.registerLogger(this.logger());
        try {
            Utils$.MODULE$.fromCommandLineArgs(args, this.kyuubiConf());
            this.kyuubiConf().setIfMissing(KyuubiConf$.MODULE$.FRONTEND_THRIFT_BINARY_BIND_PORT(), (Object)BoxesRunTime.boxToInteger((int)0));
            this.kyuubiConf().setIfMissing(HighAvailabilityConf$.MODULE$.HA_ZK_CONN_RETRY_POLICY(), (Object)RetryPolicies$.MODULE$.N_TIME().toString());
            this.startEngine();
            this.org$apache$kyuubi$engine$trino$TrinoSqlEngine$$countDownLatch().await();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                if (this.currentEngine().isDefined()) {
                    this.currentEngine().foreach((Function1 & Serializable & scala.Serializable)engine -> {
                        TrinoSqlEngine$.$anonfun$main$1(throwable3, engine);
                        return BoxedUnit.UNIT;
                    });
                }
            }
            if (throwable2 != null) {
                Throwable throwable4 = throwable2;
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Create Trino Engine Failed", throwable4);
            }
            throw throwable;
        }
    }

    public TrinoSqlEngine apply() {
        return new TrinoSqlEngine();
    }

    public boolean unapply(TrinoSqlEngine x$0) {
        return x$0 != null;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$startEngine$2(TrinoSqlEngine engine) {
        engine.initialize(MODULE$.kyuubiConf());
        EventBus$.MODULE$.post((KyuubiEvent)TrinoEngineEvent$.MODULE$.apply(engine));
        engine.start();
        EventBus$.MODULE$.post((KyuubiEvent)TrinoEngineEvent$.MODULE$.apply(engine));
        Utils$.MODULE$.addShutdownHook(() -> {
            engine.stop();
            TrinoEngineEvent qual$1 = TrinoEngineEvent$.MODULE$.apply(engine);
            long x$1 = System.currentTimeMillis();
            String x$2 = qual$1.copy$default$1();
            long x$3 = qual$1.copy$default$2();
            Enumeration.Value x$4 = qual$1.copy$default$4();
            String x$5 = qual$1.copy$default$5();
            Map<String, String> x$6 = qual$1.copy$default$6();
            TrinoEngineEvent event = qual$1.copy(x$2, x$3, x$1, x$4, x$5, x$6);
            EventBus$.MODULE$.post((KyuubiEvent)event);
        }, Utils$.MODULE$.TRINO_ENGINE_SHUTDOWN_PRIORITY() + 1);
    }

    public static final /* synthetic */ void $anonfun$main$1(Throwable x7$1, TrinoSqlEngine engine) {
        MODULE$.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> x7$1);
        engine.stop();
        TrinoEngineEvent qual$1 = TrinoEngineEvent$.MODULE$.apply(engine);
        long x$1 = System.currentTimeMillis();
        String x$2 = x7$1.getMessage();
        String x$3 = qual$1.copy$default$1();
        long x$4 = qual$1.copy$default$2();
        Enumeration.Value x$5 = qual$1.copy$default$4();
        Map<String, String> x$6 = qual$1.copy$default$6();
        TrinoEngineEvent event = qual$1.copy(x$3, x$4, x$1, x$5, x$2, x$6);
        EventBus$.MODULE$.post((KyuubiEvent)event);
    }

    private TrinoSqlEngine$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.org$apache$kyuubi$engine$trino$TrinoSqlEngine$$countDownLatch = new CountDownLatch(1);
        this.kyuubiConf = new KyuubiConf(KyuubiConf$.MODULE$.apply$default$1());
        this.currentEngine = None$.MODULE$;
    }
}

