/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.EnumSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.metrics.MetricsConstants$;
import org.apache.kyuubi.metrics.MetricsSystem$;
import org.apache.kyuubi.server.KyuubiBatchService;
import org.apache.kyuubi.server.KyuubiRestFrontendService$;
import org.apache.kyuubi.server.KyuubiServer$;
import org.apache.kyuubi.server.api.v1.ApiRootResource$;
import org.apache.kyuubi.server.http.authentication.AuthenticationFilter;
import org.apache.kyuubi.server.http.authentication.AuthenticationFilter$;
import org.apache.kyuubi.server.http.authentication.KyuubiHttpAuthenticationFactory;
import org.apache.kyuubi.server.metadata.api.Metadata;
import org.apache.kyuubi.server.ui.JettyServer;
import org.apache.kyuubi.server.ui.JettyServer$;
import org.apache.kyuubi.server.ui.JettyUtils$;
import org.apache.kyuubi.service.AbstractFrontendService;
import org.apache.kyuubi.service.Serverable;
import org.apache.kyuubi.service.Service;
import org.apache.kyuubi.service.ServiceUtils$;
import org.apache.kyuubi.service.authentication.AuthTypes$;
import org.apache.kyuubi.service.authentication.AuthUtils$;
import org.apache.kyuubi.session.KyuubiBatchSession;
import org.apache.kyuubi.session.KyuubiSessionManager;
import org.apache.kyuubi.session.Session;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionHandle$;
import org.apache.kyuubi.util.JavaUtils;
import org.apache.kyuubi.util.ThreadUtils$;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\rg\u0001\u0002\u0013&\u00019B\u0001\"\u000e\u0001\u0003\u0006\u0004%\tE\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005o!)1\b\u0001C\u0001y!Ia\u0005\u0001a\u0001\u0002\u0004%I\u0001\u0011\u0005\n\u000f\u0002\u0001\r\u00111A\u0005\n!C\u0011\"\u0015\u0001A\u0002\u0003\u0005\u000b\u0015B!\t\u000fI\u0003!\u0019!C\u0005'\"1\u0001\r\u0001Q\u0001\nQCQ!\u0019\u0001\u0005\n\tDaa\u001b\u0001\u0005\u0002\u001db\u0007bB:\u0001\u0005\u0004%I\u0001\u001e\u0005\u0007s\u0002\u0001\u000b\u0011B;\t\u0013i\u0004\u0001R1A\u0005\u0002\u001dZ\bBCA\u0003\u0001!\u0015\r\u0011\"\u0001\u0002\b!Q\u0011q\u0004\u0001\t\u0006\u0004%I!!\t\t\u0017\u0005%\u0002\u0001#b\u0001\n\u00039\u00131\u0006\u0005\u000b\u0003g\u0001\u0001R1A\u0005\n\u0005U\u0002bBA\u001f\u0001\u0011\u0005\u0011q\b\u0005\b\u0003\u000b\u0002A\u0011IA$\u0011\u001d\t9\u0006\u0001C!\u0003\u000fAq!!\u0017\u0001\t\u0013\tY\u0006C\u0004\u0002^\u0001!I!a\u0017\t\u000f\u0005}\u0003\u0001\"\u0003\u0002\\!A\u0011\u0011\r\u0001\u0005\u0002\u001d\nY\u0006C\u0004\u0002~\u0001!I!a \t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002\\!9\u0011\u0011\u0012\u0001\u0005B\u0005m\u0003bBAF\u0001\u0011\u0005\u00131\f\u0005\b\u0003\u001b\u0003A\u0011AAH\u0011\u001d\t\t\n\u0001C\u0001\u0003'Cq!!%\u0001\t\u0003\tI\nC\u0004\u0002&\u0002!\t!a\u0002\t\u000f\u0005\u001d\u0006\u0001\"\u0003\u0002*\"I\u0011Q\u0017\u0001C\u0002\u0013\u0005\u0013q\u0017\u0005\t\u0003\u0003\u0004\u0001\u0015!\u0003\u0002:\nI2*_;vE&\u0014Vm\u001d;Ge>tG/\u001a8e'\u0016\u0014h/[2f\u0015\t1s%\u0001\u0004tKJ4XM\u001d\u0006\u0003Q%\naa[=vk\nL'B\u0001\u0016,\u0003\u0019\t\u0007/Y2iK*\tA&A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001_A\u0011\u0001gM\u0007\u0002c)\u0011!gJ\u0001\bg\u0016\u0014h/[2f\u0013\t!\u0014GA\fBEN$(/Y2u\rJ|g\u000e^3oIN+'O^5dK\u0006Q1/\u001a:wKJ\f'\r\\3\u0016\u0003]\u0002\"\u0001\r\u001d\n\u0005e\n$AC*feZ,'/\u00192mK\u0006Y1/\u001a:wKJ\f'\r\\3!\u0003\u0019a\u0014N\\5u}Q\u0011Qh\u0010\t\u0003}\u0001i\u0011!\n\u0005\u0006k\r\u0001\raN\u000b\u0002\u0003B\u0011!)R\u0007\u0002\u0007*\u0011A)J\u0001\u0003k&L!AR\"\u0003\u0017)+G\u000f^=TKJ4XM]\u0001\u000bg\u0016\u0014h/\u001a:`I\u0015\fHCA%P!\tQU*D\u0001L\u0015\u0005a\u0015!B:dC2\f\u0017B\u0001(L\u0005\u0011)f.\u001b;\t\u000fA+\u0011\u0011!a\u0001\u0003\u0006\u0019\u0001\u0010J\u0019\u0002\u000fM,'O^3sA\u0005I\u0011n]*uCJ$X\rZ\u000b\u0002)B\u0011QKX\u0007\u0002-*\u0011q\u000bW\u0001\u0007CR|W.[2\u000b\u0005eS\u0016AC2p]\u000e,(O]3oi*\u00111\fX\u0001\u0005kRLGNC\u0001^\u0003\u0011Q\u0017M^1\n\u0005}3&!D!u_6L7MQ8pY\u0016\fg.\u0001\u0006jgN#\u0018M\u001d;fI\u0002\n!\u0002[1e_>\u00048i\u001c8g+\u0005\u0019\u0007C\u00013j\u001b\u0005)'B\u00014h\u0003\u0011\u0019wN\u001c4\u000b\u0005!L\u0013A\u00025bI>|\u0007/\u0003\u0002kK\ni1i\u001c8gS\u001e,(/\u0019;j_:\fab]3tg&|g.T1oC\u001e,'/F\u0001n!\tq\u0017/D\u0001p\u0015\t\u0001x%A\u0004tKN\u001c\u0018n\u001c8\n\u0005I|'\u0001F&zkV\u0014\u0017nU3tg&|g.T1oC\u001e,'/\u0001\u0007cCR\u001c\u0007n\u00115fG.,'/F\u0001v!\t1x/D\u0001Y\u0013\tA\bL\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016\fQBY1uG\"\u001c\u0005.Z2lKJ\u0004\u0013\u0001\u00042bi\u000eD7+\u001a:wS\u000e,W#\u0001?\u0011\u0007)kx0\u0003\u0002\u007f\u0017\n1q\n\u001d;j_:\u00042APA\u0001\u0013\r\t\u0019!\n\u0002\u0013\u0017f,XOY5CCR\u001c\u0007nU3sm&\u001cW-\u0001\u0003i_N$XCAA\u0005!\u0011\tY!!\u0007\u000f\t\u00055\u0011Q\u0003\t\u0004\u0003\u001fYUBAA\t\u0015\r\t\u0019\"L\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005]1*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00037\tiB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003/Y\u0015\u0001\u00029peR,\"!a\t\u0011\u0007)\u000b)#C\u0002\u0002(-\u00131!\u00138u\u0003=\u0019XmY;sSRLXI\\1cY\u0016$WCAA\u0017!\rQ\u0015qF\u0005\u0004\u0003cY%a\u0002\"p_2,\u0017M\\\u0001\u000fC\u0012l\u0017N\\5tiJ\fGo\u001c:t+\t\t9\u0004\u0005\u0004\u0002\f\u0005e\u0012\u0011B\u0005\u0005\u0003w\tiBA\u0002TKR\fq\"[:BI6Lg.[:ue\u0006$xN\u001d\u000b\u0005\u0003[\t\t\u0005C\u0004\u0002DI\u0001\r!!\u0003\u0002\u0011U\u001cXM\u001d(b[\u0016\f!\"\u001b8ji&\fG.\u001b>f)\rI\u0015\u0011\n\u0005\u0007MN\u0001\r!a\u0013\u0011\t\u00055\u00131K\u0007\u0003\u0003\u001fR1!!\u0015(\u0003\u0019\u0019wN\u001c4jO&!\u0011QKA(\u0005)Y\u00150^;cS\u000e{gNZ\u0001\u000eG>tg.Z2uS>tWK\u001d7\u0002\u001bM$\u0018M\u001d;J]R,'O\\1m)\u0005I\u0015\u0001D5ogR\fG\u000e\\,fEVK\u0015!E:uCJ$()\u0019;dQ\u000eCWmY6fe\u0006!\"/Z2pm\u0016\u0014()\u0019;dQN+7o]5p]ND3\u0001GA3!\u0011\t9'!\u001f\u000e\u0005\u0005%$\u0002BA6\u0003[\n1\"\u00198o_R\fG/[8og*!\u0011qNA9\u0003\u0019\u0019w.\\7p]*!\u00111OA;\u0003\u00199wn\\4mK*\u0011\u0011qO\u0001\u0004G>l\u0017\u0002BA>\u0003S\u0012\u0011CV5tS\ndWMR8s)\u0016\u001cH/\u001b8h\u0003a9W\r\u001e\"bi\u000eD\u0007+\u001a8eS:<W*\u0019=FY\u0006\u00048/\u001a\u000b\u0003\u0003\u0003\u00032ASAB\u0013\r\t)i\u0013\u0002\u0005\u0019>tw-\u0001\u000bxC&$hi\u001c:TKJ4XM]*uCJ$X\rZ\u0001\u0006gR\f'\u000f^\u0001\u0005gR|\u0007/A\u0006hKR\u0014V-\u00197Vg\u0016\u0014HCAA\u0005\u000399W\r^*fgNLwN\\+tKJ$B!!\u0003\u0002\u0016\"9\u0011q\u0013\u0010A\u0002\u0005%\u0011!\u00039s_bLXk]3s)\u0011\tI!a'\t\u000f\u0005uu\u00041\u0001\u0002 \u0006Y1/Z:tS>t7i\u001c8g!!\tY!!)\u0002\n\u0005%\u0011\u0002BAR\u0003;\u00111!T1q\u000319W\r^%q\u0003\u0012$'/Z:t\u000319W\r\u001e)s_bLXk]3s)!\tI!a+\u0002.\u0006E\u0006bBAOC\u0001\u0007\u0011q\u0014\u0005\b\u0003_\u000b\u0003\u0019AA\u0005\u0003%I\u0007/\u00113ee\u0016\u001c8\u000fC\u0004\u00024\u0006\u0002\r!!\u0003\u0002\u0011I,\u0017\r\\+tKJ\f\u0001\u0003Z5tG>4XM]=TKJ4\u0018nY3\u0016\u0005\u0005e\u0006\u0003\u0002&~\u0003w\u00032\u0001MA_\u0013\r\ty,\r\u0002\b'\u0016\u0014h/[2f\u0003E!\u0017n]2pm\u0016\u0014\u0018pU3sm&\u001cW\r\t")
public class KyuubiRestFrontendService
extends AbstractFrontendService {
    private Option<KyuubiBatchService> batchService;
    private String host;
    private int port;
    private boolean securityEnabled;
    private Set<String> administrators;
    private final Serverable serverable;
    private JettyServer server;
    private final AtomicBoolean isStarted;
    private final ScheduledExecutorService batchChecker;
    private final Option<Service> discoveryService;
    private volatile byte bitmap$0;

    public Serverable serverable() {
        return this.serverable;
    }

    private JettyServer server() {
        return this.server;
    }

    private void server_$eq(JettyServer x$1) {
        this.server = x$1;
    }

    private AtomicBoolean isStarted() {
        return this.isStarted;
    }

    private Configuration hadoopConf() {
        return KyuubiServer$.MODULE$.getHadoopConf();
    }

    public KyuubiSessionManager sessionManager() {
        return (KyuubiSessionManager)this.be().sessionManager();
    }

    private ScheduledExecutorService batchChecker() {
        return this.batchChecker;
    }

    private Option<KyuubiBatchService> batchService$lzycompute() {
        KyuubiRestFrontendService kyuubiRestFrontendService = this;
        synchronized (kyuubiRestFrontendService) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.batchService = BoxesRunTime.unboxToBoolean((Object)this.conf().get(KyuubiConf$.MODULE$.BATCH_SUBMITTER_ENABLED())) ? new Some((Object)new KyuubiBatchService(this, this.sessionManager())) : None$.MODULE$;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.batchService;
    }

    public Option<KyuubiBatchService> batchService() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.batchService$lzycompute();
        }
        return this.batchService;
    }

    private String host$lzycompute() {
        KyuubiRestFrontendService kyuubiRestFrontendService = this;
        synchronized (kyuubiRestFrontendService) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.host = (String)((Option)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_REST_BIND_HOST())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    if (JavaUtils.isWindows || JavaUtils.isMac) {
                        this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Kyuubi Server run in Windows or Mac environment, binding ").append(this.getName()).append(" to 0.0.0.0").toString());
                        return "0.0.0.0";
                    }
                    if (BoxesRunTime.unboxToBoolean((Object)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_CONNECTION_URL_USE_HOSTNAME()))) {
                        return JavaUtils.findLocalInetAddress().getCanonicalHostName();
                    }
                    return JavaUtils.findLocalInetAddress().getHostAddress();
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.host;
    }

    public String host() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.host$lzycompute();
        }
        return this.host;
    }

    private int port$lzycompute() {
        KyuubiRestFrontendService kyuubiRestFrontendService = this;
        synchronized (kyuubiRestFrontendService) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.port = BoxesRunTime.unboxToInt((Object)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_REST_BIND_PORT()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.port;
    }

    private int port() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.port$lzycompute();
        }
        return this.port;
    }

    private boolean securityEnabled$lzycompute() {
        KyuubiRestFrontendService kyuubiRestFrontendService = this;
        synchronized (kyuubiRestFrontendService) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                Seq authTypes = (Seq)((TraversableLike)this.conf().get(KyuubiConf$.MODULE$.AUTHENTICATION_METHOD())).map((Function1 & Serializable & scala.Serializable)s -> AuthTypes$.MODULE$.withName(s), Seq$.MODULE$.canBuildFrom());
                this.securityEnabled = AuthUtils$.MODULE$.kerberosEnabled(authTypes) || !AuthUtils$.MODULE$.effectivePlainAuthType(authTypes).contains((Object)AuthTypes$.MODULE$.NONE());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.securityEnabled;
    }

    public boolean securityEnabled() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.securityEnabled$lzycompute();
        }
        return this.securityEnabled;
    }

    private Set<String> administrators$lzycompute() {
        KyuubiRestFrontendService kyuubiRestFrontendService = this;
        synchronized (kyuubiRestFrontendService) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.administrators = (Set)((SetLike)this.conf().get(KyuubiConf$.MODULE$.SERVER_ADMINISTRATORS())).$plus((Object)Utils$.MODULE$.currentUser());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.administrators;
    }

    private Set<String> administrators() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.administrators$lzycompute();
        }
        return this.administrators;
    }

    public boolean isAdministrator(String userName) {
        if (this.securityEnabled()) {
            return this.administrators().contains((Object)userName);
        }
        return true;
    }

    public synchronized void initialize(KyuubiConf conf) {
        this.conf_$eq(conf);
        this.server_$eq(JettyServer$.MODULE$.apply(this.getName(), this.host(), this.port(), BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_REST_MAX_WORKER_THREADS())), BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_REST_JETTY_STOP_TIMEOUT())), BoxesRunTime.unboxToBoolean((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_JETTY_SEND_VERSION_ENABLED()))));
        this.batchService().foreach((Function1 & Serializable & scala.Serializable)service -> {
            this.addService(service);
            return BoxedUnit.UNIT;
        });
        super.initialize(conf);
    }

    public String connectionUrl() {
        this.checkInitialized();
        Option option = (Option)this.conf().get((ConfigEntry)KyuubiConf$.MODULE$.FRONTEND_ADVERTISED_HOST());
        if (option instanceof Some) {
            Some some = (Some)option;
            String advertisedHost = (String)some.value();
            return new StringBuilder(1).append(advertisedHost).append(":").append(this.port()).toString();
        }
        if (None$.MODULE$.equals(option)) {
            return this.server().getServerUri();
        }
        throw new MatchError((Object)option);
    }

    private void startInternal() {
        ServletContextHandler contextHandler = ApiRootResource$.MODULE$.getServletHandler(this);
        FilterHolder holder = new FilterHolder((Filter)new AuthenticationFilter(this.conf()));
        contextHandler.addFilter(holder, "/v1/*", EnumSet.allOf(DispatcherType.class));
        KyuubiHttpAuthenticationFactory authenticationFactory = new KyuubiHttpAuthenticationFactory(this.conf());
        this.server().addHandler((Handler)authenticationFactory.httpHandlerWrapperFactory().wrapHandler((Handler)contextHandler));
        ServletContextHandler proxyHandler = ApiRootResource$.MODULE$.getEngineUIProxyHandler(this);
        this.server().addHandler((Handler)authenticationFactory.httpHandlerWrapperFactory().wrapHandler((Handler)proxyHandler));
        if (BoxesRunTime.unboxToBoolean((Object)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_REST_UI_ENABLED()))) {
            this.installWebUI();
            return;
        }
    }

    private void installWebUI() {
        this.server().addRedirectHandler("/", "/ui");
        ServletContextHandler servletHandler = JettyUtils$.MODULE$.createStaticHandler("dist", "/ui");
        ErrorPageErrorHandler errorHandler = new ErrorPageErrorHandler();
        errorHandler.addErrorPage(404, "/");
        servletHandler.setErrorHandler((ErrorHandler)errorHandler);
        this.server().addHandler((Handler)servletHandler);
    }

    private void startBatchChecker() {
        long interval = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.BATCH_CHECK_INTERVAL()));
        Runnable task = new Runnable(this){
            private final /* synthetic */ KyuubiRestFrontendService $outer;

            public void run() {
                try {
                    this.$outer.sessionManager().getPeerInstanceClosedBatchSessions(this.$outer.connectionUrl()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                        $anon$1.$anonfun$run$1(this, batch);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable e) {
                    this.$outer.error((Function0 & Serializable & scala.Serializable)() -> "Error checking batch sessions", e);
                }
            }

            public static final /* synthetic */ void $anonfun$run$3(KyuubiBatchSession x$1) {
                x$1.close();
            }

            public static final /* synthetic */ void $anonfun$run$1($anon$1 $this, Metadata batch) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    SessionHandle sessionHandle = SessionHandle$.MODULE$.fromUUID(batch.identifier());
                    $this.$outer.sessionManager().getBatchSession(sessionHandle).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                        $anon$1.$anonfun$run$3(x$1);
                        return BoxedUnit.UNIT;
                    });
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(org.apache.kyuubi.server.KyuubiRestFrontendService$$anon$1 org.apache.kyuubi.server.metadata.api.Metadata ), $anonfun$run$4(), $anonfun$run$3$adapted(org.apache.kyuubi.session.KyuubiBatchSession ), $anonfun$run$2(org.apache.kyuubi.server.KyuubiRestFrontendService$$anon$1 org.apache.kyuubi.server.metadata.api.Metadata )}, serializedLambda);
            }
        };
        ThreadUtils$.MODULE$.scheduleTolerableRunnableWithFixedDelay(this.batchChecker(), task, interval, interval, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    public void recoverBatchSessions() {
        int recoveryNumThreads = BoxesRunTime.unboxToInt((Object)this.conf().get(KyuubiConf$.MODULE$.METADATA_RECOVERY_THREADS()));
        ThreadPoolExecutor batchRecoveryExecutor = ThreadUtils$.MODULE$.newDaemonFixedThreadPool(recoveryNumThreads, "batch-recovery-executor");
        try {
            Seq<KyuubiBatchSession> batchSessionsToRecover = this.sessionManager().getBatchSessionsToRecover(this.connectionUrl());
            AtomicInteger pendingRecoveryTasksCount = new AtomicInteger(0);
            Seq tasks = (Seq)batchSessionsToRecover.flatMap((Function1 & Serializable & scala.Serializable)batchSession -> {
                Iterable iterable;
                String batchId = batchSession.batchJobSubmissionOp().batchId();
                try {
                    Future<Object> task = batchRecoveryExecutor.submit(() -> {
                        Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.sessionManager().openBatchSession(batchSession));
                        return BoxedUnit.UNIT;
                    });
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(task), (Object)batchId)));
                }
                catch (Throwable e) {
                    this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Error while submitting batch[").append(batchId).append("] for recovery").toString(), e);
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            }, Seq$.MODULE$.canBuildFrom());
            pendingRecoveryTasksCount.addAndGet(tasks.size());
            tasks.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                KyuubiRestFrontendService.$anonfun$recoverBatchSessions$5(this, pendingRecoveryTasksCount, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            ThreadUtils$.MODULE$.shutdown((ExecutorService)batchRecoveryExecutor, ThreadUtils$.MODULE$.shutdown$default$2());
        }
    }

    private long getBatchPendingMaxElapse() {
        Iterable batchPendingElapseTimes = (Iterable)this.sessionManager().allSessions().map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToLong((long)KyuubiRestFrontendService.$anonfun$getBatchPendingMaxElapse$1(x0$1)), Iterable$.MODULE$.canBuildFrom());
        if (batchPendingElapseTimes.isEmpty()) {
            return 0L;
        }
        return BoxesRunTime.unboxToLong((Object)batchPendingElapseTimes.max((Ordering)Ordering.Long$.MODULE$));
    }

    public void waitForServerStarted() {
        while (!this.server().isStarted()) {
            this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Waiting for ").append(this.getName()).append("'s HTTP server getting started").toString());
            Thread.sleep(1000L);
        }
    }

    public synchronized void start() {
        if (!this.isStarted().get()) {
            try {
                this.server().start();
                this.startInternal();
                this.waitForServerStarted();
                this.isStarted().set(true);
                this.startBatchChecker();
                this.recoverBatchSessions();
                MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                    ms.registerGauge(MetricsConstants$.MODULE$.OPERATION_BATCH_PENDING_MAX_ELAPSE(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> $this.getBatchPendingMaxElapse(), (Object)BoxesRunTime.boxToLong((long)0L));
                    return BoxedUnit.UNIT;
                });
            }
            catch (Exception e) {
                throw new KyuubiException(new StringBuilder(13).append("Cannot start ").append(this.getName()).toString(), (Throwable)e);
            }
        }
        super.start();
        this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Exposing REST endpoint at: http://").append(this.server().getServerUri()).toString());
    }

    public synchronized void stop() {
        ThreadUtils$.MODULE$.shutdown((ExecutorService)this.batchChecker(), ThreadUtils$.MODULE$.shutdown$default$2());
        if (this.isStarted().getAndSet(false)) {
            this.server().stop();
        }
        super.stop();
    }

    public String getRealUser() {
        return ServiceUtils$.MODULE$.getShortName((String)Option$.MODULE$.apply((Object)AuthenticationFilter$.MODULE$.getUserName()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KyuubiRestFrontendService.$anonfun$getRealUser$1(x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous"));
    }

    public String getSessionUser(String proxyUser2) {
        Map sessionConf = (Map)Option$.MODULE$.apply((Object)proxyUser2).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KyuubiRestFrontendService.$anonfun$getSessionUser$1(x$3))).map((Function1 & Serializable & scala.Serializable)proxyUser -> (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KyuubiConf$.MODULE$.PROXY_USER().key()), proxyUser)}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
        return this.getSessionUser((Map<String, String>)sessionConf);
    }

    public String getSessionUser(Map<String, String> sessionConf) {
        String string;
        String ipAddress = AuthenticationFilter$.MODULE$.getUserIpAddress();
        String realUser = this.getRealUser();
        try {
            string = this.getProxyUser(sessionConf, ipAddress, realUser);
        }
        catch (Throwable t) {
            throw new WebApplicationException(t.getMessage(), Response.Status.FORBIDDEN);
        }
        return string;
    }

    public String getIpAddress() {
        return (String)Option$.MODULE$.apply((Object)AuthenticationFilter$.MODULE$.getUserProxyHeaderIpAddress()).getOrElse((Function0 & Serializable & scala.Serializable)() -> AuthenticationFilter$.MODULE$.getUserIpAddress());
    }

    private String getProxyUser(Map<String, String> sessionConf, String ipAddress, String realUser) {
        String proxyUser;
        block1: {
            if (sessionConf == null) {
                return realUser;
            }
            proxyUser = (String)sessionConf.getOrElse((Object)KyuubiConf$.MODULE$.PROXY_USER().key(), (Function0 & Serializable & scala.Serializable)() -> (String)sessionConf.getOrElse((Object)AuthUtils$.MODULE$.HS2_PROXY_USER(), (Function0 & Serializable & scala.Serializable)() -> realUser));
            if (proxyUser.equals(realUser) || this.isAdministrator(realUser)) break block1;
            AuthUtils$.MODULE$.verifyProxyAccess(realUser, proxyUser, ipAddress, this.hadoopConf());
        }
        return proxyUser;
    }

    public Option<Service> discoveryService() {
        return this.discoveryService;
    }

    public static final /* synthetic */ void $anonfun$recoverBatchSessions$5(KyuubiRestFrontendService $this, AtomicInteger pendingRecoveryTasksCount$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Future task = (Future)tuple2._1();
            String batchId = (String)tuple2._2();
            try {
                BoxedUnit boxedUnit;
                try {
                    boxedUnit = (BoxedUnit)task.get();
                }
                catch (Throwable e) {
                    $this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Error while recovering batch[").append(batchId).append("]").toString(), e);
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            finally {
                int pendingTasks = pendingRecoveryTasksCount$1.decrementAndGet();
                $this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Batch[").append(batchId).append("] recovery task terminated, current pending tasks ").append(pendingTasks).toString());
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ long $anonfun$getBatchPendingMaxElapse$1(Session x0$1) {
        Session session = x0$1;
        if (session instanceof KyuubiBatchSession) {
            KyuubiBatchSession kyuubiBatchSession = (KyuubiBatchSession)session;
            return kyuubiBatchSession.batchJobSubmissionOp().getPendingElapsedTime();
        }
        return 0L;
    }

    public static final /* synthetic */ boolean $anonfun$getRealUser$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getSessionUser$1(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).nonEmpty();
    }

    public KyuubiRestFrontendService(Serverable serverable) {
        this.serverable = serverable;
        super("KyuubiRestFrontendService");
        this.isStarted = new AtomicBoolean(false);
        this.batchChecker = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("batch-checker", ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor$default$2());
        this.discoveryService = None$.MODULE$;
    }
}

