/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state;

import org.apache.kafka.streams.kstream.EmitStrategy;
import org.apache.kafka.streams.state.DslKeyValueParams;
import org.apache.kafka.streams.state.DslSessionParams;
import org.apache.kafka.streams.state.DslStoreSuppliers;
import org.apache.kafka.streams.state.DslWindowParams;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.SessionBytesStoreSupplier;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.internals.RocksDbIndexedTimeOrderedWindowBytesStoreSupplier;
import org.apache.kafka.streams.state.internals.RocksDbTimeOrderedSessionBytesStoreSupplier;

public class BuiltInDslStoreSuppliers {
    public static final DslStoreSuppliers ROCKS_DB = new RocksDBDslStoreSuppliers();
    public static final DslStoreSuppliers IN_MEMORY = new InMemoryDslStoreSuppliers();

    public static class InMemoryDslStoreSuppliers
    implements DslStoreSuppliers {
        @Override
        public KeyValueBytesStoreSupplier keyValueStore(DslKeyValueParams params) {
            return Stores.inMemoryKeyValueStore(params.name());
        }

        @Override
        public WindowBytesStoreSupplier windowStore(DslWindowParams params) {
            return Stores.inMemoryWindowStore(params.name(), params.retentionPeriod(), params.windowSize(), params.retainDuplicates());
        }

        @Override
        public SessionBytesStoreSupplier sessionStore(DslSessionParams params) {
            return Stores.inMemorySessionStore(params.name(), params.retentionPeriod());
        }
    }

    public static class RocksDBDslStoreSuppliers
    implements DslStoreSuppliers {
        @Override
        public KeyValueBytesStoreSupplier keyValueStore(DslKeyValueParams params) {
            return params.isTimestamped() ? Stores.persistentTimestampedKeyValueStore(params.name()) : Stores.persistentKeyValueStore(params.name());
        }

        @Override
        public WindowBytesStoreSupplier windowStore(DslWindowParams params) {
            if (params.emitStrategy().type() == EmitStrategy.StrategyType.ON_WINDOW_CLOSE) {
                return RocksDbIndexedTimeOrderedWindowBytesStoreSupplier.create(params.name(), params.retentionPeriod(), params.windowSize(), params.retainDuplicates(), params.isSlidingWindow());
            }
            if (params.isTimestamped()) {
                return Stores.persistentTimestampedWindowStore(params.name(), params.retentionPeriod(), params.windowSize(), params.retainDuplicates());
            }
            return Stores.persistentWindowStore(params.name(), params.retentionPeriod(), params.windowSize(), params.retainDuplicates());
        }

        @Override
        public SessionBytesStoreSupplier sessionStore(DslSessionParams params) {
            if (params.emitStrategy().type() == EmitStrategy.StrategyType.ON_WINDOW_CLOSE) {
                return new RocksDbTimeOrderedSessionBytesStoreSupplier(params.name(), params.retentionPeriod().toMillis(), true);
            }
            return Stores.persistentSessionStore(params.name(), params.retentionPeriod());
        }
    }
}

