/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.EmitStrategy;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.Merger;
import org.apache.kafka.streams.kstream.SessionWindows;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.KStreamAggProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KStreamImplJoin;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.SessionCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.kstream.internals.TimestampedTupleForwarder;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.api.RecordMetadata;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.metrics.ProcessorNodeMetrics;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KStreamSessionWindowAggregate<KIn, VIn, VAgg>
implements KStreamAggProcessorSupplier<KIn, VIn, Windowed<KIn>, VAgg> {
    private static final Logger LOG = LoggerFactory.getLogger(KStreamSessionWindowAggregate.class);
    private final String storeName;
    private final SessionWindows windows;
    private final Initializer<VAgg> initializer;
    private final Aggregator<? super KIn, ? super VIn, VAgg> aggregator;
    private final Merger<? super KIn, VAgg> sessionMerger;
    private final EmitStrategy emitStrategy;
    private boolean sendOldValues = false;

    public KStreamSessionWindowAggregate(SessionWindows windows, String storeName, EmitStrategy emitStrategy, Initializer<VAgg> initializer, Aggregator<? super KIn, ? super VIn, VAgg> aggregator, Merger<? super KIn, VAgg> sessionMerger) {
        this.windows = windows;
        this.storeName = storeName;
        this.emitStrategy = emitStrategy;
        this.initializer = initializer;
        this.aggregator = aggregator;
        this.sessionMerger = sessionMerger;
    }

    @Override
    public Processor<KIn, VIn, Windowed<KIn>, Change<VAgg>> get() {
        return new KStreamSessionWindowAggregateProcessor();
    }

    public SessionWindows windows() {
        return this.windows;
    }

    @Override
    public void enableSendingOldValues() {
        this.sendOldValues = true;
    }

    private SessionWindow mergeSessionWindow(SessionWindow one, SessionWindow two) {
        long start = Math.min(one.start(), two.start());
        long end = Math.max(one.end(), two.end());
        return new SessionWindow(start, end);
    }

    @Override
    public KTableValueGetterSupplier<Windowed<KIn>, VAgg> view() {
        return new KTableValueGetterSupplier<Windowed<KIn>, VAgg>(){

            @Override
            public KTableValueGetter<Windowed<KIn>, VAgg> get() {
                return new KTableSessionWindowValueGetter();
            }

            @Override
            public String[] storeNames() {
                return new String[]{KStreamSessionWindowAggregate.this.storeName};
            }
        };
    }

    private class KTableSessionWindowValueGetter
    implements KTableValueGetter<Windowed<KIn>, VAgg> {
        private SessionStore<KIn, VAgg> store;

        private KTableSessionWindowValueGetter() {
        }

        @Override
        public void init(ProcessorContext<?, ?> context) {
            this.store = (SessionStore)context.getStateStore(KStreamSessionWindowAggregate.this.storeName);
        }

        @Override
        public ValueAndTimestamp<VAgg> get(Windowed<KIn> key) {
            return ValueAndTimestamp.make(this.store.fetchSession(key.key(), key.window().start(), key.window().end()), key.window().end());
        }

        @Override
        public boolean isVersioned() {
            return false;
        }
    }

    private class KStreamSessionWindowAggregateProcessor
    extends ContextualProcessor<KIn, VIn, Windowed<KIn>, Change<VAgg>> {
        private SessionStore<KIn, VAgg> store;
        private TimestampedTupleForwarder<Windowed<KIn>, VAgg> tupleForwarder;
        private Sensor droppedRecordsSensor;
        private Sensor emittedRecordsSensor;
        private Sensor emitFinalLatencySensor;
        private long lastEmitWindowCloseTime = -1L;
        private long observedStreamTime = -1L;
        private InternalProcessorContext<Windowed<KIn>, Change<VAgg>> internalProcessorContext;
        private final Time time = Time.SYSTEM;
        protected final KStreamImplJoin.TimeTracker timeTracker = new KStreamImplJoin.TimeTracker();

        private KStreamSessionWindowAggregateProcessor() {
        }

        @Override
        public void init(ProcessorContext<Windowed<KIn>, Change<VAgg>> context) {
            super.init(context);
            this.internalProcessorContext = (InternalProcessorContext)context;
            StreamsMetricsImpl metrics = (StreamsMetricsImpl)context.metrics();
            String threadId = Thread.currentThread().getName();
            String processorName = this.internalProcessorContext.currentNode().name();
            this.droppedRecordsSensor = TaskMetrics.droppedRecordsSensor(threadId, context.taskId().toString(), metrics);
            this.emittedRecordsSensor = ProcessorNodeMetrics.emittedRecordsSensor(threadId, context.taskId().toString(), processorName, metrics);
            this.emitFinalLatencySensor = ProcessorNodeMetrics.emitFinalLatencySensor(threadId, context.taskId().toString(), processorName, metrics);
            this.store = (SessionStore)context.getStateStore(KStreamSessionWindowAggregate.this.storeName);
            if (KStreamSessionWindowAggregate.this.emitStrategy.type() == EmitStrategy.StrategyType.ON_WINDOW_CLOSE) {
                Long lastEmitWindowCloseTime = this.internalProcessorContext.processorMetadataForKey(KStreamSessionWindowAggregate.this.storeName);
                if (lastEmitWindowCloseTime != null) {
                    this.lastEmitWindowCloseTime = lastEmitWindowCloseTime;
                }
                long emitInterval = StreamsConfig.InternalConfig.getLong(context.appConfigs(), "__emit.interval.ms.kstreams.windowed.aggregation__", 1000L);
                this.timeTracker.setEmitInterval(emitInterval);
                this.tupleForwarder = new TimestampedTupleForwarder(context, KStreamSessionWindowAggregate.this.sendOldValues);
            } else {
                this.tupleForwarder = new TimestampedTupleForwarder(this.store, context, new SessionCacheFlushListener(context), KStreamSessionWindowAggregate.this.sendOldValues);
            }
        }

        @Override
        public void process(Record<KIn, VIn> record) {
            SessionWindow newSessionWindow;
            if (record.key() == null) {
                this.logSkippedRecordForNullKey();
                return;
            }
            long timestamp = record.timestamp();
            this.observedStreamTime = Math.max(this.observedStreamTime, timestamp);
            long windowCloseTime = this.observedStreamTime - KStreamSessionWindowAggregate.this.windows.gracePeriodMs() - KStreamSessionWindowAggregate.this.windows.inactivityGap();
            ArrayList<KeyValue> merged = new ArrayList<KeyValue>();
            SessionWindow mergedWindow = newSessionWindow = new SessionWindow(timestamp, timestamp);
            Object agg = KStreamSessionWindowAggregate.this.initializer.apply();
            Throwable throwable = null;
            try (Iterator iterator = this.store.findSessions(record.key(), timestamp - KStreamSessionWindowAggregate.this.windows.inactivityGap(), timestamp + KStreamSessionWindowAggregate.this.windows.inactivityGap());){
                while (iterator.hasNext()) {
                    KeyValue next = (KeyValue)iterator.next();
                    merged.add(next);
                    agg = KStreamSessionWindowAggregate.this.sessionMerger.apply(record.key(), agg, next.value);
                    mergedWindow = KStreamSessionWindowAggregate.this.mergeSessionWindow(mergedWindow, (SessionWindow)((Windowed)next.key).window());
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            if (mergedWindow.end() < windowCloseTime) {
                this.logSkippedRecordForExpiredWindow(timestamp, windowCloseTime, mergedWindow);
            } else {
                if (!mergedWindow.equals(newSessionWindow)) {
                    for (KeyValue keyValue : merged) {
                        this.store.remove((Windowed)keyValue.key);
                        this.maybeForwardUpdate((Windowed)keyValue.key, keyValue.value, null);
                    }
                }
                agg = KStreamSessionWindowAggregate.this.aggregator.apply(record.key(), record.value(), agg);
                Windowed sessionKey = new Windowed(record.key(), mergedWindow);
                this.store.put(sessionKey, agg);
                this.maybeForwardUpdate(sessionKey, null, agg);
            }
            this.maybeForwardFinalResult(record, windowCloseTime);
        }

        private void maybeForwardUpdate(Windowed<KIn> windowedkey, VAgg oldAgg, VAgg newAgg) {
            if (KStreamSessionWindowAggregate.this.emitStrategy.type() == EmitStrategy.StrategyType.ON_WINDOW_CLOSE) {
                return;
            }
            long newTimestamp = windowedkey.window().end();
            this.tupleForwarder.maybeForward(new Record(windowedkey, new Change(newAgg, KStreamSessionWindowAggregate.this.sendOldValues ? oldAgg : null), newTimestamp));
        }

        private void maybeForwardFinalResult(Record<KIn, VIn> record, long windowCloseTime) {
            long emitRangeLowerBound;
            long emitRangeUpperBound;
            if (this.shouldEmitFinal(windowCloseTime) && (emitRangeUpperBound = this.emitRangeUpperBound(windowCloseTime)) >= 0L && this.shouldRangeFetch(emitRangeLowerBound = this.emitRangeLowerBound(), emitRangeUpperBound)) {
                this.fetchAndEmit(record, windowCloseTime, emitRangeLowerBound, emitRangeUpperBound);
            }
        }

        private boolean shouldEmitFinal(long windowCloseTime) {
            if (KStreamSessionWindowAggregate.this.emitStrategy.type() != EmitStrategy.StrategyType.ON_WINDOW_CLOSE) {
                return false;
            }
            long now = this.internalProcessorContext.currentSystemTimeMs();
            if (now < this.timeTracker.nextTimeToEmit) {
                return false;
            }
            this.timeTracker.nextTimeToEmit = now;
            this.timeTracker.advanceNextTimeToEmit();
            return this.lastEmitWindowCloseTime == -1L || this.lastEmitWindowCloseTime < windowCloseTime;
        }

        private long emitRangeLowerBound() {
            return Math.max(0L, this.lastEmitWindowCloseTime);
        }

        private long emitRangeUpperBound(long windowCloseTime) {
            return windowCloseTime - 1L;
        }

        private boolean shouldRangeFetch(long emitRangeLowerBound, long emitRangeUpperBound) {
            return emitRangeUpperBound >= emitRangeLowerBound;
        }

        private void fetchAndEmit(Record<KIn, VIn> record, long windowCloseTime, long emitRangeLowerBound, long emitRangeUpperBound) {
            long startMs = this.time.milliseconds();
            int emittedCount = 0;
            try (KeyValueIterator windowToEmit = this.store.findSessions(emitRangeLowerBound, emitRangeUpperBound);){
                while (windowToEmit.hasNext()) {
                    ++emittedCount;
                    KeyValue kv = (KeyValue)windowToEmit.next();
                    this.tupleForwarder.maybeForward(record.withKey(kv.key).withValue(new Change<Object>(kv.value, null)).withTimestamp(((Windowed)kv.key).window().end()).withHeaders(record.headers()));
                }
            }
            this.emittedRecordsSensor.record((double)emittedCount);
            this.emitFinalLatencySensor.record((double)(this.time.milliseconds() - startMs));
            this.lastEmitWindowCloseTime = windowCloseTime;
            this.internalProcessorContext.addProcessorMetadataKeyValue(KStreamSessionWindowAggregate.this.storeName, windowCloseTime);
        }

        private void logSkippedRecordForNullKey() {
            if (this.context().recordMetadata().isPresent()) {
                RecordMetadata recordMetadata = this.context().recordMetadata().get();
                LOG.warn("Skipping record due to null key. topic=[{}] partition=[{}] offset=[{}]", new Object[]{recordMetadata.topic(), recordMetadata.partition(), recordMetadata.offset()});
            } else {
                LOG.warn("Skipping record due to null key. Topic, partition, and offset not known.");
            }
            this.droppedRecordsSensor.record();
        }

        private void logSkippedRecordForExpiredWindow(long timestamp, long windowExpire, SessionWindow window) {
            String windowString = "[" + window.start() + "," + window.end() + "]";
            if (this.context().recordMetadata().isPresent()) {
                RecordMetadata recordMetadata = this.context().recordMetadata().get();
                LOG.warn("Skipping record for expired window. topic=[{}] partition=[{}] offset=[{}] timestamp=[{}] window={} expiration=[{}] streamTime=[{}]", new Object[]{recordMetadata.topic(), recordMetadata.partition(), recordMetadata.offset(), timestamp, windowString, windowExpire, this.observedStreamTime});
            } else {
                LOG.warn("Skipping record for expired window. Topic, partition, and offset not known. timestamp=[{}] window={} expiration=[{}] streamTime=[{}]", new Object[]{timestamp, windowString, windowExpire, this.observedStreamTime});
            }
            this.droppedRecordsSensor.record();
        }
    }
}

