/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.kafka.common.MessageFormatter;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.kafka.tools.consumer.DefaultMessageFormatter;
import org.apache.kafka.tools.consumer.LoggingMessageFormatter;
import org.apache.kafka.tools.consumer.NoOpMessageFormatter;

public final class ConsoleConsumerOptions
extends CommandDefaultOptions {
    private static final Random RANDOM = new Random();
    private final OptionSpec<String> topicOpt;
    private final OptionSpec<String> whitelistOpt;
    private final OptionSpec<String> includeOpt;
    private final OptionSpec<Integer> partitionIdOpt;
    private final OptionSpec<String> offsetOpt;
    private final OptionSpec<String> messageFormatterOpt;
    private final OptionSpec<String> messageFormatterArgOpt;
    private final OptionSpec<String> messageFormatterConfigOpt;
    private final OptionSpec<?> resetBeginningOpt;
    private final OptionSpec<Integer> maxMessagesOpt;
    private final OptionSpec<Long> timeoutMsOpt;
    private final OptionSpec<?> skipMessageOnErrorOpt;
    private final OptionSpec<String> bootstrapServerOpt;
    private final OptionSpec<String> keyDeserializerOpt;
    private final OptionSpec<String> valueDeserializerOpt;
    private final OptionSpec<?> enableSystestEventsLoggingOpt;
    private final OptionSpec<String> isolationLevelOpt;
    private final OptionSpec<String> groupIdOpt;
    private final Properties consumerProps;
    private final long offset;
    private final long timeoutMs;
    private final MessageFormatter formatter;

    public ConsoleConsumerOptions(String[] args) throws IOException {
        super(args);
        this.topicOpt = this.parser.accepts("topic", "The topic to consume on.").withRequiredArg().describedAs("topic").ofType(String.class);
        this.whitelistOpt = this.parser.accepts("whitelist", "DEPRECATED, use --include instead; ignored if --include specified. Regular expression specifying list of topics to include for consumption.").withRequiredArg().describedAs("Java regex (String)").ofType(String.class);
        this.includeOpt = this.parser.accepts("include", "Regular expression specifying list of topics to include for consumption.").withRequiredArg().describedAs("Java regex (String)").ofType(String.class);
        this.partitionIdOpt = this.parser.accepts("partition", "The partition to consume from. Consumption starts from the end of the partition unless '--offset' is specified.").withRequiredArg().describedAs("partition").ofType(Integer.class);
        this.offsetOpt = this.parser.accepts("offset", "The offset to consume from (a non-negative number), or 'earliest' which means from beginning, or 'latest' which means from end").withRequiredArg().describedAs("consume offset").ofType(String.class).defaultsTo((Object)"latest", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec consumerPropertyOpt = this.parser.accepts("consumer-property", "A mechanism to pass user-defined properties in the form key=value to the consumer.").withRequiredArg().describedAs("consumer_prop").ofType(String.class);
        ArgumentAcceptingOptionSpec consumerConfigOpt = this.parser.accepts("consumer.config", "Consumer config properties file. Note that " + consumerPropertyOpt + " takes precedence over this config.").withRequiredArg().describedAs("config file").ofType(String.class);
        this.messageFormatterOpt = this.parser.accepts("formatter", "The name of a class to use for formatting kafka messages for display.").withRequiredArg().describedAs("class").ofType(String.class).defaultsTo((Object)DefaultMessageFormatter.class.getName(), (Object[])new String[0]);
        this.messageFormatterArgOpt = this.parser.accepts("property", "The properties to initialize the message formatter. Default properties include: \n print.timestamp=true|false\n print.key=true|false\n print.offset=true|false\n print.partition=true|false\n print.headers=true|false\n print.value=true|false\n key.separator=<key.separator>\n line.separator=<line.separator>\n headers.separator=<line.separator>\n null.literal=<null.literal>\n key.deserializer=<key.deserializer>\n value.deserializer=<value.deserializer>\n header.deserializer=<header.deserializer>\n\nUsers can also pass in customized properties for their formatter; more specifically, users can pass in properties keyed with 'key.deserializer.', 'value.deserializer.' and 'headers.deserializer.' prefixes to configure their deserializers.").withRequiredArg().describedAs("prop").ofType(String.class);
        this.messageFormatterConfigOpt = this.parser.accepts("formatter-config", "Config properties file to initialize the message formatter. Note that " + this.messageFormatterArgOpt + " takes precedence over this config.").withRequiredArg().describedAs("config file").ofType(String.class);
        this.resetBeginningOpt = this.parser.accepts("from-beginning", "If the consumer does not already have an established offset to consume from, start with the earliest message present in the log rather than the latest message.");
        this.maxMessagesOpt = this.parser.accepts("max-messages", "The maximum number of messages to consume before exiting. If not set, consumption is continual.").withRequiredArg().describedAs("num_messages").ofType(Integer.class);
        this.timeoutMsOpt = this.parser.accepts("timeout-ms", "If specified, exit if no message is available for consumption for the specified interval.").withRequiredArg().describedAs("timeout_ms").ofType(Long.class);
        this.skipMessageOnErrorOpt = this.parser.accepts("skip-message-on-error", "If there is an error when processing a message, skip it instead of halt.");
        this.bootstrapServerOpt = this.parser.accepts("bootstrap-server", "REQUIRED: The server(s) to connect to.").withRequiredArg().describedAs("server to connect to").ofType(String.class);
        this.keyDeserializerOpt = this.parser.accepts("key-deserializer").withRequiredArg().describedAs("deserializer for key").ofType(String.class);
        this.valueDeserializerOpt = this.parser.accepts("value-deserializer").withRequiredArg().describedAs("deserializer for values").ofType(String.class);
        this.enableSystestEventsLoggingOpt = this.parser.accepts("enable-systest-events", "Log lifecycle events of the consumer in addition to logging consumed messages. (This is specific for system tests.)");
        this.isolationLevelOpt = this.parser.accepts("isolation-level", "Set to read_committed in order to filter out transactional messages which are not committed. Set to read_uncommitted to read all messages.").withRequiredArg().ofType(String.class).defaultsTo((Object)"read_uncommitted", (Object[])new String[0]);
        this.groupIdOpt = this.parser.accepts("group", "The consumer group id of the consumer.").withRequiredArg().describedAs("consumer group id").ofType(String.class);
        try {
            this.options = this.parser.parse(args);
        }
        catch (OptionException oe) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)oe.getMessage());
        }
        CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)this, (String)"This tool helps to read data from Kafka topics and outputs it to standard output.");
        this.checkRequiredArgs();
        Properties consumerPropsFromFile = this.options.has((OptionSpec)consumerConfigOpt) ? Utils.loadProps((String)((String)this.options.valueOf((OptionSpec)consumerConfigOpt))) : new Properties();
        Properties extraConsumerProps = CommandLineUtils.parseKeyValueArgs((List)this.options.valuesOf((OptionSpec)consumerPropertyOpt));
        Set<String> groupIdsProvided = this.checkConsumerGroup(consumerPropsFromFile, extraConsumerProps);
        this.consumerProps = this.buildConsumerProps(consumerPropsFromFile, extraConsumerProps, groupIdsProvided);
        this.offset = this.parseOffset();
        this.timeoutMs = this.parseTimeoutMs();
        this.formatter = this.buildFormatter();
    }

    private void checkRequiredArgs() {
        ArrayList<Optional> topicOrFilterArgs = new ArrayList<Optional>(Arrays.asList(this.topicArg(), this.includedTopicsArg()));
        topicOrFilterArgs.removeIf(arg -> !arg.isPresent());
        if (topicOrFilterArgs.size() != 1) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Exactly one of --include/--topic is required. " + (this.options.has(this.whitelistOpt) ? "--whitelist is DEPRECATED use --include instead; ignored if --include specified." : "")));
        }
        if (this.partitionArg().isPresent()) {
            if (!this.options.has(this.topicOpt)) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"The topic is required when partition is specified.");
            }
            if (this.fromBeginning() && this.options.has(this.offsetOpt)) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"Options from-beginning and offset cannot be specified together.");
            }
        } else if (this.options.has(this.offsetOpt)) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"The partition is required when offset is specified.");
        }
        CommandLineUtils.checkRequiredArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec[])new OptionSpec[]{this.bootstrapServerOpt});
    }

    private Set<String> checkConsumerGroup(Properties consumerPropsFromFile, Properties extraConsumerProps) {
        HashSet<String> groupIdsProvided = new HashSet<String>();
        if (this.options.has(this.groupIdOpt)) {
            groupIdsProvided.add((String)this.options.valueOf(this.groupIdOpt));
        }
        if (consumerPropsFromFile.containsKey("group.id")) {
            groupIdsProvided.add((String)consumerPropsFromFile.get("group.id"));
        }
        if (extraConsumerProps.containsKey("group.id")) {
            groupIdsProvided.add(extraConsumerProps.getProperty("group.id"));
        }
        if (groupIdsProvided.size() > 1) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("The group ids provided in different places (directly using '--group', via '--consumer-property', or via '--consumer.config') do not match. Detected group ids: " + groupIdsProvided.stream().map(group -> "'" + group + "'").collect(Collectors.joining(", "))));
        }
        if (!groupIdsProvided.isEmpty() && this.partitionArg().isPresent()) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"Options group and partition cannot be specified together.");
        }
        return groupIdsProvided;
    }

    private Properties buildConsumerProps(Properties consumerPropsFromFile, Properties extraConsumerProps, Set<String> groupIdsProvided) {
        Properties consumerProps = new Properties();
        consumerProps.putAll((Map<?, ?>)consumerPropsFromFile);
        consumerProps.putAll((Map<?, ?>)extraConsumerProps);
        this.setAutoOffsetResetValue(consumerProps);
        consumerProps.put("bootstrap.servers", this.bootstrapServer());
        if (consumerProps.getProperty("client.id") == null) {
            consumerProps.put("client.id", "console-consumer");
        }
        CommandLineUtils.maybeMergeOptions((Properties)consumerProps, (String)"isolation.level", (OptionSet)this.options, this.isolationLevelOpt);
        if (groupIdsProvided.isEmpty()) {
            consumerProps.put("group.id", "console-consumer-" + RANDOM.nextInt(100000));
            if (!consumerProps.containsKey("enable.auto.commit")) {
                consumerProps.put("enable.auto.commit", "false");
            }
        } else {
            consumerProps.put("group.id", groupIdsProvided.iterator().next());
        }
        return consumerProps;
    }

    private void setAutoOffsetResetValue(Properties props) {
        String earliestConfigValue = "earliest";
        String latestConfigValue = "latest";
        if (props.containsKey("auto.offset.reset")) {
            String autoResetOption = props.getProperty("auto.offset.reset");
            if (this.fromBeginning() && !earliestConfigValue.equals(autoResetOption)) {
                System.err.println("Can't simultaneously specify --from-beginning and 'auto.offset.reset=" + autoResetOption + "', please remove one option");
                Exit.exit((int)1);
            }
        } else {
            String autoResetOption = this.fromBeginning() ? earliestConfigValue : latestConfigValue;
            props.put("auto.offset.reset", autoResetOption);
        }
    }

    private long parseOffset() {
        if (this.options.has(this.offsetOpt)) {
            switch (((String)this.options.valueOf(this.offsetOpt)).toLowerCase(Locale.ROOT)) {
                case "earliest": {
                    return -2L;
                }
                case "latest": {
                    return -1L;
                }
            }
            String offsetString = (String)this.options.valueOf(this.offsetOpt);
            try {
                long offset = Long.parseLong(offsetString);
                if (offset < 0L) {
                    this.invalidOffset(offsetString);
                }
                return offset;
            }
            catch (NumberFormatException nfe) {
                this.invalidOffset(offsetString);
            }
        } else if (this.fromBeginning()) {
            return -2L;
        }
        return -1L;
    }

    private void invalidOffset(String offset) {
        CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("The provided offset value '" + offset + "' is incorrect. Valid values are 'earliest', 'latest', or a non-negative long."));
    }

    private long parseTimeoutMs() {
        long timeout = this.options.has(this.timeoutMsOpt) ? (Long)this.options.valueOf(this.timeoutMsOpt) : -1L;
        return timeout >= 0L ? timeout : Long.MAX_VALUE;
    }

    private MessageFormatter buildFormatter() {
        MessageFormatter formatter = null;
        try {
            Class<?> messageFormatterClass = Class.forName(ConsoleConsumerOptions.convertDeprecatedClass((String)this.options.valueOf(this.messageFormatterOpt)));
            formatter = (MessageFormatter)messageFormatterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Properties formatterArgs = this.formatterArgs();
            HashMap<String, String> formatterConfigs = new HashMap<String, String>();
            for (String name : formatterArgs.stringPropertyNames()) {
                formatterConfigs.put(name, formatterArgs.getProperty(name));
            }
            formatter.configure(formatterConfigs);
        }
        catch (Exception e) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)e.getMessage());
        }
        return formatter;
    }

    private static String convertDeprecatedClass(String className) {
        switch (className) {
            case "kafka.tools.DefaultMessageFormatter": {
                System.err.println("WARNING: kafka.tools.DefaultMessageFormatter is deprecated and will be removed in the next major release. Please use org.apache.kafka.tools.consumer.DefaultMessageFormatter instead");
                return DefaultMessageFormatter.class.getName();
            }
            case "kafka.tools.LoggingMessageFormatter": {
                System.err.println("WARNING: kafka.tools.LoggingMessageFormatter is deprecated and will be removed in the next major release. Please use org.apache.kafka.tools.consumer.LoggingMessageFormatter instead");
                return LoggingMessageFormatter.class.getName();
            }
            case "kafka.tools.NoOpMessageFormatter": {
                System.err.println("WARNING: kafka.tools.NoOpMessageFormatter is deprecated and will be removed in the next major release. Please use org.apache.kafka.tools.consumer.NoOpMessageFormatter instead");
                return NoOpMessageFormatter.class.getName();
            }
            case "kafka.coordinator.transaction.TransactionLog$TransactionLogMessageFormatter": {
                System.err.println("WARNING: kafka.coordinator.transaction.TransactionLog$TransactionLogMessageFormatter is deprecated and will be removed in the next major release. Please use org.apache.kafka.tools.consumer.TransactionLogMessageFormatter instead");
                return className;
            }
            case "kafka.coordinator.group.GroupMetadataManager$OffsetsMessageFormatter": {
                System.err.println("WARNING: kafka.coordinator.group.GroupMetadataManager$OffsetsMessageFormatter is deprecated and will be removed in the next major release. Please use org.apache.kafka.tools.consumer.OffsetsMessageFormatter instead");
                return className;
            }
            case "kafka.coordinator.group.GroupMetadataManager$GroupMetadataMessageFormatter": {
                System.err.println("WARNING: kafka.coordinator.group.GroupMetadataManager$GroupMetadataMessageFormatter is deprecated and will be removed in the next major release. Please use org.apache.kafka.tools.consumer.GroupMetadataMessageFormatter instead");
                return className;
            }
        }
        return className;
    }

    Properties consumerProps() {
        return this.consumerProps;
    }

    boolean fromBeginning() {
        return this.options.has(this.resetBeginningOpt);
    }

    long offsetArg() {
        return this.offset;
    }

    boolean skipMessageOnError() {
        return this.options.has(this.skipMessageOnErrorOpt);
    }

    OptionalInt partitionArg() {
        if (this.options.has(this.partitionIdOpt)) {
            return OptionalInt.of((Integer)this.options.valueOf(this.partitionIdOpt));
        }
        return OptionalInt.empty();
    }

    Optional<String> topicArg() {
        return this.options.has(this.topicOpt) ? Optional.of(this.options.valueOf(this.topicOpt)) : Optional.empty();
    }

    int maxMessages() {
        return this.options.has(this.maxMessagesOpt) ? (Integer)this.options.valueOf(this.maxMessagesOpt) : -1;
    }

    long timeoutMs() {
        return this.timeoutMs;
    }

    boolean enableSystestEventsLogging() {
        return this.options.has(this.enableSystestEventsLoggingOpt);
    }

    String bootstrapServer() {
        return (String)this.options.valueOf(this.bootstrapServerOpt);
    }

    Optional<String> includedTopicsArg() {
        return this.options.has(this.includeOpt) ? Optional.of(this.options.valueOf(this.includeOpt)) : Optional.ofNullable(this.options.valueOf(this.whitelistOpt));
    }

    Properties formatterArgs() throws IOException {
        String valueDeserializer;
        Properties formatterArgs = this.options.has(this.messageFormatterConfigOpt) ? Utils.loadProps((String)((String)this.options.valueOf(this.messageFormatterConfigOpt))) : new Properties();
        String keyDeserializer = (String)this.options.valueOf(this.keyDeserializerOpt);
        if (keyDeserializer != null && !keyDeserializer.isEmpty()) {
            formatterArgs.setProperty("key.deserializer", keyDeserializer);
        }
        if ((valueDeserializer = (String)this.options.valueOf(this.valueDeserializerOpt)) != null && !valueDeserializer.isEmpty()) {
            formatterArgs.setProperty("value.deserializer", valueDeserializer);
        }
        formatterArgs.putAll((Map<?, ?>)CommandLineUtils.parseKeyValueArgs((List)this.options.valuesOf(this.messageFormatterArgOpt)));
        return formatterArgs;
    }

    MessageFormatter formatter() {
        return this.formatter;
    }
}

