/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.errors;

import java.util.OptionalInt;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.errors.TimeoutException;

public class ControllerExceptions {
    public static boolean isTimeoutException(Throwable exception) {
        if (exception == null) {
            return false;
        }
        if (exception instanceof ExecutionException && (exception = exception.getCause()) == null) {
            return false;
        }
        return exception instanceof TimeoutException;
    }

    public static boolean isNotControllerException(Throwable exception) {
        if (exception == null) {
            return false;
        }
        if (exception instanceof ExecutionException && (exception = exception.getCause()) == null) {
            return false;
        }
        return exception instanceof NotControllerException;
    }

    public static NotControllerException newPreMigrationException(OptionalInt controllerId) {
        if (controllerId.isPresent()) {
            return new NotControllerException("The controller is in pre-migration mode.");
        }
        return new NotControllerException("No controller appears to be active.");
    }

    public static NotControllerException newWrongControllerException(OptionalInt controllerId) {
        if (controllerId.isPresent()) {
            return new NotControllerException("The active controller appears to be node " + controllerId.getAsInt() + ".");
        }
        return new NotControllerException("No controller appears to be active.");
    }
}

