/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.ThreadLocalRandom;
import kafka.server.CachedControllerId;
import kafka.server.KRaftCachedControllerId$;
import kafka.server.MetadataCache;
import kafka.server.metadata.ConfigRepository;
import kafka.utils.Logging;
import org.apache.kafka.admin.BrokerMetadata;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.DescribeClientQuotasRequestData;
import org.apache.kafka.common.message.DescribeClientQuotasResponseData;
import org.apache.kafka.common.message.DescribeTopicPartitionsResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.FinalizedFeatures;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0001\r\rg\u0001\u0002\u001a4\u0001iB\u0001b\u0014\u0001\u0003\u0006\u0004%\t\u0001\u0015\u0005\t)\u0002\u0011\t\u0011)A\u0005#\")Q\u000b\u0001C\u0001-\"9\u0011\f\u0001a\u0001\n\u0013Q\u0006b\u00024\u0001\u0001\u0004%Ia\u001a\u0005\u0007[\u0002\u0001\u000b\u0015B.\t\u000bI\u0004A\u0011B:\t\u000f\u0005=\u0002\u0001\"\u0001\u00022!9\u00111\u0007\u0001\u0005\n\u0005U\u0002bBAN\u0001\u0011%\u0011Q\u0014\u0005\b\u0003\u000f\u0004A\u0011BAe\u0011\u001d\ti\u000e\u0001C\u0005\u0003?Dq!a<\u0001\t\u0013\t\t\u0010C\u0004\u0002x\u0002!I!!?\t\u000f\t5\u0001\u0001\"\u0011\u0003\u0010!I!1\u0007\u0001\u0012\u0002\u0013\u0005!Q\u0007\u0005\n\u0005\u0017\u0002\u0011\u0013!C\u0001\u0005kAqA!\u0014\u0001\t\u0003\u0011y\u0005C\u0004\u0003r\u0001!\tEa\u001d\t\u000f\tU\u0004\u0001\"\u0011\u0003x!9!1\u0011\u0001\u0005B\t\u0015\u0005b\u0002BH\u0001\u0011\u0005#\u0011\u0013\u0005\b\u00053\u0003A\u0011\tBN\u0011\u001d\u0011y\n\u0001C\u0001\u0005CCqA!*\u0001\t\u0003\u00119\u000bC\u0004\u0003,\u0002!\tE!,\t\u000f\t-\u0006\u0001\"\u0003\u0003B\"9!Q\u0019\u0001\u0005B\t\u001d\u0007b\u0002Bg\u0001\u0011\u0005#q\u001a\u0005\b\u0005+\u0004A\u0011\tBl\u0011\u001d\u0011y\u000f\u0001C!\u0005cDqAa>\u0001\t\u0003\u0012I\u0010C\u0004\u0004\u0002\u0001!\tea\u0001\t\u000f\r\u001d\u0001\u0001\"\u0011\u0004\n!91Q\u0002\u0001\u0005B\r=\u0001bBB\f\u0001\u0011\u00053\u0011\u0004\u0005\b\u0007K\u0001A\u0011IB\u0014\u0011\u001d\u0019\t\u0004\u0001C!\u0007gAqa!\u000e\u0001\t\u0013\u00199\u0004C\u0004\u0004<\u0001!\ta!\u0010\t\u000f\r%\u0003\u0001\"\u0011\u0004L!91\u0011\f\u0001\u0005B\rm\u0003bBB-\u0001\u0011\u00053q\f\u0005\b\u0007G\u0002A\u0011AB3\u0011\u001d\u0019Y\u0007\u0001C!\u0007[Bqaa!\u0001\t\u0003\u0019)\tC\u0004\u0004\u0018\u0002!\ta!'\t\u000f\r%\u0006\u0001\"\u0011\u0004,\"91\u0011\u0018\u0001\u0005B\rm&AE&SC\u001a$X*\u001a;bI\u0006$\u0018mQ1dQ\u0016T!\u0001N\u001b\u0002\u00115,G/\u00193bi\u0006T!AN\u001c\u0002\rM,'O^3s\u0015\u0005A\u0014!B6bM.\f7\u0001A\n\u0006\u0001m\nUi\u0013\t\u0003y}j\u0011!\u0010\u0006\u0002}\u0005)1oY1mC&\u0011\u0001)\u0010\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\t\u001bU\"A\u001b\n\u0005\u0011+$!D'fi\u0006$\u0017\r^1DC\u000eDW\r\u0005\u0002G\u00136\tqI\u0003\u0002Io\u0005)Q\u000f^5mg&\u0011!j\u0012\u0002\b\u0019><w-\u001b8h!\taU*D\u00014\u0013\tq5G\u0001\tD_:4\u0017n\u001a*fa>\u001c\u0018\u000e^8ss\u0006A!M]8lKJLE-F\u0001R!\ta$+\u0003\u0002T{\t\u0019\u0011J\u001c;\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002X1B\u0011A\n\u0001\u0005\u0006\u001f\u000e\u0001\r!U\u0001\u000e?\u000e,(O]3oi&k\u0017mZ3\u0016\u0003m\u0003\"\u0001\u00183\u000e\u0003uS!AX0\u0002\u000b%l\u0017mZ3\u000b\u0005a\u0002'BA1c\u0003\u0019\t\u0007/Y2iK*\t1-A\u0002pe\u001eL!!Z/\u0003\u001b5+G/\u00193bi\u0006LU.Y4f\u0003Ey6-\u001e:sK:$\u0018*\\1hK~#S-\u001d\u000b\u0003Q.\u0004\"\u0001P5\n\u0005)l$\u0001B+oSRDq\u0001\\\u0003\u0002\u0002\u0003\u00071,A\u0002yIE\nabX2veJ,g\u000e^%nC\u001e,\u0007\u0005\u000b\u0002\u0007_B\u0011A\b]\u0005\u0003cv\u0012\u0001B^8mCRLG.Z\u0001\u0019[\u0006L(-\u001a$jYR,'/\u00117jm\u0016\u0014V\r\u001d7jG\u0006\u001cH#\u0003;\u0002\u0006\u0005\u001d\u0011\u0011CA\u0013!\r)(\u0010`\u0007\u0002m*\u0011q\u000f_\u0001\u0005kRLGNC\u0001z\u0003\u0011Q\u0017M^1\n\u0005m4(\u0001\u0002'jgR\u00042!`A\u0001\u001b\u0005q(BA@y\u0003\u0011a\u0017M\\4\n\u0007\u0005\raPA\u0004J]R,w-\u001a:\t\u000by;\u0001\u0019A.\t\u000f\u0005%q\u00011\u0001\u0002\f\u00059!M]8lKJ\u001c\b\u0003\u0002\u001f\u0002\u000eEK1!a\u0004>\u0005\u0015\t%O]1z\u0011\u001d\t\u0019b\u0002a\u0001\u0003+\tA\u0002\\5ti\u0016tWM\u001d(b[\u0016\u0004B!a\u0006\u0002\"5\u0011\u0011\u0011\u0004\u0006\u0005\u00037\ti\"A\u0004oKR<xN]6\u000b\u0007\u0005}q,\u0001\u0004d_6lwN\\\u0005\u0005\u0003G\tIB\u0001\u0007MSN$XM\\3s\u001d\u0006lW\rC\u0004\u0002(\u001d\u0001\r!!\u000b\u00025\u0019LG\u000e^3s+:\fg/Y5mC\ndW-\u00128ea>Lg\u000e^:\u0011\u0007q\nY#C\u0002\u0002.u\u0012qAQ8pY\u0016\fg.\u0001\u0007dkJ\u0014XM\u001c;J[\u0006<W\rF\u0001\\\u0003Q9W\r\u001e)beRLG/[8o\u001b\u0016$\u0018\rZ1uCRa\u0011qGA>\u0003{\n\t*a%\u0002\u0018B)A(!\u000f\u0002>%\u0019\u00111H\u001f\u0003\r=\u0003H/[8o!\u0019\ty$a\u0014\u0002V9!\u0011\u0011IA&\u001d\u0011\t\u0019%!\u0013\u000e\u0005\u0005\u0015#bAA$s\u00051AH]8pizJ\u0011AP\u0005\u0004\u0003\u001bj\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003#\n\u0019F\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\r\ti%\u0010\t\u0005\u0003/\n)H\u0004\u0003\u0002Z\u0005=d\u0002BA.\u0003WrA!!\u0018\u0002j9!\u0011qLA4\u001d\u0011\t\t'!\u001a\u000f\t\u0005\r\u00131M\u0005\u0002G&\u0011\u0011MY\u0005\u0003q\u0001L1!a\b`\u0013\u0011\ti'!\b\u0002\u000f5,7o]1hK&!\u0011\u0011OA:\u0003QiU\r^1eCR\f'+Z:q_:\u001cX\rR1uC*!\u0011QNA\u000f\u0013\u0011\t9(!\u001f\u000335+G/\u00193bi\u0006\u0014Vm\u001d9p]N,\u0007+\u0019:uSRLwN\u001c\u0006\u0005\u0003c\n\u0019\bC\u0003_\u0013\u0001\u00071\fC\u0004\u0002\u0000%\u0001\r!!!\u0002\u0013Q|\u0007/[2OC6,\u0007\u0003BAB\u0003\u0017sA!!\"\u0002\bB\u0019\u00111I\u001f\n\u0007\u0005%U(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001b\u000byI\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0013k\u0004bBA\n\u0013\u0001\u0007\u0011Q\u0003\u0005\b\u0003+K\u0001\u0019AA\u0015\u0003e)'O]8s+:\fg/Y5mC\ndW-\u00128ea>Lg\u000e^:\t\u000f\u0005e\u0015\u00021\u0001\u0002*\u0005IRM\u001d:peVs\u0017M^1jY\u0006\u0014G.\u001a'jgR,g.\u001a:t\u00031:W\r\u001e)beRLG/[8o\u001b\u0016$\u0018\rZ1uC\u001a{'\u000fR3tGJL'-\u001a+pa&\u001c'+Z:q_:\u001cX\r\u0006\u0007\u0002 \u0006e\u00161XA_\u0003\u007f\u000b\u0019\r\u0005\u0004=\u0003C\u000b)+U\u0005\u0004\u0003Gk$A\u0002+va2,'\u0007E\u0003=\u0003s\t9\u000b\u0005\u0004\u0002@\u0005%\u00161V\u0005\u0004w\u0006M\u0003\u0003BAW\u0003gsA!!\u0017\u00020&!\u0011\u0011WA:\u0003\r\"Um]2sS\n,Gk\u001c9jGB\u000b'\u000f^5uS>t7OU3ta>t7/\u001a#bi\u0006LA!!.\u00028\nAC)Z:de&\u0014W\rV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d*fgB|gn]3QCJ$\u0018\u000e^5p]*!\u0011\u0011WA:\u0011\u0015q&\u00021\u0001\\\u0011\u001d\tyH\u0003a\u0001\u0003\u0003Cq!a\u0005\u000b\u0001\u0004\t)\u0002\u0003\u0004\u0002B*\u0001\r!U\u0001\u000bgR\f'\u000f^%oI\u0016D\bBBAc\u0015\u0001\u0007\u0011+\u0001\u0005nCb\u001cu.\u001e8u\u0003I9W\r^(gM2Lg.\u001a*fa2L7-Y:\u0015\u000fQ\fY-!4\u0002\\\")al\u0003a\u00017\"9\u0011qZ\u0006A\u0002\u0005E\u0017!\u00039beRLG/[8o!\u0011\t\u0019.a6\u000e\u0005\u0005U'B\u0001\u001b`\u0013\u0011\tI.!6\u0003+A\u000b'\u000f^5uS>t'+Z4jgR\u0014\u0018\r^5p]\"9\u00111C\u0006A\u0002\u0005U\u0011\u0001E5t%\u0016\u0004H.[2b\u001f\u001a4G.\u001b8f)!\tI#!9\u0002d\u0006\u0015\bbBAh\u0019\u0001\u0007\u0011\u0011\u001b\u0005\b\u0003'a\u0001\u0019AA\u000b\u0011\u001d\t9\u000f\u0004a\u0001\u0003S\faA\u0019:pW\u0016\u0014\b\u0003BAj\u0003WLA!!<\u0002V\n\u0011\"I]8lKJ\u0014VmZ5tiJ\fG/[8o\u0003UI7OU3qY&\u001c\u0017-\u00138PM\u001ad\u0017N\\3ESJ$b!!\u000b\u0002t\u0006U\bbBAt\u001b\u0001\u0007\u0011\u0011\u001e\u0005\b\u0003\u001fl\u0001\u0019AAi\u0003A9W\r^!mSZ,WI\u001c3q_&tG\u000f\u0006\u0005\u0002|\n\u0015!q\u0001B\u0006!\u0015a\u0014\u0011HA\u007f!\u0011\tyP!\u0001\u000e\u0005\u0005u\u0011\u0002\u0002B\u0002\u0003;\u0011AAT8eK\")aL\u0004a\u00017\"1!\u0011\u0002\bA\u0002E\u000b!!\u001b3\t\u000f\u0005Ma\u00021\u0001\u0002\u0016\u0005\u0001r-\u001a;U_BL7-T3uC\u0012\fG/\u0019\u000b\u000b\u0005#\u0011\u0019C!\f\u00030\tE\u0002C\u0002B\n\u00053\u0011i\"\u0004\u0002\u0003\u0016)\u0019!qC\u001f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u001c\tU!aA*fcB!\u0011q\u000bB\u0010\u0013\u0011\u0011\t#!\u001f\u0003+5+G/\u00193bi\u0006\u0014Vm\u001d9p]N,Gk\u001c9jG\"9!QE\bA\u0002\t\u001d\u0012A\u0002;pa&\u001c7\u000f\u0005\u0004\u0003\u0014\t%\u0012\u0011Q\u0005\u0005\u0005W\u0011)BA\u0002TKRDq!a\u0005\u0010\u0001\u0004\t)\u0002C\u0005\u0002\u0016>\u0001\n\u00111\u0001\u0002*!I\u0011\u0011T\b\u0011\u0002\u0003\u0007\u0011\u0011F\u0001\u001bO\u0016$Hk\u001c9jG6+G/\u00193bi\u0006$C-\u001a4bk2$HeM\u000b\u0003\u0005oQC!!\u000b\u0003:-\u0012!1\b\t\u0005\u0005{\u00119%\u0004\u0002\u0003@)!!\u0011\tB\"\u0003%)hn\u00195fG.,GMC\u0002\u0003Fu\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011IEa\u0010\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u000ehKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uC\u0012\"WMZ1vYR$C'\u0001\u0015hKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uC\u001a{'\u000fR3tGJL'-\u001a+pa&\u001c'+Z:q_:\u001cX\r\u0006\u0007\u0003R\te#Q\fB0\u0005S\u0012i\u0007\u0005\u0003\u0003T\tUSBAA:\u0013\u0011\u00119&a\u001d\u0003G\u0011+7o\u0019:jE\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c(+Z:q_:\u001cX\rR1uC\"9!Q\u0005\nA\u0002\tm\u0003CBA \u0003\u001f\n\t\tC\u0004\u0002\u0014I\u0001\r!!\u0006\t\u000f\t\u0005$\u00031\u0001\u0003d\u0005ABo\u001c9jGB\u000b'\u000f^5uS>t7\u000b^1si&sG-\u001a=\u0011\rq\u0012)'!!R\u0013\r\u00119'\u0010\u0002\n\rVt7\r^5p]FBaAa\u001b\u0013\u0001\u0004\t\u0016!G7bq&lW/\u001c(v[\n,'o\u00144QCJ$\u0018\u000e^5p]NDqAa\u001c\u0013\u0001\u0004\tI#\u0001\u000ejO:|'/\u001a+pa&\u001c7oV5uQ\u0016C8-\u001a9uS>t7/\u0001\u0007hKR\fE\u000e\u001c+pa&\u001c7\u000f\u0006\u0002\u0003(\u0005\u0011r-\u001a;U_BL7\rU1si&$\u0018n\u001c8t)\u0011\u0011IH!!\u0011\r\tM!\u0011\u0006B>!\u0011\tyP! \n\t\t}\u0014Q\u0004\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\ty\b\u0006a\u0001\u0003\u0003\u000b!bZ3u)>\u0004\u0018nY%e)\u0011\u00119I!$\u0011\t\u0005}(\u0011R\u0005\u0005\u0005\u0017\u000biB\u0001\u0003Vk&$\u0007bBA@+\u0001\u0007\u0011\u0011Q\u0001\rO\u0016$Hk\u001c9jG:\u000bW.\u001a\u000b\u0005\u0005'\u0013)\nE\u0003=\u0003s\t\t\tC\u0004\u0003\u0018Z\u0001\rAa\"\u0002\u000fQ|\u0007/[2JI\u0006q\u0001.Y:BY&4XM\u0011:pW\u0016\u0014H\u0003BA\u0015\u0005;CQaT\fA\u0002E\u000ba\"[:Ce>\\WM\u001d$f]\u000e,G\r\u0006\u0003\u0002*\t\r\u0006\"B(\u0019\u0001\u0004\t\u0016\u0001F5t\u0005J|7.\u001a:TQV$H/\u001b8h\t><h\u000e\u0006\u0003\u0002*\t%\u0006\"B(\u001a\u0001\u0004\t\u0016aD4fi\u0006c\u0017N^3Ce>\\WM]:\u0015\u0005\t=\u0006CBA \u0005c\u0013),\u0003\u0003\u00034\u0006M#\u0001C%uKJ\f'\r\\3\u0011\t\t]&QX\u0007\u0003\u0005sS1Aa/`\u0003\u0015\tG-\\5o\u0013\u0011\u0011yL!/\u0003\u001d\t\u0013xn[3s\u001b\u0016$\u0018\rZ1uCR!!q\u0016Bb\u0011\u0015q6\u00041\u0001\\\u0003I9W\r^!mSZ,'I]8lKJtu\u000eZ3\u0015\r\u0005m(\u0011\u001aBf\u0011\u0015yE\u00041\u0001R\u0011\u001d\t\u0019\u0002\ba\u0001\u0003+\t1cZ3u\u00032Lg/\u001a\"s_.,'OT8eKN$BA!5\u0003TB1!1\u0003B\r\u0003{Dq!a\u0005\u001e\u0001\u0004\t)\"\u0001\thKR\u0004\u0016M\u001d;ji&|g.\u00138g_R1!\u0011\u001cBu\u0005W\u0004R\u0001PA\u001d\u00057\u0004BA!8\u0003d:!\u0011\u0011\fBp\u0013\u0011\u0011\t/a\u001d\u00023U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti\u0012\u000bG/Y\u0005\u0005\u0005K\u00149O\u0001\u000fVa\u0012\fG/Z'fi\u0006$\u0017\r^1QCJ$\u0018\u000e^5p]N#\u0018\r^3\u000b\t\t\u0005\u00181\u000f\u0005\b\u0003\u007fr\u0002\u0019AAA\u0011\u0019\u0011iO\ba\u0001#\u0006Y\u0001/\u0019:uSRLwN\\%e\u00035qW/\u001c)beRLG/[8ogR!!1\u001fB{!\u0011a\u0014\u0011H)\t\u000f\u0005}t\u00041\u0001\u0002\u0002\u0006yAo\u001c9jG:\u000bW.Z:U_&#7\u000f\u0006\u0002\u0003|B9QO!@\u0002\u0002\n\u001d\u0015b\u0001B\u0000m\n\u0019Q*\u00199\u0002\u001fQ|\u0007/[2JIN$vNT1nKN$\"a!\u0002\u0011\u000fU\u0014iPa\"\u0002\u0002\u0006YAo\u001c9jG&#\u0017J\u001c4p)\t\u0019Y\u0001E\u0004=\u0003C\u0013Yp!\u0002\u00025\u001d,G\u000fU1si&$\u0018n\u001c8MK\u0006$WM]#oIB|\u0017N\u001c;\u0015\u0011\u0005m8\u0011CB\n\u0007+Aq!a $\u0001\u0004\t\t\t\u0003\u0004\u0003n\u000e\u0002\r!\u0015\u0005\b\u0003'\u0019\u0003\u0019AA\u000b\u0003q9W\r\u001e)beRLG/[8o%\u0016\u0004H.[2b\u000b:$\u0007o\\5oiN$baa\u0007\u0004 \r\r\u0002c\u0002B\n\u0007;\t\u0016Q`\u0005\u0005\u0005\u007f\u0014)\u0002C\u0004\u0004\"\u0011\u0002\rAa\u001f\u0002\u0005Q\u0004\bbBA\nI\u0001\u0007\u0011QC\u0001\u0010O\u0016$8i\u001c8ue>dG.\u001a:JIV\u00111\u0011\u0006\t\u0006y\u0005e21\u0006\t\u0004\u0005\u000e5\u0012bAB\u0018k\t\u00112)Y2iK\u0012\u001cuN\u001c;s_2dWM]%e\u0003Y9W\r\u001e*b]\u0012|W.\u00117jm\u0016\u0014%o\\6fe&#WC\u0001Bz\u0003Q9W\r\u001e*b]\u0012|W.\u00117jm\u0016\u0014%o\\6feR!!1_B\u001d\u0011\u0015qv\u00051\u0001\\\u0003M9W\r^!mSZ,'I]8lKJ,\u0005o\\2i)\u0011\u0019yda\u0012\u0011\u000bq\nId!\u0011\u0011\u0007q\u001a\u0019%C\u0002\u0004Fu\u0012A\u0001T8oO\")q\n\u000ba\u0001#\u0006\u0011r-\u001a;DYV\u001cH/\u001a:NKR\fG-\u0019;b)\u0019\u0019iea\u0015\u0004XA!\u0011q`B(\u0013\u0011\u0019\t&!\b\u0003\u000f\rcWo\u001d;fe\"91QK\u0015A\u0002\u0005\u0005\u0015!C2mkN$XM]%e\u0011\u001d\t\u0019\"\u000ba\u0001\u0003+\t\u0001bY8oi\u0006Lgn\u001d\u000b\u0005\u0003S\u0019i\u0006C\u0004\u0002\u0000)\u0002\r!!!\u0015\t\u0005%2\u0011\r\u0005\b\u0007CY\u0003\u0019\u0001B>\u0003!\u0019X\r^%nC\u001e,Gc\u00015\u0004h!11\u0011\u000e\u0017A\u0002m\u000b\u0001B\\3x\u00136\fw-Z\u0001\u0007G>tg-[4\u0015\t\r=4Q\u000f\t\u0004k\u000eE\u0014bAB:m\nQ\u0001K]8qKJ$\u0018.Z:\t\u000f\r]T\u00061\u0001\u0004z\u0005q1m\u001c8gS\u001e\u0014Vm]8ve\u000e,\u0007\u0003BB>\u0007\u007fj!a! \u000b\t\r-\u0014QD\u0005\u0005\u0007\u0003\u001biH\u0001\bD_:4\u0017n\u001a*fg>,(oY3\u0002)\u0011,7o\u0019:jE\u0016\u001cE.[3oiF+x\u000e^1t)\u0011\u00199i!$\u0011\t\tM3\u0011R\u0005\u0005\u0007\u0017\u000b\u0019H\u0001\u0011EKN\u001c'/\u001b2f\u00072LWM\u001c;Rk>$\u0018m\u001d*fgB|gn]3ECR\f\u0007bBBH]\u0001\u00071\u0011S\u0001\be\u0016\fX/Z:u!\u0011\u0011\u0019fa%\n\t\rU\u00151\u000f\u0002 \t\u0016\u001c8M]5cK\u000ec\u0017.\u001a8u#V|G/Y:SKF,Xm\u001d;ECR\f\u0017\u0001\u00073fg\u000e\u0014\u0018NY3TGJ\fWn\u0011:fI\u0016tG/[1mgR!11TBQ!\u0011\u0011\u0019f!(\n\t\r}\u00151\u000f\u0002)\t\u0016\u001c8M]5cKV\u001bXM]*de\u0006l7I]3eK:$\u0018.\u00197t%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0005\b\u0007\u001f{\u0003\u0019ABR!\u0011\u0011\u0019f!*\n\t\r\u001d\u00161\u000f\u0002(\t\u0016\u001c8M]5cKV\u001bXM]*de\u0006l7I]3eK:$\u0018.\u00197t%\u0016\fX/Z:u\t\u0006$\u0018-A\bnKR\fG-\u0019;b-\u0016\u00148/[8o)\t\u0019i\u000b\u0005\u0003\u00040\u000eUVBABY\u0015\u0011\tyba-\u000b\u0005Yz\u0016\u0002BB\\\u0007c\u0013q\"T3uC\u0012\fG/\u0019,feNLwN\\\u0001\tM\u0016\fG/\u001e:fgR\u00111Q\u0018\t\u0005\u0007_\u001by,\u0003\u0003\u0004B\u000eE&!\u0005$j]\u0006d\u0017N_3e\r\u0016\fG/\u001e:fg\u0002")
public class KRaftMetadataCache
implements MetadataCache,
Logging,
ConfigRepository {
    private final int brokerId;
    private volatile MetadataImage _currentImage;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public Properties topicConfig(String topicName) {
        return ConfigRepository.topicConfig$(this, topicName);
    }

    @Override
    public Properties brokerConfig(int brokerId) {
        return ConfigRepository.brokerConfig$(this, brokerId);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    private MetadataImage _currentImage() {
        return this._currentImage;
    }

    private void _currentImage_$eq(MetadataImage x$1) {
        this._currentImage = x$1;
    }

    private java.util.List<Integer> maybeFilterAliveReplicas(MetadataImage image, int[] brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        if (!filterUnavailableEndpoints) {
            return Replicas.toList((int[])brokers);
        }
        ArrayList<Integer> res = new ArrayList<Integer>(brokers.length);
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(brokers)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Option$.MODULE$.apply((Object)image.cluster().broker(brokerId)).foreach((Function1 & Serializable & scala.Serializable)b -> {
            if (!b.fenced() && b.listeners().containsKey(listenerName.value())) {
                return BoxesRunTime.boxToBoolean((boolean)res.add(Predef$.MODULE$.int2Integer(brokerId)));
            }
            return BoxedUnit.UNIT;
        }));
        return res;
    }

    public MetadataImage currentImage() {
        return this._currentImage();
    }

    private Option<Iterator<MetadataResponseData.MetadataResponsePartition>> getPartitionMetadata(MetadataImage image, String topicName, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            return new Some((Object)((GenSetLike)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(topic.partitions().entrySet()).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> {
                Integer partitionId = (Integer)entry.getKey();
                PartitionRegistration partition = (PartitionRegistration)entry.getValue();
                java.util.List<Integer> filteredReplicas = this.maybeFilterAliveReplicas(image, partition.replicas, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> filteredIsr = this.maybeFilterAliveReplicas(image, partition.isr, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> offlineReplicas = this.getOfflineReplicas(image, partition, listenerName);
                Option<Node> maybeLeader = this.getAliveEndpoint(image, partition.leader, listenerName);
                if (None$.MODULE$.equals(maybeLeader)) {
                    Errors errors;
                    if (!image.cluster().brokers().containsKey(BoxesRunTime.boxToInteger((int)partition.leader))) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": leader not available").toString());
                        errors = Errors.LEADER_NOT_AVAILABLE;
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": listener ").append(listenerName).append(" ").append("not found on leader ").append(partition$1.leader).toString());
                        errors = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(-1).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                if (maybeLeader instanceof Some) {
                    Errors errors;
                    Node leader = (Node)((Some)maybeLeader).value();
                    if (filteredReplicas.size() < partition.replicas.length) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(93).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": replica information not available for ").append("following brokers ").append(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partition$1.replicas)).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredReplicas.contains(x$1))))).mkString(",")).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else if (filteredIsr.size() < partition.isr.length) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": in sync replica information not available for ").append("following brokers ").append(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partition$1.isr)).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredIsr.contains(x$1))))).mkString(",")).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else {
                        errors = Errors.NONE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(leader.id()).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                throw new MatchError(maybeLeader);
            }, scala.collection.mutable.Set$.MODULE$.canBuildFrom())).iterator());
        }
        throw new MatchError((Object)option);
    }

    private Tuple2<Option<List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition>>, Object> getPartitionMetadataForDescribeTopicResponse(MetadataImage image, String topicName, ListenerName listenerName, int startIndex, int maxCount) {
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return new Tuple2((Object)None$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)-1));
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            ListBuffer result = new ListBuffer();
            java.util.Set partitions = topic.partitions().keySet();
            int upperIndex = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(topic.partitions().size()), startIndex + maxCount);
            int nextIndex = upperIndex < partitions.size() ? upperIndex : -1;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(startIndex), upperIndex).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> {
                PartitionRegistration partitionRegistration = (PartitionRegistration)topic.partitions().get(BoxesRunTime.boxToInteger((int)partitionId));
                if (partitionRegistration != null) {
                    java.util.List<Integer> filteredReplicas = this.maybeFilterAliveReplicas(image, partitionRegistration.replicas, listenerName, false);
                    java.util.List<Integer> filteredIsr = this.maybeFilterAliveReplicas(image, partitionRegistration.isr, listenerName, false);
                    java.util.List<Integer> offlineReplicas = this.getOfflineReplicas(image, partitionRegistration, listenerName);
                    Option<Node> maybeLeader = this.getAliveEndpoint(image, partitionRegistration.leader, listenerName);
                    if (None$.MODULE$.equals(maybeLeader)) {
                        result.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition[]{new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition().setPartitionIndex(partitionId).setLeaderId(-1).setLeaderEpoch(partitionRegistration.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas).setEligibleLeaderReplicas(Replicas.toList((int[])partitionRegistration.elr)).setLastKnownElr(Replicas.toList((int[])partitionRegistration.lastKnownElr))}));
                        return;
                    }
                    if (maybeLeader instanceof Some) {
                        Node leader = (Node)((Some)maybeLeader).value();
                        result.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition[]{new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition().setPartitionIndex(partitionId).setLeaderId(leader.id()).setLeaderEpoch(partitionRegistration.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas).setEligibleLeaderReplicas(Replicas.toList((int[])partitionRegistration.elr)).setLastKnownElr(Replicas.toList((int[])partitionRegistration.lastKnownElr))}));
                        return;
                    }
                    throw new MatchError(maybeLeader);
                }
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("The partition ").append(partitionId).append(" does not exist for ").append(topicName).toString());
            });
            return new Tuple2((Object)new Some((Object)result.toList()), (Object)BoxesRunTime.boxToInteger((int)nextIndex));
        }
        throw new MatchError((Object)option);
    }

    private java.util.List<Integer> getOfflineReplicas(MetadataImage image, PartitionRegistration partition, ListenerName listenerName) {
        ArrayList<Integer> offlineReplicas = new ArrayList<Integer>(0);
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partition.replicas)).foreach((Function1 & Serializable & scala.Serializable)brokerId -> KRaftMetadataCache.$anonfun$getOfflineReplicas$1(this, image, offlineReplicas, partition, listenerName, BoxesRunTime.unboxToInt((Object)brokerId)));
        return offlineReplicas;
    }

    private boolean isReplicaOffline(PartitionRegistration partition, ListenerName listenerName, BrokerRegistration broker) {
        return broker.fenced() || !broker.listeners().containsKey(listenerName.value()) || this.isReplicaInOfflineDir(broker, partition);
    }

    private boolean isReplicaInOfflineDir(BrokerRegistration broker, PartitionRegistration partition) {
        return !broker.hasOnlineDir(partition.directory(broker.id()));
    }

    private Option<Node> getAliveEndpoint(MetadataImage image, int id, ListenerName listenerName) {
        return Option$.MODULE$.apply((Object)image.cluster().broker(id)).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$1.node(listenerName.value()))));
    }

    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataImage image = this._currentImage();
        return (Seq)topics.toSeq().flatMap((Function1 & Serializable & scala.Serializable)topic -> Option$.MODULE$.option2Iterable(this.getPartitionMetadata(image, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1 & Serializable & scala.Serializable)partitionMetadata -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName(topic).setTopicId((Uuid)Option$.MODULE$.apply((Object)image.topics().getTopic(topic).id()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topic)).setPartitions((java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(partitionMetadata.toBuffer()).asJava()))), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public boolean getTopicMetadata$default$3() {
        return false;
    }

    @Override
    public boolean getTopicMetadata$default$4() {
        return false;
    }

    public DescribeTopicPartitionsResponseData getTopicMetadataForDescribeTopicResponse(Iterator<String> topics, ListenerName listenerName, Function1<String, Object> topicPartitionStartIndex, int maximumNumberOfPartitions, boolean ignoreTopicsWithExceptions) {
        MetadataImage image = this._currentImage();
        IntRef remaining = IntRef.create((int)maximumNumberOfPartitions);
        DescribeTopicPartitionsResponseData result = new DescribeTopicPartitionsResponseData();
        Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> topics.foreach((Function1 & Serializable & scala.Serializable)topicName -> {
            if (remaining$1.elem > 0) {
                void var9_9;
                Tuple2<Option<List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition>>, Object> tuple2 = this.getPartitionMetadataForDescribeTopicResponse(image, (String)topicName, listenerName, BoxesRunTime.unboxToInt((Object)topicPartitionStartIndex.apply(topicName)), remaining$1.elem);
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                Option partitionResponse = (Option)tuple2._1();
                int n = tuple2._2$mcI$sp();
                var9_9.map((Function1 & Serializable & scala.Serializable)partitions -> {
                    KRaftMetadataCache.$anonfun$getTopicMetadataForDescribeTopicResponse$3(topicName, image, result, n, remaining, partitions);
                    return BoxedUnit.UNIT;
                });
                if (!ignoreTopicsWithExceptions && var9_9.isEmpty()) {
                    Errors errors;
                    try {
                        Topic.validate((String)topicName);
                        errors = Errors.UNKNOWN_TOPIC_OR_PARTITION;
                    }
                    catch (InvalidTopicException invalidTopicException) {
                        errors = Errors.INVALID_TOPIC_EXCEPTION;
                    }
                    Errors error = errors;
                    return BoxesRunTime.boxToBoolean((boolean)result.topics().add((ImplicitLinkedHashCollection.Element)new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic().setErrorCode(error.code()).setName(topicName).setTopicId(this.getTopicId((String)topicName)).setIsInternal(Topic.isInternal((String)topicName))));
                }
                return BoxedUnit.UNIT;
            }
            if (remaining$1.elem == 0) {
                result.setNextCursor(new DescribeTopicPartitionsResponseData.Cursor().setTopicName(topicName).setPartitionIndex(0));
                throw Breaks$.MODULE$.break();
            }
            return BoxedUnit.UNIT;
        }));
        return result;
    }

    @Override
    public Set<String> getAllTopics() {
        return (Set)CollectionConverters$.MODULE$.asScalaSetConverter(this._currentImage().topics().topicsByName().keySet()).asScala();
    }

    @Override
    public Set<TopicPartition> getTopicPartitions(String topicName) {
        Option option = Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return Set$.MODULE$.empty();
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            return (Set)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(topic.partitions().keySet()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> new TopicPartition(topicName, Predef$.MODULE$.Integer2int(x$3)), scala.collection.mutable.Set$.MODULE$.canBuildFrom());
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Uuid getTopicId(String topicName) {
        return (Uuid)((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this._currentImage().topics().topicsByName()).asScala()).get((Object)topicName).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.id()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID);
    }

    @Override
    public Option<String> getTopicName(Uuid topicId) {
        return ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this._currentImage().topics().topicsById()).asScala()).get((Object)topicId).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.name());
    }

    @Override
    public boolean hasAliveBroker(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$hasAliveBroker$1(x$6))) == 1;
    }

    public boolean isBrokerFenced(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.fenced())) == 1;
    }

    public boolean isBrokerShuttingDown(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.inControlledShutdown())) == 1;
    }

    @Override
    public Iterable<BrokerMetadata> getAliveBrokers() {
        return this.getAliveBrokers(this._currentImage());
    }

    private Iterable<BrokerMetadata> getAliveBrokers(MetadataImage image) {
        return (Iterable)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(image.cluster().brokers().values()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.fenced()))).map((Function1 & Serializable & scala.Serializable)b -> new BrokerMetadata(b.id(), b.rack()), Iterable$.MODULE$.canBuildFrom());
    }

    @Override
    public Option<Node> getAliveBrokerNode(int brokerId, ListenerName listenerName) {
        return Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId)).filterNot((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.fenced())).flatMap((Function1 & Serializable & scala.Serializable)x$11 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$11.node(listenerName.value()))));
    }

    public Seq<Node> getAliveBrokerNodes(ListenerName listenerName) {
        return ((TraversableOnce)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this._currentImage().cluster().brokers().values()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.fenced()))).flatMap((Function1 & Serializable & scala.Serializable)x$13 -> Option$.MODULE$.option2Iterable(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$13.node(listenerName.value())))), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    @Override
    public Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfo(String topicName, int partitionId) {
        return Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName)).flatMap((Function1 & Serializable & scala.Serializable)topic -> Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger((int)partitionId)))).flatMap((Function1 & Serializable & scala.Serializable)partition -> new Some((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topicName).setPartitionIndex(partitionId).setControllerEpoch(-1).setLeader(partition.leader).setLeaderEpoch(partition.leaderEpoch).setIsr(Replicas.toList((int[])partition.isr)).setZkVersion(partition.partitionEpoch).setReplicas(Replicas.toList((int[])partition.replicas))));
    }

    @Override
    public Option<Object> numPartitions(String topicName) {
        return Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName)).map((Function1 & Serializable & scala.Serializable)topic -> BoxesRunTime.boxToInteger((int)KRaftMetadataCache.$anonfun$numPartitions$1(topic)));
    }

    @Override
    public java.util.Map<String, Uuid> topicNamesToIds() {
        return this._currentImage().topics().topicNameToIdView();
    }

    @Override
    public java.util.Map<Uuid, String> topicIdsToNames() {
        return this._currentImage().topics().topicIdToNameView();
    }

    @Override
    public Tuple2<java.util.Map<String, Uuid>, java.util.Map<Uuid, String>> topicIdInfo() {
        MetadataImage image = this._currentImage();
        return new Tuple2((Object)image.topics().topicNameToIdView(), (Object)image.topics().topicIdToNameView());
    }

    @Override
    public Option<Node> getPartitionLeaderEndpoint(String topicName, int partitionId, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            Option option2 = Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger((int)partitionId)));
            if (None$.MODULE$.equals(option2)) {
                return None$.MODULE$;
            }
            if (option2 instanceof Some) {
                PartitionRegistration partition = (PartitionRegistration)((Some)option2).value();
                Option option3 = Option$.MODULE$.apply((Object)image.cluster().broker(partition.leader));
                if (None$.MODULE$.equals(option3)) {
                    return new Some((Object)Node.noNode());
                }
                if (option3 instanceof Some) {
                    BrokerRegistration broker = (BrokerRegistration)((Some)option3).value();
                    return new Some((Object)broker.node(listenerName.value()).orElse(Node.noNode()));
                }
                throw new MatchError((Object)option3);
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Map<Object, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        scala.collection.mutable.HashMap result = new scala.collection.mutable.HashMap();
        Option$.MODULE$.apply((Object)image.topics().getTopic(tp.topic())).foreach((Function1 & Serializable & scala.Serializable)topic -> {
            KRaftMetadataCache.$anonfun$getPartitionReplicaEndpoints$1(image, listenerName, result, topic);
            return BoxedUnit.UNIT;
        });
        return result;
    }

    @Override
    public Option<CachedControllerId> getControllerId() {
        return this.getRandomAliveBroker(this._currentImage()).map((Function1)KRaftCachedControllerId$.MODULE$);
    }

    @Override
    public Option<Object> getRandomAliveBrokerId() {
        return this.getRandomAliveBroker(this._currentImage());
    }

    private Option<Object> getRandomAliveBroker(MetadataImage image) {
        List aliveBrokers = this.getAliveBrokers(image).toList();
        if (aliveBrokers.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)((BrokerMetadata)aliveBrokers.apply((int)ThreadLocalRandom.current().nextInt((int)aliveBrokers.size()))).id));
    }

    public Option<Object> getAliveBrokerEpoch(int brokerId) {
        return Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId)).filterNot((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.fenced())).map((Function1 & Serializable & scala.Serializable)brokerRegistration -> BoxesRunTime.boxToLong((long)brokerRegistration.epoch()));
    }

    @Override
    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        HashMap nodes = new HashMap();
        image.cluster().brokers().values().forEach(broker -> {
            if (!broker.fenced()) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(broker.node(listenerName.value()))).foreach((Function1 & Serializable & scala.Serializable)node -> nodes.put(Predef$.MODULE$.int2Integer(broker.id()), node));
                return;
            }
        });
        ArrayList partitionInfos = new ArrayList();
        HashSet internalTopics = new HashSet();
        image.topics().topicsByName().values().forEach(topic -> topic.partitions().forEach((key, value) -> {
            partitionInfos.add(new PartitionInfo(topic.name(), Predef$.MODULE$.Integer2int(key), KRaftMetadataCache.node$1(value.leader, nodes), (Node[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(value.replicas)).map((Function1 & Serializable & scala.Serializable)replica -> KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)replica), nodes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Node.class))), (Node[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(value.isr)).map((Function1 & Serializable & scala.Serializable)replica -> KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)replica), nodes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Node.class))), (Node[])((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(this.getOfflineReplicas(image, (PartitionRegistration)value, listenerName)).asScala()).map((Function1 & Serializable & scala.Serializable)replica -> KRaftMetadataCache.node$1(Predef$.MODULE$.Integer2int(replica), nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class))));
            if (Topic.isInternal((String)topic.name())) {
                internalTopics.add(topic.name());
                return;
            }
        }));
        Node controllerNode = KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)this.getRandomAliveBroker(image).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1)), nodes);
        return new Cluster(clusterId, nodes.values(), partitionInfos, Collections.emptySet(), internalTopics, controllerNode);
    }

    @Override
    public boolean contains(String topicName) {
        return this._currentImage().topics().topicsByName().containsKey((Object)topicName);
    }

    @Override
    public boolean contains(TopicPartition tp) {
        Option option = Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(tp.topic()));
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            return ((TopicImage)((Some)option).value()).partitions().containsKey(BoxesRunTime.boxToInteger((int)tp.partition()));
        }
        throw new MatchError((Object)option);
    }

    public void setImage(MetadataImage newImage) {
        this._currentImage_$eq(newImage);
    }

    @Override
    public Properties config(ConfigResource configResource) {
        return this._currentImage().configs().configProperties(configResource);
    }

    public DescribeClientQuotasResponseData describeClientQuotas(DescribeClientQuotasRequestData request) {
        return this._currentImage().clientQuotas().describe(request);
    }

    public DescribeUserScramCredentialsResponseData describeScramCredentials(DescribeUserScramCredentialsRequestData request) {
        return this._currentImage().scram().describe(request);
    }

    @Override
    public MetadataVersion metadataVersion() {
        return this._currentImage().features().metadataVersion();
    }

    @Override
    public FinalizedFeatures features() {
        MetadataImage image = this._currentImage();
        return new FinalizedFeatures(image.features().metadataVersion(), image.features().finalizedVersions(), image.highestOffsetAndEpoch().offset(), true);
    }

    public static final /* synthetic */ Object $anonfun$getOfflineReplicas$1(KRaftMetadataCache $this, MetadataImage image$4, ArrayList offlineReplicas$1, PartitionRegistration partition$2, ListenerName listenerName$4, int brokerId) {
        Option option = Option$.MODULE$.apply((Object)image$4.cluster().broker(brokerId));
        if (None$.MODULE$.equals(option)) {
            return BoxesRunTime.boxToBoolean((boolean)offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
        }
        if (option instanceof Some) {
            BrokerRegistration broker = (BrokerRegistration)((Some)option).value();
            if ($this.isReplicaOffline(partition$2, listenerName$4, broker)) {
                return BoxesRunTime.boxToBoolean((boolean)offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
            }
            return BoxedUnit.UNIT;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ void $anonfun$getTopicMetadataForDescribeTopicResponse$3(String topicName$3, MetadataImage image$6, DescribeTopicPartitionsResponseData result$2, int nextPartition$1, IntRef remaining$1, List partitions) {
        DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic response = new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic().setErrorCode(Errors.NONE.code()).setName(topicName$3).setTopicId((Uuid)Option$.MODULE$.apply((Object)image$6.topics().getTopic(topicName$3).id()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topicName$3)).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)partitions).asJava());
        result$2.topics().add((ImplicitLinkedHashCollection.Element)response);
        if (nextPartition$1 != -1) {
            result$2.setNextCursor(new DescribeTopicPartitionsResponseData.Cursor().setTopicName(topicName$3).setPartitionIndex(nextPartition$1));
            throw Breaks$.MODULE$.break();
        }
        remaining$1.elem -= partitions.size();
    }

    public static final /* synthetic */ boolean $anonfun$hasAliveBroker$1(BrokerRegistration x$6) {
        return !x$6.fenced();
    }

    public static final /* synthetic */ int $anonfun$numPartitions$1(TopicImage topic) {
        return topic.partitions().size();
    }

    public static final /* synthetic */ void $anonfun$getPartitionReplicaEndpoints$1(MetadataImage image$7, ListenerName listenerName$10, scala.collection.mutable.HashMap result$3, TopicImage topic) {
        topic.partitions().values().forEach(partition -> new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partition.replicas)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)replicaId -> {
            BrokerRegistration broker = image$7.cluster().broker(replicaId);
            if (broker != null && !broker.fenced()) {
                broker.node(listenerName$10.value()).ifPresent(node -> {
                    if (!node.isEmpty()) {
                        result$3.put((Object)BoxesRunTime.boxToInteger((int)replicaId), node);
                        return;
                    }
                });
                return;
            }
        }));
    }

    private static final Node node$1(int id, HashMap nodes$1) {
        return (Node)Option$.MODULE$.apply(nodes$1.get(BoxesRunTime.boxToInteger((int)id))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Node.noNode());
    }

    public KRaftMetadataCache(int brokerId) {
        this.brokerId = brokerId;
        Logging.$init$(this);
        ConfigRepository.$init$(this);
        this.logIdent_$eq(new StringBuilder(26).append("[MetadataCache brokerId=").append(brokerId).append("] ").toString());
        this._currentImage = MetadataImage.EMPTY;
    }
}

