/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jwt;

import com.google.common.collect.ImmutableList;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import java.security.Key;
import java.security.PublicKey;
import java.util.List;
import java.util.Optional;
import org.apache.james.jwt.DefaultPublicKeyProvider;
import org.apache.james.jwt.JwtConfiguration;
import org.apache.james.jwt.PublicKeyProvider;
import org.apache.james.jwt.PublicKeyReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtTokenVerifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtTokenVerifier.class);
    private final List<JwtParser> jwtParsers;

    public static JwtTokenVerifier create(JwtConfiguration jwtConfiguration) {
        DefaultPublicKeyProvider publicKeyProvider = new DefaultPublicKeyProvider(jwtConfiguration, new PublicKeyReader());
        return new JwtTokenVerifier(publicKeyProvider);
    }

    public JwtTokenVerifier(PublicKeyProvider pubKeyProvider) {
        this.jwtParsers = (List)pubKeyProvider.get().stream().map(this::toImmutableJwtParser).collect(ImmutableList.toImmutableList());
    }

    public Optional<String> verifyAndExtractLogin(String token) {
        return this.verifyAndExtractClaim(token, "sub", String.class).filter(s -> !s.isEmpty());
    }

    public <T> Optional<T> verifyAndExtractClaim(String token, String claimName, Class<T> returnType) {
        return this.jwtParsers.stream().flatMap(parser -> this.verifyAndExtractClaim(token, claimName, returnType, (JwtParser)parser).stream()).findFirst();
    }

    private <T> Optional<T> verifyAndExtractClaim(String token, String claimName, Class<T> returnType, JwtParser parser) {
        try {
            Jws jws = parser.parseClaimsJws(token);
            Object claim = ((Claims)jws.getBody()).get(claimName, returnType);
            if (claim == null) {
                throw new MalformedJwtException("'" + claimName + "' field in token is mandatory");
            }
            return Optional.of(claim);
        }
        catch (JwtException e) {
            LOGGER.info("Failed Jwt verification", (Throwable)e);
            return Optional.empty();
        }
    }

    public boolean hasAttribute(String attributeName, Object expectedValue, String token) {
        try {
            return this.verifyAndExtractClaim(token, attributeName, Object.class).map(expectedValue::equals).orElse(false);
        }
        catch (JwtException e) {
            LOGGER.info("Jwt validation failed for claim {} to {}", new Object[]{attributeName, expectedValue, e});
            return false;
        }
    }

    private JwtParser toImmutableJwtParser(PublicKey publicKey) {
        return Jwts.parserBuilder().setSigningKey((Key)publicKey).build();
    }

    public static interface Factory {
        public JwtTokenVerifier create();
    }
}

