/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.james.jmap.api.filtering.Rule;
import org.apache.james.jmap.draft.model.deserialization.JmapRuleDTODeserializer;

@JsonDeserialize(using=JmapRuleDTODeserializer.class)
public class JmapRuleDTO {
    private final String id;
    private final String name;
    private final ConditionDTO conditionDTO;
    private final ActionDTO actionDTO;

    public static ImmutableList<Rule> toRules(List<JmapRuleDTO> ruleDTOList) {
        Preconditions.checkNotNull(ruleDTOList);
        return (ImmutableList)ruleDTOList.stream().map(JmapRuleDTO::toRule).collect(ImmutableList.toImmutableList());
    }

    public static ImmutableList<JmapRuleDTO> from(List<Rule> rules) {
        Preconditions.checkNotNull(rules);
        return (ImmutableList)rules.stream().map(JmapRuleDTO::from).collect(ImmutableList.toImmutableList());
    }

    public static JmapRuleDTO from(Rule rule) {
        return new JmapRuleDTO(rule.getId().asString(), rule.getName(), ConditionDTO.from(rule.getCondition()), ActionDTO.from(rule.getAction()));
    }

    @JsonCreator
    public JmapRuleDTO(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="condition") ConditionDTO conditionDTO, @JsonProperty(value="action") ActionDTO actionDTO) {
        this.name = name;
        this.conditionDTO = conditionDTO;
        this.actionDTO = actionDTO;
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public ConditionDTO getCondition() {
        return this.conditionDTO;
    }

    public ActionDTO getAction() {
        return this.actionDTO;
    }

    public Rule toRule() {
        return Rule.builder().id(Rule.Id.of((String)this.id)).name(this.name).condition(this.conditionDTO.toCondition()).action(this.actionDTO.toAction()).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).toString();
    }

    public static class ActionDTO {
        private final AppendInMailboxesDTO appendIn;

        public static ActionDTO from(Rule.Action action) {
            return new ActionDTO(AppendInMailboxesDTO.from(action.getAppendInMailboxes()));
        }

        @JsonCreator
        public ActionDTO(@JsonProperty(value="appendIn") AppendInMailboxesDTO appendIn) {
            this.appendIn = appendIn;
        }

        public AppendInMailboxesDTO getAppendIn() {
            return this.appendIn;
        }

        public Rule.Action toAction() {
            return Rule.Action.of((Rule.Action.AppendInMailboxes)this.appendIn.toAppendInMailboxes());
        }

        public static class AppendInMailboxesDTO {
            private final List<String> mailboxIds;

            public static AppendInMailboxesDTO from(Rule.Action.AppendInMailboxes appendInMailboxes) {
                return new AppendInMailboxesDTO((List<String>)appendInMailboxes.getMailboxIds());
            }

            @JsonCreator
            public AppendInMailboxesDTO(@JsonProperty(value="mailboxIds") List<String> mailboxIds) {
                this.mailboxIds = ImmutableList.copyOf(mailboxIds);
            }

            public List<String> getMailboxIds() {
                return this.mailboxIds;
            }

            public Rule.Action.AppendInMailboxes toAppendInMailboxes() {
                return Rule.Action.AppendInMailboxes.withMailboxIds(this.mailboxIds);
            }
        }
    }

    public static class ConditionDTO {
        private final String field;
        private final String comparator;
        private final String value;

        public static ConditionDTO from(Rule.Condition condition) {
            return new ConditionDTO(condition.getField().asString(), condition.getComparator().asString(), condition.getValue());
        }

        @JsonCreator
        public ConditionDTO(@JsonProperty(value="field") String field, @JsonProperty(value="comparator") String comparator, @JsonProperty(value="value") String value) {
            this.field = field;
            this.comparator = comparator;
            this.value = value;
        }

        public String getField() {
            return this.field;
        }

        public String getComparator() {
            return this.comparator;
        }

        public String getValue() {
            return this.value;
        }

        public Rule.Condition toCondition() {
            return Rule.Condition.of((Rule.Condition.Field)Rule.Condition.Field.of((String)this.field), (Rule.Condition.Comparator)Rule.Condition.Comparator.of((String)this.comparator), (String)this.value);
        }
    }
}

