/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq;

import com.github.fge.lambdas.Throwing;
import com.rabbitmq.client.Channel;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.apache.james.backends.rabbitmq.SimpleConnectionPool;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import org.apache.james.queue.rabbitmq.MailQueueName;
import org.apache.james.queue.rabbitmq.RabbitMQMailQueueFactory;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class RabbitMQMailQueueConsumerHealthCheck
implements HealthCheck {
    public static final ComponentName COMPONENT_NAME = new ComponentName("RabbitMQMailQueueConsumersHealthCheck");
    public static final ComponentName COMPONENT = new ComponentName("MailQueueConsumers");
    private final RabbitMQMailQueueFactory queueFactory;
    private final Set<SimpleConnectionPool.ReconnectionHandler> reconnectionHandlers;
    private final SimpleConnectionPool connectionPool;

    @Inject
    public RabbitMQMailQueueConsumerHealthCheck(RabbitMQMailQueueFactory queueFactory, Set<SimpleConnectionPool.ReconnectionHandler> reconnectionHandlers, SimpleConnectionPool connectionPool) {
        this.queueFactory = queueFactory;
        this.reconnectionHandlers = reconnectionHandlers;
        this.connectionPool = connectionPool;
    }

    public ComponentName componentName() {
        return COMPONENT_NAME;
    }

    public Mono<Result> check() {
        return this.connectionPool.getResilientConnection().map((Function)Throwing.function(connection -> {
            try (Channel channel = connection.createChannel();){
                Result result = this.check(channel);
                return result;
            }
        })).subscribeOn(Schedulers.elastic());
    }

    private Result check(Channel channel) {
        boolean queueWithoutConsumers = this.queueFactory.listCreatedMailQueues().stream().map(org.apache.james.queue.api.MailQueueName::asString).map(MailQueueName::fromString).map(m -> m.toWorkQueueName().asString()).anyMatch((Predicate<String>)Throwing.predicate(queue -> channel.consumerCount(queue) == 0L));
        if (queueWithoutConsumers) {
            this.reconnectionHandlers.forEach(r -> this.connectionPool.getResilientConnection().flatMap(c -> Mono.from((Publisher)r.handleReconnection(c))).subscribeOn(Schedulers.boundedElastic()).block());
            return Result.degraded((ComponentName)COMPONENT, (String)"No consumers");
        }
        return Result.healthy((ComponentName)COMPONENT);
    }
}

