/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile;

import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFHistogram
implements UDTF {
    private int[] bucket;
    private double gap;
    private int count;
    private double start;

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE).validate(count -> (Integer)count > 0, "parameter $count$ should be larger than 0", (Object)validator.getParameters().getIntOrDefault("count", 1)).validate(params -> (Double)params[0] <= (Double)params[1], "parameter $end$ should be larger than or equal to $start$", validator.getParameters().getDoubleOrDefault("min", -1.7976931348623157E308), validator.getParameters().getDoubleOrDefault("max", Double.MAX_VALUE));
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(Type.INT32);
        this.start = parameters.getDoubleOrDefault("min", -1.7976931348623157E308);
        double end = parameters.getDoubleOrDefault("max", Double.MAX_VALUE);
        this.count = parameters.getIntOrDefault("count", 1);
        this.bucket = new int[this.count];
        this.gap = (end - this.start) / (double)this.count;
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        double value = Util.getValueAsDouble(row);
        if (Double.isFinite(value)) {
            int id;
            int n = id = Math.min(Math.max((int)Math.floor((value - this.start) / this.gap), 0), this.count - 1);
            this.bucket[n] = this.bucket[n] + 1;
        }
    }

    @Override
    public void terminate(PointCollector collector) throws Exception {
        for (int i = 0; i < this.count; ++i) {
            collector.putInt(i, this.bucket[i]);
        }
    }
}

