/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memcontrol;

import java.util.List;
import org.apache.iotdb.db.schemaengine.rescon.CachedSchemaRegionStatistics;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.ICachedMNode;

public class MemoryStatistics {
    private final CachedSchemaRegionStatistics regionStatistics;

    public MemoryStatistics(CachedSchemaRegionStatistics regionStatistics) {
        this.regionStatistics = regionStatistics;
    }

    public void requestPinnedMemResource(ICachedMNode node) {
        int size = node.estimateSize();
        this.regionStatistics.requestMemory(size);
        this.regionStatistics.updatePinnedMemorySize(size);
        this.regionStatistics.updatePinnedMNodeNum(1);
    }

    public void upgradeMemResource(ICachedMNode node) {
        int size = node.estimateSize();
        this.regionStatistics.updatePinnedMemorySize(size);
        this.regionStatistics.updatePinnedMNodeNum(1);
        this.regionStatistics.updateUnpinnedMemorySize(-size);
        this.regionStatistics.updateUnpinnedMNodeNum(-1);
    }

    public void releasePinnedMemResource(ICachedMNode node) {
        int size = node.estimateSize();
        this.regionStatistics.updateUnpinnedMemorySize(size);
        this.regionStatistics.updateUnpinnedMNodeNum(1);
        this.regionStatistics.updatePinnedMemorySize(-size);
        this.regionStatistics.updatePinnedMNodeNum(-1);
    }

    public void releaseMemResource(ICachedMNode node) {
        int size = node.estimateSize();
        this.regionStatistics.updateUnpinnedMemorySize(-size);
        this.regionStatistics.updateUnpinnedMNodeNum(-1);
        this.regionStatistics.releaseMemory(size);
    }

    public int releaseMemResource(List<ICachedMNode> evictedNodes) {
        int size = 0;
        for (ICachedMNode node : evictedNodes) {
            size += node.estimateSize();
        }
        this.regionStatistics.updateUnpinnedMNodeNum(-evictedNodes.size());
        this.regionStatistics.updateUnpinnedMemorySize(-size);
        this.regionStatistics.releaseMemory(size);
        return size;
    }

    public void updatePinnedSize(int deltaSize) {
        if (deltaSize > 0) {
            this.regionStatistics.requestMemory(deltaSize);
        } else {
            this.regionStatistics.releaseMemory(-deltaSize);
        }
        this.regionStatistics.updatePinnedMemorySize(deltaSize);
    }

    public void addVolatileNode() {
        this.regionStatistics.updateVolatileMNodeNum(1);
    }

    public void removeVolatileNode() {
        this.regionStatistics.updateVolatileMNodeNum(-1);
    }
}

