/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TAggregationType;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.isession.INodeSupplier;
import org.apache.iotdb.isession.ISession;
import org.apache.iotdb.isession.SessionConfig;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.isession.template.Template;
import org.apache.iotdb.isession.template.TemplateNode;
import org.apache.iotdb.isession.util.Version;
import org.apache.iotdb.rpc.BatchExecutionException;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.NoValidValueException;
import org.apache.iotdb.rpc.RedirectException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.service.rpc.thrift.TCreateTimeseriesUsingSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSAppendSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSBackupConfigurationResp;
import org.apache.iotdb.service.rpc.thrift.TSConnectionInfoResp;
import org.apache.iotdb.service.rpc.thrift.TSCreateAlignedTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateMultiTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSDeleteDataReq;
import org.apache.iotdb.service.rpc.thrift.TSDropSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsOfOneDeviceReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordsOfOneDeviceReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletsReq;
import org.apache.iotdb.service.rpc.thrift.TSProtocolVersion;
import org.apache.iotdb.service.rpc.thrift.TSPruneSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSQueryTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSQueryTemplateResp;
import org.apache.iotdb.service.rpc.thrift.TSSetSchemaTemplateReq;
import org.apache.iotdb.service.rpc.thrift.TSUnsetSchemaTemplateReq;
import org.apache.iotdb.session.AbstractSessionBuilder;
import org.apache.iotdb.session.DummyNodesSupplier;
import org.apache.iotdb.session.InsertConsumer;
import org.apache.iotdb.session.NodesSupplier;
import org.apache.iotdb.session.SessionConnection;
import org.apache.iotdb.session.template.MeasurementNode;
import org.apache.iotdb.session.template.TemplateQueryType;
import org.apache.iotdb.session.util.SessionUtils;
import org.apache.iotdb.session.util.ThreadUtils;
import org.apache.thrift.TException;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session
implements ISession {
    private static final Logger logger = LoggerFactory.getLogger(Session.class);
    protected static final TSProtocolVersion protocolVersion = TSProtocolVersion.IOTDB_SERVICE_PROTOCOL_V3;
    public static final String MSG_UNSUPPORTED_DATA_TYPE = "Unsupported data type:";
    public static final String MSG_DONOT_ENABLE_REDIRECT = "Query do not enable redirect, please confirm the session and server conf.";
    private static final ThreadPoolExecutor OPERATION_EXECUTOR = new ThreadPoolExecutor(SessionConfig.DEFAULT_SESSION_EXECUTOR_THREAD_NUM, SessionConfig.DEFAULT_SESSION_EXECUTOR_THREAD_NUM, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1000), ThreadUtils.createThreadFactory("SessionExecutor", true));
    protected List<String> nodeUrls;
    protected String username;
    protected String password;
    protected int fetchSize;
    protected boolean useSSL;
    protected String trustStore;
    protected String trustStorePwd;
    private long queryTimeoutInMs = -1L;
    protected boolean enableRPCCompression;
    protected int connectionTimeoutInMs;
    protected ZoneId zoneId;
    protected int thriftDefaultBufferSize;
    protected int thriftMaxFrameSize;
    protected TEndPoint defaultEndPoint;
    protected SessionConnection defaultSessionConnection;
    private boolean isClosed = true;
    protected boolean enableRedirection;
    protected boolean enableRecordsAutoConvertTablet = true;
    private static final double CONVERT_THRESHOLD = 0.5;
    private static final double SAMPLE_PROPORTION = 0.05;
    private static final int MIN_RECORDS_SIZE = 40;
    protected volatile Map<String, TEndPoint> deviceIdToEndpoint;
    protected volatile Map<IDeviceID, TEndPoint> tableModelDeviceIdToEndpoint;
    protected volatile Map<TEndPoint, SessionConnection> endPointToSessionConnection;
    protected volatile ScheduledExecutorService executorService;
    protected INodeSupplier availableNodes;
    protected boolean enableQueryRedirection = false;
    protected Version version;
    protected boolean enableAutoFetch = true;
    protected int maxRetryCount = 60;
    protected long retryIntervalInMs = 500L;
    protected volatile String sqlDialect = "tree";
    protected volatile String database;
    private static final String REDIRECT_TWICE = "redirect twice";
    private static final String REDIRECT_TWICE_RETRY = "redirect twice, please try again.";
    private static final String VALUES_SIZE_SHOULD_BE_EQUAL = "times, measurementsList and valuesList's size should be equal";
    private static final String SESSION_CANNOT_CONNECT = "Session can not connect to {}";
    private static final String ALL_VALUES_ARE_NULL = "All values are null and this submission is ignored,deviceId is [{}],time is [{}],measurements is [{}]";
    private static final String ALL_VALUES_ARE_NULL_WITH_TIME = "All values are null and this submission is ignored,deviceId is [{}],times are [{}],measurements are [{}]";
    private static final String ALL_VALUES_ARE_NULL_MULTI_DEVICES = "All values are null and this submission is ignored,deviceIds are [{}],times are [{}],measurements are [{}]";
    private static final String ALL_INSERT_DATA_IS_NULL = "All inserted data is null.";
    protected static final String TABLE = "table";
    protected static final String TREE = "tree";

    public Session(String host, int rpcPort) {
        this(host, rpcPort, "root", "root", 5000, null, 1024, 0x4000000, true, SessionConfig.DEFAULT_VERSION);
    }

    public Session(String host, String rpcPort, String username, String password) {
        this(host, Integer.parseInt(rpcPort), username, password, 5000, null, 1024, 0x4000000, true, SessionConfig.DEFAULT_VERSION);
    }

    public Session(String host, int rpcPort, String username, String password) {
        this(host, rpcPort, username, password, 5000, null, 1024, 0x4000000, true, SessionConfig.DEFAULT_VERSION);
    }

    public Session(String host, int rpcPort, String username, String password, int fetchSize) {
        this(host, rpcPort, username, password, fetchSize, null, 1024, 0x4000000, true, SessionConfig.DEFAULT_VERSION);
    }

    public Session(String host, int rpcPort, String username, String password, int fetchSize, long queryTimeoutInMs) {
        this(host, rpcPort, username, password, fetchSize, null, 1024, 0x4000000, true, SessionConfig.DEFAULT_VERSION);
        this.queryTimeoutInMs = queryTimeoutInMs;
    }

    public Session(String host, int rpcPort, String username, String password, ZoneId zoneId) {
        this(host, rpcPort, username, password, 5000, zoneId, 1024, 0x4000000, true, SessionConfig.DEFAULT_VERSION);
    }

    public Session(String host, int rpcPort, String username, String password, boolean enableRedirection) {
        this(host, rpcPort, username, password, 5000, null, 1024, 0x4000000, enableRedirection, SessionConfig.DEFAULT_VERSION);
    }

    public Session(String host, int rpcPort, String username, String password, int fetchSize, ZoneId zoneId, boolean enableRedirection) {
        this(host, rpcPort, username, password, fetchSize, zoneId, 1024, 0x4000000, enableRedirection, SessionConfig.DEFAULT_VERSION);
    }

    public Session(String host, int rpcPort, String username, String password, int fetchSize, ZoneId zoneId, int thriftDefaultBufferSize, int thriftMaxFrameSize, boolean enableRedirection, Version version) {
        this.defaultEndPoint = new TEndPoint(host, rpcPort);
        this.username = username;
        this.password = password;
        this.fetchSize = fetchSize;
        this.zoneId = zoneId;
        this.thriftDefaultBufferSize = thriftDefaultBufferSize;
        this.thriftMaxFrameSize = thriftMaxFrameSize;
        this.enableRedirection = enableRedirection;
        this.version = version;
    }

    public Session(List<String> nodeUrls, String username, String password) {
        this(nodeUrls, username, password, 5000, null, 1024, 0x4000000, true, SessionConfig.DEFAULT_VERSION);
    }

    public Session(List<String> nodeUrls, String username, String password, int fetchSize) {
        this(nodeUrls, username, password, fetchSize, null, 1024, 0x4000000, true, SessionConfig.DEFAULT_VERSION);
    }

    public Session(List<String> nodeUrls, String username, String password, ZoneId zoneId) {
        this(nodeUrls, username, password, 5000, zoneId, 1024, 0x4000000, true, SessionConfig.DEFAULT_VERSION);
    }

    public Session(List<String> nodeUrls, String username, String password, int fetchSize, ZoneId zoneId, int thriftDefaultBufferSize, int thriftMaxFrameSize, boolean enableRedirection, Version version) {
        if (nodeUrls.isEmpty()) {
            throw new IllegalArgumentException("nodeUrls shouldn't be empty.");
        }
        Collections.shuffle(nodeUrls);
        this.nodeUrls = nodeUrls;
        this.username = username;
        this.password = password;
        this.fetchSize = fetchSize;
        this.zoneId = zoneId;
        this.thriftDefaultBufferSize = thriftDefaultBufferSize;
        this.thriftMaxFrameSize = thriftMaxFrameSize;
        this.enableRedirection = enableRedirection;
        this.version = version;
    }

    public Session(AbstractSessionBuilder builder) {
        if (builder.nodeUrls != null) {
            if (builder.nodeUrls.isEmpty()) {
                throw new IllegalArgumentException("nodeUrls shouldn't be empty.");
            }
            Collections.shuffle(builder.nodeUrls);
            this.nodeUrls = builder.nodeUrls;
            this.enableQueryRedirection = true;
        } else {
            this.defaultEndPoint = new TEndPoint(builder.host, builder.rpcPort);
            this.enableQueryRedirection = builder.enableRedirection;
        }
        this.enableRedirection = builder.enableRedirection;
        this.enableRecordsAutoConvertTablet = builder.enableRecordsAutoConvertTablet;
        this.username = builder.username;
        this.password = builder.pw;
        this.fetchSize = builder.fetchSize;
        this.zoneId = builder.zoneId;
        this.thriftDefaultBufferSize = builder.thriftDefaultBufferSize;
        this.thriftMaxFrameSize = builder.thriftMaxFrameSize;
        this.version = builder.version;
        this.useSSL = builder.useSSL;
        this.trustStore = builder.trustStore;
        this.trustStorePwd = builder.trustStorePwd;
        this.enableAutoFetch = builder.enableAutoFetch;
        this.maxRetryCount = builder.maxRetryCount;
        this.retryIntervalInMs = builder.retryIntervalInMs;
        this.sqlDialect = builder.sqlDialect;
        this.queryTimeoutInMs = builder.timeOut;
        this.database = builder.database;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public synchronized void open() throws IoTDBConnectionException {
        this.open(false, 0);
    }

    public synchronized void open(boolean enableRPCCompression) throws IoTDBConnectionException {
        this.open(enableRPCCompression, 0);
    }

    public synchronized void open(boolean enableRPCCompression, int connectionTimeoutInMs) throws IoTDBConnectionException {
        if (!this.isClosed) {
            return;
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService = null;
        }
        if (this.availableNodes != null) {
            this.availableNodes.close();
            this.availableNodes = null;
        }
        if (this.enableAutoFetch) {
            this.initThreadPool();
            this.availableNodes = NodesSupplier.createNodeSupplier(this.getNodeUrls(), this.executorService, this.username, this.password, this.zoneId, this.thriftDefaultBufferSize, this.thriftMaxFrameSize, connectionTimeoutInMs, this.useSSL, this.trustStore, this.trustStorePwd, enableRPCCompression, this.version.toString());
        } else {
            this.availableNodes = new DummyNodesSupplier(this.getNodeUrls());
        }
        this.enableRPCCompression = enableRPCCompression;
        this.connectionTimeoutInMs = connectionTimeoutInMs;
        this.setDefaultSessionConnection(this.constructSessionConnection(this, this.defaultEndPoint, this.zoneId));
        this.getDefaultSessionConnection().setEnableRedirect(this.enableQueryRedirection);
        this.isClosed = false;
        if (this.enableRedirection || this.enableQueryRedirection) {
            this.deviceIdToEndpoint = new ConcurrentHashMap<String, TEndPoint>();
            this.tableModelDeviceIdToEndpoint = new ConcurrentHashMap<IDeviceID, TEndPoint>();
            this.endPointToSessionConnection = new ConcurrentHashMap<TEndPoint, SessionConnection>();
            this.endPointToSessionConnection.put(this.defaultEndPoint, this.getDefaultSessionConnection());
        }
    }

    private void initThreadPool() {
        this.executorService = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(Thread.currentThread().getThreadGroup(), r, "PeriodicalUpdateDNList", 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        });
    }

    private List<TEndPoint> getNodeUrls() {
        if (this.defaultEndPoint != null) {
            return Collections.singletonList(this.defaultEndPoint);
        }
        return SessionUtils.parseSeedNodeUrls(this.nodeUrls);
    }

    public synchronized void open(boolean enableRPCCompression, int connectionTimeoutInMs, Map<String, TEndPoint> deviceIdToEndpoint, INodeSupplier nodesSupplier) throws IoTDBConnectionException {
        if (!this.isClosed) {
            return;
        }
        this.availableNodes = nodesSupplier;
        this.enableRPCCompression = enableRPCCompression;
        this.connectionTimeoutInMs = connectionTimeoutInMs;
        this.setDefaultSessionConnection(this.constructSessionConnection(this, this.defaultEndPoint, this.zoneId));
        this.getDefaultSessionConnection().setEnableRedirect(this.enableQueryRedirection);
        this.isClosed = false;
        if (this.enableRedirection || this.enableQueryRedirection) {
            this.deviceIdToEndpoint = deviceIdToEndpoint;
            this.tableModelDeviceIdToEndpoint = new ConcurrentHashMap<IDeviceID, TEndPoint>();
            this.endPointToSessionConnection = new ConcurrentHashMap<TEndPoint, SessionConnection>();
            this.endPointToSessionConnection.put(this.defaultEndPoint, this.getDefaultSessionConnection());
        }
    }

    public synchronized void open(boolean enableRPCCompression, int connectionTimeoutInMs, Map<String, TEndPoint> deviceIdToEndpoint, Map<IDeviceID, TEndPoint> tableModelDeviceIdToEndpoint, INodeSupplier nodesSupplier) throws IoTDBConnectionException {
        if (!this.isClosed) {
            return;
        }
        this.availableNodes = nodesSupplier;
        this.enableRPCCompression = enableRPCCompression;
        this.connectionTimeoutInMs = connectionTimeoutInMs;
        this.setDefaultSessionConnection(this.constructSessionConnection(this, this.defaultEndPoint, this.zoneId));
        this.getDefaultSessionConnection().setEnableRedirect(this.enableQueryRedirection);
        this.isClosed = false;
        if (this.enableRedirection || this.enableQueryRedirection) {
            this.deviceIdToEndpoint = deviceIdToEndpoint;
            this.tableModelDeviceIdToEndpoint = tableModelDeviceIdToEndpoint;
            this.endPointToSessionConnection = new ConcurrentHashMap<TEndPoint, SessionConnection>();
            this.endPointToSessionConnection.put(this.defaultEndPoint, this.getDefaultSessionConnection());
        }
    }

    public synchronized void close() throws IoTDBConnectionException {
        try {
            if (this.isClosed) {
                return;
            }
            if (this.enableRedirection) {
                for (SessionConnection sessionConnection : this.endPointToSessionConnection.values()) {
                    sessionConnection.close();
                }
                this.endPointToSessionConnection.clear();
            }
            this.getDefaultSessionConnection().close();
            this.setDefaultSessionConnection(null);
        }
        finally {
            if (this.executorService != null) {
                this.executorService.shutdown();
                this.executorService = null;
                this.availableNodes.close();
                this.availableNodes = null;
            }
            this.isClosed = true;
        }
    }

    public SessionConnection constructSessionConnection(Session session, TEndPoint endpoint, ZoneId zoneId) throws IoTDBConnectionException {
        if (endpoint == null) {
            return new SessionConnection(session, zoneId, (Supplier<List<TEndPoint>>)this.availableNodes, this.maxRetryCount, this.retryIntervalInMs, this.sqlDialect, this.database);
        }
        return new SessionConnection(session, endpoint, zoneId, (Supplier<List<TEndPoint>>)this.availableNodes, this.maxRetryCount, this.retryIntervalInMs, this.sqlDialect, this.database);
    }

    public synchronized String getTimeZone() throws IoTDBConnectionException {
        return this.getDefaultSessionConnection().getTimeZone();
    }

    public synchronized void setTimeZone(String zoneId) throws StatementExecutionException, IoTDBConnectionException {
        this.getDefaultSessionConnection().setTimeZone(zoneId);
        this.zoneId = ZoneId.of(zoneId);
    }

    public void setTimeZoneOfSession(String zoneId) throws IoTDBConnectionException {
        this.getDefaultSessionConnection().setTimeZoneOfSession(zoneId);
        this.zoneId = ZoneId.of(zoneId);
    }

    public void setStorageGroup(String storageGroup) throws IoTDBConnectionException, StatementExecutionException {
        this.getDefaultSessionConnection().setStorageGroup(storageGroup);
    }

    public void deleteStorageGroup(String storageGroup) throws IoTDBConnectionException, StatementExecutionException {
        this.getDefaultSessionConnection().deleteStorageGroups(Collections.singletonList(storageGroup));
    }

    public void deleteStorageGroups(List<String> storageGroups) throws IoTDBConnectionException, StatementExecutionException {
        this.getDefaultSessionConnection().deleteStorageGroups(storageGroups);
    }

    public void createDatabase(String database) throws IoTDBConnectionException, StatementExecutionException {
        this.getDefaultSessionConnection().setStorageGroup(database);
    }

    public void deleteDatabase(String database) throws IoTDBConnectionException, StatementExecutionException {
        this.getDefaultSessionConnection().deleteStorageGroups(Collections.singletonList(database));
    }

    public void deleteDatabases(List<String> databases) throws IoTDBConnectionException, StatementExecutionException {
        this.getDefaultSessionConnection().deleteStorageGroups(databases);
    }

    public void createTimeseries(String path, TSDataType dataType, TSEncoding encoding, CompressionType compressor) throws IoTDBConnectionException, StatementExecutionException {
        TSCreateTimeseriesReq request = this.genTSCreateTimeseriesReq(path, dataType, encoding, compressor, null, null, null, null);
        this.getDefaultSessionConnection().createTimeseries(request);
    }

    public void createTimeseries(String path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props, Map<String, String> tags, Map<String, String> attributes, String measurementAlias) throws IoTDBConnectionException, StatementExecutionException {
        TSCreateTimeseriesReq request = this.genTSCreateTimeseriesReq(path, dataType, encoding, compressor, props, tags, attributes, measurementAlias);
        this.getDefaultSessionConnection().createTimeseries(request);
    }

    private TSCreateTimeseriesReq genTSCreateTimeseriesReq(String path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props, Map<String, String> tags, Map<String, String> attributes, String measurementAlias) {
        TSCreateTimeseriesReq request = new TSCreateTimeseriesReq();
        request.setPath(path);
        request.setDataType(dataType.ordinal());
        request.setEncoding(encoding.ordinal());
        request.setCompressor((int)compressor.serialize());
        request.setProps(props);
        request.setTags(tags);
        request.setAttributes(attributes);
        request.setMeasurementAlias(measurementAlias);
        return request;
    }

    public void createAlignedTimeseries(String deviceId, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<String> measurementAliasList) throws IoTDBConnectionException, StatementExecutionException {
        TSCreateAlignedTimeseriesReq request = this.getTSCreateAlignedTimeseriesReq(deviceId, measurements, dataTypes, encodings, compressors, measurementAliasList, null, null);
        this.getDefaultSessionConnection().createAlignedTimeseries(request);
    }

    public void createAlignedTimeseries(String deviceId, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<String> measurementAliasList, List<Map<String, String>> tagsList, List<Map<String, String>> attributesList) throws IoTDBConnectionException, StatementExecutionException {
        TSCreateAlignedTimeseriesReq request = this.getTSCreateAlignedTimeseriesReq(deviceId, measurements, dataTypes, encodings, compressors, measurementAliasList, tagsList, attributesList);
        this.getDefaultSessionConnection().createAlignedTimeseries(request);
    }

    private TSCreateAlignedTimeseriesReq getTSCreateAlignedTimeseriesReq(String prefixPath, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<String> measurementAliasList, List<Map<String, String>> tagsList, List<Map<String, String>> attributesList) {
        TSCreateAlignedTimeseriesReq request = new TSCreateAlignedTimeseriesReq();
        request.setPrefixPath(prefixPath);
        request.setMeasurements(measurements);
        request.setDataTypes(dataTypes.stream().map(Enum::ordinal).collect(Collectors.toList()));
        request.setEncodings(encodings.stream().map(Enum::ordinal).collect(Collectors.toList()));
        request.setCompressors(compressors.stream().map(i -> i.serialize()).collect(Collectors.toList()));
        request.setMeasurementAlias(measurementAliasList);
        request.setTagsList(tagsList);
        request.setAttributesList(attributesList);
        return request;
    }

    public void createMultiTimeseries(List<String> paths, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<Map<String, String>> propsList, List<Map<String, String>> tagsList, List<Map<String, String>> attributesList, List<String> measurementAliasList) throws IoTDBConnectionException, StatementExecutionException {
        TSCreateMultiTimeseriesReq request = this.genTSCreateMultiTimeseriesReq(paths, dataTypes, encodings, compressors, propsList, tagsList, attributesList, measurementAliasList);
        this.getDefaultSessionConnection().createMultiTimeseries(request);
    }

    private TSCreateMultiTimeseriesReq genTSCreateMultiTimeseriesReq(List<String> paths, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<Map<String, String>> propsList, List<Map<String, String>> tagsList, List<Map<String, String>> attributesList, List<String> measurementAliasList) {
        TSCreateMultiTimeseriesReq request = new TSCreateMultiTimeseriesReq();
        request.setPaths(paths);
        ArrayList<Integer> dataTypeOrdinals = new ArrayList<Integer>(dataTypes.size());
        for (TSDataType tSDataType : dataTypes) {
            dataTypeOrdinals.add(tSDataType.ordinal());
        }
        request.setDataTypes(dataTypeOrdinals);
        ArrayList<Integer> encodingOrdinals = new ArrayList<Integer>(dataTypes.size());
        for (TSEncoding encoding : encodings) {
            encodingOrdinals.add(encoding.ordinal());
        }
        request.setEncodings(encodingOrdinals);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(paths.size());
        for (CompressionType compression : compressors) {
            arrayList.add(Integer.valueOf(compression.serialize()));
        }
        request.setCompressors(arrayList);
        request.setPropsList(propsList);
        request.setTagsList(tagsList);
        request.setAttributesList(attributesList);
        request.setMeasurementAliasList(measurementAliasList);
        return request;
    }

    public boolean checkTimeseriesExists(String path) throws IoTDBConnectionException, StatementExecutionException {
        return this.getDefaultSessionConnection().checkTimeseriesExists(path, this.queryTimeoutInMs);
    }

    public void setQueryTimeout(long timeoutInMs) {
        this.queryTimeoutInMs = timeoutInMs;
    }

    public long getQueryTimeout() {
        return this.queryTimeoutInMs;
    }

    public SessionDataSet executeQueryStatement(String sql) throws StatementExecutionException, IoTDBConnectionException {
        return this.executeStatementMayRedirect(sql, this.queryTimeoutInMs);
    }

    public SessionDataSet executeQueryStatement(String sql, long timeoutInMs) throws StatementExecutionException, IoTDBConnectionException {
        return this.executeStatementMayRedirect(sql, timeoutInMs);
    }

    private SessionDataSet executeStatementMayRedirect(String sql, long timeoutInMs) throws StatementExecutionException, IoTDBConnectionException {
        try {
            return this.getQuerySessionConnection().executeQueryStatement(sql, timeoutInMs);
        }
        catch (RedirectException e) {
            this.handleQueryRedirection(e.getEndPoint());
            if (this.enableQueryRedirection) {
                try {
                    return this.getDefaultSessionConnection().executeQueryStatement(sql, this.queryTimeoutInMs);
                }
                catch (RedirectException redirectException) {
                    logger.error("{} redirect twice", (Object)sql, (Object)redirectException);
                    throw new StatementExecutionException(sql + " redirect twice, please try again.");
                }
            }
            throw new StatementExecutionException(MSG_DONOT_ENABLE_REDIRECT);
        }
    }

    private SessionConnection getQuerySessionConnection() throws IoTDBConnectionException {
        Optional endPoint;
        Optional optional = endPoint = this.availableNodes == null ? Optional.empty() : this.availableNodes.getQueryEndPoint();
        if (!endPoint.isPresent() || this.endPointToSessionConnection == null) {
            return this.getDefaultSessionConnection();
        }
        SessionConnection connection = this.endPointToSessionConnection.computeIfAbsent((TEndPoint)endPoint.get(), k -> {
            try {
                return this.constructSessionConnection(this, (TEndPoint)endPoint.get(), this.zoneId);
            }
            catch (IoTDBConnectionException ex) {
                return null;
            }
        });
        return connection == null ? this.getDefaultSessionConnection() : connection;
    }

    public void executeNonQueryStatement(String sql) throws IoTDBConnectionException, StatementExecutionException {
        String previousDB = this.database;
        String previousDialect = this.sqlDialect;
        this.getDefaultSessionConnection().executeNonQueryStatement(sql);
        if (!(Objects.equals(previousDB, this.database) && Objects.equals(previousDialect, this.sqlDialect) || this.endPointToSessionConnection == null)) {
            Iterator<Map.Entry<TEndPoint, SessionConnection>> iterator = this.endPointToSessionConnection.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<TEndPoint, SessionConnection> entry = iterator.next();
                SessionConnection sessionConnection = entry.getValue();
                if (sessionConnection == this.getDefaultSessionConnection()) continue;
                try {
                    sessionConnection.executeNonQueryStatement(sql);
                }
                catch (Throwable t) {
                    logger.warn("failed to execute '{}' for {}", (Object)sql, (Object)entry.getKey());
                    iterator.remove();
                }
            }
        }
    }

    public SessionDataSet executeRawDataQuery(List<String> paths, long startTime, long endTime, long timeOut) throws StatementExecutionException, IoTDBConnectionException {
        try {
            return this.getDefaultSessionConnection().executeRawDataQuery(paths, startTime, endTime, timeOut);
        }
        catch (RedirectException e) {
            this.handleQueryRedirection(e.getEndPoint());
            if (this.enableQueryRedirection) {
                try {
                    return this.getDefaultSessionConnection().executeRawDataQuery(paths, startTime, endTime, timeOut);
                }
                catch (RedirectException redirectException) {
                    logger.error(REDIRECT_TWICE, (Throwable)redirectException);
                    throw new StatementExecutionException(REDIRECT_TWICE_RETRY);
                }
            }
            throw new StatementExecutionException(MSG_DONOT_ENABLE_REDIRECT);
        }
    }

    public SessionDataSet executeRawDataQuery(List<String> paths, long startTime, long endTime) throws StatementExecutionException, IoTDBConnectionException {
        return this.executeRawDataQuery(paths, startTime, endTime, this.queryTimeoutInMs);
    }

    public SessionDataSet executeLastDataQuery(List<String> paths, long lastTime) throws StatementExecutionException, IoTDBConnectionException {
        return this.executeLastDataQuery(paths, lastTime, this.queryTimeoutInMs);
    }

    public SessionDataSet executeLastDataQuery(List<String> paths, long lastTime, long timeOut) throws StatementExecutionException, IoTDBConnectionException {
        try {
            return this.getDefaultSessionConnection().executeLastDataQuery(paths, lastTime, timeOut);
        }
        catch (RedirectException e) {
            this.handleQueryRedirection(e.getEndPoint());
            if (this.enableQueryRedirection) {
                try {
                    return this.getDefaultSessionConnection().executeLastDataQuery(paths, lastTime, timeOut);
                }
                catch (RedirectException redirectException) {
                    logger.error(REDIRECT_TWICE, (Throwable)redirectException);
                    throw new StatementExecutionException(REDIRECT_TWICE_RETRY);
                }
            }
            throw new StatementExecutionException(MSG_DONOT_ENABLE_REDIRECT);
        }
    }

    public SessionDataSet executeLastDataQuery(List<String> paths) throws StatementExecutionException, IoTDBConnectionException {
        long time = 0L;
        return this.executeLastDataQuery(paths, time, this.queryTimeoutInMs);
    }

    public SessionDataSet executeFastLastDataQueryForOnePrefixPath(List<String> prefixes) throws IoTDBConnectionException, StatementExecutionException, RedirectException {
        return this.getDefaultSessionConnection().executeLastDataQueryForOnePrefixPath(prefixes);
    }

    public SessionDataSet executeLastDataQueryForOneDevice(String db, String device, List<String> sensors, boolean isLegalPathNodes) throws StatementExecutionException, IoTDBConnectionException {
        try {
            Pair<SessionDataSet, TEndPoint> pair = this.getSessionConnection(device).executeLastDataQueryForOneDevice(db, device, sensors, isLegalPathNodes, this.queryTimeoutInMs);
            if (pair.right != null) {
                this.handleRedirection(device, (TEndPoint)pair.right);
            }
            return (SessionDataSet)pair.left;
        }
        catch (IoTDBConnectionException e) {
            if (this.enableRedirection && this.deviceIdToEndpoint != null && !this.deviceIdToEndpoint.isEmpty() && this.deviceIdToEndpoint.get(device) != null) {
                logger.warn(SESSION_CANNOT_CONNECT, (Object)this.deviceIdToEndpoint.get(device));
                this.deviceIdToEndpoint.remove(device);
                return (SessionDataSet)this.getDefaultSessionConnection().executeLastDataQueryForOneDevice((String)db, (String)device, sensors, (boolean)isLegalPathNodes, (long)this.queryTimeoutInMs).left;
            }
            throw e;
        }
    }

    public SessionDataSet executeAggregationQuery(List<String> paths, List<TAggregationType> aggregations) throws StatementExecutionException, IoTDBConnectionException {
        try {
            return this.getDefaultSessionConnection().executeAggregationQuery(paths, aggregations);
        }
        catch (RedirectException e) {
            this.handleQueryRedirection(e.getEndPoint());
            if (this.enableQueryRedirection) {
                try {
                    return this.getDefaultSessionConnection().executeAggregationQuery(paths, aggregations);
                }
                catch (RedirectException redirectException) {
                    logger.error(REDIRECT_TWICE, (Throwable)redirectException);
                    throw new StatementExecutionException(REDIRECT_TWICE_RETRY);
                }
            }
            throw new StatementExecutionException(MSG_DONOT_ENABLE_REDIRECT);
        }
    }

    public SessionDataSet executeAggregationQuery(List<String> paths, List<TAggregationType> aggregations, long startTime, long endTime) throws StatementExecutionException, IoTDBConnectionException {
        try {
            return this.getDefaultSessionConnection().executeAggregationQuery(paths, aggregations, startTime, endTime);
        }
        catch (RedirectException e) {
            this.handleQueryRedirection(e.getEndPoint());
            if (this.enableQueryRedirection) {
                try {
                    return this.getDefaultSessionConnection().executeAggregationQuery(paths, aggregations, startTime, endTime);
                }
                catch (RedirectException redirectException) {
                    logger.error(REDIRECT_TWICE, (Throwable)redirectException);
                    throw new StatementExecutionException(REDIRECT_TWICE_RETRY);
                }
            }
            throw new StatementExecutionException(MSG_DONOT_ENABLE_REDIRECT);
        }
    }

    public SessionDataSet executeAggregationQuery(List<String> paths, List<TAggregationType> aggregations, long startTime, long endTime, long interval) throws StatementExecutionException, IoTDBConnectionException {
        try {
            return this.getDefaultSessionConnection().executeAggregationQuery(paths, aggregations, startTime, endTime, interval);
        }
        catch (RedirectException e) {
            this.handleQueryRedirection(e.getEndPoint());
            if (this.enableQueryRedirection) {
                try {
                    return this.getDefaultSessionConnection().executeAggregationQuery(paths, aggregations, startTime, endTime, interval);
                }
                catch (RedirectException redirectException) {
                    logger.error(REDIRECT_TWICE, (Throwable)redirectException);
                    throw new StatementExecutionException(REDIRECT_TWICE_RETRY);
                }
            }
            throw new StatementExecutionException(MSG_DONOT_ENABLE_REDIRECT);
        }
    }

    public SessionDataSet executeAggregationQuery(List<String> paths, List<TAggregationType> aggregations, long startTime, long endTime, long interval, long slidingStep) throws StatementExecutionException, IoTDBConnectionException {
        try {
            return this.getDefaultSessionConnection().executeAggregationQuery(paths, aggregations, startTime, endTime, interval, slidingStep);
        }
        catch (RedirectException e) {
            this.handleQueryRedirection(e.getEndPoint());
            if (this.enableQueryRedirection) {
                try {
                    return this.getDefaultSessionConnection().executeAggregationQuery(paths, aggregations, startTime, endTime, interval, slidingStep);
                }
                catch (RedirectException redirectException) {
                    logger.error(REDIRECT_TWICE, (Throwable)redirectException);
                    throw new StatementExecutionException(REDIRECT_TWICE_RETRY);
                }
            }
            throw new StatementExecutionException(MSG_DONOT_ENABLE_REDIRECT);
        }
    }

    public void insertRecord(String deviceId, long time, List<String> measurements, List<TSDataType> types, Object ... values) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertRecordReq request;
        try {
            request = this.filterAndGenTSInsertRecordReq(deviceId, time, measurements, types, Arrays.asList(values), false);
        }
        catch (NoValidValueException e) {
            logger.warn(ALL_VALUES_ARE_NULL, new Object[]{deviceId, time, measurements});
            return;
        }
        this.insertRecord(deviceId, request);
    }

    private void insertRecord(String prefixPath, TSInsertRecordReq request) throws IoTDBConnectionException, StatementExecutionException {
        try {
            this.getSessionConnection(prefixPath).insertRecord(request);
        }
        catch (RedirectException e) {
            this.handleRedirection(prefixPath, e.getEndPoint());
        }
        catch (IoTDBConnectionException e) {
            if (this.enableRedirection && !this.deviceIdToEndpoint.isEmpty() && this.deviceIdToEndpoint.get(prefixPath) != null) {
                logger.warn(SESSION_CANNOT_CONNECT, (Object)this.deviceIdToEndpoint.get(prefixPath));
                this.deviceIdToEndpoint.remove(prefixPath);
                try {
                    this.getDefaultSessionConnection().insertRecord(request);
                }
                catch (RedirectException redirectException) {}
            }
            throw e;
        }
    }

    private void insertRecord(String deviceId, TSInsertStringRecordReq request) throws IoTDBConnectionException, StatementExecutionException {
        try {
            this.getSessionConnection(deviceId).insertRecord(request);
        }
        catch (RedirectException e) {
            this.handleRedirection(deviceId, e.getEndPoint());
        }
        catch (IoTDBConnectionException e) {
            if (this.enableRedirection && !this.deviceIdToEndpoint.isEmpty() && this.deviceIdToEndpoint.get(deviceId) != null) {
                logger.warn(SESSION_CANNOT_CONNECT, (Object)this.deviceIdToEndpoint.get(deviceId));
                this.deviceIdToEndpoint.remove(deviceId);
                try {
                    this.getDefaultSessionConnection().insertRecord(request);
                }
                catch (RedirectException redirectException) {}
            }
            throw e;
        }
    }

    private SessionConnection getSessionConnection(String deviceId) throws IoTDBConnectionException {
        TEndPoint endPoint;
        if (this.enableRedirection && this.deviceIdToEndpoint != null && !this.deviceIdToEndpoint.isEmpty() && (endPoint = this.deviceIdToEndpoint.get(deviceId)) != null && this.endPointToSessionConnection.containsKey(endPoint)) {
            return this.endPointToSessionConnection.get(endPoint);
        }
        return this.getDefaultSessionConnection();
    }

    private SessionConnection getSessionConnection(IDeviceID deviceId) throws IoTDBConnectionException {
        TEndPoint endPoint;
        if (this.enableRedirection && this.tableModelDeviceIdToEndpoint != null && (endPoint = this.tableModelDeviceIdToEndpoint.get(deviceId)) != null && this.endPointToSessionConnection.containsKey(endPoint)) {
            return this.endPointToSessionConnection.get(endPoint);
        }
        return this.getDefaultSessionConnection();
    }

    public String getTimestampPrecision() throws TException, IoTDBConnectionException {
        return this.getDefaultSessionConnection().getClient().getProperties().getTimestampPrecision();
    }

    public void removeBrokenSessionConnection(SessionConnection sessionConnection) {
        if (this.enableRedirection) {
            Map.Entry<Object, SessionConnection> entry;
            Iterator<Map.Entry<Object, SessionConnection>> it;
            TEndPoint endPoint = null;
            if (this.endPointToSessionConnection != null) {
                it = this.endPointToSessionConnection.entrySet().iterator();
                while (it.hasNext()) {
                    entry = it.next();
                    if (!entry.getValue().equals(sessionConnection)) continue;
                    endPoint = entry.getKey();
                    it.remove();
                    break;
                }
            }
            if (this.deviceIdToEndpoint != null && !this.deviceIdToEndpoint.isEmpty()) {
                it = this.deviceIdToEndpoint.entrySet().iterator();
                while (it.hasNext()) {
                    entry = it.next();
                    if (!((TEndPoint)entry.getValue()).equals(endPoint)) continue;
                    it.remove();
                }
            }
            if (this.tableModelDeviceIdToEndpoint != null && !this.tableModelDeviceIdToEndpoint.isEmpty()) {
                it = this.tableModelDeviceIdToEndpoint.entrySet().iterator();
                while (it.hasNext()) {
                    entry = it.next();
                    if (!((TEndPoint)entry.getValue()).equals(endPoint)) continue;
                    it.remove();
                }
            }
        }
    }

    private void handleRedirection(String deviceId, TEndPoint endpoint) {
        if (this.enableRedirection) {
            SessionConnection connection;
            if (endpoint.ip.equals("0.0.0.0")) {
                return;
            }
            if (!this.deviceIdToEndpoint.containsKey(deviceId) || !this.deviceIdToEndpoint.get(deviceId).equals(endpoint)) {
                this.deviceIdToEndpoint.put(deviceId, endpoint);
            }
            if ((connection = this.endPointToSessionConnection.computeIfAbsent(endpoint, k -> {
                try {
                    return this.constructSessionConnection(this, endpoint, this.zoneId);
                }
                catch (IoTDBConnectionException ex) {
                    return null;
                }
            })) == null) {
                this.deviceIdToEndpoint.remove(deviceId);
            }
        }
    }

    private void handleRedirection(IDeviceID deviceId, TEndPoint endpoint) {
        if (this.enableRedirection) {
            SessionConnection connection;
            if (endpoint.ip.equals("0.0.0.0")) {
                return;
            }
            if (!this.tableModelDeviceIdToEndpoint.containsKey(deviceId) || !this.tableModelDeviceIdToEndpoint.get(deviceId).equals(endpoint)) {
                this.tableModelDeviceIdToEndpoint.put(deviceId, endpoint);
            }
            if ((connection = this.endPointToSessionConnection.computeIfAbsent(endpoint, k -> {
                try {
                    return this.constructSessionConnection(this, endpoint, this.zoneId);
                }
                catch (IoTDBConnectionException ex) {
                    return null;
                }
            })) == null) {
                this.tableModelDeviceIdToEndpoint.remove(deviceId);
            }
        }
    }

    private void handleQueryRedirection(TEndPoint endPoint) throws IoTDBConnectionException {
        if (this.enableQueryRedirection) {
            AtomicReference exceptionReference = new AtomicReference();
            SessionConnection connection = this.endPointToSessionConnection.computeIfAbsent(endPoint, k -> {
                try {
                    SessionConnection sessionConnection = this.constructSessionConnection(this, endPoint, this.zoneId);
                    sessionConnection.setEnableRedirect(this.enableQueryRedirection);
                    return sessionConnection;
                }
                catch (IoTDBConnectionException ex) {
                    exceptionReference.set(ex);
                    return null;
                }
            });
            if (connection == null) {
                throw new IoTDBConnectionException((Throwable)exceptionReference.get());
            }
            this.setDefaultSessionConnection(connection);
        }
    }

    public void insertRecord(String deviceId, long time, List<String> measurements, List<TSDataType> types, List<Object> values) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertRecordReq request;
        try {
            request = this.filterAndGenTSInsertRecordReq(deviceId, time, measurements, types, values, false);
        }
        catch (NoValidValueException e) {
            logger.warn(ALL_VALUES_ARE_NULL, new Object[]{deviceId, time, measurements});
            return;
        }
        this.insertRecord(deviceId, request);
    }

    public void insertAlignedRecord(String deviceId, long time, List<String> measurements, List<TSDataType> types, List<Object> values) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertRecordReq request;
        try {
            request = this.filterAndGenTSInsertRecordReq(deviceId, time, measurements, types, values, true);
        }
        catch (NoValidValueException e) {
            logger.warn(ALL_VALUES_ARE_NULL, new Object[]{deviceId, time, measurements});
            return;
        }
        this.insertRecord(deviceId, request);
    }

    private TSInsertRecordReq filterAndGenTSInsertRecordReq(String prefixPath, long time, List<String> measurements, List<TSDataType> types, List<Object> values, boolean isAligned) throws IoTDBConnectionException {
        boolean isAllValuesNull;
        if (this.hasNull(values) && (isAllValuesNull = this.filterNullValueAndMeasurement(prefixPath, measurements = new ArrayList<String>(measurements), types = new ArrayList<TSDataType>(types), values = new ArrayList<Object>(values)))) {
            throw new NoValidValueException(ALL_INSERT_DATA_IS_NULL);
        }
        return this.genTSInsertRecordReq(prefixPath, time, measurements, types, values, isAligned);
    }

    private TSInsertRecordReq genTSInsertRecordReq(String prefixPath, long time, List<String> measurements, List<TSDataType> types, List<Object> values, boolean isAligned) throws IoTDBConnectionException {
        TSInsertRecordReq request = new TSInsertRecordReq();
        request.setPrefixPath(prefixPath);
        request.setTimestamp(time);
        request.setMeasurements(measurements);
        ByteBuffer buffer = SessionUtils.getValueBuffer(types, values, measurements);
        request.setValues(buffer);
        request.setIsAligned(isAligned);
        return request;
    }

    public void insertRecord(String deviceId, long time, List<String> measurements, List<String> values) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertStringRecordReq request;
        try {
            request = this.filterAndGenTSInsertStringRecordReq(deviceId, time, measurements, values, false);
        }
        catch (NoValidValueException e) {
            logger.warn(ALL_VALUES_ARE_NULL, new Object[]{deviceId, time, measurements});
            return;
        }
        this.insertRecord(deviceId, request);
    }

    public void insertAlignedRecord(String deviceId, long time, List<String> measurements, List<String> values) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertStringRecordReq request;
        try {
            request = this.filterAndGenTSInsertStringRecordReq(deviceId, time, measurements, values, true);
        }
        catch (NoValidValueException e) {
            logger.warn(ALL_VALUES_ARE_NULL, new Object[]{deviceId, time, measurements});
            return;
        }
        this.insertRecord(deviceId, request);
    }

    private TSInsertStringRecordReq filterAndGenTSInsertStringRecordReq(String prefixPath, long time, List<String> measurements, List<String> values, boolean isAligned) {
        boolean isAllValueNull;
        if (this.hasNull(values) && (isAllValueNull = this.filterNullValueAndMeasurementWithStringType(values = new ArrayList<String>(values), prefixPath, measurements = new ArrayList<String>(measurements)))) {
            throw new NoValidValueException(ALL_INSERT_DATA_IS_NULL);
        }
        return this.genTSInsertStringRecordReq(prefixPath, time, measurements, values, isAligned);
    }

    private TSInsertStringRecordReq genTSInsertStringRecordReq(String prefixPath, long time, List<String> measurements, List<String> values, boolean isAligned) {
        TSInsertStringRecordReq request = new TSInsertStringRecordReq();
        request.setPrefixPath(prefixPath);
        request.setTimestamp(time);
        request.setMeasurements(measurements);
        request.setValues(values);
        request.setIsAligned(isAligned);
        return request;
    }

    public void insertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        int len = deviceIds.size();
        if (len != times.size() || len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException("deviceIds, times, measurementsList and valuesList's size should be equal");
        }
        if (this.enableRedirection) {
            this.insertStringRecordsWithLeaderCache(deviceIds, times, measurementsList, valuesList, false);
        } else {
            TSInsertStringRecordsReq request;
            try {
                request = this.filterAndGenTSInsertStringRecordsReq(deviceIds, times, measurementsList, valuesList, false);
            }
            catch (NoValidValueException e) {
                logger.warn(ALL_VALUES_ARE_NULL_MULTI_DEVICES, new Object[]{deviceIds, times, measurementsList});
                return;
            }
            try {
                this.getDefaultSessionConnection().insertRecords(request);
            }
            catch (RedirectException redirectException) {
                // empty catch block
            }
        }
    }

    private void filterNullValueAndMeasurement(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<Object>> valuesList, List<List<TSDataType>> typesList) {
        for (int i = valuesList.size() - 1; i >= 0; --i) {
            List<Object> values = valuesList.get(i);
            List<String> measurements = measurementsList.get(i);
            List<TSDataType> types = typesList.get(i);
            boolean isAllValuesNull = this.filterNullValueAndMeasurement(deviceIds.get(i), measurements, types, values);
            if (!isAllValuesNull) continue;
            valuesList.remove(i);
            measurementsList.remove(i);
            deviceIds.remove(i);
            times.remove(i);
            typesList.remove(i);
        }
        if (valuesList.isEmpty()) {
            throw new NoValidValueException(ALL_INSERT_DATA_IS_NULL);
        }
    }

    private void filterNullValueAndMeasurementOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) {
        for (int i = valuesList.size() - 1; i >= 0; --i) {
            List<TSDataType> types;
            List<Object> values = valuesList.get(i);
            List<String> measurements = measurementsList.get(i);
            boolean isAllValuesNull = this.filterNullValueAndMeasurement(deviceId, measurements, types = typesList.get(i), values);
            if (!isAllValuesNull) continue;
            valuesList.remove(i);
            measurementsList.remove(i);
            typesList.remove(i);
            times.remove(i);
        }
        if (valuesList.isEmpty()) {
            throw new NoValidValueException(ALL_INSERT_DATA_IS_NULL);
        }
    }

    private void filterNullValueAndMeasurementWithStringTypeOfOneDevice(List<Long> times, String deviceId, List<List<String>> measurementsList, List<List<String>> valuesList) {
        for (int i = valuesList.size() - 1; i >= 0; --i) {
            List<String> measurements;
            List<String> values = valuesList.get(i);
            boolean isAllValuesNull = this.filterNullValueAndMeasurementWithStringType(values, deviceId, measurements = measurementsList.get(i));
            if (!isAllValuesNull) continue;
            valuesList.remove(i);
            measurementsList.remove(i);
            times.remove(i);
        }
        if (valuesList.isEmpty()) {
            throw new NoValidValueException(ALL_INSERT_DATA_IS_NULL);
        }
    }

    private boolean filterNullValueAndMeasurement(String deviceId, List<String> measurementsList, List<TSDataType> types, List<Object> valuesList) {
        HashMap<String, Object> nullMap = new HashMap<String, Object>();
        for (int i = valuesList.size() - 1; i >= 0; --i) {
            if (valuesList.get(i) != null) continue;
            nullMap.put(measurementsList.get(i), valuesList.get(i));
            valuesList.remove(i);
            measurementsList.remove(i);
            types.remove(i);
        }
        if (valuesList.isEmpty()) {
            logger.info("All values of the {} are null,null values are {}", (Object)deviceId, nullMap);
            return true;
        }
        logger.info("Some values of {} are null,null values are {}", (Object)deviceId, nullMap);
        return false;
    }

    private void filterNullValueAndMeasurementWithStringType(List<String> prefixPaths, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) {
        for (int i = valuesList.size() - 1; i >= 0; --i) {
            List<String> values = valuesList.get(i);
            List<String> measurements = measurementsList.get(i);
            boolean isAllValueNull = this.filterNullValueAndMeasurementWithStringType(values, prefixPaths.get(i), measurements);
            if (!isAllValueNull) continue;
            valuesList.remove(i);
            measurementsList.remove(i);
            times.remove(i);
            prefixPaths.remove(i);
        }
        if (valuesList.isEmpty()) {
            throw new NoValidValueException(ALL_INSERT_DATA_IS_NULL);
        }
    }

    private boolean filterNullValueAndMeasurementWithStringType(List<String> valuesList, String deviceId, List<String> measurementsList) {
        HashMap<String, String> nullMap = new HashMap<String, String>();
        for (int i = valuesList.size() - 1; i >= 0; --i) {
            if (valuesList.get(i) != null) continue;
            nullMap.put(measurementsList.get(i), valuesList.get(i));
            valuesList.remove(i);
            measurementsList.remove(i);
        }
        if (valuesList.isEmpty()) {
            logger.info("All values of the {} are null,null values are {}", (Object)deviceId, nullMap);
            return true;
        }
        logger.info("Some values of {} are null,null values are {}", (Object)deviceId, nullMap);
        return false;
    }

    private boolean hasNull(List valuesList) {
        boolean haveNull = false;
        for (int i1 = 0; i1 < valuesList.size(); ++i1) {
            Object o = valuesList.get(i1);
            if (o instanceof List) {
                List o1 = (List)o;
                if (!this.hasNull(o1)) continue;
                haveNull = true;
                break;
            }
            if (o != null) continue;
            haveNull = true;
            break;
        }
        return haveNull;
    }

    public void insertAlignedRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        int len = deviceIds.size();
        if (len != times.size() || len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException("prefixPaths, times, subMeasurementsList and valuesList's size should be equal");
        }
        if (this.enableRedirection) {
            this.insertStringRecordsWithLeaderCache(deviceIds, times, measurementsList, valuesList, true);
        } else {
            TSInsertStringRecordsReq request;
            try {
                request = this.filterAndGenTSInsertStringRecordsReq(deviceIds, times, measurementsList, valuesList, true);
            }
            catch (NoValidValueException e) {
                logger.warn(ALL_VALUES_ARE_NULL_MULTI_DEVICES, new Object[]{deviceIds, times, measurementsList});
                return;
            }
            try {
                this.getDefaultSessionConnection().insertRecords(request);
            }
            catch (RedirectException redirectException) {
                // empty catch block
            }
        }
    }

    private void insertStringRecordsWithLeaderCache(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList, boolean isAligned) throws IoTDBConnectionException, StatementExecutionException {
        HashMap<SessionConnection, TSInsertStringRecordsReq> recordsGroup = new HashMap<SessionConnection, TSInsertStringRecordsReq>();
        for (int i = 0; i < deviceIds.size(); ++i) {
            SessionConnection connection = this.getSessionConnection(deviceIds.get(i));
            TSInsertStringRecordsReq request = recordsGroup.getOrDefault(connection, new TSInsertStringRecordsReq());
            request.setIsAligned(isAligned);
            try {
                this.filterAndUpdateTSInsertStringRecordsReq(request, deviceIds.get(i), times.get(i), measurementsList.get(i), valuesList.get(i));
                recordsGroup.putIfAbsent(connection, request);
                continue;
            }
            catch (NoValidValueException e) {
                logger.warn(ALL_VALUES_ARE_NULL, new Object[]{deviceIds.get(i), times.get(i), measurementsList.get(i).toString()});
            }
        }
        if (recordsGroup.size() == 1) {
            this.insertOnce(recordsGroup, SessionConnection::insertRecords);
        } else {
            this.insertByGroup(recordsGroup, SessionConnection::insertRecords);
        }
    }

    private TSInsertStringRecordsReq filterAndGenTSInsertStringRecordsReq(List<String> prefixPaths, List<Long> time, List<List<String>> measurements, List<List<String>> values, boolean isAligned) {
        if (this.hasNull(values)) {
            values = this.changeToArrayListWithStringType(values);
            measurements = this.changeToArrayListWithStringType(measurements);
            prefixPaths = new ArrayList<String>(prefixPaths);
            time = new ArrayList<Long>(time);
            this.filterNullValueAndMeasurementWithStringType(prefixPaths, time, measurements, values);
        }
        return this.genTSInsertStringRecordsReq(prefixPaths, time, measurements, values, isAligned);
    }

    private List<List<String>> changeToArrayListWithStringType(List<List<String>> values) {
        if (!(values instanceof ArrayList)) {
            values = new ArrayList<List<String>>(values);
        }
        for (int i = 0; i < values.size(); ++i) {
            List<String> currentValue = values.get(i);
            if (currentValue instanceof ArrayList) continue;
            values.set(i, new ArrayList<String>(currentValue));
        }
        return values;
    }

    private List<List<Object>> changeToArrayList(List<List<Object>> values) {
        if (!(values instanceof ArrayList)) {
            values = new ArrayList<List<Object>>(values);
        }
        for (int i = 0; i < values.size(); ++i) {
            List<Object> currentValue = values.get(i);
            if (currentValue instanceof ArrayList) continue;
            values.set(i, new ArrayList<Object>(currentValue));
        }
        return values;
    }

    private List<List<TSDataType>> changeToArrayListWithTSDataType(List<List<TSDataType>> values) {
        if (!(values instanceof ArrayList)) {
            values = new ArrayList<List<TSDataType>>(values);
        }
        for (int i = 0; i < values.size(); ++i) {
            List<TSDataType> currentValue = values.get(i);
            if (currentValue instanceof ArrayList) continue;
            values.set(i, new ArrayList<TSDataType>(currentValue));
        }
        return values;
    }

    private TSInsertStringRecordsReq genTSInsertStringRecordsReq(List<String> prefixPaths, List<Long> time, List<List<String>> measurements, List<List<String>> values, boolean isAligned) {
        TSInsertStringRecordsReq request = new TSInsertStringRecordsReq();
        request.setPrefixPaths(prefixPaths);
        request.setTimestamps(time);
        request.setMeasurementsList(measurements);
        request.setValuesList(values);
        request.setIsAligned(isAligned);
        return request;
    }

    private void filterAndUpdateTSInsertStringRecordsReq(TSInsertStringRecordsReq request, String deviceId, long time, List<String> measurements, List<String> values) {
        boolean isAllValueNull;
        if (this.hasNull(values) && (isAllValueNull = this.filterNullValueAndMeasurementWithStringType(values = new ArrayList<String>(values), deviceId, measurements = new ArrayList<String>(measurements)))) {
            throw new NoValidValueException(ALL_INSERT_DATA_IS_NULL);
        }
        this.updateTSInsertStringRecordsReq(request, deviceId, time, measurements, values);
    }

    private void updateTSInsertStringRecordsReq(TSInsertStringRecordsReq request, String deviceId, long time, List<String> measurements, List<String> values) {
        request.addToPrefixPaths(deviceId);
        request.addToTimestamps(time);
        request.addToMeasurementsList(measurements);
        request.addToValuesList(values);
    }

    public void insertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        HashSet<String> deviceSet;
        int len = deviceIds.size();
        if (len != times.size() || len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException("deviceIds, times, measurementsList and valuesList's size should be equal");
        }
        if (this.enableRecordsAutoConvertTablet && len >= 40 && (double)(deviceSet = new HashSet<String>(deviceIds)).size() / (double)deviceIds.size() <= 0.5 && this.judgeConvertOfMultiDevice(deviceIds, measurementsList)) {
            this.convertToTabletsAndInsert(deviceIds, times, measurementsList, typesList, valuesList, deviceSet.size(), false);
            return;
        }
        if (this.enableRedirection) {
            this.insertRecordsWithLeaderCache(deviceIds, times, measurementsList, typesList, valuesList, false);
        } else {
            TSInsertRecordsReq request;
            try {
                request = this.filterAndGenTSInsertRecordsReq(deviceIds, times, measurementsList, typesList, valuesList, false);
            }
            catch (NoValidValueException e) {
                logger.warn(ALL_VALUES_ARE_NULL_MULTI_DEVICES, new Object[]{deviceIds, times, measurementsList});
                return;
            }
            try {
                this.getDefaultSessionConnection().insertRecords(request);
            }
            catch (RedirectException redirectException) {
                // empty catch block
            }
        }
    }

    public void insertAlignedRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        HashSet<String> deviceSet;
        int len = deviceIds.size();
        if (len != times.size() || len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException("prefixPaths, times, subMeasurementsList and valuesList's size should be equal");
        }
        if (this.enableRecordsAutoConvertTablet && len >= 40 && (double)(deviceSet = new HashSet<String>(deviceIds)).size() / (double)deviceIds.size() <= 0.5 && this.judgeConvertOfMultiDevice(deviceIds, measurementsList)) {
            this.convertToTabletsAndInsert(deviceIds, times, measurementsList, typesList, valuesList, deviceSet.size(), true);
            return;
        }
        if (this.enableRedirection) {
            this.insertRecordsWithLeaderCache(deviceIds, times, measurementsList, typesList, valuesList, true);
        } else {
            TSInsertRecordsReq request;
            try {
                request = this.filterAndGenTSInsertRecordsReq(deviceIds, times, measurementsList, typesList, valuesList, true);
            }
            catch (NoValidValueException e) {
                logger.warn(ALL_VALUES_ARE_NULL_MULTI_DEVICES, new Object[]{deviceIds, times, measurementsList});
                return;
            }
            try {
                this.getDefaultSessionConnection().insertRecords(request);
            }
            catch (RedirectException redirectException) {
                // empty catch block
            }
        }
    }

    public void insertRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        this.insertRecordsOfOneDevice(deviceId, times, measurementsList, typesList, valuesList, false);
    }

    public void insertRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList, boolean haveSorted) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertRecordsOfOneDeviceReq request;
        int len = times.size();
        if (len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException(VALUES_SIZE_SHOULD_BE_EQUAL);
        }
        if (this.enableRecordsAutoConvertTablet && len >= 40 && this.judgeConvertOfOneDevice(measurementsList)) {
            this.convertToTabletAndInsert(deviceId, times, measurementsList, typesList, valuesList, false);
            return;
        }
        try {
            request = this.filterAndGenTSInsertRecordsOfOneDeviceReq(deviceId, times, measurementsList, typesList, valuesList, haveSorted, false);
        }
        catch (NoValidValueException e) {
            logger.warn(ALL_VALUES_ARE_NULL_WITH_TIME, new Object[]{deviceId, times, measurementsList});
            return;
        }
        try {
            this.getSessionConnection(deviceId).insertRecordsOfOneDevice(request);
        }
        catch (RedirectException e) {
            this.handleRedirection(deviceId, e.getEndPoint());
        }
        catch (IoTDBConnectionException e) {
            if (this.enableRedirection && this.deviceIdToEndpoint != null && !this.deviceIdToEndpoint.isEmpty() && this.deviceIdToEndpoint.get(deviceId) != null) {
                logger.warn(SESSION_CANNOT_CONNECT, (Object)this.deviceIdToEndpoint.get(deviceId));
                this.deviceIdToEndpoint.remove(deviceId);
                try {
                    this.getDefaultSessionConnection().insertRecordsOfOneDevice(request);
                }
                catch (RedirectException redirectException) {}
            }
            throw e;
        }
    }

    public void insertStringRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList, boolean haveSorted) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertStringRecordsOfOneDeviceReq req;
        int len = times.size();
        if (len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException(VALUES_SIZE_SHOULD_BE_EQUAL);
        }
        try {
            req = this.filterAndGenTSInsertStringRecordsOfOneDeviceReq(deviceId, times, measurementsList, valuesList, haveSorted, false);
        }
        catch (NoValidValueException e) {
            logger.warn(ALL_VALUES_ARE_NULL_WITH_TIME, new Object[]{deviceId, times, measurementsList});
            return;
        }
        try {
            this.getSessionConnection(deviceId).insertStringRecordsOfOneDevice(req);
        }
        catch (RedirectException e) {
            this.handleRedirection(deviceId, e.getEndPoint());
        }
        catch (IoTDBConnectionException e) {
            if (this.enableRedirection && this.deviceIdToEndpoint != null && !this.deviceIdToEndpoint.isEmpty() && this.deviceIdToEndpoint.get(deviceId) != null) {
                logger.warn(SESSION_CANNOT_CONNECT, (Object)this.deviceIdToEndpoint.get(deviceId));
                this.deviceIdToEndpoint.remove(deviceId);
                try {
                    this.getDefaultSessionConnection().insertStringRecordsOfOneDevice(req);
                }
                catch (RedirectException redirectException) {}
            }
            throw e;
        }
    }

    public void insertStringRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        this.insertStringRecordsOfOneDevice(deviceId, times, measurementsList, valuesList, false);
    }

    public void insertAlignedRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        this.insertAlignedRecordsOfOneDevice(deviceId, times, measurementsList, typesList, valuesList, false);
    }

    public void insertAlignedRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList, boolean haveSorted) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertRecordsOfOneDeviceReq request;
        int len = times.size();
        if (len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException("times, subMeasurementsList and valuesList's size should be equal");
        }
        if (this.enableRecordsAutoConvertTablet && len >= 40 && this.judgeConvertOfOneDevice(measurementsList)) {
            this.convertToTabletAndInsert(deviceId, times, measurementsList, typesList, valuesList, true);
            return;
        }
        try {
            request = this.filterAndGenTSInsertRecordsOfOneDeviceReq(deviceId, times, measurementsList, typesList, valuesList, haveSorted, true);
        }
        catch (NoValidValueException e) {
            logger.warn(ALL_VALUES_ARE_NULL_WITH_TIME, new Object[]{deviceId, times, measurementsList});
            return;
        }
        try {
            this.getSessionConnection(deviceId).insertRecordsOfOneDevice(request);
        }
        catch (RedirectException e) {
            this.handleRedirection(deviceId, e.getEndPoint());
        }
        catch (IoTDBConnectionException e) {
            if (this.enableRedirection && this.deviceIdToEndpoint != null && !this.deviceIdToEndpoint.isEmpty() && this.deviceIdToEndpoint.get(deviceId) != null) {
                logger.warn(SESSION_CANNOT_CONNECT, (Object)this.deviceIdToEndpoint.get(deviceId));
                this.deviceIdToEndpoint.remove(deviceId);
                try {
                    this.getDefaultSessionConnection().insertRecordsOfOneDevice(request);
                }
                catch (RedirectException redirectException) {}
            }
            throw e;
        }
    }

    public void insertAlignedStringRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList, boolean haveSorted) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertStringRecordsOfOneDeviceReq req;
        int len = times.size();
        if (len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException(VALUES_SIZE_SHOULD_BE_EQUAL);
        }
        try {
            req = this.filterAndGenTSInsertStringRecordsOfOneDeviceReq(deviceId, times, measurementsList, valuesList, haveSorted, true);
        }
        catch (NoValidValueException e) {
            logger.warn(ALL_VALUES_ARE_NULL_WITH_TIME, new Object[]{deviceId, times, measurementsList});
            return;
        }
        try {
            this.getSessionConnection(deviceId).insertStringRecordsOfOneDevice(req);
        }
        catch (RedirectException e) {
            this.handleRedirection(deviceId, e.getEndPoint());
        }
        catch (IoTDBConnectionException e) {
            if (this.enableRedirection && this.deviceIdToEndpoint != null && !this.deviceIdToEndpoint.isEmpty() && this.deviceIdToEndpoint.get(deviceId) != null) {
                logger.warn(SESSION_CANNOT_CONNECT, (Object)this.deviceIdToEndpoint.get(deviceId));
                this.deviceIdToEndpoint.remove(deviceId);
                try {
                    this.getDefaultSessionConnection().insertStringRecordsOfOneDevice(req);
                }
                catch (RedirectException redirectException) {}
            }
            throw e;
        }
    }

    public void insertAlignedStringRecordsOfOneDevice(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        this.insertAlignedStringRecordsOfOneDevice(deviceId, times, measurementsList, valuesList, false);
    }

    private TSInsertRecordsOfOneDeviceReq filterAndGenTSInsertRecordsOfOneDeviceReq(String prefixPath, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList, boolean haveSorted, boolean isAligned) throws IoTDBConnectionException {
        if (this.hasNull(valuesList)) {
            measurementsList = this.changeToArrayListWithStringType(measurementsList);
            valuesList = this.changeToArrayList(valuesList);
            typesList = this.changeToArrayListWithTSDataType(typesList);
            times = new ArrayList<Long>(times);
            this.filterNullValueAndMeasurementOfOneDevice(prefixPath, times, measurementsList, typesList, valuesList);
        }
        return this.genTSInsertRecordsOfOneDeviceReq(prefixPath, times, measurementsList, typesList, valuesList, haveSorted, isAligned);
    }

    private TSInsertRecordsOfOneDeviceReq genTSInsertRecordsOfOneDeviceReq(String prefixPath, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList, boolean haveSorted, boolean isAligned) throws IoTDBConnectionException {
        int len = times.size();
        if (len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException(VALUES_SIZE_SHOULD_BE_EQUAL);
        }
        if (!this.checkSorted(times)) {
            Integer[] index = new Integer[times.size()];
            for (int i = 0; i < times.size(); ++i) {
                index[i] = i;
            }
            Arrays.sort(index, Comparator.comparingLong(times::get));
            times.sort(Long::compareTo);
            measurementsList = Session.sortList(measurementsList, index);
            typesList = Session.sortList(typesList, index);
            valuesList = Session.sortList(valuesList, index);
        }
        TSInsertRecordsOfOneDeviceReq request = new TSInsertRecordsOfOneDeviceReq();
        request.setPrefixPath(prefixPath);
        request.setTimestamps(times);
        request.setMeasurementsList(measurementsList);
        List<ByteBuffer> buffersList = this.objectValuesListToByteBufferList(valuesList, typesList, measurementsList);
        request.setValuesList(buffersList);
        request.setIsAligned(isAligned);
        return request;
    }

    private TSInsertStringRecordsOfOneDeviceReq filterAndGenTSInsertStringRecordsOfOneDeviceReq(String prefixPath, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList, boolean haveSorted, boolean isAligned) {
        if (this.hasNull(valuesList)) {
            measurementsList = this.changeToArrayListWithStringType(measurementsList);
            valuesList = this.changeToArrayListWithStringType(valuesList);
            times = new ArrayList<Long>(times);
            this.filterNullValueAndMeasurementWithStringTypeOfOneDevice(times, prefixPath, measurementsList, valuesList);
        }
        return this.genTSInsertStringRecordsOfOneDeviceReq(prefixPath, times, measurementsList, valuesList, haveSorted, isAligned);
    }

    private TSInsertStringRecordsOfOneDeviceReq genTSInsertStringRecordsOfOneDeviceReq(String prefixPath, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList, boolean haveSorted, boolean isAligned) {
        int len = times.size();
        if (len != measurementsList.size() || len != valuesList.size()) {
            throw new IllegalArgumentException(VALUES_SIZE_SHOULD_BE_EQUAL);
        }
        if (!this.checkSorted(times)) {
            Integer[] index = new Integer[times.size()];
            for (int i = 0; i < index.length; ++i) {
                index[i] = i;
            }
            Arrays.sort(index, Comparator.comparingLong(times::get));
            times.sort(Long::compareTo);
            measurementsList = Session.sortList(measurementsList, index);
            valuesList = Session.sortList(valuesList, index);
        }
        TSInsertStringRecordsOfOneDeviceReq req = new TSInsertStringRecordsOfOneDeviceReq();
        req.setPrefixPath(prefixPath);
        req.setTimestamps(times);
        req.setMeasurementsList(measurementsList);
        req.setValuesList(valuesList);
        req.setIsAligned(isAligned);
        return req;
    }

    private static <T> List<T> sortList(List<T> source, Integer[] index) {
        return Arrays.stream(index).map(source::get).collect(Collectors.toList());
    }

    private List<ByteBuffer> objectValuesListToByteBufferList(List<List<Object>> valuesList, List<List<TSDataType>> typesList, List<List<String>> measurementsList) throws IoTDBConnectionException {
        ArrayList<ByteBuffer> buffersList = new ArrayList<ByteBuffer>();
        for (int i = 0; i < valuesList.size(); ++i) {
            ByteBuffer buffer = SessionUtils.getValueBuffer(typesList.get(i), valuesList.get(i), measurementsList.get(i));
            buffersList.add(buffer);
        }
        return buffersList;
    }

    private void insertRecordsWithLeaderCache(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList, boolean isAligned) throws IoTDBConnectionException, StatementExecutionException {
        HashMap<SessionConnection, TSInsertRecordsReq> recordsGroup = new HashMap<SessionConnection, TSInsertRecordsReq>();
        for (int i = 0; i < deviceIds.size(); ++i) {
            SessionConnection connection = this.getSessionConnection(deviceIds.get(i));
            TSInsertRecordsReq request = recordsGroup.getOrDefault(connection, new TSInsertRecordsReq());
            request.setIsAligned(isAligned);
            try {
                this.filterAndUpdateTSInsertRecordsReq(request, deviceIds.get(i), times.get(i), measurementsList.get(i), typesList.get(i), valuesList.get(i));
                recordsGroup.putIfAbsent(connection, request);
                continue;
            }
            catch (NoValidValueException e) {
                logger.warn("All values are null and this submission is ignored,deviceId is [{}],time is [{}],measurements are [{}]", new Object[]{deviceIds.get(i), times.get(i), measurementsList.get(i)});
            }
        }
        if (recordsGroup.size() == 1) {
            this.insertOnce(recordsGroup, SessionConnection::insertRecords);
        } else {
            this.insertByGroup(recordsGroup, SessionConnection::insertRecords);
        }
    }

    private TSInsertRecordsReq filterAndGenTSInsertRecordsReq(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList, boolean isAligned) throws IoTDBConnectionException {
        if (this.hasNull(valuesList)) {
            measurementsList = this.changeToArrayListWithStringType(measurementsList);
            valuesList = this.changeToArrayList(valuesList);
            deviceIds = new ArrayList<String>(deviceIds);
            times = new ArrayList<Long>(times);
            typesList = this.changeToArrayListWithTSDataType(typesList);
            this.filterNullValueAndMeasurement(deviceIds, times, measurementsList, valuesList, typesList);
        }
        return this.genTSInsertRecordsReq(deviceIds, times, measurementsList, typesList, valuesList, isAligned);
    }

    private TSInsertRecordsReq genTSInsertRecordsReq(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList, boolean isAligned) throws IoTDBConnectionException {
        TSInsertRecordsReq request = new TSInsertRecordsReq();
        request.setPrefixPaths(deviceIds);
        request.setTimestamps(times);
        request.setMeasurementsList(measurementsList);
        request.setIsAligned(isAligned);
        List<ByteBuffer> buffersList = this.objectValuesListToByteBufferList(valuesList, typesList, measurementsList);
        request.setValuesList(buffersList);
        return request;
    }

    private void filterAndUpdateTSInsertRecordsReq(TSInsertRecordsReq request, String deviceId, Long time, List<String> measurements, List<TSDataType> types, List<Object> values) throws IoTDBConnectionException {
        boolean isAllValuesNull;
        if (this.hasNull(values) && (isAllValuesNull = this.filterNullValueAndMeasurement(deviceId, measurements = new ArrayList<String>(measurements), types = new ArrayList<TSDataType>(types), values = new ArrayList<Object>(values)))) {
            throw new NoValidValueException(ALL_INSERT_DATA_IS_NULL);
        }
        this.updateTSInsertRecordsReq(request, deviceId, time, measurements, types, values);
    }

    private void updateTSInsertRecordsReq(TSInsertRecordsReq request, String deviceId, Long time, List<String> measurements, List<TSDataType> types, List<Object> values) throws IoTDBConnectionException {
        request.addToPrefixPaths(deviceId);
        request.addToTimestamps(time.longValue());
        request.addToMeasurementsList(measurements);
        ByteBuffer buffer = SessionUtils.getValueBuffer(types, values, measurements);
        request.addToValuesList(buffer);
    }

    public void insertTablet(Tablet tablet) throws StatementExecutionException, IoTDBConnectionException {
        this.insertTablet(tablet, false);
    }

    public void insertTablet(Tablet tablet, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertTabletReq request = this.genTSInsertTabletReq(tablet, sorted, false);
        this.insertTabletInternal(tablet, request);
    }

    private void insertTabletInternal(Tablet tablet, TSInsertTabletReq request) throws IoTDBConnectionException, StatementExecutionException {
        try {
            this.getSessionConnection(tablet.getDeviceId()).insertTablet(request);
        }
        catch (RedirectException e) {
            this.handleRedirection(tablet.getDeviceId(), e.getEndPoint());
        }
        catch (IoTDBConnectionException e) {
            if (this.enableRedirection && this.deviceIdToEndpoint != null && !this.deviceIdToEndpoint.isEmpty() && this.deviceIdToEndpoint.get(tablet.getDeviceId()) != null) {
                logger.warn(SESSION_CANNOT_CONNECT, (Object)this.deviceIdToEndpoint.get(tablet.getDeviceId()));
                this.deviceIdToEndpoint.remove(tablet.getDeviceId());
                try {
                    this.getDefaultSessionConnection().insertTablet(request);
                }
                catch (RedirectException redirectException) {}
            }
            throw e;
        }
    }

    public void insertRelationalTablet(Tablet tablet) throws IoTDBConnectionException, StatementExecutionException {
        if (tablet.getRowSize() == 0) {
            return;
        }
        if (this.enableRedirection) {
            this.insertRelationalTabletWithLeaderCache(tablet);
        } else {
            TSInsertTabletReq request = this.genTSInsertTabletReq(tablet, false, false);
            request.setWriteToTable(true);
            request.setColumnCategories(tablet.getColumnTypes().stream().map(t -> (byte)t.ordinal()).collect(Collectors.toList()));
            try {
                this.getDefaultSessionConnection().insertTablet(request);
            }
            catch (RedirectException redirectException) {
                // empty catch block
            }
        }
    }

    private void insertRelationalTabletWithLeaderCache(Tablet tablet) throws IoTDBConnectionException, StatementExecutionException {
        HashMap<SessionConnection, Tablet> relationalTabletGroup = new HashMap<SessionConnection, Tablet>();
        if (this.tableModelDeviceIdToEndpoint.isEmpty()) {
            relationalTabletGroup.put(this.getDefaultSessionConnection(), tablet);
        } else if (SessionUtils.isTabletContainsSingleDevice(tablet)) {
            relationalTabletGroup.put(this.getSessionConnection(tablet.getDeviceID(0)), tablet);
        } else {
            int i = 0;
            while (i < tablet.getRowSize()) {
                IDeviceID iDeviceID = tablet.getDeviceID(i);
                SessionConnection connection = this.getSessionConnection(iDeviceID);
                int finalI = i++;
                relationalTabletGroup.compute(connection, (k, v) -> {
                    if (v == null) {
                        ArrayList measurements = new ArrayList(tablet.getSchemas().size());
                        ArrayList dataTypes = new ArrayList();
                        tablet.getSchemas().forEach(schema -> {
                            measurements.add(schema.getMeasurementName());
                            dataTypes.add(schema.getType());
                        });
                        v = new Tablet(tablet.getTableName(), measurements, dataTypes, tablet.getColumnTypes(), tablet.getRowSize());
                    }
                    for (int j = 0; j < v.getSchemas().size(); ++j) {
                        v.addValue(((IMeasurementSchema)v.getSchemas().get(j)).getMeasurementName(), v.getRowSize(), tablet.getValue(finalI, j));
                    }
                    v.addTimestamp(v.getRowSize(), tablet.getTimestamp(finalI));
                    return v;
                });
            }
        }
        if (relationalTabletGroup.size() == 1) {
            this.insertRelationalTabletOnce(relationalTabletGroup);
        } else {
            this.insertRelationalTabletByGroup(relationalTabletGroup);
        }
    }

    private void insertRelationalTabletOnce(Map<SessionConnection, Tablet> relationalTabletGroup) throws IoTDBConnectionException, StatementExecutionException {
        Map.Entry<SessionConnection, Tablet> entry = relationalTabletGroup.entrySet().iterator().next();
        SessionConnection connection = entry.getKey();
        Tablet tablet = entry.getValue();
        TSInsertTabletReq request = this.genTSInsertTabletReq(tablet, false, false);
        request.setWriteToTable(true);
        request.setColumnCategories(tablet.getColumnTypes().stream().map(t -> (byte)t.ordinal()).collect(Collectors.toList()));
        try {
            connection.insertTablet(request);
        }
        catch (RedirectException e) {
            List endPointList = e.getEndPointList();
            HashMap<IDeviceID, TEndPoint> endPointMap = new HashMap<IDeviceID, TEndPoint>();
            for (int i = 0; i < endPointList.size(); ++i) {
                if (endPointList.get(i) == null) continue;
                endPointMap.put(tablet.getDeviceID(i), (TEndPoint)endPointList.get(i));
            }
            endPointMap.forEach(this::handleRedirection);
        }
        catch (IoTDBConnectionException e) {
            if (this.endPointToSessionConnection != null && this.endPointToSessionConnection.size() > 1) {
                this.removeBrokenSessionConnection(connection);
                try {
                    this.getDefaultSessionConnection().insertTablet(request);
                }
                catch (RedirectException redirectException) {}
            }
            throw e;
        }
    }

    private void insertRelationalTabletByGroup(Map<SessionConnection, Tablet> relationalTabletGroup) throws IoTDBConnectionException, StatementExecutionException {
        List completableFutures = relationalTabletGroup.entrySet().stream().map(entry -> {
            SessionConnection connection = (SessionConnection)entry.getKey();
            Tablet subTablet = (Tablet)entry.getValue();
            return CompletableFuture.runAsync(() -> {
                TSInsertTabletReq request = this.genTSInsertTabletReq(subTablet, false, false);
                request.setWriteToTable(true);
                request.setColumnCategories(subTablet.getColumnTypes().stream().map(t -> (byte)t.ordinal()).collect(Collectors.toList()));
                InsertConsumer<TSInsertTabletReq> insertConsumer = SessionConnection::insertTablet;
                try {
                    insertConsumer.insert(connection, request);
                }
                catch (RedirectException e) {
                    List endPointList = e.getEndPointList();
                    HashMap<IDeviceID, TEndPoint> endPointMap = new HashMap<IDeviceID, TEndPoint>();
                    for (int i = 0; i < endPointList.size(); ++i) {
                        if (endPointList.get(i) == null) continue;
                        endPointMap.put(subTablet.getDeviceID(i), (TEndPoint)endPointList.get(i));
                    }
                    endPointMap.forEach(this::handleRedirection);
                }
                catch (StatementExecutionException e) {
                    throw new CompletionException(e);
                }
                catch (IoTDBConnectionException e) {
                    this.removeBrokenSessionConnection(connection);
                    try {
                        insertConsumer.insert(this.getDefaultSessionConnection(), request);
                    }
                    catch (IoTDBConnectionException | StatementExecutionException ex) {
                        throw new CompletionException(ex);
                    }
                    catch (RedirectException redirectException) {
                        // empty catch block
                    }
                }
            }, OPERATION_EXECUTOR);
        }).collect(Collectors.toList());
        StringBuilder errMsgBuilder = new StringBuilder();
        for (CompletableFuture completableFuture : completableFutures) {
            try {
                completableFuture.join();
            }
            catch (CompletionException completionException) {
                Throwable cause = completionException.getCause();
                logger.error("Meet error when async insert!", cause);
                if (cause instanceof IoTDBConnectionException) {
                    throw (IoTDBConnectionException)cause;
                }
                if (errMsgBuilder.length() > 0) {
                    errMsgBuilder.append(";");
                }
                errMsgBuilder.append(cause.getMessage());
            }
        }
        if (errMsgBuilder.length() > 0) {
            throw new StatementExecutionException(errMsgBuilder.toString());
        }
    }

    public void insertAlignedTablet(Tablet tablet) throws StatementExecutionException, IoTDBConnectionException {
        this.insertAlignedTablet(tablet, false);
    }

    public void insertAlignedTablet(Tablet tablet, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertTabletReq request = this.genTSInsertTabletReq(tablet, sorted, true);
        try {
            this.getSessionConnection(tablet.getDeviceId()).insertTablet(request);
        }
        catch (RedirectException e) {
            this.handleRedirection(tablet.getDeviceId(), e.getEndPoint());
        }
        catch (IoTDBConnectionException e) {
            if (this.enableRedirection && this.deviceIdToEndpoint != null && !this.deviceIdToEndpoint.isEmpty() && this.deviceIdToEndpoint.get(tablet.getDeviceId()) != null) {
                logger.warn(SESSION_CANNOT_CONNECT, (Object)this.deviceIdToEndpoint.get(tablet.getDeviceId()));
                this.deviceIdToEndpoint.remove(tablet.getDeviceId());
                try {
                    this.getDefaultSessionConnection().insertTablet(request);
                }
                catch (RedirectException redirectException) {}
            }
            throw e;
        }
    }

    private TSInsertTabletReq genTSInsertTabletReq(Tablet tablet, boolean sorted, boolean isAligned) {
        if (!this.checkSorted(tablet)) {
            this.sortTablet(tablet);
        }
        TSInsertTabletReq request = new TSInsertTabletReq();
        for (IMeasurementSchema measurementSchema : tablet.getSchemas()) {
            if (measurementSchema.getMeasurementName() == null) {
                throw new IllegalArgumentException("measurement should be non null value");
            }
            request.addToMeasurements(measurementSchema.getMeasurementName());
            request.addToTypes(measurementSchema.getType().ordinal());
        }
        request.setPrefixPath(tablet.getDeviceId());
        request.setIsAligned(isAligned);
        request.setTimestamps(SessionUtils.getTimeBuffer(tablet));
        request.setValues(SessionUtils.getValueBuffer(tablet));
        request.setSize(tablet.getRowSize());
        return request;
    }

    public void insertTablets(Map<String, Tablet> tablets) throws IoTDBConnectionException, StatementExecutionException {
        this.insertTablets(tablets, false);
    }

    public void insertTablets(Map<String, Tablet> tablets, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        if (this.enableRedirection) {
            this.insertTabletsWithLeaderCache(tablets, sorted, false);
        } else {
            TSInsertTabletsReq request = this.genTSInsertTabletsReq(new ArrayList<Tablet>(tablets.values()), sorted, false);
            try {
                this.getDefaultSessionConnection().insertTablets(request);
            }
            catch (RedirectException redirectException) {
                // empty catch block
            }
        }
    }

    public void insertAlignedTablets(Map<String, Tablet> tablets) throws IoTDBConnectionException, StatementExecutionException {
        this.insertAlignedTablets(tablets, false);
    }

    public void insertAlignedTablets(Map<String, Tablet> tablets, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        if (this.enableRedirection) {
            this.insertTabletsWithLeaderCache(tablets, sorted, true);
        } else {
            TSInsertTabletsReq request = this.genTSInsertTabletsReq(new ArrayList<Tablet>(tablets.values()), sorted, true);
            try {
                this.getDefaultSessionConnection().insertTablets(request);
            }
            catch (RedirectException redirectException) {
                // empty catch block
            }
        }
    }

    private void insertTabletsWithLeaderCache(Map<String, Tablet> tablets, boolean sorted, boolean isAligned) throws IoTDBConnectionException, StatementExecutionException {
        HashMap<SessionConnection, TSInsertTabletsReq> tabletGroup = new HashMap<SessionConnection, TSInsertTabletsReq>();
        for (Map.Entry<String, Tablet> entry : tablets.entrySet()) {
            SessionConnection connection = this.getSessionConnection(entry.getKey());
            TSInsertTabletsReq request = tabletGroup.computeIfAbsent(connection, k -> new TSInsertTabletsReq());
            this.updateTSInsertTabletsReq(request, entry.getValue(), sorted, isAligned);
        }
        if (tabletGroup.size() == 1) {
            this.insertOnce(tabletGroup, SessionConnection::insertTablets);
        } else {
            this.insertByGroup(tabletGroup, SessionConnection::insertTablets);
        }
    }

    private TSInsertTabletsReq genTSInsertTabletsReq(List<Tablet> tablets, boolean sorted, boolean isAligned) throws BatchExecutionException {
        TSInsertTabletsReq request = new TSInsertTabletsReq();
        if (tablets.isEmpty()) {
            throw new BatchExecutionException("No tablet is inserting!");
        }
        for (Tablet tablet : tablets) {
            this.updateTSInsertTabletsReq(request, tablet, sorted, isAligned);
        }
        return request;
    }

    private void updateTSInsertTabletsReq(TSInsertTabletsReq request, Tablet tablet, boolean sorted, boolean isAligned) {
        if (!this.checkSorted(tablet)) {
            this.sortTablet(tablet);
        }
        request.addToPrefixPaths(tablet.getDeviceId());
        ArrayList<String> measurements = new ArrayList<String>();
        ArrayList<Integer> dataTypes = new ArrayList<Integer>();
        request.setIsAligned(isAligned);
        for (IMeasurementSchema measurementSchema : tablet.getSchemas()) {
            if (measurementSchema.getMeasurementName() == null) {
                throw new IllegalArgumentException("measurement should be non null value");
            }
            measurements.add(measurementSchema.getMeasurementName());
            dataTypes.add(measurementSchema.getType().ordinal());
        }
        request.addToMeasurementsList(measurements);
        request.addToTypesList(dataTypes);
        request.addToTimestampsList(SessionUtils.getTimeBuffer(tablet));
        request.addToValuesList(SessionUtils.getValueBuffer(tablet));
        request.addToSizeList(tablet.getRowSize());
    }

    private boolean judgeConvertOfOneDevice(List<List<String>> measurementsList) {
        int i;
        int size = measurementsList.size();
        int sampleNum = (int)((double)size * 0.05);
        List indexList = ThreadLocalRandom.current().ints(0, size).distinct().limit(sampleNum).boxed().collect(Collectors.toList());
        HashSet allMeasurement = new HashSet(measurementsList.get((Integer)indexList.get(0)).size() + 1, 1.0f);
        for (i = 0; i < sampleNum; ++i) {
            allMeasurement.addAll(measurementsList.get((Integer)indexList.get(i)));
        }
        for (i = 0; i < sampleNum; ++i) {
            if (!((double)measurementsList.get((Integer)indexList.get(i)).size() / (double)allMeasurement.size() < 0.5)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void convertToTabletAndInsert(String deviceId, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList, boolean isAligned) throws IoTDBConnectionException, StatementExecutionException {
        void var10_15;
        HashMap<String, Pair<TSDataType, Boolean>> measuremenMap = new HashMap<String, Pair<TSDataType, Boolean>>(measurementsList.get(0).size() + 1, 1.0f);
        for (int rowIndex = 0; rowIndex < measurementsList.size(); ++rowIndex) {
            List<String> measurements = measurementsList.get(rowIndex);
            List<TSDataType> list = typesList.get(rowIndex);
            for (int colIndex = 0; colIndex < measurements.size(); ++colIndex) {
                String measurement = (String)measurements.get(colIndex);
                if (measuremenMap.containsKey(measurement)) continue;
                measuremenMap.put(measurement, new Pair((Object)list.get(colIndex), (Object)true));
            }
        }
        ArrayList<MeasurementSchema> schemaList = new ArrayList<MeasurementSchema>(measuremenMap.size());
        for (Map.Entry entry : measuremenMap.entrySet()) {
            schemaList.add(new MeasurementSchema((String)entry.getKey(), (TSDataType)((Pair)entry.getValue()).getLeft()));
        }
        Tablet tablet = new Tablet(deviceId, schemaList, times.size());
        boolean bl = false;
        while (var10_15 < times.size()) {
            this.addRecordToTablet(tablet, times.get((int)var10_15), measurementsList.get((int)var10_15), valuesList.get((int)var10_15), measuremenMap);
            ++var10_15;
        }
        if (isAligned) {
            this.insertAlignedTablet(tablet);
        } else {
            this.insertTablet(tablet);
        }
    }

    private boolean judgeConvertOfMultiDevice(List<String> deviceIds, List<List<String>> measurementsList) {
        int index;
        int i;
        int size = deviceIds.size();
        int sampleNum = (int)((double)size * 0.05);
        HashMap<String, Set> measurementMap = new HashMap<String, Set>(sampleNum + 1, 1.0f);
        List indexList = ThreadLocalRandom.current().ints(0, size).distinct().limit(sampleNum).boxed().collect(Collectors.toList());
        for (i = 0; i < sampleNum; ++i) {
            index = (Integer)indexList.get(i);
            List<String> measurements = measurementsList.get(index);
            Set allMeasurement = measurementMap.computeIfAbsent(deviceIds.get(index), k -> new HashSet(measurements.size() + 1, 1.0f));
            allMeasurement.addAll(measurements);
        }
        for (i = 0; i < sampleNum; ++i) {
            index = (Integer)indexList.get(i);
            Set allMeasurement = (Set)measurementMap.get(deviceIds.get(index));
            if (!((double)measurementsList.get(index).size() / (double)allMeasurement.size() < 0.5)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void convertToTabletsAndInsert(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList, int deviceSize, boolean isAligned) throws IoTDBConnectionException, StatementExecutionException {
        void var12_17;
        HashMap<String, Map> deviceMeasuremenMap = new HashMap<String, Map>(deviceSize + 1, 1.0f);
        HashMap<Object, Integer> rowMap = new HashMap<Object, Integer>(deviceSize + 1, 1.0f);
        for (int rowIndex = 0; rowIndex < deviceIds.size(); ++rowIndex) {
            String device = deviceIds.get(rowIndex);
            List<String> list = measurementsList.get(rowIndex);
            List<TSDataType> types = typesList.get(rowIndex);
            Map measurementMap = deviceMeasuremenMap.computeIfAbsent(device, k -> new HashMap(measurements.size() + 1, 1.0f));
            for (int i = 0; i < list.size(); ++i) {
                String measurement = list.get(i);
                if (measurementMap.containsKey(measurement)) continue;
                measurementMap.put(measurement, new Pair((Object)types.get(i), (Object)true));
            }
            rowMap.merge(device, 1, Integer::sum);
        }
        HashMap schemaMap = new HashMap(deviceSize + 1, 1.0f);
        for (Map.Entry entry : deviceMeasuremenMap.entrySet()) {
            ArrayList<MeasurementSchema> schemaList = new ArrayList<MeasurementSchema>(((Map)entry.getValue()).size() + 1);
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                schemaList.add(new MeasurementSchema((String)entry2.getKey(), (TSDataType)((Pair)entry2.getValue()).getLeft()));
            }
            schemaMap.put((String)entry.getKey(), schemaList);
        }
        HashMap<String, Tablet> tablets = new HashMap<String, Tablet>(deviceSize + 1, 1.0f);
        boolean bl = false;
        while (var12_17 < deviceIds.size()) {
            String device = deviceIds.get((int)var12_17);
            Tablet tablet = tablets.computeIfAbsent(device, k -> new Tablet(device, (List)schemaMap.get(device), ((Integer)rowMap.get(device)).intValue()));
            this.addRecordToTablet(tablet, times.get((int)var12_17), measurementsList.get((int)var12_17), valuesList.get((int)var12_17), (Map)deviceMeasuremenMap.get(device));
            ++var12_17;
        }
        if (isAligned) {
            this.insertAlignedTablets(tablets);
        } else {
            this.insertTablets(tablets);
        }
    }

    private void addRecordToTablet(Tablet tablet, Long timestamp, List<String> measurements, List<Object> values, Map<String, Pair<TSDataType, Boolean>> allMeasurementMap) {
        int row = tablet.getRowSize();
        tablet.addTimestamp(row, timestamp.longValue());
        if (measurements.size() == allMeasurementMap.size()) {
            for (int i = 0; i < measurements.size(); ++i) {
                tablet.addValue(measurements.get(i), row, values.get(i));
            }
            return;
        }
        for (int i = 0; i < measurements.size(); ++i) {
            String measurement = measurements.get(i);
            tablet.addValue(measurement, row, values.get(i));
            allMeasurementMap.get(measurement).setRight((Object)false);
        }
        for (Map.Entry<String, Pair<TSDataType, Boolean>> entry : allMeasurementMap.entrySet()) {
            if (((Boolean)entry.getValue().getRight()).booleanValue()) {
                tablet.addValue(entry.getKey(), row, null);
                continue;
            }
            entry.getValue().setRight((Object)true);
        }
    }

    public void testInsertTablet(Tablet tablet) throws IoTDBConnectionException, StatementExecutionException {
        this.testInsertTablet(tablet, false);
    }

    public void testInsertTablet(Tablet tablet, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertTabletReq request = this.genTSInsertTabletReq(tablet, sorted, false);
        this.getDefaultSessionConnection().testInsertTablet(request);
    }

    public void testInsertTablets(Map<String, Tablet> tablets) throws IoTDBConnectionException, StatementExecutionException {
        this.testInsertTablets(tablets, false);
    }

    public void testInsertTablets(Map<String, Tablet> tablets, boolean sorted) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertTabletsReq request = this.genTSInsertTabletsReq(new ArrayList<Tablet>(tablets.values()), sorted, false);
        this.getDefaultSessionConnection().testInsertTablets(request);
    }

    public void testInsertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<String>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertStringRecordsReq request;
        try {
            request = this.filterAndGenTSInsertStringRecordsReq(deviceIds, times, measurementsList, valuesList, false);
        }
        catch (NoValidValueException e) {
            logger.warn(ALL_VALUES_ARE_NULL_MULTI_DEVICES, new Object[]{deviceIds, times, measurementsList});
            return;
        }
        this.getDefaultSessionConnection().testInsertRecords(request);
    }

    public void testInsertRecords(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<TSDataType>> typesList, List<List<Object>> valuesList) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertRecordsReq request;
        try {
            request = this.filterAndGenTSInsertRecordsReq(deviceIds, times, measurementsList, typesList, valuesList, false);
        }
        catch (NoValidValueException e) {
            logger.warn(ALL_VALUES_ARE_NULL_MULTI_DEVICES, new Object[]{deviceIds, times, measurementsList});
            return;
        }
        this.getDefaultSessionConnection().testInsertRecords(request);
    }

    public void testInsertRecord(String deviceId, long time, List<String> measurements, List<String> values) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertStringRecordReq request;
        try {
            request = this.filterAndGenTSInsertStringRecordReq(deviceId, time, measurements, values, false);
        }
        catch (NoValidValueException e) {
            logger.warn(ALL_VALUES_ARE_NULL, new Object[]{deviceId, time, measurements});
            return;
        }
        this.getDefaultSessionConnection().testInsertRecord(request);
    }

    public void testInsertRecord(String deviceId, long time, List<String> measurements, List<TSDataType> types, List<Object> values) throws IoTDBConnectionException, StatementExecutionException {
        TSInsertRecordReq request;
        try {
            request = this.filterAndGenTSInsertRecordReq(deviceId, time, measurements, types, values, false);
        }
        catch (NoValidValueException e) {
            logger.warn(ALL_VALUES_ARE_NULL, new Object[]{deviceId, time, measurements});
            return;
        }
        this.getDefaultSessionConnection().testInsertRecord(request);
    }

    public void deleteTimeseries(String path) throws IoTDBConnectionException, StatementExecutionException {
        this.getDefaultSessionConnection().deleteTimeseries(Collections.singletonList(path));
    }

    public void deleteTimeseries(List<String> paths) throws IoTDBConnectionException, StatementExecutionException {
        this.getDefaultSessionConnection().deleteTimeseries(paths);
    }

    public void deleteData(String path, long endTime) throws IoTDBConnectionException, StatementExecutionException {
        this.deleteData(Collections.singletonList(path), Long.MIN_VALUE, endTime);
    }

    public void deleteData(List<String> paths, long endTime) throws IoTDBConnectionException, StatementExecutionException {
        this.deleteData(paths, Long.MIN_VALUE, endTime);
    }

    public void deleteData(List<String> paths, long startTime, long endTime) throws IoTDBConnectionException, StatementExecutionException {
        TSDeleteDataReq request = this.genTSDeleteDataReq(paths, startTime, endTime);
        this.getDefaultSessionConnection().deleteData(request);
    }

    private TSDeleteDataReq genTSDeleteDataReq(List<String> paths, long startTime, long endTime) {
        TSDeleteDataReq request = new TSDeleteDataReq();
        request.setPaths(paths);
        request.setStartTime(startTime);
        request.setEndTime(endTime);
        return request;
    }

    private boolean checkSorted(Tablet tablet) {
        for (int i = 1; i < tablet.getRowSize(); ++i) {
            if (tablet.getTimestamp(i) >= tablet.getTimestamp(i - 1)) continue;
            return false;
        }
        return true;
    }

    private boolean checkSorted(List<Long> times) {
        for (int i = 1; i < times.size(); ++i) {
            if (times.get(i) >= times.get(i - 1)) continue;
            return false;
        }
        return true;
    }

    public void sortTablet(Tablet tablet) {
        long[] timestamps = tablet.getTimestamps();
        Object[] values = tablet.getValues();
        BitMap[] bitMaps = tablet.getBitMaps();
        Integer[] index = new Integer[tablet.getRowSize()];
        for (int i = 0; i < tablet.getRowSize(); ++i) {
            index[i] = i;
        }
        Arrays.sort(index, Comparator.comparingLong(o -> timestamps[o]));
        Arrays.sort(timestamps, 0, tablet.getRowSize());
        int columnIndex = 0;
        for (int i = 0; i < tablet.getSchemas().size(); ++i) {
            IMeasurementSchema schema = (IMeasurementSchema)tablet.getSchemas().get(i);
            if (schema instanceof MeasurementSchema) {
                values[columnIndex] = this.sortList(values[columnIndex], schema.getType(), index);
                if (bitMaps != null && bitMaps[columnIndex] != null) {
                    bitMaps[columnIndex] = this.sortBitMap(bitMaps[columnIndex], index);
                }
                ++columnIndex;
                continue;
            }
            int measurementSize = schema.getSubMeasurementsList().size();
            for (int j = 0; j < measurementSize; ++j) {
                values[columnIndex] = this.sortList(values[columnIndex], (TSDataType)schema.getSubMeasurementsTSDataTypeList().get(j), index);
                if (bitMaps != null && bitMaps[columnIndex] != null) {
                    bitMaps[columnIndex] = this.sortBitMap(bitMaps[columnIndex], index);
                }
                ++columnIndex;
            }
        }
    }

    private Object sortList(Object valueList, TSDataType dataType, Integer[] index) {
        switch (dataType) {
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])valueList;
                boolean[] sortedValues = new boolean[boolValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedValues[i] = boolValues[index[i]];
                }
                return sortedValues;
            }
            case INT32: {
                int[] intValues = (int[])valueList;
                int[] sortedIntValues = new int[intValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedIntValues[i] = intValues[index[i]];
                }
                return sortedIntValues;
            }
            case DATE: {
                LocalDate[] date = (LocalDate[])valueList;
                LocalDate[] sortedDateValues = new LocalDate[date.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedDateValues[i] = date[index[i]];
                }
                return sortedDateValues;
            }
            case INT64: 
            case TIMESTAMP: {
                long[] longValues = (long[])valueList;
                long[] sortedLongValues = new long[longValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedLongValues[i] = longValues[index[i]];
                }
                return sortedLongValues;
            }
            case FLOAT: {
                float[] floatValues = (float[])valueList;
                float[] sortedFloatValues = new float[floatValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedFloatValues[i] = floatValues[index[i]];
                }
                return sortedFloatValues;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])valueList;
                double[] sortedDoubleValues = new double[doubleValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedDoubleValues[i] = doubleValues[index[i]];
                }
                return sortedDoubleValues;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                Binary[] binaryValues = (Binary[])valueList;
                Binary[] sortedBinaryValues = new Binary[binaryValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedBinaryValues[i] = binaryValues[index[i]];
                }
                return sortedBinaryValues;
            }
        }
        throw new UnSupportedDataTypeException(MSG_UNSUPPORTED_DATA_TYPE + dataType);
    }

    private BitMap sortBitMap(BitMap bitMap, Integer[] index) {
        BitMap sortedBitMap = new BitMap(bitMap.getSize());
        for (int i = 0; i < index.length; ++i) {
            if (!bitMap.isMarked(index[i].intValue())) continue;
            sortedBitMap.mark(i);
        }
        return sortedBitMap;
    }

    public void setSchemaTemplate(String templateName, String prefixPath) throws IoTDBConnectionException, StatementExecutionException {
        TSSetSchemaTemplateReq request = this.getTSSetSchemaTemplateReq(templateName, prefixPath);
        this.getDefaultSessionConnection().setSchemaTemplate(request);
    }

    public void createSchemaTemplate(Template template) throws IOException, IoTDBConnectionException, StatementExecutionException {
        TSCreateSchemaTemplateReq req = new TSCreateSchemaTemplateReq();
        req.setName(template.getName());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        template.serialize((OutputStream)baos);
        req.setSerializedTemplate(baos.toByteArray());
        baos.close();
        this.getDefaultSessionConnection().createSchemaTemplate(req);
    }

    public void createSchemaTemplate(String templateName, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, boolean isAligned) throws IOException, IoTDBConnectionException, StatementExecutionException {
        Template temp = new Template(templateName, isAligned);
        int len = measurements.size();
        if (len != dataTypes.size() || len != encodings.size() || len != compressors.size()) {
            throw new StatementExecutionException("Different length of measurements, datatypes, encodings or compressors when create device template.");
        }
        for (int idx = 0; idx < measurements.size(); ++idx) {
            MeasurementNode mNode = new MeasurementNode(measurements.get(idx), dataTypes.get(idx), encodings.get(idx), compressors.get(idx));
            temp.addToTemplate((TemplateNode)mNode);
        }
        this.createSchemaTemplate(temp);
    }

    @Deprecated
    public void createSchemaTemplate(String name, List<String> schemaNames, List<List<String>> measurements, List<List<TSDataType>> dataTypes, List<List<TSEncoding>> encodings, List<CompressionType> compressors) throws IoTDBConnectionException, StatementExecutionException {
        ArrayList<String> flatMeasurements = new ArrayList<String>();
        ArrayList<TSDataType> flatDataTypes = new ArrayList<TSDataType>();
        ArrayList<TSEncoding> flatEncodings = new ArrayList<TSEncoding>();
        for (int idx = 0; idx < measurements.size(); ++idx) {
            flatMeasurements.add(measurements.get(idx).get(0));
            flatDataTypes.add(dataTypes.get(idx).get(0));
            flatEncodings.add(encodings.get(idx).get(0));
        }
        try {
            this.createSchemaTemplate(name, flatMeasurements, flatDataTypes, flatEncodings, compressors, false);
        }
        catch (IOException e) {
            throw new StatementExecutionException(e.getMessage());
        }
    }

    public void addAlignedMeasurementsInTemplate(String templateName, List<String> measurementsPath, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors) throws IOException, IoTDBConnectionException, StatementExecutionException {
        TSAppendSchemaTemplateReq req = new TSAppendSchemaTemplateReq();
        req.setName(templateName);
        req.setMeasurements(measurementsPath);
        req.setDataTypes(dataTypes.stream().map(Enum::ordinal).collect(Collectors.toList()));
        req.setEncodings(encodings.stream().map(Enum::ordinal).collect(Collectors.toList()));
        req.setCompressors(compressors.stream().map(i -> i.serialize()).collect(Collectors.toList()));
        req.setIsAligned(true);
        this.getDefaultSessionConnection().appendSchemaTemplate(req);
    }

    public void addAlignedMeasurementInTemplate(String templateName, String measurementPath, TSDataType dataType, TSEncoding encoding, CompressionType compressor) throws IOException, IoTDBConnectionException, StatementExecutionException {
        TSAppendSchemaTemplateReq req = new TSAppendSchemaTemplateReq();
        req.setName(templateName);
        req.setMeasurements(Collections.singletonList(measurementPath));
        req.setDataTypes(Collections.singletonList(dataType.ordinal()));
        req.setEncodings(Collections.singletonList(encoding.ordinal()));
        req.setCompressors(Collections.singletonList(Integer.valueOf(compressor.serialize())));
        req.setIsAligned(true);
        this.getDefaultSessionConnection().appendSchemaTemplate(req);
    }

    public void addUnalignedMeasurementsInTemplate(String templateName, List<String> measurementsPath, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors) throws IOException, IoTDBConnectionException, StatementExecutionException {
        TSAppendSchemaTemplateReq req = new TSAppendSchemaTemplateReq();
        req.setName(templateName);
        req.setMeasurements(measurementsPath);
        req.setDataTypes(dataTypes.stream().map(Enum::ordinal).collect(Collectors.toList()));
        req.setEncodings(encodings.stream().map(Enum::ordinal).collect(Collectors.toList()));
        req.setCompressors(compressors.stream().map(i -> i.serialize()).collect(Collectors.toList()));
        req.setIsAligned(false);
        this.getDefaultSessionConnection().appendSchemaTemplate(req);
    }

    public void addUnalignedMeasurementInTemplate(String templateName, String measurementPath, TSDataType dataType, TSEncoding encoding, CompressionType compressor) throws IOException, IoTDBConnectionException, StatementExecutionException {
        TSAppendSchemaTemplateReq req = new TSAppendSchemaTemplateReq();
        req.setName(templateName);
        req.setMeasurements(Collections.singletonList(measurementPath));
        req.setDataTypes(Collections.singletonList(dataType.ordinal()));
        req.setEncodings(Collections.singletonList(encoding.ordinal()));
        req.setCompressors(Collections.singletonList(Integer.valueOf(compressor.serialize())));
        req.setIsAligned(false);
        this.getDefaultSessionConnection().appendSchemaTemplate(req);
    }

    public void deleteNodeInTemplate(String templateName, String path) throws IOException, IoTDBConnectionException, StatementExecutionException {
        TSPruneSchemaTemplateReq req = new TSPruneSchemaTemplateReq();
        req.setName(templateName);
        req.setPath(path);
        this.getDefaultSessionConnection().pruneSchemaTemplate(req);
    }

    public int countMeasurementsInTemplate(String name) throws StatementExecutionException, IoTDBConnectionException {
        TSQueryTemplateReq req = new TSQueryTemplateReq();
        req.setName(name);
        req.setQueryType(TemplateQueryType.COUNT_MEASUREMENTS.ordinal());
        TSQueryTemplateResp resp = this.getDefaultSessionConnection().querySchemaTemplate(req);
        return resp.getCount();
    }

    public boolean isMeasurementInTemplate(String templateName, String path) throws StatementExecutionException, IoTDBConnectionException {
        TSQueryTemplateReq req = new TSQueryTemplateReq();
        req.setName(templateName);
        req.setQueryType(TemplateQueryType.IS_MEASUREMENT.ordinal());
        req.setMeasurement(path);
        TSQueryTemplateResp resp = this.getDefaultSessionConnection().querySchemaTemplate(req);
        return resp.result;
    }

    public boolean isPathExistInTemplate(String templateName, String path) throws StatementExecutionException, IoTDBConnectionException {
        TSQueryTemplateReq req = new TSQueryTemplateReq();
        req.setName(templateName);
        req.setQueryType(TemplateQueryType.PATH_EXIST.ordinal());
        req.setMeasurement(path);
        TSQueryTemplateResp resp = this.getDefaultSessionConnection().querySchemaTemplate(req);
        return resp.result;
    }

    public List<String> showMeasurementsInTemplate(String templateName) throws StatementExecutionException, IoTDBConnectionException {
        TSQueryTemplateReq req = new TSQueryTemplateReq();
        req.setName(templateName);
        req.setQueryType(TemplateQueryType.SHOW_MEASUREMENTS.ordinal());
        req.setMeasurement("");
        TSQueryTemplateResp resp = this.getDefaultSessionConnection().querySchemaTemplate(req);
        return resp.getMeasurements();
    }

    public List<String> showMeasurementsInTemplate(String templateName, String pattern) throws StatementExecutionException, IoTDBConnectionException {
        TSQueryTemplateReq req = new TSQueryTemplateReq();
        req.setName(templateName);
        req.setQueryType(TemplateQueryType.SHOW_MEASUREMENTS.ordinal());
        req.setMeasurement(pattern);
        TSQueryTemplateResp resp = this.getDefaultSessionConnection().querySchemaTemplate(req);
        return resp.getMeasurements();
    }

    public List<String> showAllTemplates() throws StatementExecutionException, IoTDBConnectionException {
        TSQueryTemplateReq req = new TSQueryTemplateReq();
        req.setName("");
        req.setQueryType(TemplateQueryType.SHOW_TEMPLATES.ordinal());
        TSQueryTemplateResp resp = this.getDefaultSessionConnection().querySchemaTemplate(req);
        return resp.getMeasurements();
    }

    public List<String> showPathsTemplateSetOn(String templateName) throws StatementExecutionException, IoTDBConnectionException {
        TSQueryTemplateReq req = new TSQueryTemplateReq();
        req.setName(templateName);
        req.setQueryType(TemplateQueryType.SHOW_SET_TEMPLATES.ordinal());
        TSQueryTemplateResp resp = this.getDefaultSessionConnection().querySchemaTemplate(req);
        return resp.getMeasurements();
    }

    public List<String> showPathsTemplateUsingOn(String templateName) throws StatementExecutionException, IoTDBConnectionException {
        TSQueryTemplateReq req = new TSQueryTemplateReq();
        req.setName(templateName);
        req.setQueryType(TemplateQueryType.SHOW_USING_TEMPLATES.ordinal());
        TSQueryTemplateResp resp = this.getDefaultSessionConnection().querySchemaTemplate(req);
        return resp.getMeasurements();
    }

    public void unsetSchemaTemplate(String prefixPath, String templateName) throws IoTDBConnectionException, StatementExecutionException {
        TSUnsetSchemaTemplateReq request = this.getTSUnsetSchemaTemplateReq(prefixPath, templateName);
        this.getDefaultSessionConnection().unsetSchemaTemplate(request);
    }

    public void dropSchemaTemplate(String templateName) throws IoTDBConnectionException, StatementExecutionException {
        TSDropSchemaTemplateReq request = this.getTSDropSchemaTemplateReq(templateName);
        this.getDefaultSessionConnection().dropSchemaTemplate(request);
    }

    private TSSetSchemaTemplateReq getTSSetSchemaTemplateReq(String templateName, String prefixPath) {
        TSSetSchemaTemplateReq request = new TSSetSchemaTemplateReq();
        request.setTemplateName(templateName);
        request.setPrefixPath(prefixPath);
        return request;
    }

    private TSUnsetSchemaTemplateReq getTSUnsetSchemaTemplateReq(String prefixPath, String templateName) {
        TSUnsetSchemaTemplateReq request = new TSUnsetSchemaTemplateReq();
        request.setPrefixPath(prefixPath);
        request.setTemplateName(templateName);
        return request;
    }

    private TSDropSchemaTemplateReq getTSDropSchemaTemplateReq(String templateName) {
        TSDropSchemaTemplateReq request = new TSDropSchemaTemplateReq();
        request.setTemplateName(templateName);
        return request;
    }

    public void createTimeseriesUsingSchemaTemplate(List<String> devicePathList) throws IoTDBConnectionException, StatementExecutionException {
        if (devicePathList == null || devicePathList.contains(null)) {
            throw new StatementExecutionException("Given device path list should not be  or contains null.");
        }
        TCreateTimeseriesUsingSchemaTemplateReq request = new TCreateTimeseriesUsingSchemaTemplateReq();
        request.setDevicePathList(devicePathList);
        this.getDefaultSessionConnection().createTimeseriesUsingSchemaTemplate(request);
    }

    private <T> void insertOnce(Map<SessionConnection, T> insertGroup, InsertConsumer<T> insertConsumer) throws IoTDBConnectionException, StatementExecutionException {
        Map.Entry<SessionConnection, T> entry = insertGroup.entrySet().iterator().next();
        SessionConnection connection = entry.getKey();
        T insertReq = entry.getValue();
        try {
            insertConsumer.insert(connection, insertReq);
        }
        catch (RedirectException e) {
            e.getDeviceEndPointMap().forEach(this::handleRedirection);
        }
        catch (IoTDBConnectionException e) {
            if (this.endPointToSessionConnection != null && this.endPointToSessionConnection.size() > 1) {
                this.removeBrokenSessionConnection(connection);
                try {
                    insertConsumer.insert(this.getDefaultSessionConnection(), insertReq);
                }
                catch (RedirectException redirectException) {}
            }
            throw e;
        }
    }

    private <T> void insertByGroup(Map<SessionConnection, T> insertGroup, InsertConsumer<T> insertConsumer) throws IoTDBConnectionException, StatementExecutionException {
        List completableFutures = insertGroup.entrySet().stream().map(entry -> {
            SessionConnection connection = (SessionConnection)entry.getKey();
            Object insertReq = entry.getValue();
            return CompletableFuture.runAsync(() -> {
                try {
                    insertConsumer.insert(connection, insertReq);
                }
                catch (RedirectException e) {
                    e.getDeviceEndPointMap().forEach(this::handleRedirection);
                }
                catch (StatementExecutionException e) {
                    throw new CompletionException(e);
                }
                catch (IoTDBConnectionException e) {
                    this.removeBrokenSessionConnection(connection);
                    try {
                        insertConsumer.insert(this.getDefaultSessionConnection(), insertReq);
                    }
                    catch (IoTDBConnectionException | StatementExecutionException ex) {
                        throw new CompletionException(ex);
                    }
                    catch (RedirectException redirectException) {
                        // empty catch block
                    }
                }
            }, OPERATION_EXECUTOR);
        }).collect(Collectors.toList());
        StringBuilder errMsgBuilder = new StringBuilder();
        for (CompletableFuture completableFuture : completableFutures) {
            try {
                completableFuture.join();
            }
            catch (CompletionException completionException) {
                Throwable cause = completionException.getCause();
                logger.error("Meet error when async insert!", cause);
                if (cause instanceof IoTDBConnectionException) {
                    throw (IoTDBConnectionException)cause;
                }
                if (errMsgBuilder.length() > 0) {
                    errMsgBuilder.append(";");
                }
                errMsgBuilder.append(cause.getMessage());
            }
        }
        if (errMsgBuilder.length() > 0) {
            throw new StatementExecutionException(errMsgBuilder.toString());
        }
    }

    public boolean isEnableQueryRedirection() {
        return this.enableQueryRedirection;
    }

    public void setEnableQueryRedirection(boolean enableQueryRedirection) {
        this.enableQueryRedirection = enableQueryRedirection;
    }

    public boolean isEnableRedirection() {
        return this.enableRedirection;
    }

    public void setEnableRedirection(boolean enableRedirection) {
        this.enableRedirection = enableRedirection;
    }

    public TSBackupConfigurationResp getBackupConfiguration() throws IoTDBConnectionException, StatementExecutionException {
        return this.getDefaultSessionConnection().getBackupConfiguration();
    }

    public TSConnectionInfoResp fetchAllConnections() throws IoTDBConnectionException {
        return this.getDefaultSessionConnection().fetchAllConnections();
    }

    protected void changeDatabase(String database) {
        this.database = database;
    }

    public String getDatabase() {
        return this.database;
    }

    protected void changeSqlDialect(String sqlDialect) {
        this.sqlDialect = sqlDialect;
        this.database = null;
    }

    public String getSqlDialect() {
        return this.sqlDialect;
    }

    protected SessionConnection getDefaultSessionConnection() throws IoTDBConnectionException {
        if (this.defaultSessionConnection == null) {
            throw new IoTDBConnectionException("Session is not open, please invoke Session.open() first");
        }
        return this.defaultSessionConnection;
    }

    protected void setDefaultSessionConnection(SessionConnection defaultSessionConnection) {
        this.defaultSessionConnection = defaultSessionConnection;
    }

    public static class Builder
    extends AbstractSessionBuilder {
        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.rpcPort = port;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.pw = password;
            return this;
        }

        public Builder fetchSize(int fetchSize) {
            this.fetchSize = fetchSize;
            return this;
        }

        public Builder zoneId(ZoneId zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder thriftDefaultBufferSize(int thriftDefaultBufferSize) {
            this.thriftDefaultBufferSize = thriftDefaultBufferSize;
            return this;
        }

        public Builder thriftMaxFrameSize(int thriftMaxFrameSize) {
            this.thriftMaxFrameSize = thriftMaxFrameSize;
            return this;
        }

        public Builder enableRedirection(boolean enableRedirection) {
            this.enableRedirection = enableRedirection;
            return this;
        }

        public Builder enableRecordsAutoConvertTablet(boolean enableRecordsAutoConvertTablet) {
            this.enableRecordsAutoConvertTablet = enableRecordsAutoConvertTablet;
            return this;
        }

        public Builder nodeUrls(List<String> nodeUrls) {
            this.nodeUrls = nodeUrls;
            return this;
        }

        public Builder version(Version version) {
            this.version = version;
            return this;
        }

        public Builder timeOut(long timeOut) {
            this.timeOut = timeOut;
            return this;
        }

        public Builder enableAutoFetch(boolean enableAutoFetch) {
            this.enableAutoFetch = enableAutoFetch;
            return this;
        }

        public Builder maxRetryCount(int maxRetryCount) {
            this.maxRetryCount = maxRetryCount;
            return this;
        }

        public Builder retryIntervalInMs(long retryIntervalInMs) {
            this.retryIntervalInMs = retryIntervalInMs;
            return this;
        }

        public Builder sqlDialect(String sqlDialect) {
            this.sqlDialect = sqlDialect;
            return this;
        }

        public Builder database(String database) {
            this.database = database;
            return this;
        }

        public Builder useSSL(boolean useSSL) {
            this.useSSL = useSSL;
            return this;
        }

        public Builder trustStore(String keyStore) {
            this.trustStore = keyStore;
            return this;
        }

        public Builder trustStorePwd(String keyStorePwd) {
            this.trustStorePwd = keyStorePwd;
            return this;
        }

        public Session build() {
            if (!(this.nodeUrls == null || "localhost".equals(this.host) && this.rpcPort == 6667)) {
                throw new IllegalArgumentException("You should specify either nodeUrls or (host + rpcPort), but not both");
            }
            return new Session(this);
        }
    }
}

