/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.protocol.airgap;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.sink.protocol.IoTDBAirGapSink;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaRegionSnapshotEvent;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaRegionWritePlanEvent;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferSchemaSnapshotPieceReq;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferSchemaSnapshotSealReq;
import org.apache.iotdb.db.pipe.sink.protocol.airgap.IoTDBDataNodeAirGapSink;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBSchemaRegionAirGapSink
extends IoTDBDataNodeAirGapSink {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBSchemaRegionAirGapSink.class);

    public void transfer(TabletInsertionEvent tabletInsertionEvent) throws Exception {
        throw new UnsupportedOperationException("IoTDBSchemaRegionAirGapConnector can't transfer TabletInsertionEvent.");
    }

    public void transfer(TsFileInsertionEvent tsFileInsertionEvent) throws Exception {
        throw new UnsupportedOperationException("IoTDBSchemaRegionAirGapConnector can't transfer TsFileInsertionEvent.");
    }

    public void transfer(Event event) throws Exception {
        int socketIndex = this.nextSocketIndex();
        IoTDBAirGapSink.AirGapSocket socket = (IoTDBAirGapSink.AirGapSocket)this.sockets.get(socketIndex);
        try {
            if (event instanceof PipeSchemaRegionWritePlanEvent) {
                this.doTransferWrapper(socket, (PipeSchemaRegionWritePlanEvent)event);
            } else if (event instanceof PipeSchemaRegionSnapshotEvent) {
                this.doTransferWrapper(socket, (PipeSchemaRegionSnapshotEvent)event);
            } else if (!(event instanceof PipeHeartbeatEvent)) {
                LOGGER.warn("IoTDBSchemaRegionAirGapConnector does not support transferring generic event: {}.", (Object)event);
            }
        }
        catch (IOException e) {
            this.isSocketAlive.set(socketIndex, false);
            throw new PipeConnectionException(String.format("Network error when transfer event %s, because %s.", ((EnrichedEvent)event).coreReportMessage(), e.getMessage()), (Throwable)e);
        }
    }

    private void doTransferWrapper(IoTDBAirGapSink.AirGapSocket socket, PipeSchemaRegionSnapshotEvent pipeSchemaRegionSnapshotEvent) throws PipeException, IOException {
        if (!pipeSchemaRegionSnapshotEvent.increaseReferenceCount(IoTDBSchemaRegionAirGapSink.class.getName())) {
            return;
        }
        try {
            this.doTransfer(socket, pipeSchemaRegionSnapshotEvent);
        }
        finally {
            pipeSchemaRegionSnapshotEvent.decreaseReferenceCount(IoTDBSchemaRegionAirGapSink.class.getName(), false);
        }
    }

    private void doTransfer(IoTDBAirGapSink.AirGapSocket socket, PipeSchemaRegionSnapshotEvent pipeSchemaRegionSnapshotEvent) throws PipeException, IOException {
        String pipeName = pipeSchemaRegionSnapshotEvent.getPipeName();
        long creationTime = pipeSchemaRegionSnapshotEvent.getCreationTime();
        File mtreeSnapshotFile = pipeSchemaRegionSnapshotEvent.getMTreeSnapshotFile();
        File tagLogSnapshotFile = pipeSchemaRegionSnapshotEvent.getTagLogSnapshotFile();
        this.transferFilePieces(pipeName, creationTime, mtreeSnapshotFile, socket, true);
        if (Objects.nonNull(tagLogSnapshotFile)) {
            this.transferFilePieces(pipeName, creationTime, tagLogSnapshotFile, socket, true);
        }
        if (!this.send(pipeName, creationTime, socket, PipeTransferSchemaSnapshotSealReq.toTPipeTransferBytes(pipeSchemaRegionSnapshotEvent.getPatternString(), mtreeSnapshotFile.getName(), mtreeSnapshotFile.length(), Objects.nonNull(tagLogSnapshotFile) ? tagLogSnapshotFile.getName() : null, Objects.nonNull(tagLogSnapshotFile) ? tagLogSnapshotFile.length() : 0L, pipeSchemaRegionSnapshotEvent.getDatabaseName(), pipeSchemaRegionSnapshotEvent.toSealTypeString()))) {
            String errorMessage = String.format("Seal schema region snapshot file %s and %s error. Socket %s.", mtreeSnapshotFile, tagLogSnapshotFile, socket);
            this.receiverStatusHandler.handle(new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(errorMessage), errorMessage, pipeSchemaRegionSnapshotEvent.toString(), true);
        } else {
            LOGGER.info("Successfully transferred schema region snapshot {} and {}.", (Object)mtreeSnapshotFile, (Object)tagLogSnapshotFile);
        }
    }

    protected void mayLimitRateAndRecordIO(long requiredBytes) {
    }

    protected byte[] getTransferSingleFilePieceBytes(String fileName, long position, byte[] payLoad) {
        throw new UnsupportedOperationException("The schema region air gap connector does not support transferring single file piece bytes.");
    }

    protected byte[] getTransferMultiFilePieceBytes(String fileName, long position, byte[] payLoad) throws IOException {
        return PipeTransferSchemaSnapshotPieceReq.toTPipeTransferBytes(fileName, position, payLoad);
    }
}

