/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class ServerDiagnosticsSummaryDataType
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=859");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=860");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=861");
    private final UInteger serverViewCount;
    private final UInteger currentSessionCount;
    private final UInteger cumulatedSessionCount;
    private final UInteger securityRejectedSessionCount;
    private final UInteger rejectedSessionCount;
    private final UInteger sessionTimeoutCount;
    private final UInteger sessionAbortCount;
    private final UInteger currentSubscriptionCount;
    private final UInteger cumulatedSubscriptionCount;
    private final UInteger publishingIntervalCount;
    private final UInteger securityRejectedRequestsCount;
    private final UInteger rejectedRequestsCount;

    public ServerDiagnosticsSummaryDataType(UInteger serverViewCount, UInteger currentSessionCount, UInteger cumulatedSessionCount, UInteger securityRejectedSessionCount, UInteger rejectedSessionCount, UInteger sessionTimeoutCount, UInteger sessionAbortCount, UInteger currentSubscriptionCount, UInteger cumulatedSubscriptionCount, UInteger publishingIntervalCount, UInteger securityRejectedRequestsCount, UInteger rejectedRequestsCount) {
        this.serverViewCount = serverViewCount;
        this.currentSessionCount = currentSessionCount;
        this.cumulatedSessionCount = cumulatedSessionCount;
        this.securityRejectedSessionCount = securityRejectedSessionCount;
        this.rejectedSessionCount = rejectedSessionCount;
        this.sessionTimeoutCount = sessionTimeoutCount;
        this.sessionAbortCount = sessionAbortCount;
        this.currentSubscriptionCount = currentSubscriptionCount;
        this.cumulatedSubscriptionCount = cumulatedSubscriptionCount;
        this.publishingIntervalCount = publishingIntervalCount;
        this.securityRejectedRequestsCount = securityRejectedRequestsCount;
        this.rejectedRequestsCount = rejectedRequestsCount;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public UInteger getServerViewCount() {
        return this.serverViewCount;
    }

    public UInteger getCurrentSessionCount() {
        return this.currentSessionCount;
    }

    public UInteger getCumulatedSessionCount() {
        return this.cumulatedSessionCount;
    }

    public UInteger getSecurityRejectedSessionCount() {
        return this.securityRejectedSessionCount;
    }

    public UInteger getRejectedSessionCount() {
        return this.rejectedSessionCount;
    }

    public UInteger getSessionTimeoutCount() {
        return this.sessionTimeoutCount;
    }

    public UInteger getSessionAbortCount() {
        return this.sessionAbortCount;
    }

    public UInteger getCurrentSubscriptionCount() {
        return this.currentSubscriptionCount;
    }

    public UInteger getCumulatedSubscriptionCount() {
        return this.cumulatedSubscriptionCount;
    }

    public UInteger getPublishingIntervalCount() {
        return this.publishingIntervalCount;
    }

    public UInteger getSecurityRejectedRequestsCount() {
        return this.securityRejectedRequestsCount;
    }

    public UInteger getRejectedRequestsCount() {
        return this.rejectedRequestsCount;
    }

    protected ServerDiagnosticsSummaryDataType(ServerDiagnosticsSummaryDataTypeBuilder<?, ?> b) {
        super(b);
        this.serverViewCount = ((ServerDiagnosticsSummaryDataTypeBuilder)b).serverViewCount;
        this.currentSessionCount = ((ServerDiagnosticsSummaryDataTypeBuilder)b).currentSessionCount;
        this.cumulatedSessionCount = ((ServerDiagnosticsSummaryDataTypeBuilder)b).cumulatedSessionCount;
        this.securityRejectedSessionCount = ((ServerDiagnosticsSummaryDataTypeBuilder)b).securityRejectedSessionCount;
        this.rejectedSessionCount = ((ServerDiagnosticsSummaryDataTypeBuilder)b).rejectedSessionCount;
        this.sessionTimeoutCount = ((ServerDiagnosticsSummaryDataTypeBuilder)b).sessionTimeoutCount;
        this.sessionAbortCount = ((ServerDiagnosticsSummaryDataTypeBuilder)b).sessionAbortCount;
        this.currentSubscriptionCount = ((ServerDiagnosticsSummaryDataTypeBuilder)b).currentSubscriptionCount;
        this.cumulatedSubscriptionCount = ((ServerDiagnosticsSummaryDataTypeBuilder)b).cumulatedSubscriptionCount;
        this.publishingIntervalCount = ((ServerDiagnosticsSummaryDataTypeBuilder)b).publishingIntervalCount;
        this.securityRejectedRequestsCount = ((ServerDiagnosticsSummaryDataTypeBuilder)b).securityRejectedRequestsCount;
        this.rejectedRequestsCount = ((ServerDiagnosticsSummaryDataTypeBuilder)b).rejectedRequestsCount;
    }

    public static ServerDiagnosticsSummaryDataTypeBuilder<?, ?> builder() {
        return new ServerDiagnosticsSummaryDataTypeBuilderImpl();
    }

    public ServerDiagnosticsSummaryDataTypeBuilder<?, ?> toBuilder() {
        return new ServerDiagnosticsSummaryDataTypeBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerDiagnosticsSummaryDataType)) {
            return false;
        }
        ServerDiagnosticsSummaryDataType other = (ServerDiagnosticsSummaryDataType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UInteger this$serverViewCount = this.getServerViewCount();
        UInteger other$serverViewCount = other.getServerViewCount();
        if (this$serverViewCount == null ? other$serverViewCount != null : !((Object)this$serverViewCount).equals(other$serverViewCount)) {
            return false;
        }
        UInteger this$currentSessionCount = this.getCurrentSessionCount();
        UInteger other$currentSessionCount = other.getCurrentSessionCount();
        if (this$currentSessionCount == null ? other$currentSessionCount != null : !((Object)this$currentSessionCount).equals(other$currentSessionCount)) {
            return false;
        }
        UInteger this$cumulatedSessionCount = this.getCumulatedSessionCount();
        UInteger other$cumulatedSessionCount = other.getCumulatedSessionCount();
        if (this$cumulatedSessionCount == null ? other$cumulatedSessionCount != null : !((Object)this$cumulatedSessionCount).equals(other$cumulatedSessionCount)) {
            return false;
        }
        UInteger this$securityRejectedSessionCount = this.getSecurityRejectedSessionCount();
        UInteger other$securityRejectedSessionCount = other.getSecurityRejectedSessionCount();
        if (this$securityRejectedSessionCount == null ? other$securityRejectedSessionCount != null : !((Object)this$securityRejectedSessionCount).equals(other$securityRejectedSessionCount)) {
            return false;
        }
        UInteger this$rejectedSessionCount = this.getRejectedSessionCount();
        UInteger other$rejectedSessionCount = other.getRejectedSessionCount();
        if (this$rejectedSessionCount == null ? other$rejectedSessionCount != null : !((Object)this$rejectedSessionCount).equals(other$rejectedSessionCount)) {
            return false;
        }
        UInteger this$sessionTimeoutCount = this.getSessionTimeoutCount();
        UInteger other$sessionTimeoutCount = other.getSessionTimeoutCount();
        if (this$sessionTimeoutCount == null ? other$sessionTimeoutCount != null : !((Object)this$sessionTimeoutCount).equals(other$sessionTimeoutCount)) {
            return false;
        }
        UInteger this$sessionAbortCount = this.getSessionAbortCount();
        UInteger other$sessionAbortCount = other.getSessionAbortCount();
        if (this$sessionAbortCount == null ? other$sessionAbortCount != null : !((Object)this$sessionAbortCount).equals(other$sessionAbortCount)) {
            return false;
        }
        UInteger this$currentSubscriptionCount = this.getCurrentSubscriptionCount();
        UInteger other$currentSubscriptionCount = other.getCurrentSubscriptionCount();
        if (this$currentSubscriptionCount == null ? other$currentSubscriptionCount != null : !((Object)this$currentSubscriptionCount).equals(other$currentSubscriptionCount)) {
            return false;
        }
        UInteger this$cumulatedSubscriptionCount = this.getCumulatedSubscriptionCount();
        UInteger other$cumulatedSubscriptionCount = other.getCumulatedSubscriptionCount();
        if (this$cumulatedSubscriptionCount == null ? other$cumulatedSubscriptionCount != null : !((Object)this$cumulatedSubscriptionCount).equals(other$cumulatedSubscriptionCount)) {
            return false;
        }
        UInteger this$publishingIntervalCount = this.getPublishingIntervalCount();
        UInteger other$publishingIntervalCount = other.getPublishingIntervalCount();
        if (this$publishingIntervalCount == null ? other$publishingIntervalCount != null : !((Object)this$publishingIntervalCount).equals(other$publishingIntervalCount)) {
            return false;
        }
        UInteger this$securityRejectedRequestsCount = this.getSecurityRejectedRequestsCount();
        UInteger other$securityRejectedRequestsCount = other.getSecurityRejectedRequestsCount();
        if (this$securityRejectedRequestsCount == null ? other$securityRejectedRequestsCount != null : !((Object)this$securityRejectedRequestsCount).equals(other$securityRejectedRequestsCount)) {
            return false;
        }
        UInteger this$rejectedRequestsCount = this.getRejectedRequestsCount();
        UInteger other$rejectedRequestsCount = other.getRejectedRequestsCount();
        return !(this$rejectedRequestsCount == null ? other$rejectedRequestsCount != null : !((Object)this$rejectedRequestsCount).equals(other$rejectedRequestsCount));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerDiagnosticsSummaryDataType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UInteger $serverViewCount = this.getServerViewCount();
        result = result * 59 + ($serverViewCount == null ? 43 : ((Object)$serverViewCount).hashCode());
        UInteger $currentSessionCount = this.getCurrentSessionCount();
        result = result * 59 + ($currentSessionCount == null ? 43 : ((Object)$currentSessionCount).hashCode());
        UInteger $cumulatedSessionCount = this.getCumulatedSessionCount();
        result = result * 59 + ($cumulatedSessionCount == null ? 43 : ((Object)$cumulatedSessionCount).hashCode());
        UInteger $securityRejectedSessionCount = this.getSecurityRejectedSessionCount();
        result = result * 59 + ($securityRejectedSessionCount == null ? 43 : ((Object)$securityRejectedSessionCount).hashCode());
        UInteger $rejectedSessionCount = this.getRejectedSessionCount();
        result = result * 59 + ($rejectedSessionCount == null ? 43 : ((Object)$rejectedSessionCount).hashCode());
        UInteger $sessionTimeoutCount = this.getSessionTimeoutCount();
        result = result * 59 + ($sessionTimeoutCount == null ? 43 : ((Object)$sessionTimeoutCount).hashCode());
        UInteger $sessionAbortCount = this.getSessionAbortCount();
        result = result * 59 + ($sessionAbortCount == null ? 43 : ((Object)$sessionAbortCount).hashCode());
        UInteger $currentSubscriptionCount = this.getCurrentSubscriptionCount();
        result = result * 59 + ($currentSubscriptionCount == null ? 43 : ((Object)$currentSubscriptionCount).hashCode());
        UInteger $cumulatedSubscriptionCount = this.getCumulatedSubscriptionCount();
        result = result * 59 + ($cumulatedSubscriptionCount == null ? 43 : ((Object)$cumulatedSubscriptionCount).hashCode());
        UInteger $publishingIntervalCount = this.getPublishingIntervalCount();
        result = result * 59 + ($publishingIntervalCount == null ? 43 : ((Object)$publishingIntervalCount).hashCode());
        UInteger $securityRejectedRequestsCount = this.getSecurityRejectedRequestsCount();
        result = result * 59 + ($securityRejectedRequestsCount == null ? 43 : ((Object)$securityRejectedRequestsCount).hashCode());
        UInteger $rejectedRequestsCount = this.getRejectedRequestsCount();
        result = result * 59 + ($rejectedRequestsCount == null ? 43 : ((Object)$rejectedRequestsCount).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ServerDiagnosticsSummaryDataType(serverViewCount=" + this.getServerViewCount() + ", currentSessionCount=" + this.getCurrentSessionCount() + ", cumulatedSessionCount=" + this.getCumulatedSessionCount() + ", securityRejectedSessionCount=" + this.getSecurityRejectedSessionCount() + ", rejectedSessionCount=" + this.getRejectedSessionCount() + ", sessionTimeoutCount=" + this.getSessionTimeoutCount() + ", sessionAbortCount=" + this.getSessionAbortCount() + ", currentSubscriptionCount=" + this.getCurrentSubscriptionCount() + ", cumulatedSubscriptionCount=" + this.getCumulatedSubscriptionCount() + ", publishingIntervalCount=" + this.getPublishingIntervalCount() + ", securityRejectedRequestsCount=" + this.getSecurityRejectedRequestsCount() + ", rejectedRequestsCount=" + this.getRejectedRequestsCount() + ")";
    }

    private static final class ServerDiagnosticsSummaryDataTypeBuilderImpl
    extends ServerDiagnosticsSummaryDataTypeBuilder<ServerDiagnosticsSummaryDataType, ServerDiagnosticsSummaryDataTypeBuilderImpl> {
        private ServerDiagnosticsSummaryDataTypeBuilderImpl() {
        }

        @Override
        protected ServerDiagnosticsSummaryDataTypeBuilderImpl self() {
            return this;
        }

        @Override
        public ServerDiagnosticsSummaryDataType build() {
            return new ServerDiagnosticsSummaryDataType(this);
        }
    }

    public static abstract class ServerDiagnosticsSummaryDataTypeBuilder<C extends ServerDiagnosticsSummaryDataType, B extends ServerDiagnosticsSummaryDataTypeBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private UInteger serverViewCount;
        private UInteger currentSessionCount;
        private UInteger cumulatedSessionCount;
        private UInteger securityRejectedSessionCount;
        private UInteger rejectedSessionCount;
        private UInteger sessionTimeoutCount;
        private UInteger sessionAbortCount;
        private UInteger currentSubscriptionCount;
        private UInteger cumulatedSubscriptionCount;
        private UInteger publishingIntervalCount;
        private UInteger securityRejectedRequestsCount;
        private UInteger rejectedRequestsCount;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ServerDiagnosticsSummaryDataTypeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ServerDiagnosticsSummaryDataType instance, ServerDiagnosticsSummaryDataTypeBuilder<?, ?> b) {
            b.serverViewCount(instance.serverViewCount);
            b.currentSessionCount(instance.currentSessionCount);
            b.cumulatedSessionCount(instance.cumulatedSessionCount);
            b.securityRejectedSessionCount(instance.securityRejectedSessionCount);
            b.rejectedSessionCount(instance.rejectedSessionCount);
            b.sessionTimeoutCount(instance.sessionTimeoutCount);
            b.sessionAbortCount(instance.sessionAbortCount);
            b.currentSubscriptionCount(instance.currentSubscriptionCount);
            b.cumulatedSubscriptionCount(instance.cumulatedSubscriptionCount);
            b.publishingIntervalCount(instance.publishingIntervalCount);
            b.securityRejectedRequestsCount(instance.securityRejectedRequestsCount);
            b.rejectedRequestsCount(instance.rejectedRequestsCount);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B serverViewCount(UInteger serverViewCount) {
            this.serverViewCount = serverViewCount;
            return (B)this.self();
        }

        public B currentSessionCount(UInteger currentSessionCount) {
            this.currentSessionCount = currentSessionCount;
            return (B)this.self();
        }

        public B cumulatedSessionCount(UInteger cumulatedSessionCount) {
            this.cumulatedSessionCount = cumulatedSessionCount;
            return (B)this.self();
        }

        public B securityRejectedSessionCount(UInteger securityRejectedSessionCount) {
            this.securityRejectedSessionCount = securityRejectedSessionCount;
            return (B)this.self();
        }

        public B rejectedSessionCount(UInteger rejectedSessionCount) {
            this.rejectedSessionCount = rejectedSessionCount;
            return (B)this.self();
        }

        public B sessionTimeoutCount(UInteger sessionTimeoutCount) {
            this.sessionTimeoutCount = sessionTimeoutCount;
            return (B)this.self();
        }

        public B sessionAbortCount(UInteger sessionAbortCount) {
            this.sessionAbortCount = sessionAbortCount;
            return (B)this.self();
        }

        public B currentSubscriptionCount(UInteger currentSubscriptionCount) {
            this.currentSubscriptionCount = currentSubscriptionCount;
            return (B)this.self();
        }

        public B cumulatedSubscriptionCount(UInteger cumulatedSubscriptionCount) {
            this.cumulatedSubscriptionCount = cumulatedSubscriptionCount;
            return (B)this.self();
        }

        public B publishingIntervalCount(UInteger publishingIntervalCount) {
            this.publishingIntervalCount = publishingIntervalCount;
            return (B)this.self();
        }

        public B securityRejectedRequestsCount(UInteger securityRejectedRequestsCount) {
            this.securityRejectedRequestsCount = securityRejectedRequestsCount;
            return (B)this.self();
        }

        public B rejectedRequestsCount(UInteger rejectedRequestsCount) {
            this.rejectedRequestsCount = rejectedRequestsCount;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ServerDiagnosticsSummaryDataType.ServerDiagnosticsSummaryDataTypeBuilder(super=" + super.toString() + ", serverViewCount=" + this.serverViewCount + ", currentSessionCount=" + this.currentSessionCount + ", cumulatedSessionCount=" + this.cumulatedSessionCount + ", securityRejectedSessionCount=" + this.securityRejectedSessionCount + ", rejectedSessionCount=" + this.rejectedSessionCount + ", sessionTimeoutCount=" + this.sessionTimeoutCount + ", sessionAbortCount=" + this.sessionAbortCount + ", currentSubscriptionCount=" + this.currentSubscriptionCount + ", cumulatedSubscriptionCount=" + this.cumulatedSubscriptionCount + ", publishingIntervalCount=" + this.publishingIntervalCount + ", securityRejectedRequestsCount=" + this.securityRejectedRequestsCount + ", rejectedRequestsCount=" + this.rejectedRequestsCount + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ServerDiagnosticsSummaryDataType> {
        @Override
        public Class<ServerDiagnosticsSummaryDataType> getType() {
            return ServerDiagnosticsSummaryDataType.class;
        }

        @Override
        public ServerDiagnosticsSummaryDataType decode(SerializationContext context, UaDecoder decoder) {
            UInteger serverViewCount = decoder.readUInt32("ServerViewCount");
            UInteger currentSessionCount = decoder.readUInt32("CurrentSessionCount");
            UInteger cumulatedSessionCount = decoder.readUInt32("CumulatedSessionCount");
            UInteger securityRejectedSessionCount = decoder.readUInt32("SecurityRejectedSessionCount");
            UInteger rejectedSessionCount = decoder.readUInt32("RejectedSessionCount");
            UInteger sessionTimeoutCount = decoder.readUInt32("SessionTimeoutCount");
            UInteger sessionAbortCount = decoder.readUInt32("SessionAbortCount");
            UInteger currentSubscriptionCount = decoder.readUInt32("CurrentSubscriptionCount");
            UInteger cumulatedSubscriptionCount = decoder.readUInt32("CumulatedSubscriptionCount");
            UInteger publishingIntervalCount = decoder.readUInt32("PublishingIntervalCount");
            UInteger securityRejectedRequestsCount = decoder.readUInt32("SecurityRejectedRequestsCount");
            UInteger rejectedRequestsCount = decoder.readUInt32("RejectedRequestsCount");
            return new ServerDiagnosticsSummaryDataType(serverViewCount, currentSessionCount, cumulatedSessionCount, securityRejectedSessionCount, rejectedSessionCount, sessionTimeoutCount, sessionAbortCount, currentSubscriptionCount, cumulatedSubscriptionCount, publishingIntervalCount, securityRejectedRequestsCount, rejectedRequestsCount);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ServerDiagnosticsSummaryDataType value) {
            encoder.writeUInt32("ServerViewCount", value.getServerViewCount());
            encoder.writeUInt32("CurrentSessionCount", value.getCurrentSessionCount());
            encoder.writeUInt32("CumulatedSessionCount", value.getCumulatedSessionCount());
            encoder.writeUInt32("SecurityRejectedSessionCount", value.getSecurityRejectedSessionCount());
            encoder.writeUInt32("RejectedSessionCount", value.getRejectedSessionCount());
            encoder.writeUInt32("SessionTimeoutCount", value.getSessionTimeoutCount());
            encoder.writeUInt32("SessionAbortCount", value.getSessionAbortCount());
            encoder.writeUInt32("CurrentSubscriptionCount", value.getCurrentSubscriptionCount());
            encoder.writeUInt32("CumulatedSubscriptionCount", value.getCumulatedSubscriptionCount());
            encoder.writeUInt32("PublishingIntervalCount", value.getPublishingIntervalCount());
            encoder.writeUInt32("SecurityRejectedRequestsCount", value.getSecurityRejectedRequestsCount());
            encoder.writeUInt32("RejectedRequestsCount", value.getRejectedRequestsCount());
        }
    }
}

