/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence.dao.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class BaseResult {
    private final int returnStatusCode;
    private final String extraInformation;

    public BaseResult() {
        this.returnStatusCode = ReturnStatus.SUCCESS.getCode();
        this.extraInformation = null;
    }

    public BaseResult(@Nonnull ReturnStatus returnStatus) {
        this.returnStatusCode = returnStatus.getCode();
        this.extraInformation = null;
    }

    @JsonCreator
    public BaseResult(@JsonProperty(value="returnStatus") @Nonnull ReturnStatus returnStatus, @JsonProperty(value="extraInformation") @Nullable String extraInformation) {
        this.returnStatusCode = returnStatus.getCode();
        this.extraInformation = extraInformation;
    }

    public ReturnStatus getReturnStatus() {
        return ReturnStatus.getStatus(this.returnStatusCode);
    }

    public String getExtraInformation() {
        return this.extraInformation;
    }

    public boolean isSuccess() {
        return this.returnStatusCode == ReturnStatus.SUCCESS.getCode();
    }

    public boolean alreadyExists() {
        return this.returnStatusCode == ReturnStatus.ENTITY_ALREADY_EXISTS.getCode();
    }

    public static enum ReturnStatus {
        SUCCESS(1),
        UNEXPECTED_ERROR_SIGNALED(2),
        CATALOG_PATH_CANNOT_BE_RESOLVED(3),
        ENTITY_CANNOT_BE_RESOLVED(4),
        ENTITY_NOT_FOUND(5),
        GRANT_NOT_FOUND(6),
        ENTITY_ALREADY_EXISTS(7),
        ENTITY_UNDROPPABLE(8),
        NAMESPACE_NOT_EMPTY(9),
        CATALOG_NOT_EMPTY(10),
        TARGET_ENTITY_CONCURRENTLY_MODIFIED(11),
        ENTITY_CANNOT_BE_RENAMED(12),
        SUBSCOPE_CREDS_ERROR(13),
        POLICY_MAPPING_NOT_FOUND(14),
        POLICY_MAPPING_OF_SAME_TYPE_ALREADY_EXISTS(15),
        POLICY_HAS_MAPPINGS(16);

        private final int code;
        private static final ReturnStatus[] REVERSE_MAPPING_ARRAY;

        private ReturnStatus(int code) {
            this.code = code;
        }

        int getCode() {
            return this.code;
        }

        static ReturnStatus getStatus(int code) {
            return code >= REVERSE_MAPPING_ARRAY.length ? null : REVERSE_MAPPING_ARRAY[code];
        }

        static {
            int maxCode = 0;
            for (ReturnStatus returnStatus : ReturnStatus.values()) {
                if (maxCode >= returnStatus.code) continue;
                maxCode = returnStatus.code;
            }
            REVERSE_MAPPING_ARRAY = new ReturnStatus[maxCode + 1];
            ReturnStatus[] returnStatusArray = ReturnStatus.values();
            int n = returnStatusArray.length;
            for (int i = 0; i < n; ++i) {
                ReturnStatus returnStatus;
                ReturnStatus.REVERSE_MAPPING_ARRAY[returnStatus.code] = returnStatus = returnStatusArray[i];
            }
        }
    }
}

