/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.catalog;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.polaris.core.entity.PolarisEntity;

public class PolarisCatalogHelpers {
    private PolarisCatalogHelpers() {
    }

    public static List<String> tableIdentifierToList(TableIdentifier identifier) {
        return PolarisCatalogHelpers.identifierToList(identifier.namespace(), identifier.name());
    }

    public static List<String> identifierToList(Namespace namespace, String name) {
        ImmutableList.Builder fullList = ImmutableList.builderWithExpectedSize((int)(namespace.length() + 1));
        fullList.addAll(Arrays.asList(namespace.levels()));
        fullList.add((Object)name);
        return fullList.build();
    }

    public static TableIdentifier listToTableIdentifier(List<String> ids) {
        return TableIdentifier.of((String[])ids.toArray(new String[0]));
    }

    public static Namespace getParentNamespace(Namespace namespace) {
        if (namespace.isEmpty() || namespace.length() == 1) {
            return Namespace.empty();
        }
        String[] parentLevels = new String[namespace.length() - 1];
        for (int i = 0; i < parentLevels.length; ++i) {
            parentLevels[i] = namespace.level(i);
        }
        return Namespace.of((String[])parentLevels);
    }

    public static Namespace nameAndIdToNamespace(List<PolarisEntity> catalogPath, PolarisEntity.NameAndId entity) {
        String[] fullName = new String[catalogPath.size()];
        for (int i = 0; i < fullName.length - 1; ++i) {
            fullName[i] = catalogPath.get(i + 1).getName();
        }
        fullName[fullName.length - 1] = entity.getName();
        return Namespace.of((String[])fullName);
    }

    public static Namespace parentNamespace(List<PolarisEntity> catalogPath) {
        String[] parentNamespaces = new String[catalogPath.size() - 1];
        for (int i = 0; i < parentNamespaces.length; ++i) {
            parentNamespaces[i] = catalogPath.get(i + 1).getName();
        }
        return Namespace.of((String[])parentNamespaces);
    }

    public static List<TableIdentifier> nameAndIdToTableIdentifiers(List<PolarisEntity> catalogPath, List<PolarisEntity.NameAndId> entities) {
        String[] parentNamespaces = new String[catalogPath.size() - 1];
        for (int i = 0; i < parentNamespaces.length; ++i) {
            parentNamespaces[i] = catalogPath.get(i + 1).getName();
        }
        Namespace sharedNamespace = Namespace.of((String[])parentNamespaces);
        return entities.stream().map(entity -> TableIdentifier.of((Namespace)sharedNamespace, (String)entity.getName())).collect(Collectors.toList());
    }
}

