/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.PositionDeletesScanTask;
import org.apache.iceberg.RewriteJobOrder;
import org.apache.iceberg.actions.ImmutableRewritePositionDeleteFiles;
import org.apache.iceberg.actions.RewriteGroupBase;
import org.apache.iceberg.actions.RewritePositionDeleteFiles;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.DeleteFileSet;
import org.apache.iceberg.util.ScanTaskUtil;

public class RewritePositionDeletesGroup
extends RewriteGroupBase<RewritePositionDeleteFiles.FileGroupInfo, PositionDeletesScanTask, DeleteFile> {
    private final long maxRewrittenDataSequenceNumber;
    private DeleteFileSet addedDeleteFiles = DeleteFileSet.create();

    @Deprecated
    public RewritePositionDeletesGroup(RewritePositionDeleteFiles.FileGroupInfo info, List<PositionDeletesScanTask> tasks) {
        this(info, tasks, 0L, 0L, 0);
    }

    public RewritePositionDeletesGroup(RewritePositionDeleteFiles.FileGroupInfo info, List<PositionDeletesScanTask> tasks, long writeMaxFileSize, long inputSplitSize, int expectedOutputFiles) {
        super(info, tasks, writeMaxFileSize, inputSplitSize, expectedOutputFiles);
        Preconditions.checkArgument((!tasks.isEmpty() ? 1 : 0) != 0, (Object)"Tasks must not be empty");
        this.maxRewrittenDataSequenceNumber = tasks.stream().mapToLong(t -> ((DeleteFile)t.file()).dataSequenceNumber()).max().getAsLong();
    }

    @Deprecated
    public List<PositionDeletesScanTask> tasks() {
        return this.fileScanTasks();
    }

    public void setOutputFiles(Set<DeleteFile> files) {
        this.addedDeleteFiles = DeleteFileSet.of(files);
    }

    public long maxRewrittenDataSequenceNumber() {
        return this.maxRewrittenDataSequenceNumber;
    }

    public Set<DeleteFile> rewrittenDeleteFiles() {
        return (Set)this.fileScanTasks().stream().map(ContentScanTask::file).collect(Collectors.toCollection(DeleteFileSet::create));
    }

    public Set<DeleteFile> addedDeleteFiles() {
        return this.addedDeleteFiles;
    }

    public RewritePositionDeleteFiles.FileGroupRewriteResult asResult() {
        Preconditions.checkState((this.addedDeleteFiles != null ? 1 : 0) != 0, (Object)"Cannot get result, Group was never rewritten");
        return ImmutableRewritePositionDeleteFiles.FileGroupRewriteResult.builder().info((RewritePositionDeleteFiles.FileGroupInfo)this.info()).addedDeleteFilesCount(this.addedDeleteFiles.size()).rewrittenDeleteFilesCount(this.inputFileNum()).rewrittenBytesCount(this.inputFilesSizeInBytes()).addedBytesCount(this.addedBytes()).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("info", this.info()).add("numRewrittenPositionDeleteFiles", this.fileScanTasks().size()).add("numAddedPositionDeleteFiles", (Object)(this.addedDeleteFiles == null ? "Rewrite Incomplete" : Integer.toString(this.addedDeleteFiles.size()))).add("numAddedBytes", this.addedBytes()).add("numRewrittenBytes", this.inputFilesSizeInBytes()).add("maxOutputFileSize", this.maxOutputFileSize()).add("inputSplitSize", this.inputSplitSize()).add("expectedOutputFiles", this.expectedOutputFiles()).toString();
    }

    @Deprecated
    public long rewrittenBytes() {
        return this.inputFilesSizeInBytes();
    }

    public long addedBytes() {
        return this.addedDeleteFiles.stream().mapToLong(ScanTaskUtil::contentSizeInBytes).sum();
    }

    @Deprecated
    public int numRewrittenDeleteFiles() {
        return this.inputFileNum();
    }

    public static Comparator<RewritePositionDeletesGroup> comparator(RewriteJobOrder order) {
        switch (order) {
            case BYTES_ASC: {
                return Comparator.comparing(RewriteGroupBase::inputFilesSizeInBytes);
            }
            case BYTES_DESC: {
                return Comparator.comparing(RewriteGroupBase::inputFilesSizeInBytes, Comparator.reverseOrder());
            }
            case FILES_ASC: {
                return Comparator.comparing(RewriteGroupBase::inputFileNum);
            }
            case FILES_DESC: {
                return Comparator.comparing(RewriteGroupBase::inputFileNum, Comparator.reverseOrder());
            }
        }
        return (unused, unused2) -> 0;
    }
}

