/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor.ssl;

import java.nio.ByteBuffer;
import java.security.Provider;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import org.apache.hc.core5.reactor.ssl.SSLIOSession;
import org.apache.hc.core5.reactor.ssl.SSLMode;
import org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import org.apache.hc.core5.util.Timeout;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class SSLIOSessionTest {
    private NamedEndpoint targetEndpoint;
    private IOSession ioSession;
    private SSLMode sslMode;
    private SSLContext sslContext;
    private SSLBufferMode sslBufferMode;
    private SSLSessionInitializer initializer;
    private SSLSessionVerifier verifier;
    private Timeout handshakeTimeout;
    private Callback<SSLIOSession> sessionStartCallback;
    private Callback<SSLIOSession> sessionEndCallback;
    private FutureCallback<SSLSession> resultCallback;
    private IOEventHandler ioEventHandler;
    private SSLEngine mockSSLEngine;
    private SSLSession sslSession;

    SSLIOSessionTest() {
    }

    @BeforeEach
    void setUp() throws SSLException {
        String protocol = "TestProtocol";
        this.targetEndpoint = (NamedEndpoint)Mockito.mock(NamedEndpoint.class);
        this.ioSession = (IOSession)Mockito.mock(IOSession.class);
        this.sslMode = SSLMode.CLIENT;
        SSLContextSpi sslContextSpi = (SSLContextSpi)Mockito.mock(SSLContextSpi.class);
        Provider provider = (Provider)Mockito.mock(Provider.class);
        this.sslContext = new TestSSLContext(sslContextSpi, provider, "TestProtocol");
        this.sslSession = (SSLSession)Mockito.mock(SSLSession.class);
        this.sslBufferMode = SSLBufferMode.STATIC;
        this.initializer = (SSLSessionInitializer)Mockito.mock(SSLSessionInitializer.class);
        this.verifier = (SSLSessionVerifier)Mockito.mock(SSLSessionVerifier.class);
        this.handshakeTimeout = (Timeout)Mockito.mock(Timeout.class);
        this.sessionStartCallback = (Callback)Mockito.mock(Callback.class);
        this.sessionEndCallback = (Callback)Mockito.mock(Callback.class);
        this.resultCallback = (FutureCallback)Mockito.mock(FutureCallback.class);
        this.ioEventHandler = (IOEventHandler)Mockito.mock(IOEventHandler.class);
        Mockito.when((Object)this.targetEndpoint.getHostName()).thenReturn((Object)"testHostName");
        Mockito.when((Object)this.targetEndpoint.getPort()).thenReturn((Object)8080);
        Mockito.when((Object)this.sslSession.getPacketBufferSize()).thenReturn((Object)1024);
        Mockito.when((Object)this.sslSession.getApplicationBufferSize()).thenReturn((Object)1024);
        Mockito.when((Object)this.ioSession.getEventMask()).thenReturn((Object)1);
        Mockito.when((Object)this.ioSession.getLock()).thenReturn((Object)new ReentrantLock());
        this.mockSSLEngine = (SSLEngine)Mockito.mock(SSLEngine.class);
        Mockito.when((Object)this.sslContext.createSSLEngine((String)ArgumentMatchers.any(String.class), (Integer)ArgumentMatchers.any(Integer.class))).thenReturn((Object)this.mockSSLEngine);
        Mockito.when((Object)this.mockSSLEngine.getSession()).thenReturn((Object)this.sslSession);
        Mockito.when((Object)((Object)this.mockSSLEngine.getHandshakeStatus())).thenReturn((Object)SSLEngineResult.HandshakeStatus.NEED_WRAP);
        Mockito.when((Object)this.ioSession.getHandler()).thenReturn((Object)this.ioEventHandler);
        SSLEngineResult mockResult = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.FINISHED, 0, 464);
        Mockito.when((Object)this.mockSSLEngine.wrap((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class), (ByteBuffer)ArgumentMatchers.any(ByteBuffer.class))).thenReturn((Object)mockResult);
    }

    @Test
    void testConstructorWhenSSLEngineOk() {
        String protocol = "TestProtocol";
        Mockito.when((Object)this.mockSSLEngine.getApplicationProtocol()).thenReturn((Object)"TestProtocol");
        TestableSSLIOSession sslioSession = new TestableSSLIOSession(this.targetEndpoint, this.ioSession, this.sslMode, this.sslContext, this.sslBufferMode, this.initializer, this.verifier, this.handshakeTimeout, this.sessionStartCallback, this.sessionEndCallback, this.resultCallback);
        Assertions.assertDoesNotThrow(() -> sslioSession.beginHandshake(this.ioSession));
        Assertions.assertEquals((Object)"TestProtocol", (Object)sslioSession.getTlsDetails().getApplicationProtocol());
    }

    @Test
    void testConstructorWhenSSLEngineThrowsException() {
        String protocol = "http/1.1";
        Mockito.when((Object)this.mockSSLEngine.getApplicationProtocol()).thenThrow(UnsupportedOperationException.class);
        TestableSSLIOSession sslioSession = new TestableSSLIOSession(this.targetEndpoint, this.ioSession, this.sslMode, this.sslContext, this.sslBufferMode, this.initializer, this.verifier, this.handshakeTimeout, this.sessionStartCallback, this.sessionEndCallback, this.resultCallback);
        Assertions.assertDoesNotThrow(() -> sslioSession.beginHandshake(this.ioSession));
        Assertions.assertEquals((Object)"http/1.1", (Object)sslioSession.getTlsDetails().getApplicationProtocol());
    }

    static class TestableSSLIOSession
    extends SSLIOSession {
        TestableSSLIOSession(NamedEndpoint targetEndpoint, IOSession session, SSLMode sslMode, SSLContext sslContext, SSLBufferMode sslBufferMode, SSLSessionInitializer initializer, SSLSessionVerifier verifier, Timeout handshakeTimeout, Callback<SSLIOSession> sessionStartCallback, Callback<SSLIOSession> sessionEndCallback, FutureCallback<SSLSession> resultCallback) {
            super(targetEndpoint, session, sslMode, sslContext, sslBufferMode, initializer, verifier, handshakeTimeout, sessionStartCallback, sessionEndCallback, resultCallback);
        }
    }

    static class TestSSLContext
    extends SSLContext {
        protected TestSSLContext(SSLContextSpi contextSpi, Provider provider, String protocol) {
            super(contextSpi, provider, protocol);
        }
    }
}

