/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.ReadStripedFileWithDecodingHelper;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.LocatedStripedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.util.StripedBlockUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestReadStripedFileWithDecoding {
    private static final Logger LOG = LoggerFactory.getLogger(TestReadStripedFileWithDecoding.class);
    private MiniDFSCluster cluster;
    private DistributedFileSystem dfs;
    @Rule
    public Timeout globalTimeout = new Timeout(300000);

    @Before
    public void setup() throws IOException {
        this.cluster = ReadStripedFileWithDecodingHelper.initializeCluster();
        this.dfs = this.cluster.getFileSystem();
    }

    @After
    public void tearDown() throws IOException {
        ReadStripedFileWithDecodingHelper.tearDownCluster(this.cluster);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReportBadBlock() throws IOException {
        Path file = new Path("/corrupted");
        int length = 10;
        byte[] bytes = StripedFileTestUtil.generateBytes(10);
        DFSTestUtil.writeFile((FileSystem)this.dfs, file, bytes);
        int dnIndex = ReadStripedFileWithDecodingHelper.findFirstDataNode(this.cluster, this.dfs, file, ReadStripedFileWithDecodingHelper.CELL_SIZE * ReadStripedFileWithDecodingHelper.NUM_DATA_UNITS);
        Assert.assertNotEquals((long)-1L, (long)dnIndex);
        LocatedStripedBlock slb = (LocatedStripedBlock)this.dfs.getClient().getLocatedBlocks(file.toString(), 0L, (long)(ReadStripedFileWithDecodingHelper.CELL_SIZE * ReadStripedFileWithDecodingHelper.NUM_DATA_UNITS)).get(0);
        LocatedBlock[] blks = StripedBlockUtil.parseStripedBlockGroup((LocatedStripedBlock)slb, (int)ReadStripedFileWithDecodingHelper.CELL_SIZE, (int)ReadStripedFileWithDecodingHelper.NUM_DATA_UNITS, (int)ReadStripedFileWithDecodingHelper.NUM_PARITY_UNITS);
        File storageDir = this.cluster.getInstanceStorageDir(dnIndex, 0);
        File blkFile = MiniDFSCluster.getBlockFile(storageDir, blks[0].getBlock());
        Assert.assertTrue((String)"Block file does not exist", (boolean)blkFile.exists());
        LOG.info("Deliberately corrupting file " + blkFile.getName());
        try (FileOutputStream out = new FileOutputStream(blkFile);){
            out.write("corruption".getBytes());
        }
        for (DataNode dn : this.cluster.getDataNodes()) {
            DataNodeTestUtils.setHeartbeatsDisabledForTests(dn, true);
        }
        try {
            StripedFileTestUtil.verifyStatefulRead((FileSystem)this.dfs, file, 10, bytes, ByteBuffer.allocate(1024));
            FSNamesystem ns = this.cluster.getNamesystem();
            BlockManager bm = ns.getBlockManager();
            BlockInfo blockInfo = ns.getFSDirectory().getINode4Write(file.toString()).asFile().getBlocks()[0];
            Assert.assertEquals((long)1L, (long)bm.getCorruptReplicas((Block)blockInfo).size());
        }
        finally {
            for (DataNode dn : this.cluster.getDataNodes()) {
                DataNodeTestUtils.setHeartbeatsDisabledForTests(dn, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidateBlock() throws IOException, InterruptedException {
        Path file = new Path("/invalidate");
        int length = 10;
        byte[] bytes = StripedFileTestUtil.generateBytes(10);
        DFSTestUtil.writeFile((FileSystem)this.dfs, file, bytes);
        int dnIndex = ReadStripedFileWithDecodingHelper.findFirstDataNode(this.cluster, this.dfs, file, ReadStripedFileWithDecodingHelper.CELL_SIZE * ReadStripedFileWithDecodingHelper.NUM_DATA_UNITS);
        Assert.assertNotEquals((long)-1L, (long)dnIndex);
        LocatedStripedBlock slb = (LocatedStripedBlock)this.dfs.getClient().getLocatedBlocks(file.toString(), 0L, (long)(ReadStripedFileWithDecodingHelper.CELL_SIZE * ReadStripedFileWithDecodingHelper.NUM_DATA_UNITS)).get(0);
        LocatedBlock[] blks = StripedBlockUtil.parseStripedBlockGroup((LocatedStripedBlock)slb, (int)ReadStripedFileWithDecodingHelper.CELL_SIZE, (int)ReadStripedFileWithDecodingHelper.NUM_DATA_UNITS, (int)ReadStripedFileWithDecodingHelper.NUM_PARITY_UNITS);
        Block b = blks[0].getBlock().getLocalBlock();
        DataNode dn = this.cluster.getDataNodes().get(dnIndex);
        DataNodeTestUtils.setHeartbeatsDisabledForTests(dn, true);
        try {
            this.dfs.delete(file, true);
            BlockManagerTestUtil.waitForMarkedDeleteQueueIsEmpty(this.cluster.getNamesystem().getBlockManager());
            FSNamesystem fsn = this.cluster.getNamesystem();
            BlockManager bm = fsn.getBlockManager();
            DatanodeDescriptor dnd = NameNodeAdapter.getDatanode(fsn, dn.getDatanodeId());
            Assert.assertTrue((bm.containsInvalidateBlock((DatanodeInfo)blks[0].getLocations()[0], b) || dnd.containsInvalidateBlock(b) ? 1 : 0) != 0);
        }
        finally {
            DataNodeTestUtils.setHeartbeatsDisabledForTests(dn, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCorruptionECBlockInvalidate() throws Exception {
        Path file = new Path("/invalidate_corrupted");
        int length = ReadStripedFileWithDecodingHelper.BLOCK_SIZE * ReadStripedFileWithDecodingHelper.NUM_DATA_UNITS;
        byte[] bytes = StripedFileTestUtil.generateBytes(length);
        DFSTestUtil.writeFile((FileSystem)this.dfs, file, bytes);
        int dnIndex = ReadStripedFileWithDecodingHelper.findFirstDataNode(this.cluster, this.dfs, file, ReadStripedFileWithDecodingHelper.CELL_SIZE * ReadStripedFileWithDecodingHelper.NUM_DATA_UNITS);
        int dnIndex2 = ReadStripedFileWithDecodingHelper.findDataNodeAtIndex(this.cluster, this.dfs, file, ReadStripedFileWithDecodingHelper.CELL_SIZE * ReadStripedFileWithDecodingHelper.NUM_DATA_UNITS, 2);
        Assert.assertNotEquals((long)-1L, (long)dnIndex);
        Assert.assertNotEquals((long)-1L, (long)dnIndex2);
        LocatedStripedBlock slb = (LocatedStripedBlock)this.dfs.getClient().getLocatedBlocks(file.toString(), 0L, (long)(ReadStripedFileWithDecodingHelper.CELL_SIZE * ReadStripedFileWithDecodingHelper.NUM_DATA_UNITS)).get(0);
        LocatedBlock[] blks = StripedBlockUtil.parseStripedBlockGroup((LocatedStripedBlock)slb, (int)ReadStripedFileWithDecodingHelper.CELL_SIZE, (int)ReadStripedFileWithDecodingHelper.NUM_DATA_UNITS, (int)ReadStripedFileWithDecodingHelper.NUM_PARITY_UNITS);
        Block b = blks[0].getBlock().getLocalBlock();
        Block b2 = blks[1].getBlock().getLocalBlock();
        File storageDir = this.cluster.getInstanceStorageDir(dnIndex, 0);
        File blkFile = MiniDFSCluster.getBlockFile(storageDir, blks[0].getBlock());
        Assert.assertTrue((String)"Block file does not exist", (boolean)blkFile.exists());
        LOG.info("Deliberately corrupting file " + blkFile.getName());
        try (FileOutputStream out = new FileOutputStream(blkFile);){
            out.write("corruption".getBytes());
            out.flush();
        }
        File storageDir2 = this.cluster.getInstanceStorageDir(dnIndex2, 0);
        File blkFile2 = MiniDFSCluster.getBlockFile(storageDir2, blks[1].getBlock());
        Assert.assertTrue((String)"Block file does not exist", (boolean)blkFile2.exists());
        LOG.info("Deliberately corrupting file " + blkFile2.getName());
        try (FileOutputStream out = new FileOutputStream(blkFile2);){
            out.write("corruption".getBytes());
            out.flush();
        }
        for (DataNode dataNode : this.cluster.getDataNodes()) {
            DataNodeTestUtils.setHeartbeatsDisabledForTests(dataNode, true);
        }
        try {
            StripedFileTestUtil.verifyStatefulRead((FileSystem)this.dfs, file, length, bytes, ByteBuffer.allocate(1024));
            FSNamesystem ns = this.cluster.getNamesystem();
            BlockManager bm = ns.getBlockManager();
            BlockInfo blockInfo = ns.getFSDirectory().getINode4Write(file.toString()).asFile().getBlocks()[0];
            GenericTestUtils.waitFor(() -> {
                if (bm.getCorruptReplicas((Block)blockInfo) == null) {
                    return false;
                }
                return bm.getCorruptReplicas((Block)blockInfo).size() == 2;
            }, (long)250L, (long)60000L);
            Assert.assertEquals((long)2L, (long)bm.getCorruptReplicas((Block)blockInfo).size());
            DatanodeDescriptor dnd = NameNodeAdapter.getDatanode(ns, this.cluster.getDataNodes().get(dnIndex).getDatanodeId());
            DatanodeDescriptor dnd2 = NameNodeAdapter.getDatanode(ns, this.cluster.getDataNodes().get(dnIndex2).getDatanodeId());
            for (DataNode datanode : this.cluster.getDataNodes()) {
                if (datanode.getDatanodeUuid().equals(dnd.getDatanodeUuid()) || datanode.getDatanodeUuid().equals(dnd2.getDatanodeUuid())) continue;
                DataNodeTestUtils.setHeartbeatsDisabledForTests(datanode, false);
            }
            GenericTestUtils.waitFor(() -> bm.containsInvalidateBlock((DatanodeInfo)blks[0].getLocations()[0], b) || dnd.containsInvalidateBlock(b), (long)250L, (long)60000L);
            Assert.assertTrue((bm.containsInvalidateBlock((DatanodeInfo)blks[0].getLocations()[0], b) || dnd.containsInvalidateBlock(b) ? 1 : 0) != 0);
            GenericTestUtils.waitFor(() -> bm.containsInvalidateBlock((DatanodeInfo)blks[1].getLocations()[0], b2) || dnd2.containsInvalidateBlock(b2), (long)250L, (long)60000L);
            Assert.assertTrue((bm.containsInvalidateBlock((DatanodeInfo)blks[1].getLocations()[0], b2) || dnd2.containsInvalidateBlock(b2) ? 1 : 0) != 0);
        }
        finally {
            for (DataNode datanode : this.cluster.getDataNodes()) {
                DataNodeTestUtils.setHeartbeatsDisabledForTests(datanode, false);
            }
        }
    }

    @Test
    public void testMoreThanOneCorruptedBlock() throws IOException {
        Path file = new Path("/corrupted");
        int length = ReadStripedFileWithDecodingHelper.BLOCK_SIZE * ReadStripedFileWithDecodingHelper.NUM_DATA_UNITS;
        byte[] bytes = StripedFileTestUtil.generateBytes(length);
        DFSTestUtil.writeFile((FileSystem)this.dfs, file, bytes);
        byte[] buffer = new byte[length + 100];
        for (int count = 2; count < ReadStripedFileWithDecodingHelper.NUM_PARITY_UNITS; ++count) {
            ReadStripedFileWithDecodingHelper.corruptBlocks(this.cluster, this.dfs, file, count, 0, false);
            StripedFileTestUtil.verifyStatefulRead((FileSystem)this.dfs, file, length, bytes, buffer);
        }
    }

    @Test
    public void testReadWithCorruptedDataBlockAndParityBlock() throws IOException {
        Path file = new Path("/corruptedDataBlockAndParityBlock");
        int length = ReadStripedFileWithDecodingHelper.BLOCK_SIZE * ReadStripedFileWithDecodingHelper.NUM_DATA_UNITS;
        byte[] bytes = StripedFileTestUtil.generateBytes(length);
        DFSTestUtil.writeFile((FileSystem)this.dfs, file, bytes);
        int dataBlkDelNum = 1;
        int parityBlkDelNum = 1;
        int recoverBlkNum = dataBlkDelNum + parityBlkDelNum;
        int[] dataBlkIndices = new int[]{0};
        int[] parityBlkIndices = new int[]{6};
        LocatedBlocks locatedBlocks = ReadStripedFileWithDecodingHelper.getLocatedBlocks(this.dfs, file);
        LocatedStripedBlock lastBlock = (LocatedStripedBlock)locatedBlocks.getLastLocatedBlock();
        int[] delBlkIndices = new int[recoverBlkNum];
        System.arraycopy(dataBlkIndices, 0, delBlkIndices, 0, dataBlkIndices.length);
        System.arraycopy(parityBlkIndices, 0, delBlkIndices, dataBlkIndices.length, parityBlkIndices.length);
        ExtendedBlock[] delBlocks = new ExtendedBlock[recoverBlkNum];
        for (int i = 0; i < recoverBlkNum; ++i) {
            delBlocks[i] = StripedBlockUtil.constructInternalBlock((ExtendedBlock)lastBlock.getBlock(), (int)ReadStripedFileWithDecodingHelper.CELL_SIZE, (int)ReadStripedFileWithDecodingHelper.NUM_DATA_UNITS, (int)delBlkIndices[i]);
            this.cluster.corruptBlockOnDataNodes(delBlocks[i]);
        }
        byte[] buffer = new byte[length + 100];
        StripedFileTestUtil.verifyStatefulRead((FileSystem)this.dfs, file, length, bytes, buffer);
    }
}

