/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.storage.common;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.yarn.server.timelineservice.storage.common.Separator;

public final class ColumnHelper {
    private ColumnHelper() {
    }

    public static byte[] getColumnQualifier(byte[] columnPrefixBytes, String qualifier) {
        byte[] encodedQualifier = Separator.encode(qualifier, Separator.SPACE, Separator.TAB);
        if (columnPrefixBytes == null) {
            return encodedQualifier;
        }
        byte[] columnQualifier = Separator.QUALIFIERS.join(columnPrefixBytes, encodedQualifier);
        return columnQualifier;
    }

    public static byte[] getColumnQualifier(byte[] columnPrefixBytes, long qualifier) {
        if (columnPrefixBytes == null) {
            return Bytes.toBytes((long)qualifier);
        }
        byte[] columnQualifier = Separator.QUALIFIERS.join(columnPrefixBytes, Bytes.toBytes((long)qualifier));
        return columnQualifier;
    }

    public static byte[] getColumnQualifier(byte[] columnPrefixBytes, byte[] qualifier) {
        if (columnPrefixBytes == null) {
            return qualifier;
        }
        byte[] columnQualifier = Separator.QUALIFIERS.join(columnPrefixBytes, qualifier);
        return columnQualifier;
    }
}

