/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.ReservationACL;
import org.apache.hadoop.yarn.exceptions.YarnException;

public abstract class ReservationsACLsManager {
    private boolean isReservationACLsEnable;
    Map<String, Map<ReservationACL, AccessControlList>> reservationAcls = new HashMap<String, Map<ReservationACL, AccessControlList>>();

    public ReservationsACLsManager(Configuration conf) throws YarnException {
        this.isReservationACLsEnable = conf.getBoolean("yarn.acl.reservation-enable", false) && conf.getBoolean("yarn.acl.enable", false);
    }

    public boolean checkAccess(UserGroupInformation callerUGI, ReservationACL acl, String queueName) {
        if (!this.isReservationACLsEnable) {
            return true;
        }
        if (this.reservationAcls.containsKey(queueName)) {
            Map<ReservationACL, AccessControlList> acls = this.reservationAcls.get(queueName);
            if (acls != null && acls.containsKey(acl)) {
                return acls.get(acl).isUserAllowed(callerUGI);
            }
            return true;
        }
        return false;
    }
}

