/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.jmx.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import javax.naming.OperationNotSupportedException;
import org.apache.commons.modeler.ManagedBean;
import org.apache.geode.admin.AdminException;
import org.apache.geode.admin.CacheServerConfig;
import org.apache.geode.admin.CacheVmConfig;
import org.apache.geode.admin.ConfigurationParameter;
import org.apache.geode.admin.StatisticResource;
import org.apache.geode.admin.SystemMemberCache;
import org.apache.geode.admin.SystemMemberCacheEvent;
import org.apache.geode.admin.SystemMemberRegionEvent;
import org.apache.geode.admin.internal.AdminDistributedSystemImpl;
import org.apache.geode.admin.internal.CacheServerImpl;
import org.apache.geode.admin.internal.ConfigurationParameterImpl;
import org.apache.geode.admin.jmx.internal.AdminDistributedSystemJmxImpl;
import org.apache.geode.admin.jmx.internal.ConfigurationParameterJmxImpl;
import org.apache.geode.admin.jmx.internal.MBeanUtils;
import org.apache.geode.admin.jmx.internal.ManagedResource;
import org.apache.geode.admin.jmx.internal.ManagedResourceType;
import org.apache.geode.admin.jmx.internal.RefreshNotificationType;
import org.apache.geode.admin.jmx.internal.StatisticResourceJmxImpl;
import org.apache.geode.admin.jmx.internal.SystemMemberCacheJmxImpl;
import org.apache.geode.admin.jmx.internal.SystemMemberJmx;
import org.apache.geode.internal.admin.GemFireVM;
import org.apache.geode.internal.admin.StatResource;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

@Deprecated
public class CacheServerJmxImpl
extends CacheServerImpl
implements ManagedResource,
CacheVmConfig,
CacheServerConfig,
SystemMemberJmx {
    private static final Logger logger = LogService.getLogger();
    private int refreshInterval = 0;
    private ObjectName objectName;
    private String mbeanName;
    private ModelMBean modelMBean;
    private SystemMemberCacheJmxImpl managedSystemMemberCache;
    private final Map<StatResource, StatisticResourceJmxImpl> managedStatisticsResourcesMap = new HashMap<StatResource, StatisticResourceJmxImpl>();

    CacheServerJmxImpl(AdminDistributedSystemJmxImpl system, GemFireVM vm) throws AdminException {
        super((AdminDistributedSystemImpl)system, vm);
        this.initializeMBean();
    }

    CacheServerJmxImpl(AdminDistributedSystemJmxImpl system, CacheVmConfig config) throws AdminException {
        super((AdminDistributedSystemImpl)system, config);
        this.initializeMBean();
    }

    private void initializeMBean() throws AdminException {
        this.mbeanName = "GemFire.CacheVm:id=" + MBeanUtils.makeCompliantMBeanNameProperty(this.getId()) + ",type=" + MBeanUtils.makeCompliantMBeanNameProperty(this.getType().getName());
        this.objectName = MBeanUtils.createMBean(this, this.addDynamicAttributes(MBeanUtils.lookupManagedBean(this)));
        AdminDistributedSystemJmxImpl sysJmx = (AdminDistributedSystemJmxImpl)this.system;
        if (sysJmx.getRefreshInterval() > 0) {
            this.refreshInterval = sysJmx.getRefreshInterval();
        }
    }

    @Override
    public String getMBeanName() {
        return this.mbeanName;
    }

    @Override
    public ModelMBean getModelMBean() {
        return this.modelMBean;
    }

    @Override
    public void setModelMBean(ModelMBean modelMBean) {
        this.modelMBean = modelMBean;
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public ManagedResourceType getManagedResourceType() {
        return ManagedResourceType.CACHE_VM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupResource() {
        Map<StatResource, StatisticResourceJmxImpl> map = this.managedStatisticsResourcesMap;
        synchronized (map) {
            ConfigurationParameter[] names = this.getConfiguration();
            if (names != null) {
                for (ConfigurationParameter parm : names) {
                    ((ConfigurationParameterImpl)parm).removeConfigurationParameterListener(this);
                }
            }
            this.parms.clear();
            Collection<StatisticResourceJmxImpl> statisticResources = this.managedStatisticsResourcesMap.values();
            for (StatisticResourceJmxImpl statisticResource : statisticResources) {
                MBeanUtils.unregisterMBean(statisticResource);
            }
            this.managedStatisticsResourcesMap.clear();
        }
        MBeanUtils.unregisterMBean(this.managedSystemMemberCache);
        this.managedSystemMemberCache = null;
    }

    @Override
    public String getHost() {
        return this.getConfig().getHost();
    }

    @Override
    public void setHost(String host) {
        this.getConfig().setHost(host);
    }

    @Override
    public String getWorkingDirectory() {
        return this.getConfig().getWorkingDirectory();
    }

    @Override
    public void setWorkingDirectory(String dir) {
        this.getConfig().setWorkingDirectory(dir);
    }

    @Override
    public String getProductDirectory() {
        return this.getConfig().getProductDirectory();
    }

    @Override
    public void setProductDirectory(String dir) {
        this.getConfig().setProductDirectory(dir);
    }

    @Override
    public String getRemoteCommand() {
        return this.getConfig().getRemoteCommand();
    }

    @Override
    public void setRemoteCommand(String remoteCommand) {
        this.getConfig().setRemoteCommand(remoteCommand);
    }

    @Override
    public void validate() {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new UnsupportedOperationException("Should not be invoked");
    }

    @Override
    public String getCacheXMLFile() {
        return this.getConfig().getCacheXMLFile();
    }

    @Override
    public void setCacheXMLFile(String cacheXMLFile) {
        this.getConfig().setCacheXMLFile(cacheXMLFile);
    }

    @Override
    public String getClassPath() {
        return this.getConfig().getClassPath();
    }

    @Override
    public void setClassPath(String classpath) {
        this.getConfig().setClassPath(classpath);
    }

    @Override
    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    @Override
    public void _setRefreshInterval(int refreshInterval) {
        boolean isRegistered = MBeanUtils.isRefreshNotificationRegistered(this, RefreshNotificationType.SYSTEM_MEMBER_CONFIG);
        if (isRegistered && this.getRefreshInterval() == refreshInterval) {
            return;
        }
        this.refreshInterval = SystemMemberJmx.Helper.setAndReturnRefreshInterval(this, refreshInterval);
    }

    @Override
    @Deprecated
    public void setRefreshInterval(int refreshInterval) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("RefreshInterval can not be set directly. Use DistributedSystemConfig.refreshInterval.");
    }

    @Override
    public void refreshConfig() throws AdminException {
        if (this.refreshInterval > 0) {
            this._setRefreshInterval(this.refreshInterval);
        }
        super.refreshConfig();
    }

    @Override
    public ObjectName manageCache() throws AdminException, MalformedObjectNameException {
        return SystemMemberJmx.Helper.manageCache(this);
    }

    @Override
    public ObjectName[] manageStats() throws AdminException, MalformedObjectNameException {
        return SystemMemberJmx.Helper.manageStats(this);
    }

    @Override
    public ObjectName[] manageStat(String statisticsTypeName) throws AdminException, MalformedObjectNameException {
        return SystemMemberJmx.Helper.manageStat(this, statisticsTypeName);
    }

    @Override
    public void handleNotification(Notification notification, Object hb) {
        AdminDistributedSystemJmxImpl systemJmx = (AdminDistributedSystemJmxImpl)this.system;
        if (!systemJmx.isRmiClientCountZero()) {
            SystemMemberJmx.Helper.handleNotification(this, notification, hb);
        }
    }

    @Override
    protected ConfigurationParameter createConfigurationParameter(String name, String description, Object value, Class type, boolean userModifiable) {
        return new ConfigurationParameterJmxImpl(name, description, value, type, userModifiable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StatisticResource createStatisticResource(StatResource stat) throws AdminException {
        StatisticResourceJmxImpl managedStatisticResource = null;
        Map<StatResource, StatisticResourceJmxImpl> map = this.managedStatisticsResourcesMap;
        synchronized (map) {
            StatisticResourceJmxImpl statisticResourceJmxImpl = this.managedStatisticsResourcesMap.get(stat);
            if (statisticResourceJmxImpl != null) {
                managedStatisticResource = statisticResourceJmxImpl;
            } else {
                managedStatisticResource = new StatisticResourceJmxImpl(stat, this);
                managedStatisticResource.getStatistics();
                this.managedStatisticsResourcesMap.put(stat, managedStatisticResource);
            }
        }
        return managedStatisticResource;
    }

    @Override
    protected SystemMemberCache createSystemMemberCache(GemFireVM vm) throws AdminException {
        if (this.managedSystemMemberCache == null) {
            this.managedSystemMemberCache = new SystemMemberCacheJmxImpl(vm);
        }
        return this.managedSystemMemberCache;
    }

    @Override
    public ManagedBean addDynamicAttributes(ManagedBean managed) throws AdminException {
        return SystemMemberJmx.Helper.addDynamicAttributes(this, managed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ManagedResource> cleanupBridgeClientResources(String clientId) {
        ArrayList<ManagedResource> returnedResources = new ArrayList<ManagedResource>();
        String compatibleId = "id_" + MBeanUtils.makeCompliantMBeanNameProperty(clientId);
        Map<StatResource, StatisticResourceJmxImpl> map = this.managedStatisticsResourcesMap;
        synchronized (map) {
            Set<Map.Entry<StatResource, StatisticResourceJmxImpl>> entrySet = this.managedStatisticsResourcesMap.entrySet();
            Iterator<Map.Entry<StatResource, StatisticResourceJmxImpl>> it = entrySet.iterator();
            while (it.hasNext()) {
                Map.Entry<StatResource, StatisticResourceJmxImpl> entry = it.next();
                StatisticResourceJmxImpl resource = entry.getValue();
                if (!resource.getMBeanName().contains(compatibleId)) continue;
                it.remove();
                returnedResources.add(resource);
            }
        }
        return returnedResources;
    }

    @Override
    public void handleClientMembership(String clientId, int eventType) {
        String notifType = null;
        List<ManagedResource> cleanedUp = null;
        if (eventType == 1) {
            notifType = "gemfire.distributedsystem.cache.client.left";
            cleanedUp = this.cleanupBridgeClientResources(clientId);
        } else if (eventType == 2) {
            notifType = "gemfire.distributedsystem.cache.client.crashed";
            cleanedUp = this.cleanupBridgeClientResources(clientId);
        } else if (eventType == 0) {
            notifType = "gemfire.distributedsystem.cache.client.joined";
        }
        if (cleanedUp != null) {
            for (ManagedResource resource : cleanedUp) {
                MBeanUtils.unregisterMBean(resource);
            }
        }
        SystemMemberJmx.Helper.sendNotification(this, new Notification(notifType, (Object)this.modelMBean, (long)SystemMemberJmx.Helper.getNextNotificationSequenceNumber(), clientId));
    }

    @Override
    public void handleCacheCreate(SystemMemberCacheEvent event) {
        SystemMemberJmx.Helper.sendNotification(this, new Notification("gemfire.distributedsystem.cache.created", (Object)this.modelMBean, (long)SystemMemberJmx.Helper.getNextNotificationSequenceNumber(), SystemMemberJmx.Helper.getCacheEventDetails(event)));
    }

    @Override
    public void handleCacheClose(SystemMemberCacheEvent event) {
        SystemMemberJmx.Helper.sendNotification(this, new Notification("gemfire.distributedsystem.cache.closed", (Object)this.modelMBean, (long)SystemMemberJmx.Helper.getNextNotificationSequenceNumber(), SystemMemberJmx.Helper.getCacheEventDetails(event)));
    }

    @Override
    public void handleRegionCreate(SystemMemberRegionEvent event) {
        Notification notification = new Notification("gemfire.distributedsystem.cache.region.created", (Object)this.modelMBean, (long)SystemMemberJmx.Helper.getNextNotificationSequenceNumber(), SystemMemberJmx.Helper.getRegionEventDetails(event));
        notification.setUserData(event.getRegionPath());
        SystemMemberJmx.Helper.sendNotification(this, notification);
    }

    @Override
    public void handleRegionLoss(SystemMemberRegionEvent event) {
        ManagedResource cleanedUp;
        SystemMemberCacheJmxImpl cacheResource = this.managedSystemMemberCache;
        if (cacheResource != null && (cleanedUp = cacheResource.cleanupRegionResources(event.getRegionPath())) != null) {
            MBeanUtils.unregisterMBean(cleanedUp);
        }
        Notification notification = new Notification("gemfire.distributedsystem.cache.region.lost", (Object)this.modelMBean, (long)SystemMemberJmx.Helper.getNextNotificationSequenceNumber(), SystemMemberJmx.Helper.getRegionEventDetails(event));
        notification.setUserData(event.getRegionPath());
        SystemMemberJmx.Helper.sendNotification(this, notification);
    }
}

