/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.serialization;

import org.apache.geode.internal.serialization.Version;

abstract class AbstractVersion
implements Version {
    private final short ordinal;

    protected AbstractVersion(short ordinal) {
        this.ordinal = ordinal;
    }

    @Override
    public short ordinal() {
        return this.ordinal;
    }

    @Override
    public int compareTo(Version other) {
        if (other == null) {
            return 1;
        }
        return this.compareTo(other.ordinal());
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Version) {
            return this.ordinal() == ((Version)other).ordinal();
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        int mult = 37;
        result = 37 * result + this.ordinal();
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[ordinal=" + this.ordinal() + ']';
    }

    @Override
    public final boolean isOlderThan(Version version) {
        return this.compareTo(version) < 0;
    }

    @Override
    public final boolean isNotOlderThan(Version version) {
        return this.compareTo(version) >= 0;
    }

    @Override
    public final boolean isNewerThan(Version version) {
        return this.compareTo(version) > 0;
    }

    @Override
    public final boolean isNotNewerThan(Version version) {
        return this.compareTo(version) <= 0;
    }

    @Override
    private int compareTo(short other) {
        short thisOrdinal = this.ordinal();
        short otherOrdinal = other;
        return thisOrdinal - otherOrdinal;
    }
}

