/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SimpleJsonPermsTest
extends BaseJDBCTestCase {
    private static final String DB_NAME = "simplejsonpermsdb";
    private static final String TEST_DBO = "TEST_DBO";
    private static final String ALICE = "ALICE";
    private static final String[] LEGAL_USERS = new String[]{"TEST_DBO", "ALICE"};
    private static final String LOAD_TOOL = "call syscs_util.syscs_register_tool( 'simpleJson', true )";
    private static final String UNLOAD_TOOL = "call syscs_util.syscs_register_tool( 'simpleJson', false )";
    private static final String LACK_EXECUTE_PRIV = "42504";

    public SimpleJsonPermsTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = (BaseTestSuite)TestConfiguration.embeddedSuite(SimpleJsonPermsTest.class);
        SupportFilesSetup customTest = new SupportFilesSetup((Test)suite, new String[]{"functionTests/tests/lang/json.dat"});
        Test authenticatedTest = DatabasePropertyTestSetup.builtinAuthentication((Test)customTest, LEGAL_USERS, "SimpleJsonPermissions");
        Test authorizedTest = TestConfiguration.sqlAuthorizationDecoratorSingleUse(authenticatedTest, DB_NAME, true);
        return authorizedTest;
    }

    public void test_001_basic() throws Exception {
        Connection dboConnection = this.openUserConnection(TEST_DBO);
        Connection aliceConnection = this.openUserConnection(ALICE);
        this.goodStatement(aliceConnection, "create table t( a int )");
        this.expectExecutionError(aliceConnection, LACK_EXECUTE_PRIV, LOAD_TOOL);
        this.goodStatement(dboConnection, LOAD_TOOL);
        this.goodStatement(aliceConnection, "create function f_double( jsonArray test_dbo.JSONArray )\nreturns table\n(\n  str_col varchar( 10 ),\n  bool_col boolean,\n  num_col double\n)\nlanguage java parameter style derby_jdbc_result_set contains sql\nexternal name 'org.apache.derby.optional.api.SimpleJsonVTI.readArray'\n");
        String[][] stringResults = new String[][]{{"abc", "true", "127.0"}};
        String[][] fileResults = new String[][]{{"abc", "true", "127.0"}, {"def", "false", "1.2"}, {"ghi", null, "345.67"}, {"lmn", "true", "9.223372036854776E18"}};
        this.assertResults(aliceConnection, "select * from table\n(\n    f_double\n    (\n        test_dbo.readArrayFromString\n        ( '[{ \"STR_COL\" : \"abc\", \"BOOL_COL\" : true, \"NUM_COL\" : 127 }]' )\n    )\n) t\n", stringResults, false);
        PreparedStatement ps = null;
        ResultSet rs = null;
        File inputFile = SupportFilesSetup.getReadOnly("json.dat");
        ps = aliceConnection.prepareStatement("select * from table\n( f_double( test_dbo.readArrayFromFile( ?, 'UTF-8' ) ) ) t");
        ps.setString(1, PrivilegedFileOpsForTests.getAbsolutePath(inputFile));
        rs = ps.executeQuery();
        this.assertResults(rs, fileResults, false);
        rs.close();
        ps.close();
        ps = aliceConnection.prepareStatement("select * from table\n( f_double( test_dbo.readArrayFromURL( ?, 'UTF-8' ) ) ) t");
        String inputFileURL = PrivilegedFileOpsForTests.toURI(inputFile).toURL().toString();
        ps.setString(1, inputFileURL);
        rs = ps.executeQuery();
        this.assertResults(rs, fileResults, false);
        rs.close();
        ps.close();
        this.goodStatement(aliceConnection, "drop table t");
        this.goodStatement(aliceConnection, "drop function f_double");
        this.expectExecutionError(aliceConnection, LACK_EXECUTE_PRIV, UNLOAD_TOOL);
        this.goodStatement(dboConnection, UNLOAD_TOOL);
    }
}

