/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.KeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.impl.sql.execute.CreateIndexConstantAction;
import org.apache.derby.impl.sql.execute.DDLConstantAction;
import org.apache.derby.shared.common.sanity.SanityManager;

abstract class DDLSingleTableConstantAction
extends DDLConstantAction {
    protected UUID tableId;

    DDLSingleTableConstantAction(UUID tableId) {
        this.tableId = tableId;
    }

    void dropConstraint(ConstraintDescriptor consDesc, Activation activation, LanguageConnectionContext lcc, boolean clearDeps) throws StandardException {
        this.dropConstraint(consDesc, null, null, activation, lcc, clearDeps);
    }

    void dropConstraint(ConstraintDescriptor consDesc, TableDescriptor skipCreate, Activation activation, LanguageConnectionContext lcc, boolean clearDeps) throws StandardException {
        this.dropConstraint(consDesc, skipCreate, null, activation, lcc, clearDeps);
    }

    void dropConstraint(ConstraintDescriptor consDesc, TableDescriptor skipCreate, List<ConstantAction> newConglomActions, Activation activation, LanguageConnectionContext lcc, boolean clearDeps) throws StandardException {
        ConglomerateDescriptor newBackingConglomCD;
        Properties ixProps = null;
        if (consDesc instanceof KeyConstraintDescriptor) {
            ixProps = new Properties();
            this.loadIndexProperties(lcc, ((KeyConstraintDescriptor)consDesc).getIndexConglomerateDescriptor(lcc.getDataDictionary()), ixProps);
        }
        if ((newBackingConglomCD = consDesc.drop(lcc, clearDeps)) == null) {
            return;
        }
        if (skipCreate != null && skipCreate.getUUID().equals(consDesc.getTableDescriptor().getUUID())) {
            if (newConglomActions != null) {
                newConglomActions.add(this.getConglomReplacementAction(newBackingConglomCD, consDesc.getTableDescriptor(), ixProps));
            }
        } else {
            this.executeConglomReplacement(this.getConglomReplacementAction(newBackingConglomCD, consDesc.getTableDescriptor(), ixProps), activation);
        }
    }

    void dropConglomerate(ConglomerateDescriptor congDesc, TableDescriptor td, Activation activation, LanguageConnectionContext lcc) throws StandardException {
        this.dropConglomerate(congDesc, td, false, null, activation, lcc);
    }

    void dropConglomerate(ConglomerateDescriptor congDesc, TableDescriptor td, boolean skipCreate, List<ConstantAction> newConglomActions, Activation activation, LanguageConnectionContext lcc) throws StandardException {
        Properties ixProps = new Properties();
        this.loadIndexProperties(lcc, congDesc, ixProps);
        ConglomerateDescriptor newBackingConglomCD = congDesc.drop(lcc, td);
        if (newBackingConglomCD == null) {
            return;
        }
        if (skipCreate) {
            if (newConglomActions != null) {
                newConglomActions.add(this.getConglomReplacementAction(newBackingConglomCD, td, ixProps));
            }
        } else {
            this.executeConglomReplacement(this.getConglomReplacementAction(newBackingConglomCD, td, ixProps), activation);
        }
    }

    void recreateUniqueConstraintBackingIndexAsUniqueWhenNotNull(ConglomerateDescriptor cd, TableDescriptor td, Activation activation, LanguageConnectionContext lcc) throws StandardException {
        Properties prop = new Properties();
        this.loadIndexProperties(lcc, cd, prop);
        ArrayList<ConstantAction> list = new ArrayList<ConstantAction>();
        this.dropConglomerate(cd, td, false, list, activation, lcc);
        String[] cols = cd.getColumnNames();
        if (cols == null) {
            int[] pos = cd.getIndexDescriptor().baseColumnPositions();
            cols = new String[pos.length];
            for (int i = 0; i < cols.length; ++i) {
                cols[i] = td.getColumnDescriptor(pos[i]).getColumnName();
            }
        }
        CreateIndexConstantAction action = new CreateIndexConstantAction(false, false, true, cd.getIndexDescriptor().hasDeferrableChecking(), false, 3, cd.getIndexDescriptor().indexType(), td.getSchemaName(), cd.getConglomerateName(), td.getName(), td.getUUID(), cols, cd.getIndexDescriptor().isAscending(), true, cd.getUUID(), prop);
        action.executeConstantAction(activation);
    }

    private void loadIndexProperties(LanguageConnectionContext lcc, ConglomerateDescriptor congDesc, Properties ixProps) throws StandardException {
        ConglomerateController cc = lcc.getTransactionExecute().openConglomerate(congDesc.getConglomerateNumber(), false, 4, 7, 5);
        cc.getInternalTablePropertySet(ixProps);
        cc.close();
    }

    ConstantAction getConglomReplacementAction(ConglomerateDescriptor srcCD, TableDescriptor td, Properties properties) throws StandardException {
        return new CreateIndexConstantAction(srcCD, td, properties);
    }

    void executeConglomReplacement(ConstantAction replaceConglom, Activation activation) throws StandardException {
        CreateIndexConstantAction replaceConglomAction = (CreateIndexConstantAction)replaceConglom;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        replaceConglomAction.executeConstantAction(activation);
        ConglomerateDescriptor[] congDescs = dd.getConglomerateDescriptors(replaceConglomAction.getReplacedConglomNumber());
        if (congDescs.length < 1) {
            SanityManager.THROWASSERT("Should have found at least one conglomerate descriptor that needs an updated conglomerate number (due to a dropped index), but only found " + congDescs.length);
        }
        dd.updateConglomerateDescriptor(congDescs, replaceConglomAction.getCreatedConglomNumber(), lcc.getTransactionExecute());
    }
}

