/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class BinaryArithmeticOperatorNode
extends BinaryOperatorNode {
    static final int K_DIVIDE = 0;
    static final int K_MINUS = 1;
    static final int K_PLUS = 2;
    static final int K_TIMES = 3;
    static final int K_MOD = 4;
    final int kind;

    BinaryArithmeticOperatorNode(int kind, ValueNode leftOperand, ValueNode rightOperand, ContextManager cm) {
        super(leftOperand, rightOperand, "org.apache.derby.iapi.types.NumberDataValue", "org.apache.derby.iapi.types.NumberDataValue", cm);
        String mNam;
        String op;
        this.kind = kind;
        switch (kind) {
            case 0: {
                op = "/";
                mNam = "divide";
                break;
            }
            case 1: {
                op = "-";
                mNam = "minus";
                break;
            }
            case 2: {
                op = "+";
                mNam = "plus";
                break;
            }
            case 3: {
                op = "*";
                mNam = "times";
                break;
            }
            case 4: {
                op = "mod";
                mNam = "mod";
                break;
            }
            default: {
                SanityManager.NOTREACHED();
                op = null;
                mNam = null;
            }
        }
        this.setOperator(op);
        this.setMethodName(mNam);
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        super.bindExpression(fromList, subqueryList, aggregates);
        TypeId leftType = this.leftOperand.getTypeId();
        TypeId rightType = this.rightOperand.getTypeId();
        DataTypeDescriptor leftDTS = this.leftOperand.getTypeServices();
        DataTypeDescriptor rightDTS = this.rightOperand.getTypeServices();
        if (leftType.isStringTypeId() && rightType.isNumericTypeId()) {
            boolean nullableResult = leftDTS.isNullable() || rightDTS.isNullable();
            int precision = rightDTS.getPrecision();
            int scale = rightDTS.getScale();
            int maxWidth = rightDTS.getMaximumWidth();
            if (rightType.isDecimalTypeId()) {
                int charMaxWidth = leftDTS.getMaximumWidth();
                scale += charMaxWidth;
                maxWidth = (precision += 2 * charMaxWidth) + 3;
            }
            this.leftOperand = new CastNode(this.leftOperand, new DataTypeDescriptor(rightType, precision, scale, nullableResult, maxWidth), this.getContextManager());
            ((CastNode)this.leftOperand).bindCastNodeOnly();
        } else if (rightType.isStringTypeId() && leftType.isNumericTypeId()) {
            boolean nullableResult = leftDTS.isNullable() || rightDTS.isNullable();
            int precision = leftDTS.getPrecision();
            int scale = leftDTS.getScale();
            int maxWidth = leftDTS.getMaximumWidth();
            if (leftType.isDecimalTypeId()) {
                int charMaxWidth = rightDTS.getMaximumWidth();
                scale += charMaxWidth;
                maxWidth = (precision += 2 * charMaxWidth) + 3;
            }
            this.rightOperand = new CastNode(this.rightOperand, new DataTypeDescriptor(leftType, precision, scale, nullableResult, maxWidth), this.getContextManager());
            ((CastNode)this.rightOperand).bindCastNodeOnly();
        }
        this.setType(this.leftOperand.getTypeCompiler().resolveArithmeticOperation(this.leftOperand.getTypeServices(), this.rightOperand.getTypeServices(), this.operator));
        return this;
    }

    @Override
    boolean isSameNodeKind(ValueNode o) {
        return super.isSameNodeKind(o) && ((BinaryArithmeticOperatorNode)o).kind == this.kind;
    }
}

