/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.TestRoutines;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ConnectTest
extends BaseJDBCTestCase {
    public ConnectTest(String name) {
        super(name);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new BaseTestSuite("empty ConnectTest:DriverManager not supported");
        }
        BaseTestSuite suite = new BaseTestSuite("ConnectTest suite");
        suite.addTest(TestConfiguration.defaultSuite(ConnectTest.class));
        suite.addTest(TestConfiguration.clientServerDecorator((Test)new ConnectTest("clientTestDerby2026LoginTimeout")));
        return new CleanDatabaseTestSetup((Test)suite);
    }

    public void testConnectRepeatedly() throws SQLException {
        String url = "jdbc:derby:wombat;create=true";
        Connection con = DriverManager.getConnection(url);
        Statement st = con.createStatement();
        JDBC.assertSingleValueResultSet(st.executeQuery("values 1"), "1");
        st.close();
        con.close();
        con = DriverManager.getConnection(url);
        st = con.createStatement();
        JDBC.assertSingleValueResultSet(st.executeQuery("values 1"), "1");
        st.close();
        con.close();
    }

    public void testDBName() throws SQLException {
        String url = "jdbc:derby:wombat/seg0;create=true";
        try {
            DriverManager.getConnection(url);
            ConnectTest.fail((String)"Error XBM0J is expected");
        }
        catch (SQLException e) {
            ConnectTest.assertEquals((String)"XJ041", (String)e.getSQLState());
        }
        url = "jdbc:derby: ;databaseName=wombat";
        try {
            DriverManager.getConnection(url);
            ConnectTest.fail((String)"Error XJ004 is expected");
        }
        catch (SQLException e) {
            ConnectTest.assertEquals((String)"XJ004", (String)e.getSQLState());
        }
        url = "jdbc:derby:;databaseName=wombat";
        Connection con = DriverManager.getConnection(url);
        con.close();
    }

    public void testGrantAndRevoke() throws SQLException {
        String url = "jdbc:derby:wombat";
        Connection con = DriverManager.getConnection(url);
        String sql = "create table mytab(i int)";
        Statement st = con.createStatement();
        st.execute(sql);
        sql = "grant select on mytab to satheesh";
        try {
            st.executeUpdate(sql);
            ConnectTest.fail((String)"Error 42Z60 is expected");
        }
        catch (SQLException e) {
            ConnectTest.assertEquals((String)"42Z60", (String)e.getSQLState());
        }
        sql = "revoke select on mytab to satheesh";
        try {
            st.executeUpdate(sql);
            ConnectTest.fail((String)"Error 42Z60 is expected");
        }
        catch (SQLException e) {
            ConnectTest.assertEquals((String)"42Z60", (String)e.getSQLState());
        }
        sql = "drop table mytab";
        st.execute(sql);
        st.close();
        con.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientTestDerby2026LoginTimeout() throws SQLException {
        String url = "jdbc:derby://" + TestConfiguration.getCurrent().getHostName() + ":" + TestConfiguration.getCurrent().getPort() + "/" + TestConfiguration.getCurrent().getDefaultDatabaseName();
        try {
            DriverManager.setLoginTimeout(10);
            try {
                Class.forName("org.apache.derby.jdbc.ClientDriver");
            }
            catch (ClassNotFoundException e) {
                ConnectTest.fail((String)e.getMessage());
            }
            Connection conn = DriverManager.getConnection(url);
            TestRoutines.installRoutines(conn);
            CallableStatement cs = conn.prepareCall("CALL TESTROUTINE.SLEEP(20000)");
            cs.execute();
            conn.rollback();
        }
        finally {
            DriverManager.setLoginTimeout(0);
        }
    }
}

