/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class ValueTest {
    private static final Option NULL_OPTION = null;
    private static final String NULL_STRING = null;
    private final Options opts = new Options();
    private CommandLine cl;

    ValueTest() {
    }

    protected static Stream<CommandLineParser> parsers() {
        return Stream.of(new DefaultParser(), new PosixParser());
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.opts.addOption("a", false, "toggle -a");
        this.opts.addOption("b", true, "set -b");
        this.opts.addOption("c", "c", false, "toggle -c");
        this.opts.addOption("d", "d", true, "set -d");
        OptionBuilder.hasOptionalArg();
        this.opts.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withLongOpt((String)"fish");
        this.opts.addOption(OptionBuilder.create());
        OptionBuilder.hasOptionalArgs();
        OptionBuilder.withLongOpt((String)"gravy");
        this.opts.addOption(OptionBuilder.create());
        OptionBuilder.hasOptionalArgs((int)2);
        OptionBuilder.withLongOpt((String)"hide");
        this.opts.addOption(OptionBuilder.create());
        OptionBuilder.hasOptionalArgs((int)2);
        this.opts.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.hasOptionalArgs();
        this.opts.addOption(OptionBuilder.create((char)'j'));
        this.opts.addOption(Option.builder().option("v").hasArg().valueSeparator().get());
        String[] args = new String[]{"-a", "-b", "foo", "--c", "--d", "bar"};
        this.cl = new PosixParser().parse(this.opts, args);
    }

    @Test
    void testLongNoArg() {
        Assertions.assertTrue((boolean)this.cl.hasOption("c"));
        Assertions.assertNull((Object)this.cl.getOptionValue("c"));
    }

    @Test
    void testLongNoArgWithOption() {
        Assertions.assertTrue((boolean)this.cl.hasOption(this.opts.getOption("c")));
        Assertions.assertNull((Object)this.cl.getOptionValue(this.opts.getOption("c")));
    }

    @ParameterizedTest
    @MethodSource(value={"parsers"})
    void testLongOptionalArgValue(CommandLineParser parser) throws Exception {
        String[] args = new String[]{"--fish", "face"};
        CommandLine cmd = parser.parse(this.opts, args);
        Assertions.assertTrue((boolean)cmd.hasOption("fish"));
        Assertions.assertEquals((Object)"face", (Object)cmd.getOptionValue("fish"));
    }

    @ParameterizedTest
    @MethodSource(value={"parsers"})
    void testLongOptionalArgValues(CommandLineParser parser) throws Exception {
        String[] args = new String[]{"--gravy", "gold", "garden"};
        CommandLine cmd = parser.parse(this.opts, args);
        Assertions.assertNull((Object)cmd.getOptionValues(NULL_OPTION));
        Assertions.assertNull((Object)cmd.getOptionValues(NULL_STRING));
        Assertions.assertTrue((boolean)cmd.hasOption("gravy"));
        Assertions.assertEquals((Object)"gold", (Object)cmd.getOptionValue("gravy"));
        Assertions.assertEquals((Object)"gold", (Object)cmd.getOptionValues("gravy")[0]);
        Assertions.assertEquals((Object)"garden", (Object)cmd.getOptionValues("gravy")[1]);
        Assertions.assertEquals((int)cmd.getArgs().length, (int)0);
    }

    @ParameterizedTest
    @MethodSource(value={"parsers"})
    void testLongOptionalArgValuesWithOption(CommandLineParser parser) throws Exception {
        String[] args = new String[]{"--gravy", "gold", "garden"};
        CommandLine cmd = parser.parse(this.opts, args);
        Assertions.assertNull((Object)cmd.getOptionValues(NULL_OPTION));
        Assertions.assertNull((Object)cmd.getOptionValues(NULL_STRING));
        Assertions.assertTrue((boolean)cmd.hasOption(this.opts.getOption("gravy")));
        Assertions.assertEquals((Object)"gold", (Object)cmd.getOptionValue(this.opts.getOption("gravy")));
        Assertions.assertEquals((Object)"gold", (Object)cmd.getOptionValues(this.opts.getOption("gravy"))[0]);
        Assertions.assertEquals((Object)"garden", (Object)cmd.getOptionValues(this.opts.getOption("gravy"))[1]);
        Assertions.assertEquals((int)cmd.getArgs().length, (int)0);
    }

    @ParameterizedTest
    @MethodSource(value={"parsers"})
    void testLongOptionalArgValueWithOption(CommandLineParser parser) throws Exception {
        String[] args = new String[]{"--fish", "face"};
        CommandLine cmd = parser.parse(this.opts, args);
        Assertions.assertTrue((boolean)cmd.hasOption(this.opts.getOption("fish")));
        Assertions.assertEquals((Object)"face", (Object)cmd.getOptionValue(this.opts.getOption("fish")));
    }

    @ParameterizedTest
    @MethodSource(value={"parsers"})
    void testLongOptionalNArgValues(CommandLineParser parser) throws Exception {
        String[] args = new String[]{"--hide", "house", "hair", "head"};
        CommandLine cmd = parser.parse(this.opts, args);
        Assertions.assertTrue((boolean)cmd.hasOption("hide"));
        Assertions.assertEquals((Object)"house", (Object)cmd.getOptionValue("hide"));
        Assertions.assertEquals((Object)"house", (Object)cmd.getOptionValues("hide")[0]);
        Assertions.assertEquals((Object)"hair", (Object)cmd.getOptionValues("hide")[1]);
        Assertions.assertEquals((int)cmd.getArgs().length, (int)1);
        Assertions.assertEquals((Object)"head", (Object)cmd.getArgs()[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"parsers"})
    void testLongOptionalNArgValuesWithOption(CommandLineParser parser) throws Exception {
        CommandLine cmd = parser.parse(this.opts, new String[]{"--hide", "house", "hair", "head"});
        Assertions.assertNull((Object)cmd.getOptionValues(NULL_OPTION));
        Assertions.assertNull((Object)cmd.getOptionValues(NULL_STRING));
        Assertions.assertTrue((boolean)cmd.hasOption(this.opts.getOption("hide")));
        Assertions.assertEquals((Object)"house", (Object)cmd.getOptionValue(this.opts.getOption("hide")));
        Assertions.assertEquals((Object)"house", (Object)cmd.getOptionValues(this.opts.getOption("hide"))[0]);
        Assertions.assertEquals((Object)"hair", (Object)cmd.getOptionValues(this.opts.getOption("hide"))[1]);
        Assertions.assertEquals((int)cmd.getArgs().length, (int)1);
        Assertions.assertEquals((Object)"head", (Object)cmd.getArgs()[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"parsers"})
    void testLongOptionalNoValue(CommandLineParser parser) throws Exception {
        String[] args = new String[]{"--fish"};
        CommandLine cmd = parser.parse(this.opts, args);
        Assertions.assertTrue((boolean)cmd.hasOption("fish"));
        Assertions.assertNull((Object)cmd.getOptionValue("fish"));
    }

    @ParameterizedTest
    @MethodSource(value={"parsers"})
    void testLongOptionalNoValueWithOption(CommandLineParser parser) throws Exception {
        String[] args = new String[]{"--fish"};
        CommandLine cmd = parser.parse(this.opts, args);
        Assertions.assertTrue((boolean)cmd.hasOption(this.opts.getOption("fish")));
        Assertions.assertNull((Object)cmd.getOptionValue(this.opts.getOption("fish")));
    }

    @Test
    void testLongWithArg() {
        Assertions.assertTrue((boolean)this.cl.hasOption("d"));
        Assertions.assertNotNull((Object)this.cl.getOptionValue("d"));
        Assertions.assertEquals((Object)this.cl.getOptionValue("d"), (Object)"bar");
    }

    @Test
    void testLongWithArgWithOption() {
        Assertions.assertTrue((boolean)this.cl.hasOption(this.opts.getOption("d")));
        Assertions.assertNotNull((Object)this.cl.getOptionValue(this.opts.getOption("d")));
        Assertions.assertEquals((Object)this.cl.getOptionValue(this.opts.getOption("d")), (Object)"bar");
    }

    @Test
    void testShortNoArg() {
        Assertions.assertTrue((boolean)this.cl.hasOption("a"));
        Assertions.assertNull((Object)this.cl.getOptionValue("a"));
    }

    @Test
    void testShortNoArgWithOption() {
        Assertions.assertTrue((boolean)this.cl.hasOption(this.opts.getOption("a")));
        Assertions.assertNull((Object)this.cl.getOptionValue(this.opts.getOption("a")));
    }

    @ParameterizedTest
    @MethodSource(value={"parsers"})
    void testShortOptionalArgNoValue(CommandLineParser parser) throws Exception {
        String[] args = new String[]{"-e"};
        CommandLine cmd = parser.parse(this.opts, args);
        Assertions.assertTrue((boolean)cmd.hasOption("e"));
        Assertions.assertNull((Object)cmd.getOptionValue("e"));
    }

    @ParameterizedTest
    @MethodSource(value={"parsers"})
    void testShortOptionalArgNoValueWithOption(CommandLineParser parser) throws Exception {
        String[] args = new String[]{"-e"};
        CommandLine cmd = parser.parse(this.opts, args);
        Assertions.assertTrue((boolean)cmd.hasOption(this.opts.getOption("e")));
        Assertions.assertNull((Object)cmd.getOptionValue(this.opts.getOption("e")));
    }

    @ParameterizedTest
    @MethodSource(value={"parsers"})
    void testShortOptionalArgValue(CommandLineParser parser) throws Exception {
        String[] args = new String[]{"-e", "everything"};
        CommandLine cmd = parser.parse(this.opts, args);
        Assertions.assertTrue((boolean)cmd.hasOption("e"));
        Assertions.assertEquals((Object)"everything", (Object)cmd.getOptionValue("e"));
    }

    @ParameterizedTest
    @MethodSource(value={"parsers"})
    void testShortOptionalArgValues(CommandLineParser parser) throws Exception {
        String[] args = new String[]{"-j", "ink", "idea"};
        CommandLine cmd = parser.parse(this.opts, args);
        Assertions.assertTrue((boolean)cmd.hasOption("j"));
        Assertions.assertEquals((Object)"ink", (Object)cmd.getOptionValue("j"));
        Assertions.assertEquals((Object)"ink", (Object)cmd.getOptionValues("j")[0]);
        Assertions.assertEquals((Object)"idea", (Object)cmd.getOptionValues("j")[1]);
        Assertions.assertEquals((int)cmd.getArgs().length, (int)0);
    }

    @ParameterizedTest
    @MethodSource(value={"parsers"})
    void testShortOptionalArgValuesWithOption(CommandLineParser parser) throws Exception {
        String[] args = new String[]{"-j", "ink", "idea"};
        CommandLine cmd = parser.parse(this.opts, args);
        Assertions.assertNull((Object)cmd.getOptionValues(NULL_OPTION));
        Assertions.assertNull((Object)cmd.getOptionValues(NULL_STRING));
        Assertions.assertTrue((boolean)cmd.hasOption(this.opts.getOption("j")));
        Assertions.assertEquals((Object)"ink", (Object)cmd.getOptionValue(this.opts.getOption("j")));
        Assertions.assertEquals((Object)"ink", (Object)cmd.getOptionValues(this.opts.getOption("j"))[0]);
        Assertions.assertEquals((Object)"idea", (Object)cmd.getOptionValues(this.opts.getOption("j"))[1]);
        Assertions.assertEquals((int)cmd.getArgs().length, (int)0);
    }

    @ParameterizedTest
    @MethodSource(value={"parsers"})
    void testShortOptionalArgValueWithOption(CommandLineParser parser) throws Exception {
        String[] args = new String[]{"-e", "everything"};
        CommandLine cmd = parser.parse(this.opts, args);
        Assertions.assertNull((Object)cmd.getOptionValues(NULL_OPTION));
        Assertions.assertNull((Object)cmd.getOptionValues(NULL_STRING));
        Assertions.assertTrue((boolean)cmd.hasOption(this.opts.getOption("e")));
        Assertions.assertEquals((Object)"everything", (Object)cmd.getOptionValue(this.opts.getOption("e")));
    }

    @ParameterizedTest
    @MethodSource(value={"parsers"})
    void testShortOptionalNArgValues(CommandLineParser parser) throws Exception {
        String[] args = new String[]{"-i", "ink", "idea", "isotope", "ice"};
        CommandLine cmd = parser.parse(this.opts, args);
        Assertions.assertNull((Object)cmd.getOptionValues(NULL_OPTION));
        Assertions.assertNull((Object)cmd.getOptionValues(NULL_STRING));
        Assertions.assertTrue((boolean)cmd.hasOption("i"));
        Assertions.assertEquals((Object)"ink", (Object)cmd.getOptionValue("i"));
        Assertions.assertEquals((Object)"ink", (Object)cmd.getOptionValues("i")[0]);
        Assertions.assertEquals((Object)"idea", (Object)cmd.getOptionValues("i")[1]);
        Assertions.assertEquals((int)cmd.getArgs().length, (int)2);
        Assertions.assertEquals((Object)"isotope", (Object)cmd.getArgs()[0]);
        Assertions.assertEquals((Object)"ice", (Object)cmd.getArgs()[1]);
    }

    @Test
    void testShortOptionalNArgValuesSeparated() throws Exception {
        String[] args = new String[]{"-v=ink", "-v=idea", "-v=isotope", "-v=ice"};
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(this.opts, args);
        Assertions.assertNull((Object)cmd.getOptionValues(NULL_OPTION));
        Assertions.assertNull((Object)cmd.getOptionValues(NULL_STRING));
        Assertions.assertTrue((boolean)cmd.hasOption("v"));
        Assertions.assertEquals((Object)"ink", (Object)cmd.getOptionValue("v"));
        Assertions.assertEquals((Object)"ink", (Object)cmd.getOptionValues("v")[0]);
        Assertions.assertEquals((Object)"idea", (Object)cmd.getOptionValues("v")[1]);
        Assertions.assertEquals((Object)"isotope", (Object)cmd.getOptionValues("v")[2]);
        Assertions.assertEquals((Object)"ice", (Object)cmd.getOptionValues("v")[3]);
    }

    @Test
    void testShortOptionalNArgValuesWithOption() throws Exception {
        String[] args = new String[]{"-i", "ink", "idea", "isotope", "ice"};
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(this.opts, args);
        Assertions.assertNull((Object)cmd.getOptionValues(NULL_OPTION));
        Assertions.assertNull((Object)cmd.getOptionValues(NULL_STRING));
        Assertions.assertTrue((boolean)cmd.hasOption("i"));
        Assertions.assertEquals((Object)"ink", (Object)cmd.getOptionValue(this.opts.getOption("i")));
        Assertions.assertEquals((Object)"ink", (Object)cmd.getOptionValues(this.opts.getOption("i"))[0]);
        Assertions.assertEquals((Object)"idea", (Object)cmd.getOptionValues(this.opts.getOption("i"))[1]);
        Assertions.assertEquals((int)cmd.getArgs().length, (int)2);
        Assertions.assertEquals((Object)"isotope", (Object)cmd.getArgs()[0]);
        Assertions.assertEquals((Object)"ice", (Object)cmd.getArgs()[1]);
    }

    @Test
    void testShortWithArg() {
        Assertions.assertTrue((boolean)this.cl.hasOption("b"));
        Assertions.assertNotNull((Object)this.cl.getOptionValue("b"));
        Assertions.assertEquals((Object)this.cl.getOptionValue("b"), (Object)"foo");
    }

    @Test
    void testShortWithArgWithOption() {
        Assertions.assertTrue((boolean)this.cl.hasOption(this.opts.getOption("b")));
        Assertions.assertNotNull((Object)this.cl.getOptionValue(this.opts.getOption("b")));
        Assertions.assertEquals((Object)this.cl.getOptionValue(this.opts.getOption("b")), (Object)"foo");
    }
}

