/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.value.json;

import org.apache.cayenne.value.json.MalformedJsonException;

final class JsonTokenizer {
    private static final char[] NULL_LOWER = new char[]{'n', 'u', 'l', 'l'};
    private static final char[] NULL_UPPER = new char[]{'N', 'U', 'L', 'L'};
    private static final char[] TRUE_LOWER = new char[]{'t', 'r', 'u', 'e'};
    private static final char[] TRUE_UPPER = new char[]{'T', 'R', 'U', 'E'};
    private static final char[] FALSE_LOWER = new char[]{'f', 'a', 'l', 's', 'e'};
    private static final char[] FALSE_UPPER = new char[]{'F', 'A', 'L', 'S', 'E'};
    private final char[] data;
    private int position;
    private State[] states = new State[32];
    private int currentState;

    JsonTokenizer(String json) {
        this.data = json.toCharArray();
        this.position = 0;
        this.currentState = 0;
        this.states[this.currentState] = State.NONE;
    }

    JsonToken nextToken() {
        if (this.position < this.data.length) {
            this.skipWhitespace();
            if (this.position != this.data.length) {
                JsonToken token = this.nextValue();
                if (this.states[this.currentState] == State.OBJECT_MEMBER_NAME) {
                    if (token.type != TokenType.OBJECT_END && token.type != TokenType.OBJECT_START && token.type != TokenType.STRING) {
                        throw new MalformedJsonException("Unexpected '" + token.toString() + "' at " + this.position);
                    }
                    if (this.states[this.currentState] == State.OBJECT_MEMBER_NAME && token.type == TokenType.STRING) {
                        this.states[this.currentState] = State.OBJECT_MEMBER_DELIMITER;
                    }
                } else if (token.type != TokenType.ARRAY_START && this.states[this.currentState] == State.ARRAY_VALUE) {
                    this.states[this.currentState] = State.ARRAY_DELIMITER;
                }
                return token;
            }
        }
        if (this.states[this.currentState] != State.NONE) {
            switch (this.states[this.currentState].ordinal()) {
                case 4: {
                    throw new MalformedJsonException("']' expected");
                }
                case 5: {
                    throw new MalformedJsonException("Next array value expected, ',' found");
                }
                case 2: {
                    throw new MalformedJsonException("Next object member value expected, ',' found");
                }
                case 1: {
                    throw new MalformedJsonException("Next object member name expected, ',' found");
                }
                case 3: {
                    throw new MalformedJsonException("'}' expected");
                }
            }
        }
        return new JsonToken(TokenType.NONE, this.position, this.position);
    }

    private void pushState(State state) {
        ++this.currentState;
        if (this.currentState >= this.states.length) {
            State[] newStates = new State[this.states.length << 2];
            System.arraycopy(this.states, 0, newStates, 0, this.states.length);
            this.states = newStates;
        }
        this.states[this.currentState] = state;
    }

    private void popState() {
        --this.currentState;
    }

    private void skipWhitespace() {
        int length = this.data.length;
        while (this.position < length && (this.data[this.position] == ' ' || this.data[this.position] == '\t' || this.data[this.position] == '\r' || this.data[this.position] == '\n' || this.data[this.position] == '\f')) {
            ++this.position;
        }
    }

    private JsonToken nextValue() {
        if (this.position >= this.data.length) {
            throw new MalformedJsonException("Unexpected end of document");
        }
        switch (this.data[this.position]) {
            case '{': {
                return this.startObject();
            }
            case '[': {
                return this.startArray();
            }
            case ']': {
                return this.arrayEnd();
            }
            case '}': {
                return this.objectEnd();
            }
            case ':': {
                if (this.states[this.currentState] != State.OBJECT_MEMBER_DELIMITER) {
                    throw new MalformedJsonException("Unexpected ':' at " + this.position);
                }
                this.states[this.currentState] = State.OBJECT_MEMBER_VALUE;
                ++this.position;
                this.skipWhitespace();
                return this.nextValue();
            }
            case ',': {
                if (this.states[this.currentState] == State.OBJECT_MEMBER_VALUE) {
                    this.states[this.currentState] = State.OBJECT_MEMBER_NAME;
                } else if (this.states[this.currentState] == State.ARRAY_DELIMITER) {
                    this.states[this.currentState] = State.ARRAY_VALUE;
                } else {
                    throw new MalformedJsonException("Unexpected ',' at " + this.position);
                }
                ++this.position;
                this.skipWhitespace();
                return this.nextValue();
            }
            case '\"': {
                return this.stringValue();
            }
            case 'N': 
            case 'n': {
                return this.nullValue();
            }
            case 'T': 
            case 't': {
                return this.trueValue();
            }
            case 'F': 
            case 'f': {
                return this.falseValue();
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return this.numericValue();
            }
        }
        throw new MalformedJsonException("Unexpected symbol '" + this.data[this.position] + "' at " + this.position);
    }

    private JsonToken objectEnd() {
        if (this.states[this.currentState] != State.OBJECT_MEMBER_VALUE && this.states[this.currentState] != State.OBJECT_MEMBER_NAME) {
            throw new MalformedJsonException("Unexpected '}' at " + this.position);
        }
        this.popState();
        return new JsonToken(TokenType.OBJECT_END, this.position, this.position++);
    }

    private JsonToken arrayEnd() {
        if (this.states[this.currentState] != State.ARRAY_DELIMITER && this.states[this.currentState] != State.ARRAY_VALUE) {
            throw new MalformedJsonException("Unexpected ']' at " + this.position);
        }
        this.popState();
        return new JsonToken(TokenType.ARRAY_END, this.position, this.position++);
    }

    private JsonToken startObject() {
        this.checkValueState('{');
        this.pushState(State.OBJECT_MEMBER_NAME);
        return new JsonToken(TokenType.OBJECT_START, this.position, this.position++);
    }

    private JsonToken startArray() {
        this.checkValueState('[');
        this.pushState(State.ARRAY_VALUE);
        return new JsonToken(TokenType.ARRAY_START, this.position, this.position++);
    }

    private JsonToken numericValue() {
        this.checkValueState(this.data[this.position]);
        int startPosition = this.position;
        NumberState state = NumberState.NONE;
        while (state != NumberState.DONE) {
            switch (this.data[this.position]) {
                case '0': {
                    if (state == NumberState.NONE || state == NumberState.MINUS) {
                        state = NumberState.ZERO;
                        break;
                    }
                    if (state == NumberState.EXPONENT) {
                        state = NumberState.EXP_SIGN;
                        break;
                    }
                    if (state == NumberState.DIGITS || state == NumberState.FRACTION || state == NumberState.EXP_SIGN) break;
                    throw new MalformedJsonException("Wrong number format at position " + this.position);
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (state == NumberState.NONE || state == NumberState.MINUS) {
                        state = NumberState.DIGITS;
                    }
                    if (state != NumberState.EXPONENT) break;
                    state = NumberState.EXP_SIGN;
                    break;
                }
                case '-': {
                    if (state == NumberState.NONE) {
                        state = NumberState.MINUS;
                        break;
                    }
                    if (state == NumberState.EXPONENT) {
                        state = NumberState.EXP_SIGN;
                        break;
                    }
                    throw new MalformedJsonException("Wrong number format at position " + this.position);
                }
                case '+': {
                    if (state != NumberState.EXPONENT) {
                        throw new MalformedJsonException("Wrong number format at position " + this.position);
                    }
                    state = NumberState.EXP_SIGN;
                    break;
                }
                case '.': {
                    if (state != NumberState.ZERO && state != NumberState.DIGITS) {
                        throw new MalformedJsonException("Wrong number format at position " + this.position);
                    }
                    state = NumberState.FRACTION;
                    break;
                }
                case 'E': 
                case 'e': {
                    if (state != NumberState.NONE && state != NumberState.ZERO && state != NumberState.DIGITS && state != NumberState.FRACTION) {
                        throw new MalformedJsonException("Wrong number format at position " + this.position);
                    }
                    state = NumberState.EXPONENT;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ',': 
                case ':': 
                case ']': 
                case '}': {
                    state = NumberState.DONE;
                    --this.position;
                    break;
                }
                default: {
                    throw new MalformedJsonException("Wrong number format at position " + this.position);
                }
            }
            if (this.position >= this.data.length - 1) {
                if (state == NumberState.DIGITS || state == NumberState.ZERO || state == NumberState.FRACTION || state == NumberState.EXP_SIGN) {
                    state = NumberState.DONE;
                }
                if (state != NumberState.DONE) {
                    throw new MalformedJsonException("Wrong number format at position " + this.position);
                }
            }
            ++this.position;
        }
        return new JsonToken(TokenType.NUMBER, startPosition, this.position);
    }

    private JsonToken nullValue() {
        this.checkValueState('n');
        return this.keyword(TokenType.NULL, NULL_LOWER, NULL_UPPER);
    }

    private JsonToken trueValue() {
        this.checkValueState('t');
        return this.keyword(TokenType.TRUE, TRUE_LOWER, TRUE_UPPER);
    }

    private JsonToken falseValue() {
        this.checkValueState('f');
        return this.keyword(TokenType.FALSE, FALSE_LOWER, FALSE_UPPER);
    }

    private JsonToken keyword(TokenType type, char[] keywordLower, char[] keywordUpper) {
        int length = keywordLower.length;
        if (this.data.length < this.position + length) {
            throw new MalformedJsonException("unknown value at position " + this.position);
        }
        for (int i = 0; i < length; ++i) {
            if (this.data[this.position + i] == keywordLower[i] || this.data[this.position + i] == keywordUpper[i]) continue;
            throw new MalformedJsonException("unknown value at position " + this.position + "(" + new String(keywordLower) + " expected)");
        }
        this.position += length;
        if (this.data.length > this.position && this.isLiteral(this.data[this.position])) {
            throw new MalformedJsonException("unknown value at position " + this.position);
        }
        return new JsonToken(type, this.position - length, this.position);
    }

    private void checkValueState(char unexpected) {
        State state = this.states[this.currentState];
        if (state == State.ARRAY_DELIMITER || state == State.OBJECT_MEMBER_NAME || state == State.OBJECT_MEMBER_DELIMITER) {
            throw new MalformedJsonException("Unexpected '" + unexpected + "' at " + this.position);
        }
    }

    private boolean isLiteral(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case ',': 
            case ']': 
            case '}': {
                return false;
            }
        }
        return true;
    }

    private JsonToken stringValue() {
        int startPosition = ++this.position;
        block8: while (this.position < this.data.length) {
            switch (this.data[this.position]) {
                case '\\': {
                    switch (this.data[++this.position]) {
                        case '\"': 
                        case '/': 
                        case '\\': 
                        case 'b': 
                        case 'f': 
                        case 'n': 
                        case 'r': 
                        case 't': {
                            ++this.position;
                            continue block8;
                        }
                        case 'u': {
                            ++this.position;
                            for (int i = 0; i < 4; ++i) {
                                char next = this.data[this.position + i];
                                if (next >= '0' && next <= '9' || next >= 'a' && next <= 'f' || next >= 'A' && next <= 'F') continue;
                                throw new MalformedJsonException("Unknown escape sequence " + String.valueOf(this.data, this.position - 1, 4) + " at position " + this.position);
                            }
                            this.position += 4;
                            continue block8;
                        }
                    }
                    throw new MalformedJsonException("Unknown escape sequence " + String.valueOf(this.data, this.position - 1, 1) + " at position " + this.position);
                }
                case '\"': {
                    return new JsonToken(TokenType.STRING, startPosition, this.position++);
                }
            }
            ++this.position;
        }
        throw new MalformedJsonException("Unexpected end of string literal");
    }

    static enum State {
        NONE,
        OBJECT_MEMBER_NAME,
        OBJECT_MEMBER_DELIMITER,
        OBJECT_MEMBER_VALUE,
        ARRAY_VALUE,
        ARRAY_DELIMITER;

    }

    class JsonToken
    implements Comparable<JsonToken> {
        final TokenType type;
        final int from;
        final int to;

        JsonToken(TokenType type, int from, int to) {
            this.type = type;
            this.from = from;
            this.to = to;
        }

        public TokenType getType() {
            return this.type;
        }

        char[] getData() {
            return JsonTokenizer.this.data;
        }

        int length() {
            return this.to - this.from;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JsonToken token = (JsonToken)o;
            if (this.type != token.type) {
                return false;
            }
            if (this.length() != token.length()) {
                return false;
            }
            int i = this.from;
            for (int j = token.from; i < this.to && j < token.to; ++i, ++j) {
                if (JsonTokenizer.this.data[i] == token.getData()[j]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = this.type.hashCode();
            for (int i = this.from; i < this.to; ++i) {
                result = 31 * result + JsonTokenizer.this.data[i];
            }
            return result;
        }

        @Override
        public int compareTo(JsonToken o) {
            if (this.type != o.type) {
                return this.type.ordinal() - o.type.ordinal();
            }
            int diff = this.length() - o.length();
            if (diff != 0) {
                return diff;
            }
            int i = this.from;
            for (int j = o.from; i < this.to && j < o.to; ++i, ++j) {
                diff = JsonTokenizer.this.data[i] - o.getData()[j];
                if (diff == 0) continue;
                return diff;
            }
            return 0;
        }

        public String toString() {
            return new String(JsonTokenizer.this.data, this.from, this.length());
        }
    }

    public static enum TokenType {
        NONE,
        ARRAY_START,
        ARRAY_END,
        OBJECT_START,
        OBJECT_END,
        STRING,
        NUMBER,
        TRUE,
        FALSE,
        NULL;

    }

    static enum NumberState {
        NONE,
        ZERO,
        DIGITS,
        MINUS,
        FRACTION,
        EXPONENT,
        EXP_SIGN,
        DONE;

    }
}

