/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.client.retry;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.sidecar.client.HttpResponse;
import org.apache.cassandra.sidecar.client.retry.RetryAction;
import org.apache.cassandra.sidecar.client.retry.RetryPolicy;
import org.apache.cassandra.sidecar.common.request.Request;

public class RunnableOnStatusCodeRetryPolicy
extends RetryPolicy {
    private final RetryPolicy delegate;
    private final AtomicInteger recordedAttempts = new AtomicInteger(0);
    private final int statusCode;
    private final int numberOfEntriesToSkip;
    private final Runnable runnable;

    public RunnableOnStatusCodeRetryPolicy(Runnable runnable, RetryPolicy delegate, int statusCode) {
        this(runnable, delegate, statusCode, 10);
    }

    public RunnableOnStatusCodeRetryPolicy(Runnable runnable, RetryPolicy delegate, int statusCode, int numberOfEntriesToSkip) {
        this.runnable = runnable;
        this.delegate = delegate;
        this.statusCode = statusCode;
        this.numberOfEntriesToSkip = numberOfEntriesToSkip;
    }

    @Override
    public void onResponse(CompletableFuture<HttpResponse> responseFuture, Request request, HttpResponse response, Throwable throwable, int attempts, boolean canRetryOnADifferentHost, RetryAction retryAction) {
        if (response != null && response.statusCode() == this.statusCode && this.recordedAttempts.getAndIncrement() % this.numberOfEntriesToSkip == 0) {
            this.runnable.run();
        }
        this.delegate.onResponse(responseFuture, request, response, throwable, attempts, canRetryOnADifferentHost, retryAction);
    }
}

