/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.modules;

import com.google.inject.AbstractModule;
import com.google.inject.multibindings.ProvidesIntoMap;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.StaticHandler;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.handlers.OpenApiHandler;
import org.apache.cassandra.sidecar.modules.multibindings.KeyClassMapKey;
import org.apache.cassandra.sidecar.modules.multibindings.VertxRouteMapKeys;
import org.apache.cassandra.sidecar.routes.RouteBuilder;
import org.apache.cassandra.sidecar.routes.VertxRoute;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;

@Path(value="/")
public class OpenApiModule
extends AbstractModule {
    @GET
    @Path(value="/spec/openapi.json")
    @Operation(summary="Get OpenAPI specification", description="Returns the OpenAPI specification for the Cassandra Sidecar API")
    @APIResponse(description="OpenAPI specification retrieved successfully", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(type=SchemaType.OBJECT))})
    @ProvidesIntoMap
    @KeyClassMapKey(value=VertxRouteMapKeys.OpenApiJsonRouteKey.class)
    VertxRoute openApiJsonRoute(RouteBuilder.Factory factory, OpenApiHandler openApiHandler) {
        return factory.builderForUnauthorizedRoute().handler(openApiHandler).build();
    }

    @GET
    @Path(value="/spec/openapi.yaml")
    @Operation(summary="Get OpenAPI specification in YAML", description="Returns the OpenAPI specification for the Cassandra Sidecar API in YAML format")
    @APIResponse(description="OpenAPI specification retrieved successfully", responseCode="200", content={@Content(mediaType="application/yaml", schema=@Schema(type=SchemaType.OBJECT))})
    @ProvidesIntoMap
    @KeyClassMapKey(value=VertxRouteMapKeys.OpenApiYamlRouteKey.class)
    VertxRoute openApiYamlRoute(RouteBuilder.Factory factory, OpenApiHandler openApiHandler) {
        return factory.builderForUnauthorizedRoute().handler(openApiHandler).build();
    }

    @GET
    @Path(value="/openapi/*")
    @Operation(summary="Get Swagger UI", description="Returns the Swagger UI for interactive API documentation")
    @APIResponse(description="Swagger UI page retrieved successfully", responseCode="200", content={@Content(mediaType="text/html", schema=@Schema(type=SchemaType.STRING))})
    @ProvidesIntoMap
    @KeyClassMapKey(value=VertxRouteMapKeys.OpenApiHtmlRouteKey.class)
    VertxRoute swaggerUIRoute(RouteBuilder.Factory factory, ExecutorPools executorPools) {
        return factory.builderForUnauthorizedRoute().handler((Handler<RoutingContext>)StaticHandler.create((String)"docs/openapi")).handler((Handler<RoutingContext>)((Handler)context -> {
            HttpServerRequest request = context.request();
            if (!request.isEnded()) {
                request.pause();
            }
            executorPools.service().runBlocking(() -> {
                try (InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/docs/openapi/index.html");){
                    if (inputStream == null) {
                        if (!context.request().isEnded()) {
                            context.request().resume();
                        }
                        context.next();
                    } else {
                        context.response().putHeader("Content-Type", "text/html; charset=utf-8").end(new String(inputStream.readAllBytes(), StandardCharsets.UTF_8));
                    }
                }
            });
        })).build();
    }
}

