/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers.snapshots;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.sidecar.acl.authorization.BasicPermissions;
import org.apache.cassandra.sidecar.common.server.StorageOperations;
import org.apache.cassandra.sidecar.common.server.exceptions.NodeBootstrappingException;
import org.apache.cassandra.sidecar.common.server.exceptions.SnapshotAlreadyExistsException;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.handlers.AbstractHandler;
import org.apache.cassandra.sidecar.handlers.AccessProtected;
import org.apache.cassandra.sidecar.handlers.data.SnapshotRequestParam;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.cassandra.sidecar.utils.HttpExceptions;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Singleton
public class CreateSnapshotHandler
extends AbstractHandler<SnapshotRequestParam>
implements AccessProtected {
    private static final String TTL_QUERY_PARAM = "ttl";

    @Inject
    public CreateSnapshotHandler(InstanceMetadataFetcher metadataFetcher, CassandraInputValidator validator, ExecutorPools executorPools) {
        super(metadataFetcher, executorPools, validator);
    }

    @Override
    public Set<Authorization> requiredAuthorizations() {
        return Collections.singleton(BasicPermissions.CREATE_SNAPSHOT.toAuthorization());
    }

    @Override
    public void handleInternal(RoutingContext context, HttpServerRequest httpRequest, @NotNull String host, SocketAddress remoteAddress, SnapshotRequestParam requestParams) {
        StorageOperations storageOperations = this.metadataFetcher.delegate(host).storageOperations();
        this.executorPools.service().runBlocking(() -> {
            this.logger.debug("Creating snapshot request={}, remoteAddress={}, instance={}", new Object[]{requestParams, remoteAddress, host});
            ImmutableMap options = requestParams.ttl() != null ? ImmutableMap.of((Object)TTL_QUERY_PARAM, (Object)requestParams.ttl()) : ImmutableMap.of();
            storageOperations.takeSnapshot(requestParams.snapshotName(), requestParams.keyspace(), requestParams.tableName(), (Map)options);
            JsonObject jsonObject = new JsonObject().put("result", (Object)"Success");
            context.json((Object)jsonObject);
        }).onFailure(cause -> this.processFailure((Throwable)cause, context, host, remoteAddress, requestParams));
    }

    @Override
    protected void processFailure(Throwable cause, RoutingContext context, String host, SocketAddress remoteAddress, SnapshotRequestParam requestParams) {
        this.logger.error("SnapshotsHandler failed for request={}, remoteAddress={}, instance={}, method={}", new Object[]{requestParams, remoteAddress, host, context.request().method(), cause});
        if (cause instanceof SnapshotAlreadyExistsException) {
            context.fail((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.CONFLICT, cause.getMessage()));
            return;
        }
        if (cause instanceof NodeBootstrappingException) {
            context.fail((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.SERVICE_UNAVAILABLE, "The Cassandra instance " + host + " is not available"));
        } else if (cause instanceof IllegalArgumentException) {
            if (StringUtils.contains((CharSequence)cause.getMessage(), (CharSequence)("Keyspace " + requestParams.keyspace() + " does not exist")) || StringUtils.contains((CharSequence)cause.getMessage(), (CharSequence)"Unknown keyspace/cf pair")) {
                context.fail((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.NOT_FOUND, cause.getMessage()));
            } else {
                context.fail((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, cause.getMessage()));
            }
            return;
        }
        context.fail((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, "Invalid request for " + requestParams));
    }

    @Override
    protected SnapshotRequestParam extractParamsOrThrow(RoutingContext context) {
        String ttl = context.request().getParam(TTL_QUERY_PARAM);
        SnapshotRequestParam snapshotRequestParam = SnapshotRequestParam.builder().qualifiedTableName(this.qualifiedTableName(context)).snapshotName(context.pathParam("snapshot")).ttl(ttl).build();
        this.validate(snapshotRequestParam);
        return snapshotRequestParam;
    }

    private void validate(SnapshotRequestParam request) {
        this.validator.validateSnapshotName(request.snapshotName());
    }
}

